/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.bootstrap;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.namebindings.CORBAObjectNameSpaceBinding;
import com.ibm.websphere.models.config.namebindings.EjbNameSpaceBinding;
import com.ibm.websphere.models.config.namebindings.IndirectLookupNameSpaceBinding;
import com.ibm.websphere.models.config.namebindings.NameSpaceBinding;
import com.ibm.websphere.models.config.namebindings.NamebindingsPackage;
import com.ibm.websphere.models.config.namebindings.StringNameSpaceBinding;
import com.ibm.websphere.models.config.namingserver.NameServer;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cell.ForeignCell;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.bootstrap.ConfigInfoImpl;
import com.ibm.ws.naming.bootstrap.ConfiguredBindingInfoImpl;
import com.ibm.ws.naming.cosbase.WsnOptimizedNamingImplBase;
import com.ibm.ws.naming.distcos.ConfiguredBindingInfo;
import com.ibm.ws.naming.distcos.EndpointGroup;
import com.ibm.ws.naming.distcos.NameSpaceConfigurationException;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.InvalidNameSyntaxException;
import com.ibm.ws.naming.util.URLNameHelpers;
import com.ibm.ws.naming.util.WsnName;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.naming.InvalidNameException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.omg.CosNaming.BindingType;

class ConfigInfoBuilder {
    private static final TraceComponent _tc = Tr.register(ConfigInfoBuilder.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final int CBT_STRING = 0;
    private static final int CBT_EJB = 1;
    private static final int CBT_INDIRECT_JNDI = 2;
    private static final int CBT_CORBA_URL = 3;
    private static final String CELL_XML = "cell.xml";
    private static final String NODE_XML = "node.xml";
    private static final String SERVER_XML = "server.xml";
    private static final String CLUSTER_XML = "cluster.xml";
    private static final String SERVERINDEX_XML = "serverindex.xml";
    private static final String BOOTSTRAP_ADDR = "BOOTSTRAP_ADDRESS";
    private static final String IS_CELL_MANAGER = "CELL_DISCOVERY_ADDRESS";
    private static final String IS_NODE_AGENT = "NODE_DISCOVERY_ADDRESS";
    private static final HashSet EXCLUDED_SERVER_TYPES;
    private Server _server;
    private VariableMap _variableMap = null;
    private ConfigRoot _configRoot;
    private String _serverProcessType;
    private String _nameSpaceScope = "cell";
    private boolean _expandStringBindings = false;
    private ConfigInfoImpl _ci;
    private String _cellName;
    private String _nodeName;
    private String _serverName;
    private String _clusterName = null;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$serverindex$ServerIndex;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$namebindings$StringNameSpaceBinding;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$namebindings$IndirectLookupNameSpaceBinding;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$namebindings$EjbNameSpaceBinding;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$namebindings$CORBAObjectNameSpaceBinding;

    public ConfigInfoBuilder(Server server2, VariableMap variableMap, ConfigRoot configRoot, String string) throws NameSpaceConfigurationException {
        this._server = server2;
        this._variableMap = variableMap;
        this._configRoot = configRoot;
        this._serverProcessType = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigInfoImpl buildConfigInfo() throws NameSpaceConfigurationException {
        try {
            this._ci = new ConfigInfoImpl();
            this._cellName = this._server.getCellName();
            this._nodeName = this._server.getNodeName();
            this._serverName = this._server.getName();
            this._clusterName = this._server.getClusterName();
            this._ci.setCellName(this._cellName);
            this._ci.setNodeName(this._nodeName);
            this._ci.setServerName(this._serverName);
            Properties properties = this.getNameServerCustomProperties();
            this.addNameServerCustomPropertiesToConfigInfo(properties);
            this._nameSpaceScope = this._ci.getNameServerCustomProperty("naming.systemNameSpace.scope");
            this._expandStringBindings = Boolean.parseBoolean(this._ci.getNameServerCustomProperty("com.ibm.websphere.naming.expandStringBindings"));
            this.initServers();
            this.initClusters();
            this.initForeignCellInfo();
            this._ci.setCellNameStoreURI(this._serverProcessType);
            this._ci.setNodeNameStoreURI(this._serverProcessType);
            this.initConfiguredBindingInfo(0);
            this.initConfiguredBindingInfo(3);
            if (this._clusterName != null) {
                this.initConfiguredBindingInfo(2);
            }
            this.initConfiguredBindingInfo(4);
        }
        finally {
            this._configRoot = null;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Extraction of Configuration Information Complete:", this._ci.toStringDebug());
        }
        return this._ci;
    }

    private Properties getNameServerCustomProperties() throws NameSpaceConfigurationException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNameServerCustomProperties");
        }
        int[] nArray = new int[]{0, 3, 4};
        String[] stringArray = new String[]{CELL_XML, NODE_XML, SERVER_XML};
        Properties properties = new Properties();
        String string = "cfExceptionOnLoadingServerXML";
        for (int i = 0; i < nArray.length; ++i) {
            Object object;
            String[] stringArray2;
            Resource resource;
            try {
                resource = this._configRoot.getResource(nArray[i], stringArray[i]);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.bootstrap.ConfigInfoImpl.getNameServerCustomProperties", "592", this);
                stringArray2 = new String[]{stringArray[i], throwable.toString()};
                this._ci.issueConfigurationWarning(string, stringArray2);
                continue;
            }
            EList eList = null;
            stringArray2 = resource.getContents().iterator();
            if (!stringArray2.hasNext()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getNameServerCustomProperties: No contents in extent for file " + stringArray[i]);
                }
                object = new String[]{stringArray[i], "No contents in extent for file."};
                this._ci.issueConfigurationWarning(string, (String[])object);
                continue;
            }
            block1 : switch (i) {
                case 0: {
                    Object object2;
                    object = stringArray2.next();
                    if (object instanceof Cell) {
                        object2 = (Cell)object;
                        eList = object2.getProperties();
                        if (!_tc.isDebugEnabled()) break;
                        if (eList == null || eList.size() == 0) {
                            Tr.debug(_tc, "getNameServerCustomProperties: No cell-scoped properties.");
                            break;
                        }
                        Tr.debug(_tc, "getNameServerCustomProperties: Cell-scoped properties:", eList);
                        break;
                    }
                    object2 = object == null ? "[NULL]" : object.getClass().getName();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getNameServerCustomProperties: Unexpected object type in file " + stringArray[i] + ".  Object type: " + (String)object2);
                    }
                    String[] stringArray3 = new String[]{stringArray[i], "Unexpected object type in file.  Object type: " + (String)object2};
                    this._ci.issueConfigurationWarning(string, stringArray3);
                    break;
                }
                case 1: {
                    Object object2;
                    object = stringArray2.next();
                    if (object instanceof Node) {
                        object2 = (Node)object;
                        eList = object2.getProperties();
                        if (!_tc.isDebugEnabled()) break;
                        if (eList == null || eList.size() == 0) {
                            Tr.debug(_tc, "getNameServerCustomProperties: No node-scoped properties.");
                            break;
                        }
                        Tr.debug(_tc, "getNameServerCustomProperties: Node-scoped properties:", eList);
                        break;
                    }
                    object2 = object == null ? "[NULL]" : object.getClass().getName();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getNameServerCustomProperties: Unexpected object type in file " + stringArray[i] + ".  Object type: " + (String)object2);
                    }
                    String[] stringArray3 = new String[]{stringArray[i], "Unexpected object type in file.  Object type: " + (String)object2};
                    this._ci.issueConfigurationWarning(string, stringArray3);
                    break;
                }
                case 2: {
                    String[] stringArray3;
                    Object object2;
                    object = stringArray2.next();
                    if (object instanceof com.ibm.websphere.models.config.process.Server) {
                        object2 = (com.ibm.websphere.models.config.process.Server)object;
                        stringArray3 = object2.getComponents();
                        for (int j = 0; j < stringArray3.size(); ++j) {
                            Object e2 = stringArray3.get(j);
                            if (!(e2 instanceof NameServer)) continue;
                            eList = ((NameServer)e2).getProperties();
                            if (!_tc.isDebugEnabled()) break block1;
                            if (eList == null || eList.size() == 0) {
                                Tr.debug(_tc, "getNameServerCustomProperties: No server-scoped properties.");
                                break block1;
                            }
                            Tr.debug(_tc, "getNameServerCustomProperties: Server-scoped properties:", eList);
                            break block1;
                        }
                        break;
                    }
                    object2 = object == null ? "[NULL]" : object.getClass().getName();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getNameServerCustomProperties: Unexpected object type in file " + stringArray[i] + ".  Object type: " + (String)object2);
                    }
                    stringArray3 = new String[]{stringArray[i], "Unexpected object type in file.  Object type: " + (String)object2};
                    this._ci.issueConfigurationWarning(string, stringArray3);
                    break;
                }
            }
            this.mergeNameServerCustomProperties(properties, (List)eList);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNameServerCustomProperties", new Object[]{"Name Server Custom Properties:", properties});
        }
        return properties;
    }

    private void mergeNameServerCustomProperties(Properties properties, List list) throws NameSpaceConfigurationException {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Property property = (Property)list.get(i);
                String string = property.getName();
                String string2 = property.getValue();
                properties.put(string, string2);
            }
        }
    }

    private void addNameServerCustomPropertiesToConfigInfo(Properties properties) throws NameSpaceConfigurationException {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!this._ci.setNameServerCustomProperty(string2, string = properties.getProperty(string2))) continue;
            Tr.audit(_tc, "cfCustomProperty", new String[]{string2, string});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServers() throws NameSpaceConfigurationException {
        String[] stringArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initServers");
        }
        boolean bl = this._serverProcessType.equals("UnManagedProcess");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Properties affecting name space construction:", new String[]{"standaloneServerProcess=" + bl + ", nameSpaceScope=" + this._nameSpaceScope});
        }
        if (bl || !this._nameSpaceScope.equals("cell")) {
            stringArray = new String[]{this._nodeName};
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Restricting configuration info to this node.");
            }
        } else {
            stringArray = this._configRoot.list(3, null);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Configuration info includes all nodes.");
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            ServerIndex serverIndex;
            String string = stringArray[i];
            String string2 = this._configRoot.setValue(3, string);
            try {
                serverIndex = (ServerIndex)this.getFromDocument(3, SERVERINDEX_XML, class$com$ibm$websphere$models$config$serverindex$ServerIndex == null ? ConfigInfoBuilder.class$("com.ibm.websphere.models.config.serverindex.ServerIndex") : class$com$ibm$websphere$models$config$serverindex$ServerIndex);
            }
            finally {
                string2 = this._configRoot.setValue(3, string2);
            }
            boolean bl2 = false;
            EList eList = serverIndex.getServerEntries();
            boolean bl3 = true;
            LinkedList<ConfigInfoServerEntry> linkedList = new LinkedList<ConfigInfoServerEntry>();
            for (int j = 0; j < eList.size(); ++j) {
                object = (ServerEntry)eList.get(j);
                String string3 = object.getServerName();
                String string4 = object.getServerType();
                String string5 = object.getGenericShortName();
                String string6 = object.getServerShortName();
                boolean bl4 = false;
                if (EXCLUDED_SERVER_TYPES.contains(string4)) {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Ignoring server \"" + string3 + "\" because servers of type " + string4 + "\" are not included in the system the name space.");
                    continue;
                }
                if (bl && !string3.equals(this._serverName)) {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "This is a stand alone server process, ignore server (" + string3 + ") configuration.");
                    continue;
                }
                if (!string3.equals(this._serverName) && (bl || this._nameSpaceScope.equals("server"))) {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Ignoring configuration for server " + string3 + ".");
                    continue;
                }
                String string7 = "ManagedApplicationServer";
                if (this._serverProcessType.equals("UnManagedProcess")) {
                    string7 = "StandAloneApplicationServer";
                }
                String string8 = "INVALID-HOSTNAME";
                String string9 = "INVALID-PORT";
                EList eList2 = object.getSpecialEndpoints();
                for (int k = 0; k < eList2.size(); ++k) {
                    NamedEndPoint namedEndPoint = (NamedEndPoint)eList2.get(k);
                    if (namedEndPoint.getEndPointName().equals(BOOTSTRAP_ADDR)) {
                        bl4 = true;
                        EndPoint endPoint = namedEndPoint.getEndPoint();
                        if (endPoint == null) continue;
                        string8 = this.expandVariables(endPoint.getHost());
                        string9 = new Integer(endPoint.getPort()).toString();
                        continue;
                    }
                    if (namedEndPoint.getEndPointName().equals(IS_CELL_MANAGER)) {
                        string7 = "CellManager";
                        bl2 = true;
                        bl4 = true;
                        continue;
                    }
                    if (!namedEndPoint.getEndPointName().equals(IS_NODE_AGENT)) continue;
                    string7 = "NodeAgent";
                    bl2 = true;
                    bl4 = true;
                }
                if (bl4) {
                    ConfigInfoServerEntry configInfoServerEntry = new ConfigInfoServerEntry(string3, string, string8, string9, string7, string6, string5);
                    linkedList.add(configInfoServerEntry);
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initServers", "Skipping server " + string3 + ".");
                }
                if (bl || this._nameSpaceScope.equals("server")) break;
            }
            if (bl || this._nameSpaceScope.equals("server") || bl2) {
                arrayList.add(string);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    object = (ConfigInfoServerEntry)iterator.next();
                    this._ci.addServer(object._serverToAdd, object._node, object._bootstrapHost, object._bootstrapPort, object._type, object._serverShortName, object._genericShortName);
                }
                continue;
            }
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Skipping unmanaged node: " + string);
        }
        if (arrayList.size() > 0) {
            String[] stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            this._ci.setNodeNames(stringArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClusters() {
        if (this._serverProcessType.equals("UnManagedProcess")) {
            return;
        }
        Resource resource = null;
        String[] stringArray = this._configRoot.list(2, null);
        if (stringArray == null) {
            return;
        }
        if (this._nameSpaceScope.equals("server")) {
            if (this._clusterName != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initClusters", "Cluster member with server-scoped name space.  Bypassing cluster processing.");
                }
                this._ci.addClusterMember(this._clusterName, this._nodeName, this._serverName);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "initClusters", "Single server with server-scoped name space.  Bypassing cluster processing.");
            }
            return;
        }
        String string = this._configRoot.getValue(2);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                String string2;
                block18: {
                    this._configRoot.setValue(2, stringArray[i]);
                    try {
                        resource = this._configRoot.getResource(2, CLUSTER_XML);
                        if (resource == null) {
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "cluster.xml file contains no Resources - assuming no clusters for this config");
                        }
                        break block18;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "FileNotFoundException accessing cluster.xml file - assuming no clusters for \"" + stringArray[i] + "\" cluster config");
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.naming.bootstrap.ConfigInfoImpl.initClusters", "384", this);
                        string2 = "cfExceptionOnLoadingClusterXML";
                        stringArray2 = new String[]{CLUSTER_XML, stringArray[i], throwable.toString()};
                        this._ci.issueConfigurationWarning(string2, stringArray2);
                    }
                    continue;
                }
                Iterator iterator = resource.getContents().iterator();
                while (iterator.hasNext()) {
                    string2 = (ServerCluster)iterator.next();
                    stringArray2 = string2.getName();
                    Iterator iterator2 = string2.getMembers().iterator();
                    while (iterator2.hasNext()) {
                        ClusterMember clusterMember = (ClusterMember)iterator2.next();
                        String string3 = clusterMember.getMemberName();
                        String string4 = clusterMember.getNodeName();
                        if (this._nameSpaceScope.equals("cell") || this._nodeName.equals(string4)) {
                            this._ci.addClusterMember((String)stringArray2, string4, string3);
                            continue;
                        }
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "initClusters: Name space scope is node-level.  Ignoring cluster member from another node.", new String[]{"clusterName=" + (String)stringArray2, "nodeName=" + string4, "memberName=" + string3});
                    }
                }
            }
        }
        finally {
            this._configRoot.setValue(2, string);
        }
    }

    private void initForeignCellInfo() throws NameSpaceConfigurationException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initForeignCellInfo");
        }
        Cell cell = (Cell)this.getFromDocument(0, CELL_XML, Cell.class);
        EList eList = cell.getForeignCells();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Number of foreign cells: " + eList.size());
        }
        for (int i = 0; i < eList.size(); ++i) {
            Object object;
            ForeignCell foreignCell = (ForeignCell)eList.get(i);
            String string = foreignCell.getName();
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "Foreign cell name: " + string);
            }
            StringBuffer stringBuffer = new StringBuffer("corbaloc::");
            EList eList2 = foreignCell.getBootstrapAddresses();
            if (eList2 != null && eList2.size() > 0) {
                object = (EndPoint)eList2.get(0);
                this.appendEndPoint((EndPoint)object, stringBuffer);
                int n = eList2.size();
                for (int j = 1; j < n; ++j) {
                    stringBuffer.append(",:");
                    object = (EndPoint)eList2.get(j);
                    this.appendEndPoint((EndPoint)object, stringBuffer);
                }
            } else {
                object = foreignCell.getBootstrapAddress();
                this.appendEndPoint((EndPoint)object, stringBuffer);
            }
            stringBuffer.append("/");
            stringBuffer.append("NameServiceCellRoot");
            object = new ConfiguredBindingInfoImpl(1, string, stringBuffer.toString(), BindingType.ncontext);
            this._ci.addConfiguredBinding((ConfiguredBindingInfo)object);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initForeignCellInfo");
        }
    }

    private void appendEndPoint(EndPoint endPoint, StringBuffer stringBuffer) {
        String string = this.expandVariables(endPoint.getHost());
        String string2 = new Integer(endPoint.getPort()).toString();
        if (string.indexOf(58) == -1) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("[");
            stringBuffer.append(string);
            stringBuffer.append("]");
            stringBuffer.append(":");
        }
        stringBuffer.append(":");
        stringBuffer.append(string2);
    }

    private void initConfiguredBindingInfo(int n) throws NameSpaceConfigurationException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initConfiguredBindingInfo");
        }
        String string = "namebindings.xml";
        Class clazz = NameSpaceBinding.class;
        Resource resource = null;
        int n2 = 0;
        String string2 = null;
        NamebindingsPackage namebindingsPackage = NamebindingsPackage.eINSTANCE;
        try {
            resource = this._configRoot.getResource(n, string);
            if (n == 0) {
                n2 = 2;
                string2 = "cell";
            } else if (n == 3) {
                if (this._ci.thisIsCellManager()) {
                    String string3 = "cfInvalidConfigLocation";
                    String[] stringArray = new String[]{string};
                    this._ci.issueConfigurationWarning(string3, stringArray);
                    return;
                }
                n2 = 3;
                string2 = "node";
            } else if (n == 2) {
                n2 = 4;
                string2 = "cluster";
            } else {
                n2 = 4;
                string2 = "server";
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "initConfiguredBindingInfo: docLocation = " + string2 + ", rootIndicator = " + n2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "initConfiguredBindingInfo: Absorb FileNotFoundException, " + fileNotFoundException);
            }
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.bootstrap.ConfigInfoBuilder.initConfiguredBindingInfo", "521", this);
            throw new NameSpaceConfigurationException("Cannot load document " + string + " from " + n + " directory", exception);
        }
        Iterator iterator = resource.getContents().iterator();
        int n3 = 0;
        int n4 = 0;
        while (iterator.hasNext()) {
            Object object;
            String[] stringArray;
            String[] stringArray2;
            String string4;
            ConfiguredBindingInfoImpl configuredBindingInfoImpl;
            block50: {
                Object object2;
                ++n3;
                configuredBindingInfoImpl = null;
                NameSpaceBinding nameSpaceBinding = (NameSpaceBinding)iterator.next();
                string4 = nameSpaceBinding.getName();
                String string5 = nameSpaceBinding.getNameInNameSpace();
                if (string4.length() == 0) {
                    this.issueConfiguredBindingValidationWarning("name", "NameSpaceBinding", "-EMPTY-", string5, string2);
                    continue;
                }
                if (string5.length() == 0) {
                    this.issueConfiguredBindingValidationWarning("nameInNameSpace", "NameSpaceBinding", string4, "-EMPTY-", string2);
                    continue;
                }
                try {
                    string5 = WsnOptimizedNamingImplBase.convertJNDINameStringToINS(string5);
                }
                catch (InvalidNameException invalidNameException) {
                    this.issueConfiguredBindingInvalidParamWarning(string5, "nameInNameSpace", "NameSpaceBinding", string4, string5, string2);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "initConfiguredBindingInfo: \nFound an illegal character while escaping necessary characters per INS syntax in a JNDI name  " + string5 + ":\n" + invalidNameException);
                    continue;
                }
                catch (InvalidNameSyntaxException invalidNameSyntaxException) {
                    continue;
                }
                if ((class$com$ibm$websphere$models$config$namebindings$StringNameSpaceBinding == null ? ConfigInfoBuilder.class$("com.ibm.websphere.models.config.namebindings.StringNameSpaceBinding") : class$com$ibm$websphere$models$config$namebindings$StringNameSpaceBinding).isInstance(nameSpaceBinding)) {
                    stringArray2 = (String[])nameSpaceBinding;
                    if (this.validateCFBInfo(0, nameSpaceBinding, string2)) {
                        stringArray = stringArray2.getStringToBind();
                        if (this._expandStringBindings) {
                            try {
                                object = this.expandVariables((String)stringArray);
                                configuredBindingInfoImpl = new ConfiguredBindingInfoImpl(n2, string5, (String)object);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.naming.bootstrap.ConfigInfoBuilder.initConfiguredBindingInfo", "964", this);
                                this.issueConfiguredBindingInvalidParamWarning((String)stringArray, "stringToBind", "StringNameSpaceBinding", string4, string5, string2);
                                if (!_tc.isDebugEnabled()) break block50;
                                Tr.debug(_tc, "initConfiguredBindingInfo", "Error expanding variables in string \"" + (String)stringArray + "\": " + illegalArgumentException);
                            }
                        } else {
                            configuredBindingInfoImpl = new ConfiguredBindingInfoImpl(n2, string5, (String)stringArray);
                        }
                    }
                } else if ((class$com$ibm$websphere$models$config$namebindings$IndirectLookupNameSpaceBinding == null ? ConfigInfoBuilder.class$("com.ibm.websphere.models.config.namebindings.IndirectLookupNameSpaceBinding") : class$com$ibm$websphere$models$config$namebindings$IndirectLookupNameSpaceBinding).isInstance(nameSpaceBinding)) {
                    stringArray2 = (IndirectLookupNameSpaceBinding)nameSpaceBinding;
                    if (this.validateCFBInfo(2, nameSpaceBinding, string2)) {
                        Properties properties = new Properties();
                        object = stringArray2.getOtherCtxProperties();
                        if (object != null) {
                            int n5 = object.size();
                            for (int i = 0; i < n5; ++i) {
                                object2 = (Property)object.get(i);
                                String string6 = object2.getName();
                                String string7 = object2.getValue();
                                if (string6 != null && string7 != null && string6.length() != 0) {
                                    properties.setProperty(string6, string7);
                                    continue;
                                }
                                if (!_tc.isDebugEnabled()) continue;
                                Tr.debug(_tc, "Skipping indirect lookup ctx property because the name or value is null or empty.");
                            }
                        }
                        configuredBindingInfoImpl = new ConfiguredBindingInfoImpl(n2, string5, stringArray2.getProviderURL(), stringArray2.getJndiName(), stringArray2.getInitialContextFactory(), properties);
                    }
                } else if ((class$com$ibm$websphere$models$config$namebindings$EjbNameSpaceBinding == null ? ConfigInfoBuilder.class$("com.ibm.websphere.models.config.namebindings.EjbNameSpaceBinding") : class$com$ibm$websphere$models$config$namebindings$EjbNameSpaceBinding).isInstance(nameSpaceBinding)) {
                    stringArray2 = (EjbNameSpaceBinding)nameSpaceBinding;
                    if (this.validateCFBInfo(1, nameSpaceBinding, string2)) {
                        int n6 = stringArray2.getBindingLocation().getValue();
                        object = null;
                        object = n6 == 1 ? this._ci.getServerEndpoint(stringArray2.getApplicationNodeName(), stringArray2.getApplicationServerName()) : this._ci.getClusterEndpoint(stringArray2.getApplicationServerName());
                        if (((EndpointGroup)object).size() == 1 && ((EndpointGroup)object).toString().equals("INVALID-HOSTNAME:INVALID-PORT")) continue;
                        try {
                            String string8 = WsnOptimizedNamingImplBase.convertJNDINameStringToINS(stringArray2.getEjbJndiName());
                            string8 = URLNameHelpers.encodeString(string8, true);
                            String string9 = "corbaname:" + ((EndpointGroup)object).toUrlAddrList() + "/" + "NameServiceServerRoot" + "#" + string8;
                            configuredBindingInfoImpl = new ConfiguredBindingInfoImpl(n2, string5, string9, BindingType.nobject);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            String string10 = stringArray2.getEjbJndiName();
                            this.issueConfiguredBindingInvalidParamWarning(string10, "ejbJndiName", "EjbNameSpaceBinding", string4, string5, string2);
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "initConfiguredBindingInfo: \nFound an illegal character while escaping necessary characters per RFC 2396 in a name " + string10 + ":\n" + illegalArgumentException);
                            continue;
                        }
                        catch (InvalidNameException invalidNameException) {
                            String string11 = stringArray2.getEjbJndiName();
                            this.issueConfiguredBindingInvalidParamWarning(string11, "ejbJndiName", "EjbNameSpaceBinding", string4, string5, string2);
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "initConfiguredBindingInfo: \nInvalid JNDI name: found an illegal character while converting the name from JNDI to INS format " + string11 + ":\n" + invalidNameException);
                            continue;
                        }
                        catch (InvalidNameSyntaxException invalidNameSyntaxException) {
                            continue;
                        }
                    }
                } else if ((class$com$ibm$websphere$models$config$namebindings$CORBAObjectNameSpaceBinding == null ? ConfigInfoBuilder.class$("com.ibm.websphere.models.config.namebindings.CORBAObjectNameSpaceBinding") : class$com$ibm$websphere$models$config$namebindings$CORBAObjectNameSpaceBinding).isInstance(nameSpaceBinding)) {
                    stringArray2 = (CORBAObjectNameSpaceBinding)nameSpaceBinding;
                    if (this.validateCFBInfo(3, nameSpaceBinding, string2)) {
                        BindingType bindingType = stringArray2.isFederatedContext() ? BindingType.ncontext : BindingType.nobject;
                        object = null;
                        try {
                            String string12 = URLNameHelpers.encodeCorbaURL(stringArray2.getCorbanameUrl());
                            ObjectURL objectURL = ORB.createObjectURL((String)string12);
                            object = objectURL.getStringName();
                            if (object != null && ((String)object).length() != 0) {
                                object2 = new WsnName(URLNameHelpers.decodeString((String)object), CommonHelpers.getINSEnvironment());
                            }
                            configuredBindingInfoImpl = new ConfiguredBindingInfoImpl(n2, string5, string12, bindingType);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            String string13 = stringArray2.getCorbanameUrl();
                            this.issueConfiguredBindingInvalidParamWarning(string13, "corbanameUrl", "CORBAObjectNameSpaceBinding", string4, string5, string2);
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "initConfiguredBindingInfo: \nFound an illegal character while escaping necessary characters per RFC 2396 in an URL \n" + string13 + ":\n" + illegalArgumentException);
                            continue;
                        }
                        catch (InvalidNameException invalidNameException) {
                            String string14 = stringArray2.getCorbanameUrl();
                            this.issueConfiguredBindingInvalidParamWarning(string14, "corbanameUrl", "CORBAObjectNameSpaceBinding", string4, string5, string2);
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "initConfiguredBindingInfo: \nThe URL contains an invalid INS name string: " + (String)object + ":\n" + invalidNameException);
                            continue;
                        }
                        catch (InvalidNameSyntaxException invalidNameSyntaxException) {
                            continue;
                        }
                        catch (Throwable throwable) {
                            String string15 = stringArray2.getCorbanameUrl();
                            this.issueConfiguredBindingInvalidParamWarning(string15, "corbanameUrl", "CORBAObjectNameSpaceBinding", string4, string5, string2);
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "initConfiguredBindingInfo: \nMalformed corbaname URL: " + string15 + ":\n" + throwable);
                            continue;
                        }
                    }
                }
            }
            if (configuredBindingInfoImpl == null) continue;
            if (_tc.isDebugEnabled()) {
                stringArray2 = new String[]{"UNKNOWN", "BV_CORBA_URL", "BV_INDIRECT_JNDI", "BV_STRING_CONSTANT", "RESERVED1", "RESERVED2", "RESERVED3", "RESERVED4"};
                stringArray = new String[]{"UNKNOWN", "RI_CELLS", "RI_CELL_PERSISTENT_ROOT", "RI_NODE_PERSISTENT_ROOT", "RI_SERVER_ROOT", "RESERVED1", "RESERVED2", "RESERVED3", "RESERVED4"};
                object = configuredBindingInfoImpl.getCORBABindingType() == BindingType.nobject ? "nobject" : (configuredBindingInfoImpl.getCORBABindingType() == BindingType.ncontext ? "ncontext" : "NOT_SPECIFIED");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initConfiguredBindingInfo: addConfiguredBinding(\"" + string4 + "\")" + "\n   bindingVariety   = " + stringArray2[configuredBindingInfoImpl.getBindingVariety()] + "\n   rootIndicator    = " + stringArray[configuredBindingInfoImpl.getRootIndicator()] + "\n   bindingName      = " + configuredBindingInfoImpl.getBindingName() + "\n   corbaURL         = " + configuredBindingInfoImpl.getCORBAUrl() + "\n   corbaBindingType = " + (String)object + "\n   providerURL      = " + configuredBindingInfoImpl.getProviderUrl() + "\n   jndiName         = " + configuredBindingInfoImpl.getJndiName() + "\n   stringConstant   = " + configuredBindingInfoImpl.getStringConstant());
                }
            }
            ++n4;
            this._ci.addConfiguredBinding(configuredBindingInfoImpl);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "initConfiguredBindingInfo: docLocation = " + string2 + ", hitCountIn = " + n3 + ", hitCountOut = " + n4);
        }
    }

    private Object getFromDocument(int n, String string, Class clazz) throws NameSpaceConfigurationException {
        Resource resource = null;
        try {
            resource = this._configRoot.getResource(n, string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.bootstrap.ConfigInfoImpl.getFromDocument", "440", this);
            throw new NameSpaceConfigurationException("Cannot load document " + string + " from " + n + " directory", exception);
        }
        Object object = resource.getContents().get(0);
        if (!clazz.isInstance(object)) {
            throw new NameSpaceConfigurationException("Document " + string + " loaded from " + n + " does not contain object of type " + clazz.getName() + ", actual type is " + object.getClass().getName());
        }
        return object;
    }

    private void issueConfiguredBindingValidationWarning(String string, String string2, String string3, String string4, String string5) {
        String string6 = "cfBindingEmptyParam";
        String[] stringArray = new String[]{string, string2, string3, string4, string5};
        Tr.warning(_tc, string6, stringArray);
    }

    private void issueConfiguredBindingInvalidParamWarning(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = "cfBindingInvalidParam";
        String[] stringArray = new String[]{string, string2, string3, string4, string5, string6};
        Tr.warning(_tc, string7, stringArray);
    }

    private void issueNonexistentServerWarning(String string, String string2, String string3, String string4, String string5) {
        String string6 = "cfBindingInvalidServer";
        String[] stringArray = new String[]{string, string2, string3, string4, string5};
        Tr.warning(_tc, string6, stringArray);
    }

    private void issueNonexistentClusterWarning(String string, String string2, String string3, String string4) {
        String string5 = "cfBindingInvalidCluster";
        String[] stringArray = new String[]{string, string2, string3, string4};
        Tr.warning(_tc, string5, stringArray);
    }

    private boolean validateCFBInfo(int n, NameSpaceBinding nameSpaceBinding, String string) {
        boolean bl = true;
        NamebindingsPackage namebindingsPackage = NamebindingsPackage.eINSTANCE;
        String string2 = nameSpaceBinding.getName();
        String string3 = nameSpaceBinding.getNameInNameSpace();
        switch (n) {
            case 0: {
                StringNameSpaceBinding stringNameSpaceBinding = (StringNameSpaceBinding)nameSpaceBinding;
                if (stringNameSpaceBinding.getStringToBind().length() != 0) break;
                this.issueConfiguredBindingValidationWarning("stringToBind", "StringNameSpaceBinding", string2, string3, string);
                bl = false;
                break;
            }
            case 2: {
                IndirectLookupNameSpaceBinding indirectLookupNameSpaceBinding = (IndirectLookupNameSpaceBinding)nameSpaceBinding;
                if (indirectLookupNameSpaceBinding.getJndiName().length() != 0) break;
                this.issueConfiguredBindingValidationWarning("jndiName", "IndirectLookupNameSpaceBinding", string2, string3, string);
                bl = false;
                break;
            }
            case 1: {
                EjbNameSpaceBinding ejbNameSpaceBinding = (EjbNameSpaceBinding)nameSpaceBinding;
                if (ejbNameSpaceBinding.getEjbJndiName().length() == 0) {
                    this.issueConfiguredBindingValidationWarning("ejbJndiName", "EjbNameSpaceBinding", string2, string3, string);
                    bl = false;
                    break;
                }
                if (ejbNameSpaceBinding.getApplicationServerName().length() == 0) {
                    this.issueConfiguredBindingValidationWarning("applicationServerName", "EjbNameSpaceBinding", string2, string3, string);
                    bl = false;
                    break;
                }
                int n2 = ejbNameSpaceBinding.getBindingLocation().getValue();
                if (n2 != 1 && n2 != 0) {
                    this.issueConfiguredBindingValidationWarning("bindingLocation", "EjbNameSpaceBinding", string2, string3, string);
                    bl = false;
                    break;
                }
                if (n2 == 1) {
                    EAttribute eAttribute = NamebindingsPackage.eINSTANCE.getEjbNameSpaceBinding_ApplicationNodeName();
                    if (!ejbNameSpaceBinding.eIsSet((EStructuralFeature)eAttribute)) {
                        this.issueConfiguredBindingValidationWarning("applicationNodeName", "EjbNameSpaceBinding", string2, string3, string);
                        bl = false;
                        break;
                    }
                    if (this._ci.serverExists(ejbNameSpaceBinding.getApplicationNodeName(), ejbNameSpaceBinding.getApplicationServerName())) break;
                    if (!this._serverProcessType.equals("UnManagedProcess")) {
                        this.issueNonexistentServerWarning(ejbNameSpaceBinding.getApplicationNodeName(), ejbNameSpaceBinding.getApplicationServerName(), string2, string3, string);
                    }
                    bl = false;
                    break;
                }
                if (this._ci.clusterExists(ejbNameSpaceBinding.getApplicationServerName())) break;
                this.issueNonexistentClusterWarning(ejbNameSpaceBinding.getApplicationServerName(), string2, string3, string);
                bl = false;
                break;
            }
            case 3: {
                CORBAObjectNameSpaceBinding cORBAObjectNameSpaceBinding = (CORBAObjectNameSpaceBinding)nameSpaceBinding;
                if (cORBAObjectNameSpaceBinding.getCorbanameUrl().length() != 0) break;
                this.issueConfiguredBindingValidationWarning("corbanameURL", "CORBAObjectNameSpaceBinding", string2, string3, string);
                bl = false;
            }
        }
        return bl;
    }

    private String expandVariables(String string) {
        return this._variableMap.expand(string);
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.server/src/com/ibm/ws/naming/bootstrap/ConfigInfoBuilder.java, WAS.naming.server, WAS61.SERV1, cf311012.09, ver. 1.28.1.3");
        }
        EXCLUDED_SERVER_TYPES = new HashSet();
        EXCLUDED_SERVER_TYPES.add("GENERIC_SERVER");
        EXCLUDED_SERVER_TYPES.add("WEB_SERVER");
    }

    private class ConfigInfoServerEntry {
        String _serverToAdd;
        String _node;
        String _bootstrapHost;
        String _bootstrapPort;
        String _type;
        String _serverShortName;
        String _genericShortName;

        public ConfigInfoServerEntry(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            this._serverToAdd = string;
            this._node = string2;
            this._bootstrapHost = string3;
            this._bootstrapPort = string4;
            this._type = string5;
            this._serverShortName = string6;
            this._genericShortName = string7;
        }
    }
}

