/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.bootstrap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.naming.bootstrap.ConfigInfoBuilder;
import com.ibm.ws.naming.bootstrap.ConfigInfoImpl;
import com.ibm.ws.naming.bootstrap.SecurityServiceListenerImpl;
import com.ibm.ws.naming.bootstrap.WsnNameServiceImpl;
import com.ibm.ws.naming.cosbase.ServantManager;
import com.ibm.ws.naming.distcos.ConfigDiff;
import com.ibm.ws.naming.distcos.ConfigInfo;
import com.ibm.ws.naming.distcos.NSBCellManager;
import com.ibm.ws.naming.distcos.NSBManagedAppSvr;
import com.ibm.ws.naming.distcos.NSBNodeAgent;
import com.ibm.ws.naming.distcos.NSBSingleAppSvr;
import com.ibm.ws.naming.distcos.NameSpaceBuilder;
import com.ibm.ws.naming.distcos.NameSpaceConstructionException;
import com.ibm.ws.naming.distcos.ServantManagerImpl;
import com.ibm.ws.naming.distcos.WsnDistributedNC;
import com.ibm.ws.naming.mbean.NameServerMBeanImpl;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.server.services.NameSpaceBindStatusImpl;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.management.ObjectName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class NameServerImpl
extends ComponentImpl
implements ConfigChangeListener {
    private static final TraceComponent _tc = Tr.register(NameServerImpl.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    static final String CONFIG_WARNINGS_ISSUED = "WARNING: Name Server Configuration: Due to previous warnings it is possible the name space will not be constructed correctly";
    private static final String[] CONFIG_URI_SUFFIXES;
    private static final String[] PROPERTY_CONFIG_URI_SUFFIXES;
    private static final String TRANSPORT_MODE = "com.ibm.CORBA.TransportMode";
    private static final String TRANSPORT_MODE_PLUGGABLE = "Pluggable";
    private static final String TRANSPORT_MODE_CFW = "ChannelFramework";
    private static boolean _restartMessageLogged;
    private static NameServerImpl _lock;
    private static boolean _cellPersistentRebuildEnabled;
    private ServantManager _adminServantMgr = null;
    private ConfigInfoImpl _ci = null;
    private com.ibm.CORBA.iiop.ORB _orb = null;
    private String _serverProcessType = null;
    private SecurityService _security = null;
    private String _cellName = null;
    private String _nodeName = null;
    private String _serverName = null;
    private String _serverLogRoot = null;
    private NameSpaceBuilder _nameSpaceBuilder;
    private static ObjectName _nameServerMBeanName;
    private static final String METHOD_mbeanInit = "mbeanInit()";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(java.lang.Object object) throws ConfigurationWarning, ConfigurationError {
        boolean bl;
        Repository repository2;
        block18: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "initialize");
            }
            _lock = this;
            repository2 = null;
            Server server2 = null;
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                this._serverProcessType = adminService.getProcessType();
                if (this._serverProcessType == null || this._serverProcessType.length() == 0) {
                    throw new ConfigurationError("Unable to configure Name Service. Server process type not available from AdminService");
                }
                _cellPersistentRebuildEnabled = this._serverProcessType.equals("NodeAgent");
                repository2 = (Repository)this.getService(Repository.class);
                ConfigRoot configRoot = repository2.getConfigRoot();
                server2 = (Server)this.getService(Server.class);
                ConfigInfoBuilder configInfoBuilder = null;
                VariableMap variableMap = null;
                try {
                    variableMap = (VariableMap)this.getService(VariableMap.class);
                    this._serverLogRoot = variableMap.expand("${LOG_ROOT}/" + server2.getName());
                    configInfoBuilder = new ConfigInfoBuilder(server2, variableMap, configRoot, this._serverProcessType);
                }
                finally {
                    if (variableMap != null) {
                        this.releaseService(variableMap);
                    }
                }
                this._ci = configInfoBuilder.buildConfigInfo();
                bl = this._ci.validateConfiguration();
                if (server2 == null) break block18;
            }
            catch (ConfigurationError configurationError) {
                try {
                    FFDCFilter.processException((Throwable)configurationError, "com.ibm.ws.naming.bootstrap.NameServerImpl.initialize", "209", this);
                    Tr.exit(_tc, "initialize: Configuration error", configurationError);
                    throw configurationError;
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.naming.bootstrap.NameServerImpl.initialize", "210", this);
                        Tr.exit(_tc, "initialize: Unknown error", throwable);
                        throw new ConfigurationError("Exception encountered while extracting configuration information for the Name Space", throwable);
                    }
                }
                catch (Throwable throwable) {
                    if (server2 != null) {
                        this.releaseService(server2);
                    }
                    if (repository2 != null) {
                        this.releaseService(repository2);
                    }
                    throw throwable;
                }
            }
            this.releaseService(server2);
        }
        if (repository2 != null) {
            this.releaseService(repository2);
        }
        if (bl) {
            Tr.warning(_tc, "cfWarningsIssued1");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "initialize: Warnings issued.");
            }
            throw new ConfigurationWarning(CONFIG_WARNINGS_ISSUED);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (_tc.isDebugEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        Admin admin2 = null;
        try {
            admin2 = (Admin)this.getService(Admin.class);
            admin2.removeConfigChangeListener(this);
        }
        finally {
            if (admin2 != null) {
                this.releaseService(admin2);
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        block28: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "start");
            }
            Admin admin2 = null;
            try {
                java.lang.Object object;
                ORB oRB = null;
                try {
                    oRB = (ORB)this.getService(ORB.class);
                    if (oRB == null) {
                        throw new RuntimeError("Name Server unable to obtain ORB");
                    }
                    this._orb = oRB.getORB();
                }
                catch (Throwable throwable) {
                    this.releaseService(oRB);
                    throw throwable;
                }
                this.releaseService(oRB);
                Repository repository2 = null;
                try {
                    repository2 = (Repository)this.getService(Repository.class);
                    object = repository2.getConfigRoot();
                    if (this._serverProcessType.equals("UnManagedProcess")) {
                        this._nameSpaceBuilder = new NSBSingleAppSvr(this._ci, (ConfigRoot)object, this._orb);
                    } else if (this._serverProcessType.equals("ManagedProcess")) {
                        this._nameSpaceBuilder = new NSBManagedAppSvr(this._ci, (ConfigRoot)object, this._orb);
                    } else if (this._serverProcessType.equals("NodeAgent")) {
                        this._nameSpaceBuilder = new NSBNodeAgent(this._ci, (ConfigRoot)object, this._orb);
                    } else if (this._serverProcessType.equals("DeploymentManager")) {
                        this._nameSpaceBuilder = new NSBCellManager(this._ci, (ConfigRoot)object, this._orb);
                    } else {
                        RuntimeError runtimeError = new RuntimeError("Name Server cannot build name space for server process type = " + this._serverProcessType);
                        Tr.exit(_tc, "start: RuntimeError", runtimeError);
                        throw runtimeError;
                    }
                    this._nameSpaceBuilder.buildNameSpace();
                    this.createAdminNameService();
                    this.createBindStatusService();
                    this.mbeanInit();
                    this.startBootstrapService(this._nameSpaceBuilder);
                }
                catch (NameSpaceConstructionException nameSpaceConstructionException) {
                    FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.bootstrap.NameServerImpl.start", "290", this);
                    Tr.exit(_tc, "start: NameSpaceConstructionException.  Mapping to RuntimeError.", nameSpaceConstructionException);
                    throw new RuntimeError("Unable to initialize the Name Service", nameSpaceConstructionException);
                }
                finally {
                    if (repository2 != null) {
                        this.releaseService(repository2);
                    }
                }
                this._security = (SecurityService)this.getService(SecurityService.class);
                if (this._security != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "saDoSecListenerReg");
                    }
                    object = new SecurityServiceListenerImpl(this._security);
                    this._security.addListener((SecurityServiceListener)object);
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "saSkipSecListenerReg");
                }
                admin2 = (Admin)this.getService(Admin.class);
                admin2.addConfigChangeListener(this);
                super.start();
                if (admin2 == null) break block28;
            }
            catch (Throwable throwable) {
                if (admin2 != null) {
                    this.releaseService(admin2);
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "start");
                }
                throw throwable;
            }
            this.releaseService(admin2);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "start");
        }
    }

    private void createAdminNameService() throws NameSpaceConstructionException {
        this._adminServantMgr = new ServantManagerImpl(this._orb, "WsnObjectAdapterAdmin", null);
        WsnDistributedNC wsnDistributedNC = new WsnDistributedNC(this._orb, this._adminServantMgr);
        try {
            this._orb.register_initial_reference("WsnAdminNameService", (Object)wsnDistributedNC);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.bootstrap.NameServerImpl.createAdminNameService", "451", this);
            throw new NameSpaceConstructionException("The initial reference \"WsnAdminNameService\" could not be registered with the ORB", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigRoot getConfigRoot() throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getConfigRoot()");
        }
        Repository repository2 = null;
        ConfigRoot configRoot = null;
        try {
            repository2 = (Repository)this.getService(Repository.class);
            configRoot = repository2.getConfigRoot();
        }
        finally {
            if (repository2 != null) {
                this.releaseService(repository2);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getConfigRoot()");
        }
        return configRoot;
    }

    private void createBindStatusService() throws NameSpaceConstructionException {
        try {
            NameSpaceBindStatusImpl nameSpaceBindStatusImpl = new NameSpaceBindStatusImpl();
            this._orb.register_initial_reference("WSNameSpaceBindStatus", (Object)nameSpaceBindStatusImpl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.bootstrap.NameServerImpl.createAdminNameService", "477", this);
            throw new NameSpaceConstructionException("The initial reference \"WSNameSpaceBindStatus\" could not be registered with the ORB", exception);
        }
    }

    private void updateNameSpace(ConfigDiff configDiff) {
        block8: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "updateNameSpace");
            }
            try {
                try {
                    final NameSpaceBuilder nameSpaceBuilder = this._nameSpaceBuilder;
                    final ConfigDiff configDiff2 = configDiff;
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public java.lang.Object run() throws Exception {
                            nameSpaceBuilder.updateNameSpace(configDiff2);
                            return null;
                        }
                    };
                    SecurityContext.runAsSystem(privilegedExceptionAction);
                    this._ci = (ConfigInfoImpl)configDiff.getNewConfig();
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "updateNameSpace: An error occurred while updating the name space in response to configuration changes.", nameSpaceConstructionException);
                }
            }
            catch (Throwable throwable) {
                if (!_tc.isEventEnabled()) break block8;
                Tr.event(_tc, "updateNameSpace: An error occurred while updating the name space in response to configuration changes.", throwable);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateNameSpace");
        }
    }

    private void startBootstrapService(NameSpaceBuilder nameSpaceBuilder) throws NameSpaceConstructionException {
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "startBootstrapService");
        }
        Properties properties = new Properties();
        try {
            WsnNameServiceImpl wsnNameServiceImpl = WsnNameServiceImpl.createInstance(nameSpaceBuilder.getBootObjectProperties(), this._orb);
            string = this._orb.object_to_string((Object)wsnNameServiceImpl);
            properties.put("WsnNameService", string);
            this._orb.register_initial_reference("WsnNameService", (Object)wsnNameServiceImpl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.bootstrap.NameServerImpl.startBootstrapService", "510", this);
            throw new NameSpaceConstructionException("Initial Service WsnNameService could not be created or could not be registered with the ORB", exception);
        }
        try {
            properties.put("NameService", nameSpaceBuilder.getCellRootIOR());
            this._orb.register_initial_reference("NameService", (Object)nameSpaceBuilder.getCellRootNC());
            properties.put("NameServiceCellRoot", nameSpaceBuilder.getCellRootIOR());
            this._orb.register_initial_reference("NameServiceCellRoot", (Object)nameSpaceBuilder.getCellRootNC());
            if (!this._ci.thisIsCellManager()) {
                properties.put("NameServiceHostRoot", nameSpaceBuilder.getNodeRootIOR());
                this._orb.register_initial_reference("NameServiceHostRoot", (Object)nameSpaceBuilder.getNodeRootNC());
                properties.put("NameServiceNodeRoot", nameSpaceBuilder.getNodeRootIOR());
                this._orb.register_initial_reference("NameServiceNodeRoot", (Object)nameSpaceBuilder.getNodeRootNC());
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "On cell manager: No node root IORs to register with ORB.");
            }
            properties.put("NameServiceServerRoot", nameSpaceBuilder.getServerRootIOR());
            this._orb.register_initial_reference("NameServiceServerRoot", (Object)nameSpaceBuilder.getServerRootNC());
            properties.put("NameServiceTreeRoot", nameSpaceBuilder.getTreeRootIOR());
            this._orb.register_initial_reference("NameServiceTreeRoot", (Object)nameSpaceBuilder.getTreeRootNC());
            properties.put("NameServiceCellPersistentRoot", nameSpaceBuilder.getCellPersistentRootIOR());
            this._orb.register_initial_reference("NameServiceCellPersistentRoot", (Object)nameSpaceBuilder.getCellPersistentRootNC());
            properties.put("NameServiceLegacyRoot", nameSpaceBuilder.getCellPersistentRootIOR());
            this._orb.register_initial_reference("NameServiceLegacyRoot", (Object)nameSpaceBuilder.getCellPersistentRootNC());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.bootstrap.NameServerImpl.startBootstrapService", "540", this);
            throw new NameSpaceConstructionException("One of the CosNaming NamingContext Initial Services could not be registered with the ORB", exception);
        }
        int n = this._orb.getBootstrapPort();
        string = this._orb.getBootstrapHost();
        try {
            this.createBootstrapServer(string, n, properties);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.naming.bootstrap.NameServerImpl.startBootstrapService", "560", this);
            String string2 = "nsInitBootSvrErr";
            String[] stringArray = new String[]{"" + n, systemException.toString()};
            Tr.error(_tc, string2, stringArray);
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Unable to start bootstrap server using port " + n + ". " + "Verify that no servers or other processes are already using the bootstrap server " + "port. Also verify that the bootstrap server is being started with a user ID " + "which has sufficient (e.g., root, Administrator) privileges.", systemException);
            throw nameSpaceConstructionException;
        }
        String string3 = "corbaloc:rir:/NameServiceServerRoot";
        System.setProperty("java.naming.provider.url", string3);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "startBootstrapService");
        }
    }

    private void createBootstrapServer(String string, int n, Properties properties) {
        String string2 = string + ":" + n;
        String string3 = this._orb.getProperty(TRANSPORT_MODE);
        if (string3 == null || !string3.equals(TRANSPORT_MODE_CFW)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "createBootstrapServer: Transport not CFW", "transportMode=" + string3);
            }
            String string4 = this._ci.getNameServerCustomProperty("BootstrapPortEnabled");
            boolean bl = true;
            if (this._serverProcessType.equals("UnManagedProcess")) {
                if (string4.equals("false")) {
                    bl = false;
                }
            } else if (string4.equals("false")) {
                Tr.warning(_tc, "cfNoSupportDisableBootstrap");
            }
            if (bl) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Attempting to start bootstrap server on host:port = " + string2);
                }
                this._orb.createBootstrapServer(n, properties);
                Tr.audit(_tc, "nsBootstrapPortOpen", "" + n);
            } else {
                Tr.audit(_tc, "nsBootstrapPortDisabled", "" + n);
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Transport is CFW");
            }
            Tr.audit(_tc, "nsBootstrapPortOpen", "" + n);
            this._orb.createBootstrapServer(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        java.lang.Object object;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "configChanged");
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = NameServerImpl.disableCellPersistentRebuild();
        boolean bl4 = false;
        String string = this._ci.thisCellName().toLowerCase() + "/namestore.xml";
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            int n;
            object = configChangeNotifierArray[i].getUri();
            String string2 = ((String)object).toLowerCase();
            for (n = 0; n < CONFIG_URI_SUFFIXES.length; ++n) {
                if (!string2.endsWith(CONFIG_URI_SUFFIXES[n])) continue;
                Tr.event(_tc, "Config file has changed, requiring name space update:", object);
                bl = true;
                break;
            }
            for (n = 0; n < PROPERTY_CONFIG_URI_SUFFIXES.length; ++n) {
                if (!string2.endsWith(PROPERTY_CONFIG_URI_SUFFIXES[n])) continue;
                Tr.event(_tc, "Config file which possibly contains custom properties has changed:", object);
                bl2 = true;
                break;
            }
            if (bl3 && string2.endsWith(string)) {
                Tr.event(_tc, "namestore.xml at cell level of a nodeAgent server has changed:", object);
                bl4 = true;
            }
            if (bl && bl2 && (!bl3 || bl4)) break;
        }
        try {
            NameServerImpl nameServerImpl = this;
            synchronized (nameServerImpl) {
                if (bl || bl2) {
                    object = this.createConfigDiff();
                    if (bl2) {
                        boolean bl5 = bl = this.updateNameServerCustomProperties((ConfigDiff)object) || bl;
                    }
                    if (bl) {
                        this.updateNameSpace((ConfigDiff)object);
                    }
                }
                if (bl4) {
                    this._nameSpaceBuilder.rebuildCellPersistentPartition(this.getConfigRoot());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "configChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCelllPersistentRebuildEnabled() {
        NameServerImpl nameServerImpl = _lock;
        synchronized (nameServerImpl) {
            return _cellPersistentRebuildEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean disableCellPersistentRebuild() {
        Tr.event(_tc, "disableCellPersistentRebuild: _cellPersistentRebuildEnabled = " + _cellPersistentRebuildEnabled);
        NameServerImpl nameServerImpl = _lock;
        synchronized (nameServerImpl) {
            boolean bl = _cellPersistentRebuildEnabled;
            _cellPersistentRebuildEnabled = false;
            return bl;
        }
    }

    private ConfigDiff createConfigDiff() throws Throwable {
        ConfigDiff configDiff;
        VariableMap variableMap;
        Server server2;
        block15: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "createConfigDiff");
            }
            Repository repository2 = null;
            server2 = null;
            variableMap = null;
            configDiff = null;
            try {
                repository2 = (Repository)this.getService(Repository.class);
                server2 = (Server)this.getService(Server.class);
                variableMap = (VariableMap)this.getService(VariableMap.class);
                ConfigInfoImpl configInfoImpl = null;
                try {
                    final Repository repository3 = repository2;
                    final Server server3 = server2;
                    final VariableMap variableMap2 = variableMap;
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public java.lang.Object run() throws Exception {
                            ConfigRoot configRoot = repository3.getConfigRoot();
                            ConfigInfoBuilder configInfoBuilder = new ConfigInfoBuilder(server3, variableMap2, configRoot, NameServerImpl.this._serverProcessType);
                            return configInfoBuilder.buildConfigInfo();
                        }
                    };
                    configInfoImpl = (ConfigInfoImpl)SecurityContext.runAsSystem(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                boolean bl = configInfoImpl.validateConfiguration();
                configDiff = new ConfigDiff(this._ci, configInfoImpl);
                if (bl) {
                    Tr.warning(_tc, "cfWarningsIssued1");
                }
                if (repository2 == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "createConfigDiff:  Could not create a ConfigDiff", throwable);
                    }
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (repository2 != null) {
                        this.releaseService(repository2);
                    }
                    if (server2 != null) {
                        this.releaseService(server2);
                    }
                    if (variableMap != null) {
                        this.releaseService(variableMap);
                    }
                    throw throwable2;
                }
            }
            this.releaseService(repository2);
        }
        if (server2 != null) {
            this.releaseService(server2);
        }
        if (variableMap != null) {
            this.releaseService(variableMap);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createConfigDiff");
        }
        return configDiff;
    }

    private void mbeanInit() throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "mbeanInit");
        }
        if (_nameServerMBeanName != null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "mbeanInit: Already initialized");
            }
            return;
        }
        NameServerMBeanImpl nameServerMBeanImpl = new NameServerMBeanImpl(this._serverLogRoot);
        MBeanFactory mBeanFactory = AdminServiceFactory.getAdminService().getMBeanFactory();
        try {
            _nameServerMBeanName = mBeanFactory.activateMBean("NameServer", nameServerMBeanImpl, mBeanFactory.getConfigId("NameServer"), "com/ibm/ws/management/descriptor/xml/NameServer.xml");
            if (_nameServerMBeanName == null) {
                NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Received a null object name from MBeanFactory.activateMBean.");
                throw nameSpaceConstructionException;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Created MBean: ObjectName=" + _nameServerMBeanName.toString());
            }
        }
        catch (AdminException adminException) {
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Received an error activating MBean.", adminException);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "mbeanInit: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "mbeanInit");
        }
    }

    private boolean updateNameServerCustomProperties(ConfigDiff configDiff) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateNameServerCustomProperties");
        }
        ConfigInfo configInfo = configDiff.getOldConfig();
        ConfigInfo configInfo2 = configDiff.getNewConfig();
        if (configInfo == null || configInfo2 == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateNameServerCustomProperties", "updateNameSpace=false");
            }
            return false;
        }
        boolean bl = false;
        String string = "BootstrapPortEnabled";
        if (!configInfo.getNameServerCustomProperty(string).equals(configInfo2.getNameServerCustomProperty(string))) {
            String string2 = "cfPropChangedSvrRestart";
            String string3 = string;
            Tr.warning(_tc, string2, string3);
        }
        if (!configInfo.getNameServerCustomProperty(string = "naming.systemNameSpace.scope").equals(configInfo2.getNameServerCustomProperty(string))) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Name space scope changed.  Need to update name space.");
            }
            bl = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateNameServerCustomProperties", "updateNameSpace=" + bl);
        }
        return bl;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.server/src/com/ibm/ws/naming/bootstrap/NameServerImpl.java, WAS.naming.server, WAS61.SERV1, cf311012.09, ver. 1.85.1.1");
        }
        CONFIG_URI_SUFFIXES = new String[]{"/serverindex.xml", "/cluster.xml", "/namebindings.xml", "/cell.xml"};
        PROPERTY_CONFIG_URI_SUFFIXES = new String[]{"/server.xml", "/node.xml"};
        _restartMessageLogged = false;
        _lock = null;
        _cellPersistentRebuildEnabled = false;
        _nameServerMBeanName = null;
    }
}

