/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.bootstrap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;

public class SecurityServiceListenerImpl
implements SecurityServiceListener {
    private static final TraceComponent _tc = Tr.register(SecurityServiceListenerImpl.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static RoleBasedAuthorizer _securityAuthorizer;
    private static SecurityService _secService;
    private static boolean _isInitialized;

    protected SecurityServiceListenerImpl(SecurityService securityService) {
        _secService = securityService;
    }

    public void stateChanged(SecurityServiceEvent securityServiceEvent) {
        Tr.entry(_tc, "stateChanged");
        int n = securityServiceEvent.getState();
        if (n == 1) {
            this.initializeSecurityAuthorizer();
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Security service state change to: " + n);
        }
    }

    public static RoleBasedAuthorizer getSecurityAuthorizer() throws RoleBasedAppException {
        if (!_isInitialized) {
            throw new RoleBasedAppException("Naming RoleBasedAuthorizer has no been initialized.");
        }
        return _securityAuthorizer;
    }

    private void initializeSecurityAuthorizer() {
        Object object;
        Tr.entry(_tc, "initializeSecurityAuthorizer");
        if (_securityAuthorizer != null) {
            Tr.exit(_tc, "initializeSecurityAuthorizer: already initialized");
            return;
        }
        RoleBasedAuthorizer roleBasedAuthorizer = null;
        try {
            object = _secService.getConfigurator();
            roleBasedAuthorizer = object.loadSecurityPolicy("naming-authz", "/com/ibm/ws/naming/bootstrap/xml/NameServer.xml", "domain");
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.naming.bootstrap.SecurityServiceListenerImpl.initializeSecurityAuthorizer", "100");
            String string = "Caught exception trying to get authorizer: " + exception;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Attempt to get authorizer failed: " + string);
            }
            Tr.exit(_tc, "initializeSecurityAuthorizer: exception caught");
            return;
        }
        _securityAuthorizer = roleBasedAuthorizer;
        if (roleBasedAuthorizer == null) {
            object = "Failed to initialize RoleBasedAuthorization.";
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Attempt to get authorizer failed: " + (String)object);
            }
            Tr.exit(_tc, "initializeSecurityAuthorizer: " + (String)object);
            return;
        }
        _isInitialized = true;
        Tr.exit(_tc, "initializeSecurityAuthorizer: completed successfully");
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.server/src/com/ibm/ws/naming/bootstrap/SecurityServiceListenerImpl.java, WAS.naming.server, WAS61.SERV1, cf311012.09, ver. 1.6");
        }
        _securityAuthorizer = null;
        _secService = null;
        _isInitialized = false;
    }
}

