/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.bootstrap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.naming.mbean.NameServerMBeanImpl;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import javax.management.ObjectName;

public class ServantNameServiceImpl
extends ComponentImpl {
    private static final TraceComponent _tc = Tr.register(ServantNameServiceImpl.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "initialize");
        }
        if (!AdminHelper.getPlatformHelper().isZOS() || !AdminHelper.getPlatformHelper().isServantJvm()) {
            ComponentDisabledException componentDisabledException = new ComponentDisabledException("This component applies only to z/OS servant processes.");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "initialize: Process is not a z/OS servant.");
            }
            throw componentDisabledException;
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        try {
            this.mbeanInit();
        }
        catch (RuntimeWarning runtimeWarning) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "start: RuntimeWarning: " + runtimeWarning);
            }
            throw runtimeWarning;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Start processing completed successfully.  Invoking super.start().");
        }
        super.start();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "start");
        }
    }

    public void destroy() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "destroy");
        }
    }

    private void mbeanInit() throws RuntimeWarning {
        String string;
        VariableMap variableMap;
        block15: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "mbeanInit");
            }
            Server server2 = null;
            variableMap = null;
            string = null;
            try {
                server2 = (Server)this.getService(Server.class);
                variableMap = (VariableMap)this.getService(VariableMap.class);
                string = variableMap.expand("${LOG_ROOT}/" + server2.getName());
                if (server2 == null) break block15;
            }
            catch (Exception exception) {
                try {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.bootstrap.ServantNameServiceImpl.initialize", "155", this);
                    RuntimeWarning runtimeWarning = new RuntimeWarning("Received exception while getting the server log root.", exception);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "mbeanInit: RuntimeWarning:", runtimeWarning);
                    }
                    throw runtimeWarning;
                }
                catch (Throwable throwable) {
                    if (server2 != null) {
                        this.releaseService(server2);
                    }
                    if (variableMap != null) {
                        this.releaseService(variableMap);
                    }
                    throw throwable;
                }
            }
            this.releaseService(server2);
        }
        if (variableMap != null) {
            this.releaseService(variableMap);
        }
        NameServerMBeanImpl nameServerMBeanImpl = new NameServerMBeanImpl(string);
        MBeanFactory mBeanFactory = AdminServiceFactory.getAdminService().getMBeanFactory();
        ObjectName objectName = null;
        try {
            objectName = mBeanFactory.activateMBean("NameServer", nameServerMBeanImpl, mBeanFactory.getConfigId("NameServer"), "com/ibm/ws/management/descriptor/xml/NameServer.xml");
        }
        catch (AdminException adminException) {
            RuntimeWarning runtimeWarning = new RuntimeWarning("Received error activating NameServer MBean.", adminException);
            FFDCFilter.processException((Throwable)runtimeWarning, "com.ibm.ws.naming.bootstrap.ServantNameServiceImpl.initialize", "180", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "mbeanInit: RuntimeWarning:", runtimeWarning);
            }
            throw runtimeWarning;
        }
        if (objectName == null) {
            RuntimeWarning runtimeWarning = new RuntimeWarning("Received a null object name from MBeanFactory.activateMBean.");
            FFDCFilter.processException((Throwable)runtimeWarning, "com.ibm.ws.naming.bootstrap.ServantNameServiceImpl.initialize", "190", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "mbeanInit: RuntimeWarning:", runtimeWarning);
            }
            throw runtimeWarning;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "mbeanInit: Created NameServer MBean", "ObjectName=" + objectName.toString());
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.server/src/com/ibm/ws/naming/bootstrap/ServantNameServiceImpl.java, WAS.naming.server, WAS61.SERV1, cf311012.09, ver. 1.1");
        }
    }
}

