/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.distcos;

import [Lorg.omg.CosNaming.NameComponent;;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.cosbase.ServantManager;
import com.ibm.ws.naming.cosbase.WsnOptimizedNamingImplBase;
import com.ibm.ws.naming.distcos.ConfigDiff;
import com.ibm.ws.naming.distcos.ConfigInfo;
import com.ibm.ws.naming.distcos.ConfiguredBindingInfo;
import com.ibm.ws.naming.distcos.EndpointGroup;
import com.ibm.ws.naming.distcos.NameSpaceConstructionException;
import com.ibm.ws.naming.distcos.ServantManagerImpl;
import com.ibm.ws.naming.distcos.WsnDistributedNC;
import com.ibm.ws.naming.distcos.WsnLocalNCHelper;
import com.ibm.ws.naming.ipbase.NameSpace;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.ipcos.AdditionalData;
import com.ibm.ws.naming.jcache.CacheManager;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.IndirectJndiLookupFactoryImpl;
import com.ibm.ws.naming.util.Serialization;
import com.ibm.ws.naming.util.WsnName;
import com.ibm.ws.runtime.service.ConfigRoot;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.Referenceable;
import org.omg.CORBA.Any;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;

public abstract class NameSpaceBuilder {
    private static final TraceComponent tc = Tr.register(NameSpaceBuilder.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String BINDING_NAME_CLUSTERS = "clusters";
    private static final String BINDING_NAME_SERVERS = "servers";
    private static final String BINDING_NAME_NODE = "node";
    private static final String BINDING_NAME_NODES = "nodes";
    protected static final String BINDING_NAME_CELL = "cell";
    private static final String BINDING_NAME_DOMAIN = "domain";
    private static final String BINDING_NAME_NODE_AGENT = "nodeAgent";
    private static final String BINDING_NAME_CELL_MANAGER = "deploymentManager";
    private static final String BINDING_NAME_THIS_NODE = "thisNode";
    protected static final String BINDING_NAME_PERSISTENT = "persistent";
    private static final String BINDING_NAME_LEGACY_ROOT = "legacyRoot";
    private static final String BINDING_NAME_CELLS = "cells";
    private static final String BINDING_NAME_CELLNAME = "cellname";
    private static final String BINDING_NAME_NODENAME = "nodename";
    private static final String BINDING_NAME_SERVERNAME = "servername";
    private static final int FIXED_PARAMETER_COUNT = 3;
    private WsnDistributedNC _treeRootNC = null;
    protected WsnDistributedNC _cellRootNC = null;
    private WsnDistributedNC _nodesNC = null;
    private WsnDistributedNC _cellClustersNC = null;
    protected WsnDistributedNC _cellPersistentRootNC = null;
    private WsnDistributedNC _foreignCellsNC = null;
    private WsnDistributedNC _serverRootNC = null;
    private WsnDistributedNC _nodeRootNC = null;
    private WsnDistributedNC _nodePersistentRootNC = null;
    private WsnDistributedNC _nodePhysicalServersNC = null;
    private String _treeRootIOR = null;
    private String _cellRootIOR = null;
    private String _nodesIOR = null;
    private String _cellClustersIOR = null;
    private String _cellPersistentRootIOR = null;
    private String _foreignCellsIOR = null;
    private String _serverRootIOR = null;
    private String _nodeRootIOR = null;
    private String _nodePersistentRootIOR = null;
    private String _nodePhysicalServersIOR = null;
    protected ConfigInfo _config = null;
    protected ConfigDiff _configDiff = null;
    protected ORB _orb = null;
    protected ServantManager _servantMgrWlm = null;
    protected ServantManager _servantMgrNonWlm = null;
    private boolean _isCellManager;
    private boolean _isClusterMember;
    private String _thisNodeName;
    private String _thisServerName;
    private String _thisLogicalServerName;
    private boolean _thisIsStandaloneAppServer;
    private EndpointGroup _thisServerEndpoint;
    private boolean _errorDuringUpdate;

    public NameSpaceBuilder(ConfigInfo configInfo, ORB oRB) {
        this._config = configInfo;
        this._orb = oRB;
        this._isCellManager = this._config.thisIsCellManager();
        this._isClusterMember = this._config.thisClusterName().length() != 0;
        this._servantMgrWlm = new ServantManagerImpl(this._orb, "WsnDistCosObjectAdapterWLM", this._isClusterMember ? this._config.thisClusterName() : null);
        this._servantMgrNonWlm = new ServantManagerImpl(this._orb, "WsnDistCosObjectAdapterNonWLM", null);
        this._thisNodeName = this._config.thisNodeName();
        this._thisServerName = this._config.thisServerName();
        this._thisLogicalServerName = this._config.thisLogicalServerName();
        this._thisIsStandaloneAppServer = this._config.thisIsStandaloneAppServer();
        this._thisServerEndpoint = this._config.getThisServerEndpoint();
    }

    protected abstract NCInfo getTreeRootInfo() throws NameSpaceConstructionException;

    protected abstract NCInfo getCellRootInfo() throws NameSpaceConstructionException;

    protected abstract NCInfo getCellClustersInfo() throws NameSpaceConstructionException;

    protected abstract NCInfo getServerRootInfo() throws NameSpaceConstructionException;

    protected abstract NCInfo getNodesInfo() throws NameSpaceConstructionException;

    protected abstract NCInfo getNodeRootInfo() throws NameSpaceConstructionException;

    protected abstract NCInfo getNodePhysicalServersInfo() throws NameSpaceConstructionException;

    protected abstract NCInfo getForeignCellsInfo() throws NameSpaceConstructionException;

    protected abstract NCInfo getConfiguredIntermediateNCInfo() throws NameSpaceConstructionException;

    protected abstract WsnDistributedNC getCellPersistentRoot(WsnDistributedNC var1, String var2, boolean var3) throws NameSpaceConstructionException;

    protected abstract WsnDistributedNC getNodePersistentRoot(WsnDistributedNC var1, String var2) throws NameSpaceConstructionException;

    public void buildNameSpace() throws NameSpaceConstructionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildNameSpace: implementation " + this.getClass());
        }
        this._treeRootNC = this.createRootNC(this.getTreeRootInfo());
        this._treeRootIOR = this.getNCStringifiedIOR(this._treeRootNC);
        this._cellRootNC = this.bindNewNC(this.getCellRootInfo(), this._treeRootNC, this.escapeDots(this._config.thisCellName()));
        this._cellRootIOR = this.getNCStringifiedIOR(this._cellRootNC);
        this._nodesNC = this.bindNewNC(this.getNodesInfo(), this._cellRootNC, BINDING_NAME_NODES);
        this._nodesIOR = this.getNCStringifiedIOR(this._nodesNC);
        this._cellClustersNC = this.bindNewNC(this.getCellClustersInfo(), this._cellRootNC, BINDING_NAME_CLUSTERS);
        this._cellClustersIOR = this.getNCStringifiedIOR(this._cellClustersNC);
        this._foreignCellsNC = this.bindNewNC(this.getForeignCellsInfo(), this._cellRootNC, BINDING_NAME_CELLS);
        this._foreignCellsIOR = this.getNCStringifiedIOR(this._foreignCellsNC);
        this._nodeRootNC = this.bindNewNC(this.getNodeRootInfo(), this._nodesNC, this.escapeDots(this._thisNodeName));
        this._nodeRootIOR = this.getNCStringifiedIOR(this._nodeRootNC);
        this._nodePhysicalServersNC = this.bindNewNC(this.getNodePhysicalServersInfo(), this._nodeRootNC, BINDING_NAME_SERVERS);
        this._nodePhysicalServersIOR = this.getNCStringifiedIOR(this._nodePhysicalServersNC);
        if (!this._isCellManager) {
            this._nodePersistentRootNC = this.getNodePersistentRoot(this._nodeRootNC, BINDING_NAME_PERSISTENT);
            this.bindExistingPrimaryNC(this._nodeRootNC, this._nodePersistentRootNC, BINDING_NAME_PERSISTENT);
            this._nodePersistentRootNC.markAsUnDeleteable();
            this._nodePersistentRootIOR = this.getNCStringifiedIOR(this._nodePersistentRootNC);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "On cell manager: Skipping the creation of node persistent root.");
        }
        this._cellPersistentRootNC = this.getCellPersistentRoot(this._cellRootNC, BINDING_NAME_PERSISTENT, true);
        this.bindExistingPrimaryNC(this._cellRootNC, this._cellPersistentRootNC, BINDING_NAME_PERSISTENT);
        this._cellPersistentRootNC.markAsUnDeleteable();
        this._cellPersistentRootIOR = this.getNCStringifiedIOR(this._cellPersistentRootNC);
        if (this._isClusterMember) {
            this._serverRootNC = this.bindNewNC(this.getServerRootInfo(), this._cellClustersNC, this.escapeDots(this._config.thisLogicalServerName()));
            this._serverRootIOR = this.getNCStringifiedIOR(this._serverRootNC);
        } else {
            this._serverRootNC = this.bindNewNC(this.getServerRootInfo(), this._nodePhysicalServersNC, this.escapeDots(this._thisServerName));
            this._serverRootIOR = this.getNCStringifiedIOR(this._serverRootNC);
        }
        this.bindExistingLinkedNC(this._cellPersistentRootNC, this._cellRootNC, BINDING_NAME_CELL);
        this.bindExistingLinkedNC(this._cellRootNC, this._cellRootNC, BINDING_NAME_CELL);
        this.bindExistingLinkedNC(this._serverRootNC, this._cellRootNC, BINDING_NAME_CELL);
        this.bindExistingLinkedNC(this._nodeRootNC, this._cellRootNC, BINDING_NAME_CELL);
        this.bindExistingLinkedNC(this._nodeRootNC, this._cellRootNC, BINDING_NAME_DOMAIN);
        this.bindExistingLinkedNC(this._nodeRootNC, this._nodeRootNC, BINDING_NAME_NODE);
        if (this._isClusterMember) {
            this.bindExistingLinkedNC(this._nodePhysicalServersNC, this._serverRootNC, this.escapeDots(this._thisServerName));
        }
        this.bindExistingLinkedNC(this._cellRootNC, this._cellRootNC, BINDING_NAME_DOMAIN);
        this.bindExistingLinkedNC(this._cellRootNC, this._cellPersistentRootNC, BINDING_NAME_LEGACY_ROOT);
        this.bindExistingLinkedNC(this._serverRootNC, this._nodeRootNC, BINDING_NAME_THIS_NODE);
        this.bindStringObject(this._cellRootNC, this._config.thisCellName(), BINDING_NAME_CELLNAME);
        this.bindStringObject(this._serverRootNC, this._config.thisLogicalServerName(), BINDING_NAME_SERVERNAME);
        this.bindStringObject(this._nodeRootNC, this._thisNodeName, BINDING_NAME_NODENAME);
        this._configDiff = new ConfigDiff(null, this._config);
        this.buildChangeableStructure(true);
        WsnLocalNCHelper.setInitialNC(this._serverRootNC);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildNameSpace: implementation " + this.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNameSpace(ConfigDiff configDiff) throws NameSpaceConstructionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNameSpace");
        }
        this._configDiff = configDiff;
        this._config = configDiff.getNewConfig();
        try {
            this._errorDuringUpdate = false;
            this.buildChangeableStructure(false);
            java.lang.Object var3_2 = null;
            this._configDiff = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var3_3 = null;
            this._configDiff = null;
            CacheManager.clearAllCaches();
            if (this._errorDuringUpdate && tc.isEventEnabled()) {
                Tr.event(tc, "updateNameSpace:", "An error occurred while updating the name space in response to configuration changes.");
            }
            if (!(this._thisNodeName.equals(this._config.thisNodeName()) && this._thisServerName.equals(this._config.thisServerName()) && this._thisLogicalServerName.equals(this._config.thisLogicalServerName()) && this._thisIsStandaloneAppServer == this._config.thisIsStandaloneAppServer() && this._thisServerEndpoint.toString().equals(this._config.getThisServerEndpoint().toString()))) {
                Tr.event(tc, "Configuration change requires name server restart.", new java.lang.Object[]{"oldNodeName=" + this._thisNodeName + ", newNodeName=" + this._config.thisNodeName(), "oldServerName=" + this._thisServerName + ", newServerName=" + this._config.thisServerName(), "oldLogicalServerName=" + this._thisLogicalServerName + ", newLogicalServerName=" + this._config.thisLogicalServerName(), "oldIsStandaloneAppSvr=" + this._thisIsStandaloneAppServer + ", newIsStandaloneAppSvr=" + this._config.thisIsStandaloneAppServer(), "oldServerEndpoint=" + this._thisServerEndpoint.toString() + ", newServerEndpoint=" + this._config.getThisServerEndpoint().toString()});
                Tr.warning(tc, "cfSvrRestartRequired");
            }
            throw throwable;
        }
        CacheManager.clearAllCaches();
        if (this._errorDuringUpdate && tc.isEventEnabled()) {
            Tr.event(tc, "updateNameSpace:", "An error occurred while updating the name space in response to configuration changes.");
        }
        if (!(this._thisNodeName.equals(this._config.thisNodeName()) && this._thisServerName.equals(this._config.thisServerName()) && this._thisLogicalServerName.equals(this._config.thisLogicalServerName()) && this._thisIsStandaloneAppServer == this._config.thisIsStandaloneAppServer() && this._thisServerEndpoint.toString().equals(this._config.getThisServerEndpoint().toString()))) {
            Tr.event(tc, "Configuration change requires name server restart.", new java.lang.Object[]{"oldNodeName=" + this._thisNodeName + ", newNodeName=" + this._config.thisNodeName(), "oldServerName=" + this._thisServerName + ", newServerName=" + this._config.thisServerName(), "oldLogicalServerName=" + this._thisLogicalServerName + ", newLogicalServerName=" + this._config.thisLogicalServerName(), "oldIsStandaloneAppSvr=" + this._thisIsStandaloneAppServer + ", newIsStandaloneAppSvr=" + this._config.thisIsStandaloneAppServer(), "oldServerEndpoint=" + this._thisServerEndpoint.toString() + ", newServerEndpoint=" + this._config.getThisServerEndpoint().toString()});
            Tr.warning(tc, "cfSvrRestartRequired");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNameSpace");
        }
    }

    private void buildChangeableStructure(boolean bl) throws NameSpaceConstructionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildChangeableStructure");
        }
        if (!this._thisIsStandaloneAppServer) {
            this.updateNodeAgentAndCellManagerBindings(bl);
            this.updateBindingsForClusters(bl);
            this.updateBindingsForServersInNode(bl, this._thisNodeName, this._nodePhysicalServersNC);
            this.updateBindingsForServersInOtherNodes(bl);
        }
        this.updateConfiguredBindings();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildChangeableStructure");
        }
    }

    private void updateNodeAgentAndCellManagerBindings(boolean bl) throws NameSpaceConstructionException {
        String string;
        boolean bl2;
        boolean bl3;
        String string2 = null;
        if (!bl) {
            string2 = this._configDiff.getOldConfig().getNameServerCustomProperty("naming.systemNameSpace.scope");
        }
        String string3 = this._configDiff.getNewConfig().getNameServerCustomProperty("naming.systemNameSpace.scope");
        if (this._config.thisIsNodeAgent()) {
            if (bl) {
                this.bindExistingLinkedNC(this._nodeRootNC, this._serverRootNC, BINDING_NAME_NODE_AGENT);
            }
        } else if (!this._isCellManager) {
            bl3 = bl ? false : this.isWithinScope(string2, BINDING_NAME_NODE);
            bl2 = this.isWithinScope(string3, BINDING_NAME_NODE);
            if (!bl3 && bl2) {
                string = this.getCorbaUrl(this._config.getThisNodeAgentEndpoint(), "NameServiceServerRoot", null);
                this.bindRemoteNC(this._nodeRootNC, string, BINDING_NAME_NODE_AGENT);
            } else if (bl3 && !bl2) {
                this.unbind(this._nodeRootNC, BINDING_NAME_NODE_AGENT);
            }
        } else if (bl && tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell Manager process. Not creating a node root \"nodeAgent\" binding.");
        }
        if (this._isCellManager) {
            if (bl) {
                this.bindExistingLinkedNC(this._cellRootNC, this._serverRootNC, BINDING_NAME_CELL_MANAGER);
            }
        } else {
            bl3 = bl ? false : this.isWithinScope(string2, BINDING_NAME_CELL);
            bl2 = this.isWithinScope(string3, BINDING_NAME_CELL);
            if (!bl3 && bl2) {
                string = this.getCorbaUrl(this._config.getThisCellManagerEndpoint(), "NameServiceServerRoot", null);
                this.bindRemoteNC(this._cellRootNC, string, BINDING_NAME_CELL_MANAGER);
            } else if (bl3 && !bl2) {
                this.unbind(this._cellRootNC, BINDING_NAME_CELL_MANAGER);
            }
        }
    }

    private boolean isWithinScope(String string, String string2) {
        int n = this.compareScope(string, string2);
        return n != -1;
    }

    private int compareScope(String string, String string2) {
        int n = string2.equals(BINDING_NAME_CELL) ? (string.equals(BINDING_NAME_CELL) ? 0 : -1) : (string2.equals(BINDING_NAME_NODE) ? (string.equals(BINDING_NAME_NODE) ? 0 : (string.equals("server") ? -1 : 1)) : (string.equals("server") ? 0 : 1));
        return n;
    }

    private void updateBindingsForClusters(boolean bl) throws NameSpaceConstructionException {
        String string;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateBindingsForClusters");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unbinding deleted clusters...");
        }
        EndpointGroup[] endpointGroupArray = this._configDiff.getDeletedClustersEndpoints();
        for (n = 0; n < endpointGroupArray.length; ++n) {
            try {
                if (endpointGroupArray[n].getName().equals(this._thisLogicalServerName)) continue;
                this.unbind(this._cellClustersNC, this.escapeDots(endpointGroupArray[n].getName()));
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to unbind cluster from name space.", nameSpaceConstructionException);
                if (bl) {
                    throw nameSpaceConstructionException;
                }
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Rebinding reconfigured clusters...");
        }
        endpointGroupArray = this._configDiff.getModifiedClustersEndpoints();
        for (n = 0; n < endpointGroupArray.length; ++n) {
            try {
                if (endpointGroupArray[n].getName().equals(this._thisLogicalServerName)) continue;
                string = this.getCorbaUrl(endpointGroupArray[n], "NameServiceServerRoot", null);
                this.rebindRemoteNC(this._cellClustersNC, string, this.escapeDots(endpointGroupArray[n].getName()));
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to rebind cluster in name space.", nameSpaceConstructionException);
                if (bl) {
                    throw nameSpaceConstructionException;
                }
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding new clusters...");
        }
        endpointGroupArray = this._configDiff.getNewClustersEndpoints();
        for (n = 0; n < endpointGroupArray.length; ++n) {
            try {
                if (endpointGroupArray[n].getName().equals(this._thisLogicalServerName)) continue;
                string = this.getCorbaUrl(endpointGroupArray[n], "NameServiceServerRoot", null);
                this.bindRemoteNC(this._cellClustersNC, string, this.escapeDots(endpointGroupArray[n].getName()));
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to bind cluster to name space.", nameSpaceConstructionException);
                if (bl) {
                    throw nameSpaceConstructionException;
                }
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateBindingsForClusters");
        }
    }

    private void updateBindingsForServersInOtherNodes(boolean bl) throws NameSpaceConstructionException {
        java.lang.Object object;
        java.lang.Object object2;
        WsnDistributedNC wsnDistributedNC;
        String string;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateBindingsForServersInOtherNodes");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unbinding deleted nodes...");
        }
        String[] stringArray = this._configDiff.getDeletedNodeNames();
        for (n = 0; n < stringArray.length; ++n) {
            string = "[NOT SET]";
            try {
                string = stringArray[n];
                wsnDistributedNC = (WsnDistributedNC)this._nodesNC.resolve_str(this.escapeDots(string));
                object2 = (WsnDistributedNC)wsnDistributedNC.resolve_str(BINDING_NAME_SERVERS);
                this.unbindAllBindingsForServersInNode(string, (WsnDistributedNC)object2);
                if (!this._config.getCellMgrNodeName().equals(string)) {
                    this.unbind(wsnDistributedNC, BINDING_NAME_PERSISTENT);
                    this.unbind(wsnDistributedNC, BINDING_NAME_NODE_AGENT);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Skipping unbind of contexts \"persistent\" and \"nodeAgent\" under node root for node \"" + string + "\".");
                }
                this.unbind(wsnDistributedNC, BINDING_NAME_CELL);
                this.unbind(wsnDistributedNC, BINDING_NAME_DOMAIN);
                this.unbind(wsnDistributedNC, BINDING_NAME_NODE);
                this.unbind(wsnDistributedNC, BINDING_NAME_NODENAME);
                ((WsnDistributedNC)object2).markAsDeleteable();
                ((WsnDistributedNC)object2).destroyPrimaryContext();
                wsnDistributedNC.markAsDeleteable();
                wsnDistributedNC.destroyPrimaryContext();
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to unbind node " + string + " from name space.", nameSpaceConstructionException);
                if (bl) {
                    throw nameSpaceConstructionException;
                }
                this._errorDuringUpdate = true;
                continue;
            }
            catch (Exception exception) {
                object2 = "Exception occurred while attempting to unbind node " + string + " from name space.";
                Tr.event(tc, (String)object2, exception);
                if (bl) {
                    NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException((String)object2, exception);
                    throw nameSpaceConstructionException;
                }
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Rebinding reconfigured nodes...");
        }
        stringArray = this._configDiff.getNodeNamesWithModifiedNodeAgentEndpoint();
        for (n = 0; n < stringArray.length; ++n) {
            string = "[NOT SET]";
            try {
                string = stringArray[n];
                wsnDistributedNC = (WsnDistributedNC)this._nodesNC.resolve_str(this.escapeDots(string));
                if (!this._config.getCellMgrNodeName().equals(string)) {
                    object2 = this.getCorbaUrl(this._config.getNodeAgentEndpoint(string), "NameServiceNodeRoot", BINDING_NAME_PERSISTENT);
                    this.rebindRemoteNC(wsnDistributedNC, (String)object2, BINDING_NAME_PERSISTENT);
                    object = this.getCorbaUrl(this._config.getNodeAgentEndpoint(string), "NameServiceServerRoot", null);
                    this.rebindRemoteNC(wsnDistributedNC, (String)object, BINDING_NAME_NODE_AGENT);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Skipping rebind of contexts \"persistent\" and \"nodeAgent\" under node root for node \"" + string + "\".");
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to rebind node " + string + " in name space.", nameSpaceConstructionException);
                if (bl) {
                    throw nameSpaceConstructionException;
                }
                this._errorDuringUpdate = true;
                continue;
            }
            catch (Exception exception) {
                object2 = "Exception occurred while attempting to unbind node " + string + " from name space.";
                Tr.event(tc, (String)object2, exception);
                if (bl) {
                    object = new NameSpaceConstructionException((String)object2, exception);
                    throw object;
                }
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding new nodes...");
        }
        stringArray = this._configDiff.getNewNodeNames();
        for (n = 0; n < stringArray.length; ++n) {
            string = "[NOT SET]";
            try {
                string = stringArray[n];
                wsnDistributedNC = this.bindNewNC(this.getNodeRootInfo(), this._nodesNC, this.escapeDots(string));
                object2 = this.bindNewNC(this.getNodePhysicalServersInfo(), wsnDistributedNC, BINDING_NAME_SERVERS);
                if (!this._config.getCellMgrNodeName().equals(string)) {
                    object = this.getCorbaUrl(this._config.getNodeAgentEndpoint(string), "NameServiceNodeRoot", BINDING_NAME_PERSISTENT);
                    this.bindRemoteNC(wsnDistributedNC, (String)object, BINDING_NAME_PERSISTENT);
                    String string2 = this.getCorbaUrl(this._config.getNodeAgentEndpoint(string), "NameServiceServerRoot", null);
                    this.bindRemoteNC(wsnDistributedNC, string2, BINDING_NAME_NODE_AGENT);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Skipping bind of contexts \"persistent\" and \"nodeAgent\" under node root for node \"" + string + "\".");
                }
                this.bindExistingLinkedNC(wsnDistributedNC, this._cellRootNC, BINDING_NAME_CELL);
                this.bindExistingLinkedNC(wsnDistributedNC, this._cellRootNC, BINDING_NAME_DOMAIN);
                this.bindExistingLinkedNC(wsnDistributedNC, wsnDistributedNC, BINDING_NAME_NODE);
                this.bindStringObject(wsnDistributedNC, string, BINDING_NAME_NODENAME);
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to bind node " + string + " to name space.", nameSpaceConstructionException);
                if (bl) {
                    throw nameSpaceConstructionException;
                }
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Updating physical server bindings for other nodes...");
        }
        stringArray = this._config.getOtherNodeNames();
        for (n = 0; n < stringArray.length; ++n) {
            string = "[NOT SET]";
            try {
                string = stringArray[n];
                wsnDistributedNC = (WsnDistributedNC)this._nodesNC.resolve_str(this.escapeDots(string));
                object2 = (WsnDistributedNC)wsnDistributedNC.resolve_str(BINDING_NAME_SERVERS);
                this.updateBindingsForServersInNode(bl, string, (WsnDistributedNC)object2);
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to rebind node " + string + " in name space.", nameSpaceConstructionException);
                if (bl) {
                    throw nameSpaceConstructionException;
                }
                this._errorDuringUpdate = true;
                continue;
            }
            catch (Exception exception) {
                object2 = "Exception occurred while attempting to unbind node " + string + " from name space.";
                Tr.event(tc, (String)object2, exception);
                if (bl) {
                    object = new NameSpaceConstructionException((String)object2, exception);
                    throw object;
                }
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateBindingsForServersInOtherNodes");
        }
    }

    private void updateBindingsForServersInNode(boolean bl, String string, WsnDistributedNC wsnDistributedNC) throws NameSpaceConstructionException {
        String string2;
        String string3;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateBindingsForServersInNode");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unbinding deleted servers in node " + string + "...");
        }
        EndpointGroup[] endpointGroupArray = this._configDiff.getDeletedServersEndpoint(string);
        for (n = 0; n < endpointGroupArray.length; ++n) {
            string3 = endpointGroupArray[n].getName();
            try {
                if (string.equals(this._thisNodeName) && string3.equals(this._thisServerName)) continue;
                this.unbind(wsnDistributedNC, this.escapeDots(string3));
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to unbind a server " + string3 + " in node " + string + " from name space.", nameSpaceConstructionException);
                if (bl) {
                    throw nameSpaceConstructionException;
                }
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Rebinding reconfigured servers in this node...");
        }
        endpointGroupArray = this._configDiff.getModifiedServersEndpoint(string);
        for (n = 0; n < endpointGroupArray.length; ++n) {
            string3 = endpointGroupArray[n].getName();
            try {
                if (string.equals(this._thisNodeName) && string3.equals(this._thisServerName)) continue;
                string2 = this.getCorbaUrl(endpointGroupArray[n], "NameServiceServerRoot", null);
                this.rebindRemoteNC(wsnDistributedNC, string2, this.escapeDots(string3));
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to rebind server " + string3 + " in node " + string + " in name space.", nameSpaceConstructionException);
                if (bl) {
                    throw nameSpaceConstructionException;
                }
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding new servers in this node...");
        }
        endpointGroupArray = this._configDiff.getNewServersEndpoint(string);
        for (n = 0; n < endpointGroupArray.length; ++n) {
            string3 = endpointGroupArray[n].getName();
            try {
                if (string.equals(this._thisNodeName) && string3.equals(this._thisServerName)) continue;
                string2 = this.getCorbaUrl(endpointGroupArray[n], "NameServiceServerRoot", null);
                this.bindRemoteNC(wsnDistributedNC, string2, this.escapeDots(string3));
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to bind server " + string3 + " in node " + string + " to name space.", nameSpaceConstructionException);
                if (bl) {
                    throw nameSpaceConstructionException;
                }
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateBindingsForServersInNode");
        }
    }

    private void unbindAllBindingsForServersInNode(String string, WsnDistributedNC wsnDistributedNC) throws NameSpaceConstructionException {
        String string2;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unbindAllBindingsForServersInNode");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unbinding deleted servers in node " + string + "...");
        }
        EndpointGroup[] endpointGroupArray = this._configDiff.getDeletedServersEndpoint(string);
        for (n = 0; n < endpointGroupArray.length; ++n) {
            string2 = endpointGroupArray[n].getName();
            try {
                if (string.equals(this._thisNodeName) && string2.equals(this._thisServerName)) continue;
                this.unbind(wsnDistributedNC, this.escapeDots(string2));
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to unbind a server " + string2 + " in node " + string + " from name space.", nameSpaceConstructionException);
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unbinding existing servers in node " + string + "...");
        }
        endpointGroupArray = this._config.getServersEndpoint(string);
        for (n = 0; n < endpointGroupArray.length; ++n) {
            string2 = endpointGroupArray[n].getName();
            try {
                if (string.equals(this._thisNodeName) && string2.equals(this._thisServerName)) continue;
                this.unbind(wsnDistributedNC, this.escapeDots(string2));
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.event(tc, "Exception occurred while attempting to unbind a server " + string2 + " in node " + string + " from name space.", nameSpaceConstructionException);
                this._errorDuringUpdate = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unbindAllBindingsForServersInNode");
        }
    }

    private void updateConfiguredBindings() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateConfiguredBindings");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unbinding deleted configured bindings...");
        }
        ConfiguredBindingInfo[] configuredBindingInfoArray = this._configDiff.getDeletedConfiguredBindings();
        for (n = 0; n < configuredBindingInfoArray.length; ++n) {
            try {
                this.unbindConfiguredBinding(configuredBindingInfoArray[n]);
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Rebinding updated configured bindings...");
        }
        configuredBindingInfoArray = this._configDiff.getModifiedConfiguredBindings();
        for (n = 0; n < configuredBindingInfoArray.length; ++n) {
            try {
                this.unbindConfiguredBinding(configuredBindingInfoArray[n]);
                this.bindConfiguredBinding(configuredBindingInfoArray[n]);
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding new configured bindings...");
        }
        configuredBindingInfoArray = this._configDiff.getNewConfiguredBindings();
        for (n = 0; n < configuredBindingInfoArray.length; ++n) {
            try {
                this.bindConfiguredBinding(configuredBindingInfoArray[n]);
                continue;
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateConfiguredBindings");
        }
    }

    public void rebuildCellPersistentPartition(ConfigRoot configRoot) throws NameSpaceConstructionException {
        Throwable throwable = new Throwable("rebuildCellPersistentPartition() is called in a non-nodeAgent process, which should not happen!");
        FFDCFilter.processException(throwable, "com.ibm.ws.naming.distcos.NameSpaceBuilder.rebuildCellPersistentPartition", "1220", this);
        if (tc.isEventEnabled()) {
            Tr.event(tc, "rebuildCellPersistentPartition: This should not happen!", Helpers.getStackTrace(throwable));
        }
    }

    private WsnDistributedNC createRootNC(NCInfo nCInfo) throws NameSpaceConstructionException {
        WsnDistributedNC wsnDistributedNC = null;
        try {
            java.lang.Object[] objectArray = new java.lang.Object[]{this._orb, nCInfo._servantMgr};
            Class[] classArray = new Class[]{ORB.class, ServantManager.class};
            wsnDistributedNC = this.instantiateNC(objectArray, classArray, nCInfo);
        }
        catch (NameSpaceConstructionException nameSpaceConstructionException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindNewNC: Rethrowing NameSpaceConstructionException: " + nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        return wsnDistributedNC;
    }

    private WsnDistributedNC bindNewNC(NCInfo nCInfo, WsnDistributedNC wsnDistributedNC, String string) throws NameSpaceConstructionException {
        WsnDistributedNC wsnDistributedNC2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindNewNC");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindNewNC", new java.lang.Object[]{"parent=" + wsnDistributedNC.getFullPrimaryNameString(), "name=" + string});
        }
        try {
            NameComponent[] nameComponentArray = WsnOptimizedNamingImplBase.toCosName(string);
            java.lang.Object[] objectArray = new java.lang.Object[]{wsnDistributedNC, nameComponentArray, nCInfo._servantMgr};
            Class[] classArray = new Class[objectArray.length];
            classArray[0] = WsnDistributedNC.class;
            classArray[1] = NameComponent;.class;
            classArray[2] = ServantManager.class;
            wsnDistributedNC2 = this.instantiateNC(objectArray, classArray, nCInfo);
            wsnDistributedNC.addPrimaryContextBinding(nameComponentArray, wsnDistributedNC2, false);
        }
        catch (NameSpaceConstructionException nameSpaceConstructionException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindNewNC: Rethrowing NameSpaceConstructionException: " + nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        catch (Throwable throwable) {
            Tr.exit(tc, "bindNewNC: Throwing NameSpaceConstructionException:", throwable);
            throw new NameSpaceConstructionException("bindNewNC: Unexpected exception encountered", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindNewNC");
        }
        return wsnDistributedNC2;
    }

    private WsnDistributedNC instantiateNC(java.lang.Object[] objectArray, Class[] classArray, NCInfo nCInfo) throws NameSpaceConstructionException {
        WsnDistributedNC wsnDistributedNC;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instantiateNC");
        }
        try {
            java.lang.Object[] objectArray2 = new java.lang.Object[objectArray.length + nCInfo._ctorParms.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            System.arraycopy(nCInfo._ctorParms, 0, objectArray2, objectArray.length, nCInfo._ctorParms.length);
            Class[] classArray2 = new Class[objectArray2.length];
            System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
            for (int i = classArray.length; i < objectArray2.length; ++i) {
                classArray2[i] = objectArray2[i].getClass();
            }
            Constructor constructor = nCInfo._ncClass.getConstructor(classArray2);
            wsnDistributedNC = (WsnDistributedNC)constructor.newInstance(objectArray2);
            wsnDistributedNC.markAsUnDeleteable();
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "instantiateNC: Throwing NameSpaceConstructionException:", throwable);
            }
            throw new NameSpaceConstructionException("instantiateNC: Unexpected exception encountered", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instantiateNC");
        }
        return wsnDistributedNC;
    }

    private void bindExistingPrimaryNC(WsnDistributedNC wsnDistributedNC, WsnDistributedNC wsnDistributedNC2, String string) throws NameSpaceConstructionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindExistingPrimaryNC: \n   parentNC=" + wsnDistributedNC.getFullPrimaryNameString() + "\n   name=" + string + "\n   childPrimaryNC=" + wsnDistributedNC2.getFullPrimaryNameString());
        }
        try {
            NameComponent[] nameComponentArray = WsnOptimizedNamingImplBase.toCosName(string);
            wsnDistributedNC.addPrimaryContextBinding(nameComponentArray, wsnDistributedNC2, false);
        }
        catch (Throwable throwable) {
            throw new NameSpaceConstructionException("bindExistingPrimaryNC: Unexpected exception encountered", throwable);
        }
    }

    protected void bindExistingLinkedNC(WsnDistributedNC wsnDistributedNC, WsnDistributedNC wsnDistributedNC2, String string) throws NameSpaceConstructionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindExistingLinkedNC: \n   parentNC=" + wsnDistributedNC.getFullPrimaryNameString() + "\n   name=" + string + "\n   childLinkedNC=" + wsnDistributedNC2.getFullPrimaryNameString());
        }
        try {
            NameComponent[] nameComponentArray = WsnOptimizedNamingImplBase.toCosName(string);
            wsnDistributedNC.addLinkedContextBinding(nameComponentArray, wsnDistributedNC2, false);
        }
        catch (Throwable throwable) {
            throw new NameSpaceConstructionException("bindExistingLinkedNC: Unexpected exception encountered", throwable);
        }
    }

    private void issueAlreadyBoundWarning(String string) {
        String string2 = "cfBindingAlreadyBound";
        String[] stringArray = new String[]{string};
        Tr.warning(tc, string2, stringArray);
    }

    protected void bindConfiguredBinding(ConfiguredBindingInfo configuredBindingInfo) throws NameSpaceConstructionException {
        String string;
        WsnDistributedNC wsnDistributedNC = null;
        switch (configuredBindingInfo.getRootIndicator()) {
            case 1: {
                wsnDistributedNC = this._foreignCellsNC;
                break;
            }
            case 2: {
                wsnDistributedNC = this._cellPersistentRootNC;
                break;
            }
            case 3: {
                if (this._isCellManager) {
                    String string2 = "cfInvalidConfigLocation";
                    String[] stringArray = new String[]{"configured binding \"" + configuredBindingInfo.getBindingName() + "\""};
                    this._config.issueConfigurationWarning(string2, stringArray);
                    return;
                }
                wsnDistributedNC = this._nodePersistentRootNC;
                break;
            }
            case 4: {
                wsnDistributedNC = this._serverRootNC;
            }
        }
        String string3 = string = configuredBindingInfo.getBindingName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Binding configured binding:", new java.lang.Object[]{"rootNC=" + wsnDistributedNC.getFullPrimaryNameString(), "bindingName=" + string});
        }
        try {
            int n;
            NameComponent[] nameComponentArray = wsnDistributedNC.to_name(string);
            NameSpace nameSpace = wsnDistributedNC.getNameSpace();
            NameComponent[] nameComponentArray2 = new NameComponent[1];
            for (n = 0; n < nameComponentArray.length - 1; ++n) {
                java.lang.Object object;
                java.lang.Object object2 = null;
                try {
                    java.lang.Object object3;
                    nameComponentArray2[0] = nameComponentArray[n];
                    object2 = WsnDistributedNC.toInsJndiName(nameComponentArray2);
                    string3 = object2.toString();
                    NameSpaceBindingData nameSpaceBindingData = nameSpace.lookup(wsnDistributedNC, (Name)object2);
                    object = nameSpaceBindingData.getBoundObject();
                    if (!(object instanceof WsnDistributedNC)) {
                        Tr.warning(tc, "cfNonleafConflict", new java.lang.Object[]{string3, wsnDistributedNC.getFullPrimaryNameString()});
                        object3 = "Cannot create configured intermediate context because of a name conflict with an object other than a local NamingContext.";
                        Tr.exit(tc, "bindConfiguredBinding: Nonleaf conflict.");
                        throw new NameSpaceConstructionException((String)object3);
                    }
                    object3 = (AdditionalData)nameSpaceBindingData.getAdditionalData();
                    if (((AdditionalData)object3).getBindingProperty("System Binding") == null) {
                        Tr.warning(tc, "cfNonleafConflict", new java.lang.Object[]{string3, wsnDistributedNC.getFullPrimaryNameString()});
                        String string4 = "Cannot create configured binding because an existing intermediate context is not bound as a configured binding.";
                        Tr.exit(tc, "bindConfiguredBinding: Existing nonleaf context not configured");
                        throw new NameSpaceConstructionException(string4);
                    }
                    wsnDistributedNC = (WsnDistributedNC)object;
                    continue;
                }
                catch (NameNotFoundException nameNotFoundException) {
                    object = this.bindNewNC(this.getConfiguredIntermediateNCInfo(), wsnDistributedNC, object2.toString());
                    wsnDistributedNC = object;
                }
            }
            nameComponentArray2[0] = nameComponentArray[n];
            string3 = WsnDistributedNC.toInsJndiName(nameComponentArray2).toString();
            switch (configuredBindingInfo.getBindingVariety()) {
                case 1: {
                    if (configuredBindingInfo.getCORBABindingType() == BindingType.ncontext) {
                        this.bindRemoteNC(wsnDistributedNC, configuredBindingInfo.getCORBAUrl(), string3);
                        break;
                    }
                    this.bindRemoteObj(wsnDistributedNC, configuredBindingInfo.getCORBAUrl(), string3);
                    break;
                }
                case 2: {
                    this.bindIndirectJndiObject(wsnDistributedNC, configuredBindingInfo, string3);
                    break;
                }
                case 3: {
                    this.bindStringObject(wsnDistributedNC, configuredBindingInfo.getStringConstant(), string3);
                }
            }
        }
        catch (NameSpaceConstructionException nameSpaceConstructionException) {
            throw nameSpaceConstructionException;
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "cfBindingError", new java.lang.Object[]{string, wsnDistributedNC.getFullPrimaryNameString(), Helpers.getStackTrace(throwable)});
            Tr.exit(tc, "bindConfiguredBinding: Error occurred:", throwable);
            String string5 = "Could not add the configured binding name \"" + string + "\" to the context \"" + wsnDistributedNC.getFullPrimaryNameString() + "\".";
            throw new NameSpaceConstructionException(string5, throwable);
        }
    }

    private void bindRemoteNC(WsnDistributedNC wsnDistributedNC, String string, String string2) throws NameSpaceConstructionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindRemoteNC: \n   target   = " + wsnDistributedNC.getFullPrimaryNameString() + "\n   name     = " + string2 + "\n   corbaUrl = " + string);
        }
        try {
            NameComponent[] nameComponentArray = WsnOptimizedNamingImplBase.toCosName(string2);
            wsnDistributedNC.addUrlContextBinding(nameComponentArray, string, false);
        }
        catch (Throwable throwable) {
            WsException wsException = (WsException)throwable;
            if (NameAlreadyBoundException.class.isInstance(wsException.getCause())) {
                this.issueAlreadyBoundWarning(wsException.getCause().toString());
            }
            throw new NameSpaceConstructionException("bindRemoteNC: Unexpected exception encountered", throwable);
        }
    }

    private void rebindRemoteNC(WsnDistributedNC wsnDistributedNC, String string, String string2) throws NameSpaceConstructionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "rebindRemoteNC: \n   target   = " + wsnDistributedNC.getFullPrimaryNameString() + "\n   name     = " + string2 + "\n   corbaUrl = " + string);
        }
        try {
            NameComponent[] nameComponentArray = WsnOptimizedNamingImplBase.toCosName(string2);
            wsnDistributedNC.updateUrlContextBinding(nameComponentArray, string, false);
        }
        catch (Throwable throwable) {
            WsException wsException = (WsException)throwable;
            if (NameAlreadyBoundException.class.isInstance(wsException.getCause())) {
                this.issueAlreadyBoundWarning(wsException.getCause().toString());
            }
            throw new NameSpaceConstructionException("rebindRemoteNC: Unexpected exception encountered", throwable);
        }
    }

    private void bindRemoteObj(WsnDistributedNC wsnDistributedNC, String string, String string2) throws NameSpaceConstructionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindRemoteObj: \n   target   = " + wsnDistributedNC.getFullPrimaryNameString() + "\n   leaf     = " + string2 + "\n   corbaUrl = " + string);
        }
        try {
            NameComponent[] nameComponentArray = WsnOptimizedNamingImplBase.toCosName(string2);
            wsnDistributedNC.addUrlObjectBinding(nameComponentArray, string, "org.omg.CORBA.Object", false);
        }
        catch (Throwable throwable) {
            WsException wsException = (WsException)throwable;
            if (NameAlreadyBoundException.class.isInstance(wsException.getCause())) {
                this.issueAlreadyBoundWarning(wsException.getCause().toString());
            }
            throw new NameSpaceConstructionException("bindRemoteObj: Unexpected exception encountered", throwable);
        }
    }

    private void bindIndirectJndiObject(WsnDistributedNC wsnDistributedNC, ConfiguredBindingInfo configuredBindingInfo, String string) throws NameSpaceConstructionException {
        String string2 = configuredBindingInfo.getJndiName();
        String string3 = configuredBindingInfo.getProviderUrl();
        String string4 = configuredBindingInfo.getInitialContextFactory();
        Properties properties = configuredBindingInfo.getAdditionContextProperties();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindIndirectJndiObject: \n   target             = " + wsnDistributedNC.getFullPrimaryNameString() + "\n   leaf               = " + string + "\n   providerUrl        = " + string3 + "\n   jndiName           = " + string2 + "\n   initCtxFactory     = " + string4 + "\n   additionalCtxProps = " + properties);
        }
        try {
            IndirectJndiLookupFactoryImpl indirectJndiLookupFactoryImpl = new IndirectJndiLookupFactoryImpl();
            Referenceable referenceable = indirectJndiLookupFactoryImpl.createIndirectJndiLookup(string2, string4, string3, null, properties);
            NameComponent[] nameComponentArray = WsnOptimizedNamingImplBase.toCosName(string);
            byte[] byArray = Serialization.serializeObject(referenceable.getReference());
            Any any = this._orb.create_any();
            any.insert_Value((Serializable)byArray);
            wsnDistributedNC.addJavaObjectBinding(nameComponentArray, any, referenceable.getClass().getName(), false);
        }
        catch (Throwable throwable) {
            WsException wsException = (WsException)throwable;
            if (NameAlreadyBoundException.class.isInstance(wsException.getCause())) {
                this.issueAlreadyBoundWarning(wsException.getCause().toString());
            }
            throw new NameSpaceConstructionException("bindIndirectJndiObject: Unexpected exception encountered", throwable);
        }
    }

    private void bindStringObject(WsnDistributedNC wsnDistributedNC, String string, String string2) throws NameSpaceConstructionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindStringObject: \n   target = " + wsnDistributedNC.getFullPrimaryNameString() + "\n   leaf   = " + string2 + "\n   value  = " + string);
        }
        try {
            NameComponent[] nameComponentArray = WsnOptimizedNamingImplBase.toCosName(string2);
            byte[] byArray = Serialization.serializeObject(string);
            Any any = this._orb.create_any();
            any.insert_Value((Serializable)byArray);
            wsnDistributedNC.addJavaObjectBinding(nameComponentArray, any, String.class.getName(), false);
        }
        catch (Throwable throwable) {
            WsException wsException = (WsException)throwable;
            if (NameAlreadyBoundException.class.isInstance(wsException.getCause())) {
                this.issueAlreadyBoundWarning(wsException.getCause().toString());
            }
            throw new NameSpaceConstructionException("bindStringObject: Unexpected exception encountered", throwable);
        }
    }

    private void unbindConfiguredBinding(ConfiguredBindingInfo configuredBindingInfo) throws NameSpaceConstructionException {
        WsnDistributedNC wsnDistributedNC = null;
        switch (configuredBindingInfo.getRootIndicator()) {
            case 1: {
                wsnDistributedNC = this._foreignCellsNC;
                break;
            }
            case 2: {
                wsnDistributedNC = this._cellPersistentRootNC;
                break;
            }
            case 3: {
                if (this._isCellManager) {
                    return;
                }
                wsnDistributedNC = this._nodePersistentRootNC;
                break;
            }
            case 4: {
                wsnDistributedNC = this._serverRootNC;
            }
        }
        try {
            int n;
            String string;
            String string2 = string = configuredBindingInfo.getBindingName();
            WsnName wsnName = null;
            NameComponent[] nameComponentArray = wsnDistributedNC.to_name(string);
            WsnDistributedNC[] wsnDistributedNCArray = new WsnDistributedNC[nameComponentArray.length - 1];
            NameSpace nameSpace = wsnDistributedNC.getNameSpace();
            NameComponent[] nameComponentArray2 = new NameComponent[1];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unbinding configured binding:", new java.lang.Object[]{"rootNC=" + wsnDistributedNC.getFullPrimaryNameString(), "bindingName=" + string});
            }
            for (n = 0; n < nameComponentArray.length - 1; ++n) {
                try {
                    nameComponentArray2[0] = nameComponentArray[n];
                    wsnName = WsnDistributedNC.toInsJndiName(nameComponentArray2);
                    string2 = ((java.lang.Object)wsnName).toString();
                    NameSpaceBindingData nameSpaceBindingData = nameSpace.lookup(wsnDistributedNC, wsnName);
                    java.lang.Object object = nameSpaceBindingData.getBoundObject();
                    if (!(object instanceof WsnDistributedNC)) {
                        Tr.event(tc, "unbindConfiguredBinding: Configured context not of expected type.", new java.lang.Object[]{"bindingNameString=" + string, "nameIndex=" + n});
                        break;
                    }
                    AdditionalData additionalData = (AdditionalData)nameSpaceBindingData.getAdditionalData();
                    if (additionalData.getBindingProperty("System Binding") == null) {
                        Tr.event(tc, "unbindConfiguredBinding: Existing nonleaf context not configured", new java.lang.Object[]{"bindingNameString=" + string, "nameIndex=" + n});
                        break;
                    }
                    wsnDistributedNCArray[n] = wsnDistributedNC = (WsnDistributedNC)object;
                    continue;
                }
                catch (NameNotFoundException nameNotFoundException) {
                    break;
                }
            }
            int n2 = n - 1;
            if (n == nameComponentArray.length - 1) {
                nameComponentArray2[0] = nameComponentArray[n];
                string2 = WsnOptimizedNamingImplBase.toInsStringName(nameComponentArray2);
                this.unbind(wsnDistributedNC, string2);
            }
            for (n = n2; n >= 0; --n) {
                try {
                    wsnDistributedNCArray[n].markAsDeleteable();
                    wsnDistributedNCArray[n].destroyPrimaryContext();
                    continue;
                }
                catch (NotEmpty notEmpty) {
                    break;
                }
                catch (IMP_LIMIT iMP_LIMIT) {
                    break;
                }
            }
        }
        catch (NameSpaceConstructionException nameSpaceConstructionException) {
            throw nameSpaceConstructionException;
        }
        catch (Throwable throwable) {
            Tr.exit(tc, "unbindConfiguredBinding: Unexpected error occurred:", throwable);
        }
    }

    private void unbind(WsnDistributedNC wsnDistributedNC, String string) throws NameSpaceConstructionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unbind", new java.lang.Object[]{"targetNC=" + wsnDistributedNC.getFullPrimaryNameString(), "name=" + string});
        }
        try {
            NameComponent[] nameComponentArray = WsnOptimizedNamingImplBase.toCosName(string);
            wsnDistributedNC.removeBinding(nameComponentArray);
        }
        catch (Throwable throwable) {
            WsException wsException = (WsException)throwable;
            throw new NameSpaceConstructionException("unbind: Unexpected exception encountered", throwable);
        }
    }

    private String getCorbaUrl(EndpointGroup endpointGroup, String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (string2 == null || string2.length() == 0) {
            string4 = "corbaloc";
            string5 = "";
        } else {
            string4 = "corbaname";
            string5 = "#" + string2;
        }
        String string6 = null;
        string6 = string == null || string.length() == 0 ? "NameService" : string;
        string3 = string4 + ":" + endpointGroup.toUrlAddrList() + "/" + string6 + string5;
        return string3;
    }

    private String getNCStringifiedIOR(WsnDistributedNC wsnDistributedNC) throws NameSpaceConstructionException {
        String string = this._orb.object_to_string((Object)wsnDistributedNC);
        if (string == null) {
            throw new NameSpaceConstructionException("getNCRequiredIOR: orb.object_to_string(NamingContext)failed, NamingContext=" + wsnDistributedNC.toString());
        }
        return string;
    }

    private String escapeDots(String string) {
        String string2 = "";
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(46, n)) != -1) {
            string2 = string2 + string.substring(n, n2) + "\\.";
            n = n2 + 1;
        }
        if (n < string.length()) {
            string2 = string2 + string.substring(n);
        }
        return string2;
    }

    public Properties getBootObjectProperties() throws NameSpaceConstructionException {
        Properties properties = new Properties();
        properties.setProperty("com.ibm.ws.naming.implementation", "WsnIpCos");
        properties.setProperty("com.ibm.ws.naming.wsnidl.level", String.valueOf(this._treeRootNC.get_compatibility_level()));
        properties.setProperty("com.ibm.ws.naming.boot.treerootior", this._treeRootIOR);
        properties.setProperty("com.ibm.ws.naming.boot.domainrootior", this._cellRootIOR);
        properties.setProperty("com.ibm.ws.naming.boot.legacyrootior", this._cellPersistentRootIOR);
        properties.setProperty("com.ibm.ws.naming.boot.serverrootior", this._serverRootIOR);
        properties.setProperty("com.ibm.ws.naming.boot.treerootname", this._treeRootNC.getFullPrimaryNameString());
        properties.setProperty("com.ibm.ws.naming.boot.domainrootname", this._cellRootNC.getFullPrimaryNameString());
        properties.setProperty("com.ibm.ws.naming.boot.legacyrootname", this._cellPersistentRootNC.getFullPrimaryNameString());
        properties.setProperty("com.ibm.ws.naming.boot.serverrootname", this._serverRootNC.getFullPrimaryNameString());
        properties.setProperty("com.ibm.ws.naming.boot.treerootctxids", Helpers.contextIDsToString(this.getTreeRootParentCtxIDs()));
        properties.setProperty("com.ibm.ws.naming.boot.domainrootctxids", Helpers.contextIDsToString(this.getCellRootParentCtxIDs()));
        properties.setProperty("com.ibm.ws.naming.boot.legacyrootctxids", Helpers.contextIDsToString(this.getCellPersistentRootParentCtxIDs()));
        properties.setProperty("com.ibm.ws.naming.boot.serverrootctxids", Helpers.contextIDsToString(this.getServerRootParentCtxIDs(this._isClusterMember)));
        properties.setProperty("com.ibm.ws.naming.boot.treerootctxid", this._treeRootNC.get_context_id_string());
        properties.setProperty("com.ibm.ws.naming.boot.domainrootctxid", this._cellRootNC.get_context_id_string());
        properties.setProperty("com.ibm.ws.naming.boot.legacyrootctxid", this._cellPersistentRootNC.get_context_id_string());
        properties.setProperty("com.ibm.ws.naming.boot.serverrootctxid", this._serverRootNC.get_context_id_string());
        properties.setProperty("com.ibm.ws.naming.boot.noderootior", this._nodeRootIOR);
        properties.setProperty("com.ibm.ws.naming.boot.noderootname", this._nodeRootNC.getFullPrimaryNameString());
        properties.setProperty("com.ibm.ws.naming.boot.noderootctxids", Helpers.contextIDsToString(this.getNodeRootParentCtxIDs()));
        properties.setProperty("com.ibm.ws.naming.boot.noderootctxid", this._nodeRootNC.get_context_id_string());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBootObjectProperties", Helpers.traceHashtable("Properties for the boot object", properties));
        }
        return properties;
    }

    public WsnDistributedNC getTreeRootNC() {
        return this._treeRootNC;
    }

    public WsnDistributedNC getCellRootNC() {
        return this._cellRootNC;
    }

    public WsnDistributedNC getNodeRootNC() {
        return this._nodeRootNC;
    }

    public WsnDistributedNC getNodesNC() {
        return this._nodesNC;
    }

    public WsnDistributedNC getCellClustersNC() {
        return this._cellClustersNC;
    }

    public WsnDistributedNC getCellPersistentRootNC() {
        return this._cellPersistentRootNC;
    }

    public WsnDistributedNC getForeignCellsNC() {
        return this._foreignCellsNC;
    }

    public WsnDistributedNC getServerRootNC() {
        return this._serverRootNC;
    }

    public String getTreeRootIOR() {
        return this._treeRootIOR;
    }

    public String getCellRootIOR() {
        return this._cellRootIOR;
    }

    public String getNodeRootIOR() {
        return this._nodeRootIOR;
    }

    public String getNodesIOR() {
        return this._nodesIOR;
    }

    public String getCellClustersIOR() {
        return this._cellClustersIOR;
    }

    public String getCellPersistentRootIOR() {
        return this._cellPersistentRootIOR;
    }

    public String getForeignCellsIOR() {
        return this._foreignCellsIOR;
    }

    public String getServerRootIOR() {
        return this._serverRootIOR;
    }

    private String[] getTreeRootParentCtxIDs() {
        return new String[0];
    }

    private String[] getCellRootParentCtxIDs() {
        String[] stringArray = new String[]{this._treeRootNC.get_context_id_string()};
        return stringArray;
    }

    private String[] getCellPersistentRootParentCtxIDs() {
        String[] stringArray = new String[]{this._treeRootNC.get_context_id_string(), this._cellRootNC.get_context_id_string()};
        return stringArray;
    }

    private String[] getNodeRootParentCtxIDs() {
        String[] stringArray = new String[]{this._treeRootNC.get_context_id_string(), this._cellRootNC.get_context_id_string(), this._nodesNC.get_context_id_string()};
        return stringArray;
    }

    private String[] getServerRootParentCtxIDs(boolean bl) {
        String[] stringArray = null;
        stringArray = bl ? new String[]{this._treeRootNC.get_context_id_string(), this._cellRootNC.get_context_id_string(), this._cellClustersNC.get_context_id_string()} : new String[]{this._treeRootNC.get_context_id_string(), this._cellRootNC.get_context_id_string(), this._nodesNC.get_context_id_string(), this._nodeRootNC.get_context_id_string(), this._nodePhysicalServersNC.get_context_id_string()};
        return stringArray;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/naming.server/src/com/ibm/ws/naming/distcos/NameSpaceBuilder.java, WAS.naming.server, WAS61.SERV1, cf311012.09, ver. 1.53");
        }
    }

    protected class NCInfo {
        Class _ncClass = null;
        ServantManager _servantMgr = null;
        java.lang.Object[] _ctorParms = null;

        protected NCInfo(Class clazz, ServantManager servantManager, java.lang.Object[] objectArray) {
            this._ncClass = clazz;
            this._servantMgr = servantManager;
            this._ctorParms = objectArray != null ? objectArray : new java.lang.Object[0];
        }
    }
}

