/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.distcos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.bootstrap.NameServerImpl;
import com.ibm.ws.naming.cosbase.WsnOptimizedNamingImplBase;
import com.ibm.ws.naming.distcos.PersistentNCOperationInfo;
import com.ibm.ws.naming.distcos.PersistentXmlSlaveNC;
import com.ibm.ws.naming.distcos.WsnDistributedNC;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class PersistentNCUpdateProxy {
    private static final TraceComponent _tc = Tr.register(PersistentNCUpdateProxy.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private ORB _orb;
    private WsnDistributedNC _rootNC = null;
    private String _originID;

    public PersistentNCUpdateProxy(ORB oRB, String string) {
        this._orb = oRB;
        this._originID = string;
    }

    public void applyInMemoryUpdate(PersistentNCOperationInfo persistentNCOperationInfo) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "applyInMemoryUpdate", new java.lang.Object[]{"originIDOfThisProcess=" + this._originID, "originIDOfUpdateRequest=" + persistentNCOperationInfo.getOriginID()});
        }
        String string = persistentNCOperationInfo.getTargetContextPrimaryNameString();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "applyInMemoryUpdate:", "targetName=" + string);
        }
        NameServerImpl.disableCellPersistentRebuild();
        try {
            WsnDistributedNC wsnDistributedNC = this.getRootNC();
            if (wsnDistributedNC == null) {
                Tr.exit(_tc, "applyInMemoryUpdate: Operation not completed. Root NC not registered with the ORB.");
                return;
            }
            Object object = wsnDistributedNC.resolve_str(string);
            if (!((object = WsnOptimizedNamingImplBase.narrowToNC(object)) instanceof PersistentXmlSlaveNC)) {
                if (object == null) {
                    Tr.exit(_tc, "applyInMemoryUpdate: Operation not completed. Target context is null.");
                } else {
                    Tr.exit(_tc, "applyInMemoryUpdate: Operation not completed. Target object not a PersistentXmlSlaveNC: " + object.getClass().getName());
                }
            }
            PersistentXmlSlaveNC persistentXmlSlaveNC = (PersistentXmlSlaveNC)object;
            persistentXmlSlaveNC.applyInMemoryUpdate(persistentNCOperationInfo);
        }
        catch (Throwable throwable) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "applyInMemoryUpdate: Operation not completed.", throwable);
            }
            return;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "applyInMemoryUpdate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WsnDistributedNC getRootNC() {
        PersistentNCUpdateProxy persistentNCUpdateProxy = this;
        synchronized (persistentNCUpdateProxy) {
            if (this._rootNC == null) {
                try {
                    Tr.event(_tc, "getRootNC:  Resolving tree root naming context");
                    Object object = this._orb.resolve_initial_references("NameServiceTreeRoot");
                    object = WsnOptimizedNamingImplBase.narrowToNC(object);
                    if (object instanceof WsnDistributedNC) {
                        this._rootNC = (WsnDistributedNC)object;
                    } else {
                        Tr.event(_tc, "getRootNC:  resolve_initial_references did not return WsnDistributedNC");
                    }
                }
                catch (Throwable throwable) {
                    Tr.event(_tc, "getRootNC:  ORB could not resolve tree root naming context: ", throwable);
                }
            }
            return this._rootNC;
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.server/src/com/ibm/ws/naming/distcos/PersistentNCUpdateProxy.java, WAS.naming.server, WAS61.SERV1, cf311012.09, ver. 1.8");
        }
    }
}

