/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.distcos;

import [Lorg.omg.CosNaming.NameComponent;;
import com.ibm.WsnOptimizedNaming.NamingContext;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Uuid;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.DocumentChangedException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.namestore.CosBindingType;
import com.ibm.websphere.models.config.namestore.NameBinding;
import com.ibm.websphere.models.config.namestore.NameBindingType;
import com.ibm.websphere.models.config.namestore.NamestoreFactory;
import com.ibm.websphere.models.config.namestore.NamestorePackage;
import com.ibm.websphere.resource.WASResourceImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.naming.cosbase.ServantManager;
import com.ibm.ws.naming.cosbase.WsnOptimizedNamingImplBase;
import com.ibm.ws.naming.distcos.EndpointGroup;
import com.ibm.ws.naming.distcos.NameSpaceConstructionException;
import com.ibm.ws.naming.distcos.PersistentNCOperationInfo;
import com.ibm.ws.naming.distcos.PersistentNCUpdateProxy;
import com.ibm.ws.naming.distcos.PersistentUpdateDispatcher;
import com.ibm.ws.naming.distcos.PersistentXmlNC;
import com.ibm.ws.naming.distcos.WsnDistributedNC;
import com.ibm.ws.naming.ipbase.NameSpace;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.ipbase.NameSpaceException;
import com.ibm.ws.naming.ipcos.AdditionalData;
import com.ibm.ws.naming.jndicos.CNContextImpl;
import com.ibm.ws.naming.util.DestroyedContext;
import com.ibm.ws.naming.util.WsnName;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.security.core.SecurityContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import javax.naming.NamingException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.utilities.IDUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

class PersistentNameStoreManager {
    public static final int NAMESTORE_SCOPE_CELL = 0;
    public static final int NAMESTORE_SCOPE_NODE = 1;
    private static final TraceComponent _tc = Tr.register(PersistentNameStoreManager.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String OBJECT_NAME_NODE_NAME_PROP = "node";
    private static java.lang.Object _notificationLock;
    private static ObjectName _wsnMBeanName;
    private static boolean _initializedForReceivingUpdates;
    private static final String _originID;
    private static final String BYTE_TO_CHAR_ENCODING = "UTF-8";
    private int _scope;
    private String _nameStoreURI;
    private WsnDistributedNC _parentNC;
    private NameComponent[] _persistentRootBindingName;
    private ORB _orb;
    private ServantManager _servantManager;
    private String _processType;
    private String _nodeName;
    private Constructor _ncCtor = null;
    private EndpointGroup _masterServerEndpoint = null;
    private PersistentUpdateDispatcher _updateDispatcher = null;
    private ConfigRepository _repo;
    private NamestoreFactory _nameStoreFactory;
    private com.ibm.websphere.models.config.namestore.NamingContext _rootCtx;
    private NameSpace _ns;
    private boolean _xmlUpdatesDisabled = false;
    private NamingContext _masterRootNC;

    public PersistentNameStoreManager(int n, String string, WsnDistributedNC wsnDistributedNC, NameComponent[] nameComponentArray, ORB oRB, ServantManager servantManager, String string2, String string3, Class clazz) throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.debug(_tc, "PersistentNameStoreManager", new java.lang.Object[]{"nameStoreUri=" + string, "processType=" + string2});
        }
        this._scope = n;
        this._nameStoreURI = string;
        this._parentNC = wsnDistributedNC;
        this._persistentRootBindingName = nameComponentArray;
        this._orb = oRB;
        this._servantManager = servantManager;
        this._processType = string2;
        this._nodeName = string3;
        try {
            this._ncCtor = clazz.getConstructor(WsnDistributedNC.class, NameComponent;.class, ServantManager.class, PersistentNameStoreManager.class);
        }
        catch (Throwable throwable) {
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not get constructor for NamingContext.", throwable);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "PersistentNameStoreManager: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        NamestorePackage namestorePackage = (NamestorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/namestore.xmi");
        this._nameStoreFactory = namestorePackage.getNamestoreFactory();
        this._rootCtx = null;
        this._ns = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "PersistentNameStoreManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsnDistributedNC xmlToInMemory(ConfigRoot configRoot, boolean bl, String string) throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "xmlToInMemory");
        }
        this._ns = this._parentNC.getNameSpace();
        if (!bl) {
            this._ns.recursivelyRemoveBindings(string);
        }
        WsnDistributedNC wsnDistributedNC = null;
        try {
            boolean bl2 = this.readInRootCtxFromXml(configRoot);
            wsnDistributedNC = this.WCCMToInMemory(bl2);
        }
        finally {
            configRoot = null;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "xmlToInMemory");
        }
        return wsnDistributedNC;
    }

    private boolean readInRootCtxFromXml(ConfigRoot configRoot) throws NameSpaceConstructionException {
        java.lang.Object e2;
        String string;
        int n;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "readInRootCtxFromXml");
        }
        if (this._processType.equals("UnManagedProcess")) {
            n = 4;
            string = "server";
        } else if (this._scope == 0) {
            n = 0;
            string = "cell";
        } else {
            n = 3;
            string = OBJECT_NAME_NODE_NAME_PROP;
        }
        int n2 = this._nameStoreURI.lastIndexOf(47) + 1;
        String string2 = this._nameStoreURI.substring(n2);
        Resource resource = null;
        try {
            resource = configRoot.getResource(n, string2);
            if (resource == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Namestore file contains no resources.  Assuming no name store", new java.lang.Object[]{"scope=" + string, "fileName=" + string2, "fileURI=" + this._nameStoreURI});
                }
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Tr.event(_tc, "readInRootCtxFromXml: Namestore XML file not found:", fileNotFoundException);
            this._rootCtx = this._nameStoreFactory.createNamingContext();
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "readInRootCtxFromXml: XML file not found.");
            }
            return false;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.readInRootCtxFromXml", "239", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Unexpected exception", throwable);
            }
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Unexpected error reading name store document.", throwable);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "readInRootCtxFromXml: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        Iterator iterator = resource.getContents().iterator();
        if (iterator.hasNext()) {
            e2 = iterator.next();
            if (!(e2 instanceof com.ibm.websphere.models.config.namestore.NamingContext)) {
                NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Namestore file " + this._nameStoreURI + " contains an object of an unexpected type. " + "Object type: " + e2.getClass().getName());
                FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.readInRootCtxFromXml", "240", this);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "readInRootCtxFromXml: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
                }
                throw nameSpaceConstructionException;
            }
        } else {
            this._rootCtx = this._nameStoreFactory.createNamingContext();
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "readInRootCtxFromXml: Namestore file is empty.");
            }
            return true;
        }
        this._rootCtx = (com.ibm.websphere.models.config.namestore.NamingContext)e2;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "readInRootCtxFromXml");
        }
        return true;
    }

    private WsnDistributedNC WCCMToInMemory(boolean bl) throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WCCMToInMemory", "xmlExists=" + bl);
        }
        PersistentXmlNC persistentXmlNC = this.createNC(this._parentNC, this._persistentRootBindingName);
        if (bl) {
            EList eList = this._rootCtx.getNameBindings();
            this.addInMemoryBindings(persistentXmlNC, eList);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WCCMToInMemory");
        }
        return persistentXmlNC;
    }

    private void addInMemoryBindings(WsnDistributedNC wsnDistributedNC, EList eList) throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addInMemoryBindings");
        }
        int n = eList.size();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No. of bindings=" + n);
        }
        for (int i = 0; i < n; ++i) {
            NameBinding nameBinding = (NameBinding)eList.get(i);
            int n2 = nameBinding.getNameBindingType().getValue();
            this.addInMemoryBinding(wsnDistributedNC, nameBinding);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addInMemoryBindings");
        }
    }

    private void addInMemoryBinding(WsnDistributedNC wsnDistributedNC, NameBinding nameBinding) {
        block46: {
            NameComponent[] nameComponentArray;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "addInMemoryBinding");
            }
            int n = nameBinding.getNameBindingType().getValue();
            String string = nameBinding.getNameComponent();
            String string2 = wsnDistributedNC.getFullPrimaryNameString();
            String string3 = string2 + "/" + string;
            try {
                nameComponentArray = this.toSimpleCosName(string);
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                Tr.warning(_tc, "nsxmlInvalidName", new String[]{this._nameStoreURI, string2, string});
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "addInMemoryBinding: Invalid name");
                }
                return;
            }
            String string4 = nameBinding.getJavaClassName();
            if (string4 == null) {
                string4 = "";
            }
            NamestorePackage namestorePackage = this.getNamestorePackage();
            if (n == 0) {
                Tr.debug(_tc, "Primary context binding");
                com.ibm.websphere.models.config.namestore.NamingContext namingContext = nameBinding.getPrimaryNamingContext();
                try {
                    PersistentXmlNC persistentXmlNC = this.createNC(wsnDistributedNC, nameComponentArray);
                    wsnDistributedNC.addPrimaryContextBinding(nameComponentArray, persistentXmlNC, true);
                    EList eList = namingContext.getNameBindings();
                    this.addInMemoryBindings(persistentXmlNC, eList);
                }
                catch (NameSpaceConstructionException nameSpaceConstructionException) {
                    Tr.event(_tc, "Received NameSpaceConstructionException when adding primary context binding \"" + string3 + "\".", nameSpaceConstructionException);
                    this.disableXmlUpdates("nsxmlAddBindingErr", new java.lang.Object[]{this._nameStoreURI, string3, nameSpaceConstructionException});
                }
            } else if (n == 1) {
                Tr.debug(_tc, "Linked context binding");
                String string5 = nameBinding.getLinkedNamingContextId();
                if (string5 != null) {
                    try {
                        String string6 = nameBinding.getStringifiedIOR();
                        if (this._ns.getContext(string5) != null || string6 == null) {
                            this._ns.addLinkedContextBinding(wsnDistributedNC, this.toJndiName(nameComponentArray), string5, new AdditionalData(string4, BindingType.ncontext));
                            break block46;
                        }
                        if (_tc.isEventEnabled()) {
                            String string7 = "Linked context for WCCM binding \"" + string3 + " does not exist locally and contains no stringified IOR.";
                            Tr.event(_tc, string7);
                        }
                        wsnDistributedNC.addIorContextBinding(nameComponentArray, string6, true);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.addInMemoryBinding", "496", this);
                        Tr.event(_tc, "Received NamingException or NameSpaceException when adding linked context binding \"" + string3 + "\".", throwable);
                        this.disableXmlUpdates("nsxmlAddBindingErr", new java.lang.Object[]{this._nameStoreURI, string3, throwable});
                    }
                } else {
                    this.disableXmlUpdates("nsxmlLinkedNullCtxID", new String[]{this._nameStoreURI, string3});
                }
            } else if (n == 2) {
                Tr.debug(_tc, "IOR context binding");
                String string8 = nameBinding.getStringifiedIOR();
                if (string8 != null) {
                    try {
                        wsnDistributedNC.addIorContextBinding(nameComponentArray, string8, true);
                    }
                    catch (NameSpaceConstructionException nameSpaceConstructionException) {
                        FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.addInMemoryBinding", "429", this);
                        Tr.event(_tc, "Received NameSpaceConstructionException when adding IOR context binding \"" + string3 + "\".", nameSpaceConstructionException);
                        this.disableXmlUpdates("nsxmlAddBindingErr", new java.lang.Object[]{this._nameStoreURI, string3, nameSpaceConstructionException});
                    }
                } else {
                    this.disableXmlUpdates("nsxmlNullCtxIOR", new String[]{this._nameStoreURI, string3});
                }
            } else if (n == 3) {
                Tr.debug(_tc, "URL context binding");
                String string9 = nameBinding.getInsURL();
                if (string9 != null) {
                    try {
                        wsnDistributedNC.addUrlContextBinding(nameComponentArray, string9, true);
                    }
                    catch (NameSpaceConstructionException nameSpaceConstructionException) {
                        FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.addInMemoryBinding", "451", this);
                        Tr.event(_tc, "Received NameSpaceConstructionException when adding context URL binding \"" + string3 + "\".", nameSpaceConstructionException);
                        this.disableXmlUpdates("nsxmlAddBindingErr", new java.lang.Object[]{this._nameStoreURI, string3, nameSpaceConstructionException});
                    }
                } else {
                    this.disableXmlUpdates("nsxmlNullCtxURL", new String[]{this._nameStoreURI, string3});
                }
            } else if (n == 4) {
                Tr.debug(_tc, "IOR object binding");
                String string10 = nameBinding.getStringifiedIOR();
                try {
                    if (string10 != null) {
                        wsnDistributedNC.addIorObjectBinding(nameComponentArray, string10, string4, true);
                        break block46;
                    }
                    wsnDistributedNC.addCorbaObjectBinding(nameComponentArray, null, string4, true);
                }
                catch (NameSpaceConstructionException nameSpaceConstructionException) {
                    FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.addInMemoryBinding", "470", this);
                    Tr.event(_tc, "Received NameSpaceConstructionException when adding object IOR binding \"" + string3 + "\".", nameSpaceConstructionException);
                    this.disableXmlUpdates("nsxmlAddBindingErr", new java.lang.Object[]{this._nameStoreURI, string3, nameSpaceConstructionException});
                }
            } else if (n == 5) {
                Tr.debug(_tc, "URL object binding");
                String string11 = nameBinding.getInsURL();
                try {
                    wsnDistributedNC.addUrlObjectBinding(nameComponentArray, string11, string4, true);
                }
                catch (NameSpaceConstructionException nameSpaceConstructionException) {
                    FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.addInMemoryBinding", "492", this);
                    Tr.event(_tc, "Received NameSpaceConstructionException when adding object URL binding \"" + string3 + "\".", nameSpaceConstructionException);
                    this.disableXmlUpdates("nsxmlAddBindingErr", new java.lang.Object[]{this._nameStoreURI, string3, nameSpaceConstructionException});
                }
            } else if (n == 6) {
                Tr.debug(_tc, "Java object binding");
                String string12 = nameBinding.getSerializedBytesAsString();
                if (string12 != null) {
                    byte[] byArray = null;
                    try {
                        byArray = CNContextImpl.stringToBytes(string12);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.addInMemoryBinding", "510", this);
                        Tr.event(_tc, "Error occurred while converting serialized byte array string to a byte array for binding \"" + string3 + "\".", throwable);
                        this.disableXmlUpdates("nsxmlBadJavaObject", new java.lang.Object[]{this._nameStoreURI, string3});
                    }
                    Any any = this._orb.create_any();
                    any.insert_Value((Serializable)byArray);
                    try {
                        wsnDistributedNC.addJavaObjectBinding(nameComponentArray, any, string4, true);
                    }
                    catch (NameSpaceConstructionException nameSpaceConstructionException) {
                        FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.addInMemoryBinding", "526", this);
                        Tr.event(_tc, "Received NameSpaceConstructionException when adding java object binding \"" + string3 + "\".", nameSpaceConstructionException);
                        this.disableXmlUpdates("nsxmlAddBindingErr", new java.lang.Object[]{this._nameStoreURI, string3, nameSpaceConstructionException});
                    }
                } else {
                    Tr.event(_tc, "Could not add java object binding \"" + string3 + "\". " + "Object byte string is null.");
                    this.disableXmlUpdates("nsxmlNullJavaObject", new String[]{this._nameStoreURI, string3});
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addInMemoryBinding");
        }
    }

    public void inMemoryToXml() throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "inMemoryToXml");
        }
        try {
            this.inMemoryToWCCM();
            this.writeOutRootCtxToXml();
        }
        catch (NameSpaceConstructionException nameSpaceConstructionException) {
            FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.inMemoryToXml", "568", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "inMemoryToXml: Rethrowing NameSpaceConstructionException: " + nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "inMemoryToXml");
        }
    }

    private void inMemoryToWCCM() throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "inMemoryToWCCM");
        }
        Enumeration enumeration = null;
        WsnDistributedNC wsnDistributedNC = null;
        String string = this._parentNC.getFullPrimaryNameString();
        try {
            wsnDistributedNC = (WsnDistributedNC)this._parentNC.resolve(this._persistentRootBindingName);
        }
        catch (NotFound notFound) {
            FFDCFilter.processException((Throwable)notFound, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.inMemoryToWCCM", "600", this);
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not resolve persistent root with the name " + this._persistentRootBindingName + " from the context " + string + ".", notFound);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "inMemoryToWCCM: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        catch (CannotProceed cannotProceed) {
            FFDCFilter.processException((Throwable)cannotProceed, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.inMemoryToWCCM", "612", this);
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Internal error.  Could not resolve persistent root context from parent  context " + string + ".", cannotProceed);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "inMemoryToWCCM: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        catch (InvalidName invalidName) {
            FFDCFilter.processException((Throwable)invalidName, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.inMemoryToWCCM", "624", this);
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Internal error.  Could not resolve persistent root context from parent  context " + string + ".", invalidName);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "inMemoryToWCCM: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        this._rootCtx = this.createWCCMNamingContext(wsnDistributedNC.get_context_id_string(), this._parentNC.get_context_id_string());
        this._ns = wsnDistributedNC.getNameSpace();
        enumeration = null;
        try {
            WsnName wsnName = this.toJndiName(this._persistentRootBindingName);
            enumeration = this._ns.list(this._parentNC, wsnName);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.inMemoryToWCCM", "647", this);
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not list bindings in context " + this._parentNC.getFullPrimaryNameString() + "/" + this._persistentRootBindingName.toString() + ".", namingException);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "inMemoryToWCCM: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        catch (NameSpaceException nameSpaceException) {
            FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.inMemoryToWCCM", "658", this);
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not list bindings in context " + this._parentNC.getFullPrimaryNameString() + "/" + this._persistentRootBindingName.toString() + ".", nameSpaceException);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "inMemoryToWCCM: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        try {
            this.addWCCMBindings(this._rootCtx, wsnDistributedNC, enumeration);
        }
        catch (NameSpaceConstructionException nameSpaceConstructionException) {
            FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.inMemoryToWCCM", "674", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "inMemoryToWCCM: Rethrowing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "inMemoryToWCCM");
        }
    }

    private void addWCCMBindings(com.ibm.websphere.models.config.namestore.NamingContext namingContext, WsnDistributedNC wsnDistributedNC, Enumeration enumeration) throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addWCCMBindings");
        }
        EList eList = namingContext.getNameBindings();
        while (enumeration.hasMoreElements()) {
            NameSpaceBindingData nameSpaceBindingData = (NameSpaceBindingData)enumeration.nextElement();
            NameBinding nameBinding = null;
            try {
                nameBinding = this.createWCCMBinding(namingContext, wsnDistributedNC, nameSpaceBindingData);
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.addWCCMBindings", "707", this);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "addWCCMBindings: Rethrowing NameSpaceConstructionException:" + nameSpaceConstructionException);
                }
                throw nameSpaceConstructionException;
            }
            if (nameBinding == null) continue;
            eList.add((java.lang.Object)nameBinding);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addWCCMBindings");
        }
    }

    private NameBinding createWCCMBinding(com.ibm.websphere.models.config.namestore.NamingContext namingContext, WsnDistributedNC wsnDistributedNC, NameSpaceBindingData nameSpaceBindingData) throws NameSpaceConstructionException {
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createWCCMBinding");
        }
        String string2 = nameSpaceBindingData.getBindingName();
        NameComponent[] nameComponentArray = WsnOptimizedNamingImplBase.internalInsNametoCosName(string2);
        String string3 = wsnDistributedNC.getFullPrimaryNameString() + "/" + string2;
        WsnName wsnName = this.toJndiName(nameComponentArray);
        java.lang.Object object = nameSpaceBindingData.getBoundObject();
        int n = nameSpaceBindingData.getBindingType();
        AdditionalData additionalData = (AdditionalData)nameSpaceBindingData.getAdditionalData();
        BindingType bindingType = additionalData.getCorbaBindingType();
        CosBindingType cosBindingType = bindingType.value() == 1 ? CosBindingType.NCONTEXT_LITERAL : CosBindingType.NOBJECT_LITERAL;
        String string4 = additionalData.getBindingProperty("URL Binding");
        String string5 = additionalData.getBindingProperty("IOR Binding");
        String string6 = additionalData.getJavaClassName();
        if (string6 == null) {
            string6 = "";
        }
        if ((string = additionalData.getBindingProperty("System Binding")) != null) {
            Tr.event(_tc, "Binding \"" + string3 + "\" is a system binding and will not be saved in the XML.");
            return null;
        }
        NamestorePackage namestorePackage = this.getNamestorePackage();
        NameBinding nameBinding = this._nameStoreFactory.createNameBinding();
        nameBinding.setNameComponent(string2);
        nameBinding.setCosBindingType(cosBindingType);
        nameBinding.setJavaClassName(string6);
        switch (n) {
            case 1: {
                nameBinding.setNameBindingType(NameBindingType.CONTEXT_PRIMARY_LITERAL);
                if (!(object instanceof WsnDistributedNC)) {
                    NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Internal error: Inconsistency between bound object and binding type in the name space.  Object bound with a primary binding is not a local context object. Could not create primary context binding.  The full binding name is " + string3 + ".");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "createWCCMBinding: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
                    }
                    throw nameSpaceConstructionException;
                }
                WsnDistributedNC wsnDistributedNC2 = (WsnDistributedNC)object;
                String string7 = wsnDistributedNC2.get_context_id_string();
                com.ibm.websphere.models.config.namestore.NamingContext namingContext2 = this.createWCCMNamingContext(string7, namingContext.getContextId());
                nameBinding.setPrimaryNamingContext(namingContext2);
                Enumeration enumeration = null;
                String string8 = wsnDistributedNC.getFullPrimaryNameString();
                try {
                    enumeration = this._ns.list(wsnDistributedNC, wsnName);
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.createWCCMBinding", "804", this);
                    NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not list bindings under context " + string8 + ". ", namingException);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "createWCCMBinding: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
                    }
                    throw nameSpaceConstructionException;
                }
                catch (NameSpaceException nameSpaceException) {
                    FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.createWCCMBinding", "814", this);
                    NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not list bindings under context " + string8 + ". ", nameSpaceException);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "createWCCMBinding: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
                    }
                    throw nameSpaceConstructionException;
                }
                try {
                    this.addWCCMBindings(namingContext2, wsnDistributedNC2, enumeration);
                    break;
                }
                catch (NameSpaceConstructionException nameSpaceConstructionException) {
                    FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.createWCCMBinding", "829", this);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "createWCCMBinding: Caught exception attempting to add binding " + string3 + ".  Rethrowing NameSpaceConstructionException: " + nameSpaceConstructionException);
                    }
                    throw nameSpaceConstructionException;
                }
            }
            case 2: {
                if (bindingType == BindingType.ncontext) {
                    String string9 = this.getContextIDFromBoundContext(object);
                    if (string4 != null) {
                        nameBinding.setNameBindingType(NameBindingType.CONTEXT_URL_LITERAL);
                        nameBinding.setInsURL(string4);
                        break;
                    }
                    if (string5 != null) {
                        nameBinding.setNameBindingType(NameBindingType.CONTEXT_IOR_LITERAL);
                        nameBinding.setStringifiedIOR(string5);
                        break;
                    }
                    if (string9 != null) {
                        nameBinding.setNameBindingType(NameBindingType.CONTEXT_LINKED_LITERAL);
                        nameBinding.setLinkedNamingContextId(string9);
                        if (!(object instanceof Object)) break;
                        String string10 = this._orb.object_to_string((Object)object);
                        nameBinding.setStringifiedIOR(string10);
                        break;
                    }
                    if (object instanceof org.omg.CosNaming.NamingContext) {
                        nameBinding.setNameBindingType(NameBindingType.CONTEXT_IOR_LITERAL);
                        String string11 = this._orb.object_to_string((Object)object);
                        nameBinding.setStringifiedIOR(string11);
                        break;
                    }
                    NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not construct context binding.  Full binding name is " + string3 + ".");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "createWCCMBinding: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
                    }
                    throw nameSpaceConstructionException;
                }
                if (object == null) {
                    Any any = additionalData.getAnyObject();
                    if (any != null && any.type().kind() != TCKind.tk_null) {
                        byte[] byArray = (byte[])any.extract_Value();
                        nameBinding.setNameBindingType(NameBindingType.OBJECT_JAVA_LITERAL);
                        String string12 = null;
                        try {
                            string12 = CNContextImpl.bytesToString(byArray);
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.createWCCMBinding", "887", this);
                            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("String encoding error. ", throwable);
                            if (_tc.isEntryEnabled()) {
                                Tr.exit(_tc, "createWCCMBinding: Caught exception attempting to add the binding " + string3 + ". Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
                            }
                            throw nameSpaceConstructionException;
                        }
                        nameBinding.setSerializedBytesAsString(string12);
                        break;
                    }
                    nameBinding.setNameBindingType(NameBindingType.OBJECT_IOR_LITERAL);
                    nameBinding.setStringifiedIOR(null);
                    break;
                }
                if (string4 != null) {
                    nameBinding.setNameBindingType(NameBindingType.OBJECT_URL_LITERAL);
                    nameBinding.setInsURL(string4);
                    break;
                }
                if (string5 != null) {
                    nameBinding.setNameBindingType(NameBindingType.OBJECT_IOR_LITERAL);
                    nameBinding.setStringifiedIOR(string5);
                    break;
                }
                if (object instanceof Object) {
                    nameBinding.setNameBindingType(NameBindingType.OBJECT_IOR_LITERAL);
                    String string13 = this._orb.object_to_string((Object)object);
                    nameBinding.setStringifiedIOR(string13);
                    break;
                }
                NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not construct object binding with the full binding name " + string3 + ".  Encountered an unexpected object or binding type.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "createWCCMBinding: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
                }
                throw nameSpaceConstructionException;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createWCCMBinding");
        }
        return nameBinding;
    }

    private com.ibm.websphere.models.config.namestore.NamingContext createWCCMNamingContext(String string, String string2) {
        com.ibm.websphere.models.config.namestore.NamingContext namingContext = this._nameStoreFactory.createNamingContext();
        namingContext.setContextId(string);
        namingContext.setParentContextId(string2);
        return namingContext;
    }

    private String getContextIDFromBoundContext(java.lang.Object object) {
        String string = null;
        if (object instanceof WsnDistributedNC) {
            string = ((WsnDistributedNC)object).get_context_id_string();
        } else if (object instanceof DestroyedContext) {
            string = ((DestroyedContext)object).getContextIDString();
        }
        return string;
    }

    private void writeOutRootCtxToXml() throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "writeOutRootCtxToXml");
        }
        URI uRI = URI.createURI((String)this._nameStoreURI);
        WASResourceImpl wASResourceImpl = new WASResourceImpl(uRI);
        wASResourceImpl.getContents().add((java.lang.Object)this._rootCtx);
        this.assignRefID((EObject)this._rootCtx);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            wASResourceImpl.save((OutputStream)byteArrayOutputStream, new HashMap());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.writeOutRootCtxToXml", "1049", this);
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Error saving name space due to an error from Respository.save.", exception);
            Tr.warning(_tc, "nsxmlRepoFileUpdateError", new java.lang.Object[]{this._nameStoreURI, exception});
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "writeOutRootCtxToXml: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "writeOutRootCtxToXml: Checking in " + this._nameStoreURI);
            }
            final byte[] byArray = byteArrayOutputStream.toByteArray();
            final String string = this._nameStoreURI;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public java.lang.Object run() throws Exception {
                    java.lang.Object object;
                    ConfigRepository configRepository = PersistentNameStoreManager.this.getRepo();
                    DocumentContentSource documentContentSource = null;
                    int n = 2;
                    DocumentChangedException documentChangedException = null;
                    try {
                        do {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "writeOutRootCtxToXml: Extracting " + string);
                            }
                            object = configRepository.getDigest(string);
                            try {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "writeOutRootCtxToXml: Modifying " + string);
                                }
                                documentContentSource = new DocumentContentSource(new Document(string, (DocumentDigest)object), new ByteArrayInputStream(byArray));
                                DocumentDigest documentDigest = configRepository.modify(documentContentSource);
                                n = -99;
                            }
                            catch (DocumentChangedException documentChangedException2) {
                                if (_tc.isEventEnabled()) {
                                    Tr.event(_tc, "writeOutRootCtxToXml: DocumentChangedException.", new java.lang.Object[]{"retryCount=" + n, documentChangedException2});
                                }
                                --n;
                                documentChangedException = documentChangedException2;
                            }
                            catch (Throwable throwable) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "writeOutRootCtxToXml: Failed to write persistent name store to the config repository.", throwable);
                                }
                                NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not update persistent name store in the config repository.  See root exception for more info.", throwable);
                                throw nameSpaceConstructionException;
                            }
                        } while (n >= 0);
                    }
                    catch (DocumentNotFoundException documentNotFoundException) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "writeOutRootCtxToXml: Creating " + string);
                        }
                        documentContentSource = new DocumentContentSource(new Document(string), new ByteArrayInputStream(byArray));
                        DocumentDigest documentDigest = configRepository.create(documentContentSource);
                        n = -99;
                    }
                    catch (Throwable throwable) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "updateMetadataForNode: Failed to read existing metadata.", throwable);
                        }
                        NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not read persistent name store from config repository.  See root exception for more info.", throwable);
                        FFDCFilter.processException((Throwable)nameSpaceConstructionException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.writeOutRootCtxToXml", "1362", this);
                        throw nameSpaceConstructionException;
                    }
                    if (n == -1) {
                        object = new NameSpaceConstructionException("Could not write persistent name store to the config repository after 2 retries.", documentChangedException);
                        FFDCFilter.processException((Throwable)object, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.writeOutRootCtxToXml", "1343", this);
                        Tr.exit(_tc, "writeOutRootCtxToXml: Exhausted retry count.", object);
                        throw object;
                    }
                    return null;
                }
            };
            try {
                SecurityContext.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        catch (NameSpaceConstructionException nameSpaceConstructionException) {
            throw nameSpaceConstructionException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.writeOutRootCtxToXml", "1387", this);
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Persistent name store document update failed.  See root exception.", throwable);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "writeOutRootCtxToXml: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "writeOutRootCtxToXml");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableXmlUpdates(String string, java.lang.Object[] objectArray) {
        Tr.warning(_tc, string, objectArray);
        PersistentNameStoreManager persistentNameStoreManager = this;
        synchronized (persistentNameStoreManager) {
            if (!this._xmlUpdatesDisabled) {
                Tr.event(_tc, "Disabling updates to name store XML: " + this._nameStoreURI);
            }
            this._xmlUpdatesDisabled = true;
        }
    }

    public boolean areXmlUpdatesDisabled() {
        return this._xmlUpdatesDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void slaveInit(EndpointGroup endpointGroup) throws NameSpaceConstructionException {
        java.lang.Object object = _notificationLock;
        synchronized (object) {
            this._masterServerEndpoint = endpointGroup;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "slaveInit");
            }
            if (_wsnMBeanName != null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "slaveInit: Already initialized");
                }
                return;
            }
            PersistentNCUpdateProxy persistentNCUpdateProxy = new PersistentNCUpdateProxy(this._orb, _originID);
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(persistentNCUpdateProxy);
            MBeanFactory mBeanFactory = AdminServiceFactory.getAdminService().getMBeanFactory();
            try {
                Properties properties = new Properties();
                properties.put("WsnSlaveProcType", this._processType);
                properties.put("WsnSlaveID", _originID);
                _wsnMBeanName = mBeanFactory.activateMBean("NameServerPrivate", defaultRuntimeCollaborator, mBeanFactory.getConfigId("websphere.naming.persistent.updates"), "com/ibm/ws/management/descriptor/xml/NameServerPrivate.xml", properties);
                if (_wsnMBeanName == null) {
                    NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Received a null object name from MBeanFactory.activateMBean.");
                    throw nameSpaceConstructionException;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Created MBean: ObjectName=" + _wsnMBeanName.toString());
                }
            }
            catch (AdminException adminException) {
                NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Received an error activating MBean.", adminException);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "initNotificationForSending: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
                }
                throw nameSpaceConstructionException;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "slaveInit");
            }
        }
    }

    public void masterInit() throws NameSpaceConstructionException {
        this._updateDispatcher = new PersistentUpdateDispatcher(this._processType);
    }

    public void forwardUpdatesToSlaveServers(PersistentNCOperationInfo persistentNCOperationInfo) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "forwardUpdatesToSlaveServers: ProcessType: " + this._processType);
        }
        if (this._processType.equals("NodeAgent")) {
            this.sendUpdateToSlaveServers(persistentNCOperationInfo);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "forwardUpdatesToSlaveServers");
        }
    }

    public void sendUpdateToSlaveServers(PersistentNCOperationInfo persistentNCOperationInfo) {
        Set set;
        ObjectName objectName;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "sendUpdateToSlaveServers", new String[]{"originID=" + persistentNCOperationInfo.getOriginID(), "thisProcID=" + _originID, "opCode=" + persistentNCOperationInfo.getOp()});
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(adminService.getDomainName());
        stringBuffer.append(":");
        stringBuffer.append("type");
        stringBuffer.append("=");
        stringBuffer.append("NameServerPrivate");
        stringBuffer.append(",");
        stringBuffer.append("name");
        stringBuffer.append("=");
        stringBuffer.append("websphere.naming.persistent.updates");
        stringBuffer.append(",");
        if (this._processType.equals("DeploymentManager")) {
            stringBuffer.append("WsnSlaveProcType");
            stringBuffer.append("=");
            stringBuffer.append("NodeAgent");
        } else {
            stringBuffer.append(OBJECT_NAME_NODE_NAME_PROP);
            stringBuffer.append("=");
            stringBuffer.append(this._nodeName);
        }
        stringBuffer.append(",*");
        try {
            objectName = new ObjectName(stringBuffer.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "sendUpdateToSlaveServers: queryObjectName=" + objectName.toString());
            }
        }
        catch (Throwable throwable) {
            Tr.exit(_tc, "sendUpdateToSlaveServers: Could not create object name for query.", throwable);
            return;
        }
        try {
            set = adminService.queryNames(objectName, null);
            if (set == null) {
                Tr.event(_tc, "sendUpdateToSlaveServers: Received null Set from queryNames.");
                Tr.exit(_tc, "sendUpdateToSlaveServers: null Set from queryNames.");
                return;
            }
            int n = set.size();
            if (n == 0) {
                Tr.event(_tc, "sendUpdateToSlaveServers: Received empty Set from queryNames.");
                Tr.exit(_tc, "sendUpdateToSlaveServers: empty Set from queryNames.");
                return;
            }
            Tr.event(_tc, "sendUpdateToSlaveServers: querySetSize=" + n);
        }
        catch (Throwable throwable) {
            Tr.exit(_tc, "sendUpdateToSlaveServers: Received exception from queryNames.", throwable);
            return;
        }
        this._updateDispatcher.dispatchUpdate(persistentNCOperationInfo, set);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "sendUpdateToSlaveServers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingContext getMasterRootNC(WsnOptimizedNamingImplBase.LeafOperationData leafOperationData) throws CannotProceed {
        PersistentNameStoreManager persistentNameStoreManager = this;
        synchronized (persistentNameStoreManager) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getMasterRootNC");
            }
            if (this._masterRootNC == null) {
                String string = "corbaname:" + this._masterServerEndpoint.toUrlAddrList() + "/" + "NameServiceTreeRoot";
                try {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getMasterRootNC: URL:", string);
                    }
                    Object object = this._orb.string_to_object(string);
                    object = WsnOptimizedNamingImplBase.narrowToNC(object);
                    this._masterRootNC = (NamingContext)object;
                }
                catch (Throwable throwable) {
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getMasterRootNC: Could not get master root NC", throwable);
                    }
                    if (leafOperationData != null) {
                        throw new CannotProceed((org.omg.CosNaming.NamingContext)leafOperationData._targetCtx, leafOperationData._leafNameComponent);
                    }
                    throw new CannotProceed(null, new NameComponent[0]);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMasterRootNC");
        }
        return this._masterRootNC;
    }

    public String getOriginID() {
        Tr.debug(_tc, "getOriginID: originID=" + _originID);
        return _originID;
    }

    public PersistentXmlNC createNC(WsnDistributedNC wsnDistributedNC, NameComponent[] nameComponentArray) throws NameSpaceConstructionException {
        PersistentXmlNC persistentXmlNC;
        try {
            persistentXmlNC = (PersistentXmlNC)this._ncCtor.newInstance(wsnDistributedNC, nameComponentArray, this._servantManager, this);
        }
        catch (Throwable throwable) {
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Error occurred while creating new context.", throwable);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createNC: Could not create Peristent NC.");
            }
            throw nameSpaceConstructionException;
        }
        return persistentXmlNC;
    }

    public String getProcessType() {
        return this._processType;
    }

    private NameComponent[] toSimpleCosName(String string) throws NameSpaceConstructionException {
        try {
            NameComponent[] nameComponentArray = WsnOptimizedNamingImplBase.toCosName(string);
            if (nameComponentArray.length != 1) {
                NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("The name \"" + string + "\" is not a name with only one name component.");
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "toJndiName: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
                }
                throw nameSpaceConstructionException;
            }
            return nameComponentArray;
        }
        catch (InvalidName invalidName) {
            FFDCFilter.processException((Throwable)invalidName, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.toNameString", "1173", this);
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not convert name string \"" + string + "\" to a CORBA CosNaming name.", invalidName);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "toJndiName: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
    }

    private WsnName toJndiName(NameComponent[] nameComponentArray) throws NameSpaceConstructionException {
        try {
            return WsnOptimizedNamingImplBase.toInsJndiName(nameComponentArray);
        }
        catch (InvalidName invalidName) {
            FFDCFilter.processException((Throwable)invalidName, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.toJndiName", "1188", this);
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not convert CORBA CosNaming name to a JNDI name.", invalidName);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "toJndiName: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
            }
            throw nameSpaceConstructionException;
        }
    }

    private NamestorePackage getNamestorePackage() {
        return NamestorePackage.eINSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigRepository getRepo() throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRepo");
        }
        PersistentNameStoreManager persistentNameStoreManager = this;
        synchronized (persistentNameStoreManager) {
            if (this._repo != null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getRepo: returning cached reference");
                }
                return this._repo;
            }
            try {
                Properties properties = new Properties();
                properties.setProperty("location", "local");
                this._repo = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.naming.distcos.PersistentNameStoreManager.PersistentNameStoreManager", "1772", this);
                NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Could not get ConfigRepository.  Received exception from ConfigRespositoryFactory.", adminException);
                Tr.warning(_tc, "nsxmlRepoRefError", new java.lang.Object[]{adminException});
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getRepo: Throwing NameSpaceConstructionException:", nameSpaceConstructionException);
                }
                throw nameSpaceConstructionException;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getRepo: returning new reference");
            }
            return this._repo;
        }
    }

    public void assignRefID(EObject eObject) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "assignRefID", eObject);
        }
        IDUtil.assignID((EObject)eObject);
        Iterator iterator = eObject.eContents().iterator();
        while (iterator.hasNext()) {
            this.assignRefID((EObject)iterator.next());
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.server/src/com/ibm/ws/naming/distcos/PersistentNameStoreManager.java, WAS.naming.server, WAS61.SERV1, cf311012.09, ver. 1.49");
        }
        _notificationLock = new java.lang.Object();
        _wsnMBeanName = null;
        _initializedForReceivingUpdates = false;
        _originID = new Uuid().toString();
    }
}

