/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.distcos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.distcos.PersistentNCOperationInfo;
import com.ibm.ws.naming.distcos.PersistentUpdateDispatcher;
import com.ibm.ws.security.core.SecurityContext;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.management.ObjectName;

class PersistentUpdateServerNotifier
extends Thread {
    private static final TraceComponent _tc = Tr.register(PersistentUpdateServerNotifier.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final long WAIT_TIME = 600000L;
    private PersistentUpdateDispatcher _dispatcher;
    private ObjectName _objectName;
    private String _notifierKey;
    private Thread _notifierThread;
    private AdminService _adminSvc;
    private Vector _opQueue;
    private boolean _inactive = false;
    private boolean _stop = false;

    public PersistentUpdateServerNotifier(PersistentUpdateDispatcher persistentUpdateDispatcher, String string, ObjectName objectName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "PersistentUpdateServerNotifier", "key=" + this._notifierKey);
        }
        this._dispatcher = persistentUpdateDispatcher;
        this._objectName = objectName;
        this._notifierKey = string;
        this._opQueue = new Vector();
        this.start();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "PersistentUpdateServerNotifier", "key=" + this._notifierKey);
        }
    }

    public String getNotifierKey() {
        return this._notifierKey;
    }

    public void start() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start", "key=" + this._notifierKey);
        }
        this._stop = false;
        this._inactive = false;
        if (this._notifierThread == null) {
            this._notifierThread = new Thread(this);
            this._notifierThread.start();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "start", "key=" + this._notifierKey);
        }
    }

    public void run() {
        this.sendUpdatesToServer();
    }

    public void sendUpdatesToServer() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "sendUpdatesToServer", "key=" + this._notifierKey);
        }
        block6: while (true) {
            try {
                while (true) {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    PersistentNCOperationInfo persistentNCOperationInfo = this.getNextOperation();
                    if (persistentNCOperationInfo == null) {
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "sendUpdatesToServer", "key=" + this._notifierKey);
                        }
                        return;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Notification data: ", new Object[]{"key=" + this._notifierKey, this._objectName, persistentNCOperationInfo});
                    }
                    try {
                        final ObjectName objectName = this._objectName;
                        final PersistentNCOperationInfo persistentNCOperationInfo2 = persistentNCOperationInfo;
                        final AdminService adminService2 = adminService;
                        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return adminService2.invoke(objectName, "applyInMemoryUpdate", new Object[]{persistentNCOperationInfo2}, new String[]{"com.ibm.ws.naming.distcos.PersistentNCOperationInfo"});
                            }
                        };
                        try {
                            SecurityContext.runAsSystem(privilegedExceptionAction);
                            continue block6;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException(privilegedActionException.getException(), "com.ibm.ws.naming.distcos.PersistentUpdateServerNotifier.sendUpdatesToServer", "186");
                            throw privilegedActionException.getException();
                        }
                    }
                    catch (Throwable throwable) {
                        if (!_tc.isEventEnabled()) continue;
                        Tr.event(_tc, "sendUpdateToSlaveServers: Could not invoke MBean.", new Object[]{"key=" + this._notifierKey, "ObjectName=" + this._objectName.toString(), throwable});
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (!_tc.isEventEnabled()) continue;
                Tr.event(_tc, "PersistentUpdatedServerNotifier: Caught Throwable", new Object[]{"key=" + this._notifierKey, throwable});
                continue;
            }
            break;
        }
    }

    public synchronized void queueUpOperation(PersistentNCOperationInfo persistentNCOperationInfo) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "queueUpOperation", new Object[]{"key=" + this._notifierKey, persistentNCOperationInfo});
        }
        if (this._notifierThread == null) {
            this.start();
        }
        this._opQueue.addElement(persistentNCOperationInfo);
        this.notify();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "queueUpOperation", new Object[]{"key=" + this._notifierKey});
        }
    }

    private synchronized PersistentNCOperationInfo getNextOperation() {
        do {
            if (!this._opQueue.isEmpty()) {
                this._inactive = false;
                PersistentNCOperationInfo persistentNCOperationInfo = (PersistentNCOperationInfo)this._opQueue.elementAt(0);
                this._opQueue.removeElementAt(0);
                Tr.exit(_tc, "getNextOperation: Next request:", new Object[]{"key=" + this._notifierKey, persistentNCOperationInfo});
                return persistentNCOperationInfo;
            }
            if (this._inactive) {
                Tr.event(_tc, "Notifier thread:  Stopping due to inactivity.", new Object[]{"key=" + this._notifierKey});
                this._dispatcher.signalInactivity(this._notifierKey);
                this._notifierThread = null;
                return null;
            }
            try {
                Tr.debug(_tc, "Notifier thread:  Waiting.", new Object[]{"key=" + this._notifierKey});
                this.wait(600000L);
                this._inactive = true;
            }
            catch (InterruptedException interruptedException) {
                Tr.event(_tc, "Notifier thread:  Wait interrupted.  Ignoring.", new Object[]{"key=" + this._notifierKey});
            }
        } while (!this._stop);
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "Notifier thread:  Stopping by request.", new Object[]{"key=" + this._notifierKey});
        }
        return null;
    }

    public synchronized boolean killIfInactive() {
        boolean bl = false;
        if (this._inactive && this._opQueue.isEmpty()) {
            this._stop = true;
            this.notify();
            bl = true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "killIfInactive", new Object[]{"key=" + this._notifierKey, "killed=" + bl});
        }
        return bl;
    }
}

