/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.ipbase;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.ipbase.BindingsTableData;
import com.ibm.ws.naming.ipbase.BindingsTableKey;
import com.ibm.ws.naming.ipbase.ContextCloner;
import com.ibm.ws.naming.ipbase.ContextID;
import com.ibm.ws.naming.ipbase.DuplicateContextIDException;
import com.ibm.ws.naming.ipbase.NameNotAtomicException;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.ipbase.NameSpaceBindingDataImpl;
import com.ibm.ws.naming.ipbase.NameSpaceEnumeration;
import com.ibm.ws.naming.ipbase.NameSpaceException;
import com.ibm.ws.naming.ipbase.NameSpaceInconsistentException;
import com.ibm.ws.naming.ipbase.StringContextID;
import com.ibm.ws.naming.ipbase.UnresolvedContext;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.util.CannotDestroySubcontextException;
import com.ibm.ws.naming.util.CannotUnbindSubcontextException;
import com.ibm.ws.naming.util.InvalidObjectException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

public class NameSpace
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NAME_SPACE_TYPE_PRIMARY = 1;
    public static final int NAME_SPACE_TYPE_CACHE = 2;
    public static final int BINDING_TYPE_CREATE = 1;
    public static final int BINDING_TYPE_BIND = 2;
    public static final int BINDING_TYPE_DONT_CARE = 99;
    public static final String ROOT_CONTEXT_ID = "ROOT CONTEXT";
    private static final String NAME_COMPONENT_SEPARATOR = "/";
    private static final String ROOT_PARENT_CONTEXT_ID = "";
    private static final TraceComponent _tc = Tr.register(NameSpace.class, "Naming");
    private static int _nameSpaceCount;
    private int _nameSpaceType;
    private HashMap _bindingsTable;
    private HashMap _contextsTable;
    private int _nameSpaceID = 0;

    public NameSpace(int n) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "NameSpace(int)", "type=" + n);
        }
        if (n != 1 && n != 2) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal nameSpaceType value: " + n);
            Tr.exit(_tc, "NameSpace(int)", "Illegal type");
            throw illegalArgumentException;
        }
        this._nameSpaceType = n;
        this._bindingsTable = new HashMap();
        this._contextsTable = new HashMap();
        this._nameSpaceID = NameSpace.getNextNameSpaceID();
        Tr.exit(_tc, "NameSpace(int): nsID=" + this._nameSpaceID);
    }

    private static synchronized int getNextNameSpaceID() {
        return ++_nameSpaceCount;
    }

    private NameSpace(NameSpace nameSpace) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "NameSpace(NameSpace)", "type=" + nameSpace._nameSpaceType);
        }
        this._nameSpaceType = nameSpace._nameSpaceType;
        this._bindingsTable = (HashMap)nameSpace._bindingsTable.clone();
        this._contextsTable = (HashMap)nameSpace._contextsTable.clone();
        this._nameSpaceID = NameSpace.getNextNameSpaceID();
        Tr.exit(_tc, "NameSpace(NameSpace): nsID=" + this._nameSpaceID);
    }

    public NameSpace cloneNameSpace(ContextCloner contextCloner) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cloneNameSpace()", "type=" + this._nameSpaceType);
        }
        NameSpace nameSpace = new NameSpace(this);
        HashMap hashMap = nameSpace._contextsTable;
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            UuidContext uuidContext = (UuidContext)hashMap.get(string);
            UuidContext uuidContext2 = contextCloner.cloneContextToDifferentNameSpace(uuidContext, nameSpace);
            hashMap.put(string, uuidContext2);
        }
        Tr.exit(_tc, "cloneNameSpace(): nsID=" + nameSpace.getNameSpaceID());
        return nameSpace;
    }

    public int getNameSpaceID() {
        return this._nameSpaceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinkedContextBinding(UuidContext uuidContext, Name name2, String string, Object object) throws NamingException, NameSpaceException {
        Tr.entry(_tc, "addLinkedContextBinding");
        StringContextID stringContextID = new StringContextID(string);
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("addLinkedContextBinding", uuidContext, name2);
            Tr.debug(_tc, "linkedCtxID=" + stringContextID);
        }
        UuidContext uuidContext2 = uuidContext;
        this.validateName(name2);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            BindingsTableData bindingsTableData;
            if (uuidContext == null && name2.size() > 1) {
                uuidContext = this.lookUpRootContext(name2.get(0), null);
                name2 = name2.getSuffix(1);
            }
            String string2 = name2.get(name2.size() - 1);
            if (name2.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException nameNotAtomicException = new NameNotAtomicException("Name " + name2.toString() + " is not atomic.");
                    Tr.exit(_tc, "addLinkedContextBinding: NameNotAtomicException", nameNotAtomicException);
                    throw nameNotAtomicException;
                }
                uuidContext = this.getParentCtxInternal(uuidContext, name2, null);
            }
            String string3 = null;
            string3 = uuidContext != null ? ((Object)uuidContext.getContextID()).toString() : ROOT_PARENT_CONTEXT_ID;
            BindingsTableKey bindingsTableKey = new BindingsTableKey(string3, string2);
            int n = 2;
            if (this._nameSpaceType == 1) {
                bindingsTableData = (BindingsTableData)this._bindingsTable.get(bindingsTableKey);
                if (bindingsTableData != null) {
                    NameAlreadyBoundException nameAlreadyBoundException = new NameAlreadyBoundException("Name \"" + name2.toString() + "\" is already bound to the context \"" + uuidContext2.getNameInNamespace() + "\".");
                    Tr.exit(_tc, "addLinkedContextBinding: NameAlreadyBoundException", nameAlreadyBoundException);
                    throw nameAlreadyBoundException;
                }
                n = 2;
            }
            bindingsTableData = new BindingsTableData(string2, stringContextID, n, object);
            this._bindingsTable.put(bindingsTableKey, bindingsTableData);
        }
        Tr.exit(_tc, "addLinkedContextBinding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(UuidContext uuidContext, Name name2, Object object, Object object2) throws NamingException, NameSpaceException {
        Tr.entry(_tc, "bind");
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("bind", uuidContext, name2);
            if (object instanceof UuidContext) {
                Tr.debug(_tc, "newCtxID=" + ((Object)((UuidContext)object).getContextID()).toString());
            }
        }
        UuidContext uuidContext2 = uuidContext;
        this.validateName(name2);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            BindingsTableData bindingsTableData;
            if (uuidContext == null && name2.size() > 1) {
                uuidContext = this.lookUpRootContext(name2.get(0), null);
                name2 = name2.getSuffix(1);
            }
            String string = name2.get(name2.size() - 1);
            if (name2.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException nameNotAtomicException = new NameNotAtomicException("Name " + name2.toString() + " is not atomic.");
                    Tr.exit(_tc, "bind: NameNotAtomicException", nameNotAtomicException);
                    throw nameNotAtomicException;
                }
                uuidContext = this.getParentCtxInternal(uuidContext, name2, null);
            }
            String string2 = null;
            string2 = uuidContext != null ? ((Object)uuidContext.getContextID()).toString() : ROOT_PARENT_CONTEXT_ID;
            BindingsTableKey bindingsTableKey = new BindingsTableKey(string2, string);
            int n = 99;
            if (this._nameSpaceType == 1) {
                bindingsTableData = (BindingsTableData)this._bindingsTable.get(bindingsTableKey);
                if (bindingsTableData != null) {
                    NameAlreadyBoundException nameAlreadyBoundException = new NameAlreadyBoundException("Name \"" + name2.toString() + "\" is already bound to the context \"" + uuidContext2.getNameInNamespace() + "\".");
                    Tr.exit(_tc, "bind: NameAlreadyBoundException", nameAlreadyBoundException);
                    throw nameAlreadyBoundException;
                }
                n = 2;
            }
            if (object instanceof UuidContext) {
                object = this.getUuidContextReference((UuidContext)object);
            }
            bindingsTableData = new BindingsTableData(string, object, n, object2);
            this._bindingsTable.put(bindingsTableKey, bindingsTableData);
        }
        Tr.exit(_tc, "bind");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSubcontext(UuidContext uuidContext, Name name2, UuidContext uuidContext2, Object object) throws NamingException, NameSpaceException {
        Tr.entry(_tc, "createSubcontext");
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("createSubcontext", uuidContext, name2);
            Tr.debug(_tc, "newCtxID=" + ((Object)uuidContext2.getContextID()).toString());
        }
        this.validateName(name2);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            BindingsTableData bindingsTableData;
            if (uuidContext == null && name2.size() > 1) {
                uuidContext = this.lookUpRootContext(name2.get(0), null);
                name2 = name2.getSuffix(1);
            }
            String string = name2.get(name2.size() - 1);
            if (name2.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException nameNotAtomicException = new NameNotAtomicException("Name " + name2.toString() + " is not atomic.");
                    Tr.exit(_tc, "createSubcontext: NameNotAtomicException", nameNotAtomicException);
                    throw nameNotAtomicException;
                }
                uuidContext = this.getParentCtxInternal(uuidContext, name2, null);
            }
            String string2 = null;
            string2 = uuidContext != null ? ((Object)uuidContext.getContextID()).toString() : ROOT_PARENT_CONTEXT_ID;
            ContextID contextID = uuidContext2.getContextID();
            String string3 = ((Object)contextID).toString();
            BindingsTableKey bindingsTableKey = new BindingsTableKey(string2, string);
            int n = 99;
            if (this._nameSpaceType == 1) {
                bindingsTableData = (BindingsTableData)this._bindingsTable.get(bindingsTableKey);
                if (bindingsTableData != null) {
                    NameAlreadyBoundException nameAlreadyBoundException = new NameAlreadyBoundException("Name " + name2.toString() + " is already bound.");
                    Tr.exit(_tc, "createSubcontext: NameAlreadyBoundException", nameAlreadyBoundException);
                    throw nameAlreadyBoundException;
                }
                n = 1;
                Object v = this._contextsTable.get(string3);
                if (v != null) {
                    DuplicateContextIDException duplicateContextIDException = new DuplicateContextIDException("Context ID " + string3 + " already exists.");
                    Tr.exit(_tc, "createSubcontext: DuplicateContextIDException", duplicateContextIDException);
                    throw duplicateContextIDException;
                }
            }
            bindingsTableData = new BindingsTableData(string, contextID, n, object);
            uuidContext2 = uuidContext2.cloneContext();
            this._bindingsTable.put(bindingsTableKey, bindingsTableData);
            this._contextsTable.put(string3, uuidContext2);
        }
        Tr.exit(_tc, "createSubcontext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySubcontext(UuidContext uuidContext, Name name2) throws NamingException, NameSpaceException {
        Tr.entry(_tc, "destroySubcontext");
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("destroySubcontext", uuidContext, name2);
        }
        UuidContext uuidContext2 = uuidContext;
        this.validateName(name2);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            if (uuidContext == null && name2.size() > 1) {
                uuidContext = this.lookUpRootContext(name2.get(0), null);
                name2 = name2.getSuffix(1);
            }
            String string = name2.get(name2.size() - 1);
            if (name2.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException nameNotAtomicException = new NameNotAtomicException("Name " + name2.toString() + " is not atomic.");
                    Tr.exit(_tc, "destroySubcontext: NameNotAtomicException", nameNotAtomicException);
                    throw nameNotAtomicException;
                }
                uuidContext = this.getParentCtxInternal(uuidContext, name2, null);
            }
            String string2 = null;
            string2 = uuidContext != null ? ((Object)uuidContext.getContextID()).toString() : ROOT_PARENT_CONTEXT_ID;
            BindingsTableKey bindingsTableKey = new BindingsTableKey(string2, string);
            BindingsTableData bindingsTableData = (BindingsTableData)this._bindingsTable.get(bindingsTableKey);
            if (bindingsTableData != null) {
                Object object;
                Object object2 = bindingsTableData.getObject();
                String string3 = null;
                if (this._nameSpaceType == 1) {
                    if (!(object2 instanceof ContextID) && !(object2 instanceof Context)) {
                        NotContextException notContextException = new NotContextException("Object bound under under the name \"" + name2.toString() + "\" is not a context.");
                        Tr.exit(_tc, "destroySubcontext: NotContextException", notContextException);
                        throw notContextException;
                    }
                    if (bindingsTableData.getBindingType() == 2) {
                        CannotDestroySubcontextException cannotDestroySubcontextException = new CannotDestroySubcontextException("Cannot destroy context \"" + name2.toString() + "\" in the context \"" + uuidContext2.getNameInNamespace() + "\".  A context can " + "be destroyed only from a context from which it was created.");
                        Tr.exit(_tc, "destroySubcontext: CannotDestroySubcontextException", cannotDestroySubcontextException);
                        throw cannotDestroySubcontextException;
                    }
                    if (!(object2 instanceof ContextID)) {
                        NameSpaceInconsistentException nameSpaceInconsistentException = new NameSpaceInconsistentException("Internal error:  The context \"" + name2.toString() + "\" has " + "a binding type of \"create\" but is not a UuidContext");
                        Tr.exit(_tc, "destroySubcontext: NameSpaceInconsistentException", nameSpaceInconsistentException);
                        throw nameSpaceInconsistentException;
                    }
                    string3 = ((Object)((ContextID)object2)).toString();
                    object = this._bindingsTable.keySet();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        BindingsTableKey bindingsTableKey2 = (BindingsTableKey)iterator.next();
                        if (!bindingsTableKey2.isPartialKeyMatch(string3)) continue;
                        ContextNotEmptyException contextNotEmptyException = new ContextNotEmptyException("The context \"" + name2.toString() + "\" is not empty.");
                        Tr.exit(_tc, "destroySubcontext: ContextNotEmptyException", contextNotEmptyException);
                        throw contextNotEmptyException;
                    }
                }
                this._bindingsTable.remove(bindingsTableKey);
                if (object2 instanceof ContextID) {
                    object = (ContextID)object2;
                    this._contextsTable.remove(object.toString());
                }
            }
        }
        Tr.exit(_tc, "destroySubcontext");
    }

    public Enumeration list(UuidContext uuidContext, Name name2) throws NamingException, NameSpaceException {
        Object object;
        Tr.entry(_tc, "list");
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("list", uuidContext, name2);
        }
        if (name2 == null) {
            InvalidNameException invalidNameException = new InvalidNameException("A null name is not allowed.");
            Tr.exit(_tc, "list: InvalidNameException", invalidNameException);
            throw invalidNameException;
        }
        if (this._nameSpaceType == 2) {
            Tr.exit(_tc, "list", "Cannot invoke list method on cache.");
            throw new OperationNotSupportedException("This method is not supported for caching.");
        }
        UuidContext uuidContext2 = uuidContext;
        if (name2.size() > 0) {
            object = this.lookup(uuidContext, name2);
            Object object2 = object.getBoundObject();
            if (object2 instanceof UuidContext) {
                uuidContext2 = (UuidContext)object2;
            } else {
                NotContextException notContextException = new NotContextException("The object bound under the name \"" + name2.toString() + "\" is not a context.");
                Tr.exit(_tc, "list: NotContextException", notContextException);
                throw notContextException;
            }
        }
        object = new NameSpaceEnumeration(this, this._bindingsTable, this._contextsTable, uuidContext2);
        Tr.exit(_tc, "list");
        return object;
    }

    public NameSpaceBindingData lookup(UuidContext uuidContext, Name name2) throws NamingException, NameSpaceException {
        return this.lookupInternal(uuidContext, name2, false);
    }

    public NameSpaceBindingData intermediateCacheLookup(UuidContext uuidContext, Name name2) throws NamingException, NameSpaceException {
        return this.lookupInternal(uuidContext, name2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameSpaceBindingData lookupInternal(UuidContext uuidContext, Name name2, boolean bl) throws NamingException, NameSpaceException {
        Object object;
        BindingsTableData bindingsTableData;
        if (_tc.isEntryEnabled()) {
            if (bl) {
                Tr.entry(_tc, "lookup: intermediate cache lookup");
            } else {
                Tr.entry(_tc, "lookup: normal lookup");
            }
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("lookup", uuidContext, name2);
        }
        this.validateName(name2);
        UuidContext uuidContext2 = null;
        String string = null;
        Object object2 = this;
        synchronized (object2) {
            if (uuidContext == null) {
                bindingsTableData = new BindingsTableData();
                uuidContext = this.lookUpRootContext(name2.get(0), bindingsTableData);
                if ((name2 = name2.getSuffix(1)).size() == 0) {
                    if (uuidContext instanceof UnresolvedContext) {
                        NameNotFoundException nameNotFoundException = new NameNotFoundException("Root context not found.");
                        if (_tc.isEntryEnabled()) {
                            if (this._nameSpaceType != 2) {
                                Tr.exit(_tc, "lookup: NameNotFoundException", nameNotFoundException);
                            } else {
                                Tr.exit(_tc, "lookup: NameNotFoundException", "Cache name space: " + nameNotFoundException.getMessage());
                            }
                        }
                        throw nameNotFoundException;
                    }
                    NameSpaceBindingDataImpl nameSpaceBindingDataImpl = new NameSpaceBindingDataImpl(name2.toString(), uuidContext, bindingsTableData.getAdditionalData(), bindingsTableData.getBindingType());
                    Tr.exit(_tc, "lookup (root context)");
                    return nameSpaceBindingDataImpl;
                }
            }
            string = name2.get(name2.size() - 1);
            uuidContext2 = uuidContext;
            if (name2.size() > 1) {
                uuidContext = this.getParentCtxInternal(uuidContext, name2, null);
            }
            object = uuidContext.getContextID();
            String string2 = object.toString();
            BindingsTableKey bindingsTableKey = new BindingsTableKey(string2, string);
            bindingsTableData = (BindingsTableData)this._bindingsTable.get(bindingsTableKey);
        }
        if (bindingsTableData == null) {
            object2 = new NameNotFoundException("Name \"" + name2.toString() + "\" not found in context \"" + uuidContext2.getNameInNamespace() + "\".");
            if (_tc.isEntryEnabled()) {
                if (this._nameSpaceType != 2) {
                    Tr.exit(_tc, "lookup: NameNotFoundException", object2);
                } else {
                    Tr.exit(_tc, "lookup: NameNotFoundException", "Cache name space: " + ((Throwable)object2).getMessage());
                }
            }
            throw object2;
        }
        Object object3 = bindingsTableData.getObject();
        if (object3 instanceof ContextID) {
            if ((object3 = this._contextsTable.get(((Object)((ContextID)object3)).toString())) == null) {
                int n = bindingsTableData.getBindingType();
                if (n == 2) {
                    object = new InvalidObjectException("The context binding \"" + name2.toString() + "\", relative to context \"" + uuidContext2.getNameInNamespace() + "\", exists, but the context " + "itself does not exist.  A \"destroySubcontext\" operation may have " + "already been performed on the name under which it was created.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "lookup: InvalidObjectException", object);
                    }
                    throw object;
                }
                if (n == 1) {
                    object = new NameSpaceInconsistentException("Internal Error:  Context \"" + name2.toString() + "\" relative to " + "the context \"" + uuidContext2.getNameInNamespace() + "\" was not found in the Contexts table.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "lookup: NameSpaceInconsistentExeption", object);
                    }
                    throw object;
                }
                object = new NameNotFoundException("The context binding \"" + name2.toString() + "\", relative to context \"" + uuidContext2.getNameInNamespace() + "\", exists, but the context " + "itself does not exist.  A \"destroySubcontext\" operation may have " + "already been performed on the name under which it was created.  Since " + "this is a cache lookup, NameNotFoundException is being thrown.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "lookup: NameNotFoundException (invalid object)", object);
                }
                throw object;
            }
            if (object3 instanceof UnresolvedContext && !bl) {
                object2 = new NameNotFoundException("Name \"" + name2.toString() + "\" not found in context \"" + uuidContext2.getNameInNamespace() + "\".");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "lookup", "Name is an unresolved context. name=\"" + name2.toString() + "\"" + "curr ctx=\"" + uuidContext2.getNameInNamespace() + "\"");
                }
                throw object2;
            }
            if (!bl) {
                object3 = ((UuidContext)object3).copyContext(uuidContext2);
            }
        }
        object2 = new NameSpaceBindingDataImpl(name2.toString(), object3, bindingsTableData.getAdditionalData(), bindingsTableData.getBindingType());
        Tr.exit(_tc, "lookup");
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(UuidContext uuidContext, Name name2, Object object, Object object2) throws NamingException, NameSpaceException {
        Tr.entry(_tc, "rebind");
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("rebind", uuidContext, name2);
        }
        UuidContext uuidContext2 = uuidContext;
        this.validateName(name2);
        String string = name2.get(name2.size() - 1);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            if (name2.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException nameNotAtomicException = new NameNotAtomicException("Name " + name2.toString() + " is not atomic.");
                    Tr.exit(_tc, "rebind: NameNotAtomicException", nameNotAtomicException);
                    throw nameNotAtomicException;
                }
                uuidContext = this.getParentCtxInternal(uuidContext, name2, null);
            }
            ContextID contextID = uuidContext.getContextID();
            String string2 = ((Object)contextID).toString();
            BindingsTableKey bindingsTableKey = new BindingsTableKey(string2, string);
            BindingsTableData bindingsTableData = (BindingsTableData)this._bindingsTable.get(bindingsTableKey);
            if (this._nameSpaceType == 1 && bindingsTableData != null && bindingsTableData.getBindingType() == 1) {
                CannotUnbindSubcontextException cannotUnbindSubcontextException = new CannotUnbindSubcontextException("Cannot unbind context \"" + name2.toString() + "\" from the context \"" + uuidContext2.getNameInNamespace() + "\".  A context can " + "be unbound only from a context from which it was bound.");
                Tr.exit(_tc, "rebind: CannotUnbindSubcontextException", cannotUnbindSubcontextException);
                throw cannotUnbindSubcontextException;
            }
            if (object instanceof UuidContext) {
                object = this.getUuidContextReference((UuidContext)object);
            }
            if (bindingsTableData == null) {
                int n = 99;
                if (this._nameSpaceType == 1) {
                    n = 2;
                }
                bindingsTableData = new BindingsTableData(string, object, n, object2);
            } else {
                bindingsTableData = new BindingsTableData(bindingsTableData.getName(), object, bindingsTableData.getBindingType(), object2);
            }
            this._bindingsTable.put(bindingsTableKey, bindingsTableData);
        }
        Tr.exit(_tc, "rebind");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(UuidContext uuidContext, Name name2) throws NamingException, NameSpaceException {
        Tr.entry(_tc, "unbind");
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("unbind", uuidContext, name2);
        }
        UuidContext uuidContext2 = uuidContext;
        this.validateName(name2);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            if (uuidContext == null && name2.size() > 1) {
                uuidContext = this.lookUpRootContext(name2.get(0), null);
                name2 = name2.getSuffix(1);
            }
            String string = name2.get(name2.size() - 1);
            if (name2.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException nameNotAtomicException = new NameNotAtomicException("Name " + name2.toString() + " is not atomic.");
                    Tr.exit(_tc, "unbind: NameNotAtomicException", nameNotAtomicException);
                    throw nameNotAtomicException;
                }
                uuidContext = this.getParentCtxInternal(uuidContext, name2, null);
            }
            String string2 = null;
            string2 = uuidContext != null ? ((Object)uuidContext.getContextID()).toString() : ROOT_PARENT_CONTEXT_ID;
            BindingsTableKey bindingsTableKey = new BindingsTableKey(string2, string);
            BindingsTableData bindingsTableData = (BindingsTableData)this._bindingsTable.get(bindingsTableKey);
            if (this._nameSpaceType == 1 && bindingsTableData != null && bindingsTableData.getBindingType() == 1) {
                CannotUnbindSubcontextException cannotUnbindSubcontextException = new CannotUnbindSubcontextException("Cannot unbind context \"" + name2.toString() + "\" from the context \"" + uuidContext2.getNameInNamespace() + "\".  A context can " + "be unbound only from a context from which it was bound.");
                Tr.exit(_tc, "unbind: CannotUnbindSubcontextException", cannotUnbindSubcontextException);
                throw cannotUnbindSubcontextException;
            }
            if (bindingsTableData != null) {
                this._bindingsTable.remove(bindingsTableKey);
            }
        }
        Tr.exit(_tc, "unbind");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdditionalData(UuidContext uuidContext, Name name2, Object object) throws NamingException, NameSpaceException {
        Tr.entry(_tc, "updateAdditionalData");
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("updateAdditionalData", uuidContext, name2);
        }
        UuidContext uuidContext2 = uuidContext;
        this.validateName(name2);
        String string = name2.get(name2.size() - 1);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            String string2;
            BindingsTableKey bindingsTableKey;
            BindingsTableData bindingsTableData;
            if (name2.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException nameNotAtomicException = new NameNotAtomicException("Name " + name2.toString() + " is not atomic.");
                    Tr.exit(_tc, "updateAdditionalData: NameNotAtomicException", nameNotAtomicException);
                    throw nameNotAtomicException;
                }
                uuidContext = this.getParentCtxInternal(uuidContext, name2, null);
            }
            if ((bindingsTableData = (BindingsTableData)this._bindingsTable.get(bindingsTableKey = new BindingsTableKey(string2 = ((Object)uuidContext.getContextID()).toString(), string))) == null) {
                NameNotFoundException nameNotFoundException = new NameNotFoundException("Name " + name2.toString() + " not found in context \"" + uuidContext2.getNameInNamespace() + "\".");
                Tr.exit(_tc, "updateAdditionalData: NameNotFoundException", nameNotFoundException);
                throw nameNotFoundException;
            }
            bindingsTableData.setAdditionalData(object);
            this._bindingsTable.put(bindingsTableKey, bindingsTableData);
        }
        Tr.exit(_tc, "updateAdditionalData");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Tr.entry(_tc, "clear");
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            this._bindingsTable.clear();
            this._contextsTable.clear();
        }
        Tr.exit(_tc, "clear");
    }

    public void validateName(Name name2) throws InvalidNameException {
        if (name2 == null || name2.size() == 0) {
            Tr.debug(_tc, "validateName", "Name is null or empty.");
            throw new InvalidNameException("An null or empty name is not allowed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getContext(String string) {
        Tr.entry(_tc, "getContext", string);
        Object var2_2 = null;
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            var2_2 = this._contextsTable.get(string);
        }
        if (var2_2 == null) {
            Tr.exit(_tc, "getContext", "Context not in Context Table");
        } else {
            Tr.exit(_tc, "getContext");
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameSpaceBindingData getParentContext(UuidContext uuidContext, Name name2) throws NameNotFoundException, NotContextException, CannotProceedException, NamingException, NameSpaceInconsistentException {
        Tr.entry(_tc, "getParentContext");
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("getParentContext", uuidContext, name2);
        }
        if (name2.size() == 0) {
            Tr.exit(_tc, "getParentContext", "Empty name specified");
            return null;
        }
        UuidContext uuidContext2 = uuidContext;
        UuidContext uuidContext3 = null;
        BindingsTableData bindingsTableData = new BindingsTableData();
        Object object = this;
        synchronized (object) {
            if (uuidContext == null) {
                uuidContext = this.lookUpRootContext(name2.get(0), bindingsTableData);
                name2 = name2.getSuffix(1);
            }
            if (name2.size() > 1) {
                uuidContext3 = this.getParentCtxInternal(uuidContext, name2, bindingsTableData);
            } else if (uuidContext2 == null) {
                uuidContext3 = uuidContext;
            } else {
                Tr.exit(_tc, "getParentContext", "Non-null current context with atomic name specified");
                return null;
            }
        }
        if (uuidContext2 != null && uuidContext3 != null) {
            uuidContext3 = uuidContext3.copyContext(uuidContext2);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getParentContext", "parentCtx=" + uuidContext3.getNameInNamespace());
            }
        }
        object = new NameSpaceBindingDataImpl(name2.toString(), uuidContext3, bindingsTableData.getAdditionalData(), bindingsTableData.getBindingType());
        Tr.exit(_tc, "getParentContext");
        return object;
    }

    private UuidContext getParentCtxInternal(UuidContext uuidContext, Name name2, BindingsTableData bindingsTableData) throws NameNotFoundException, NotContextException, CannotProceedException, NamingException, NameSpaceInconsistentException {
        CannotProceedException cannotProceedException;
        Object object;
        Comparable<Object> comparable;
        Object object2;
        int n;
        Tr.entry(_tc, "getParentCtxInternal");
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("getParentCtxInternal", uuidContext, name2);
        }
        if (name2.size() < 2) {
            NameNotFoundException nameNotFoundException = new NameNotFoundException("Name \"" + name2.toString() + "\" not found in context \"" + uuidContext.getNameInNamespace() + "\".");
            if (_tc.isEntryEnabled()) {
                if (this._nameSpaceType != 2) {
                    Tr.exit(_tc, "getParentCtxInternal: NameNotFoundException", nameNotFoundException);
                } else {
                    Tr.exit(_tc, "getParentCtxInternal: NameNotFoundException", "Cache name space: " + nameNotFoundException.getMessage());
                }
            }
            throw nameNotFoundException;
        }
        UuidContext uuidContext2 = uuidContext;
        BindingsTableData bindingsTableData2 = null;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(64);
        int n2 = name2.size();
        for (n = 0; n < n2 - 1; ++n) {
            object2 = name2.get(n);
            if (n != 0) {
                stringBuffer.append(NAME_COMPONENT_SEPARATOR);
            }
            stringBuffer.append((String)object2);
            comparable = new BindingsTableKey(((Object)uuidContext.getContextID()).toString(), name2.get(n));
            bindingsTableData2 = (BindingsTableData)this._bindingsTable.get(comparable);
            if (bindingsTableData2 == null) {
                object = new NameNotFoundException("Name " + stringBuffer.toString() + " not found in context \"" + uuidContext2.getNameInNamespace() + "\".");
                if (_tc.isEntryEnabled()) {
                    if (this._nameSpaceType != 2) {
                        Tr.exit(_tc, "getParentCtxInternal: NameNotFoundException", object);
                    } else {
                        Tr.exit(_tc, "getParentCtxInternal: NameNotFoundException", "Cache name space: " + ((Throwable)object).getMessage());
                    }
                }
                throw object;
            }
            object = bindingsTableData2.getObject();
            if (object instanceof ContextID) {
                int n3 = bindingsTableData2.getBindingType();
                cannotProceedException = this._contextsTable.get(((Object)((ContextID)object)).toString());
                if (cannotProceedException == null) {
                    if (n3 == 1) {
                        NameSpaceInconsistentException nameSpaceInconsistentException = new NameSpaceInconsistentException("Internal Error:  Context \"" + stringBuffer.toString() + "\" bound in the context \"" + uuidContext2.getNameInNamespace() + "\" not found in contexts table.");
                        Tr.exit(_tc, "getParentCtxInternal: NameSpaceInconsistentException", nameSpaceInconsistentException);
                        throw nameSpaceInconsistentException;
                    }
                    if (n3 == 2) {
                        InvalidObjectException invalidObjectException = new InvalidObjectException("The context binding \"" + stringBuffer.toString() + "\", relative " + "to context \"" + uuidContext2.getNameInNamespace() + "\", exists, " + "but the context itself does not exist.  A \"destroySubcontext\" " + "operation may have already been performed on the name under which " + "it was created.");
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "getParentCtxInternal: InvalidObjectException", invalidObjectException);
                        }
                        throw invalidObjectException;
                    }
                    NameNotFoundException nameNotFoundException = new NameNotFoundException("Name \"" + stringBuffer.toString() + "\" not found in context \"" + uuidContext2.getNameInNamespace() + "\".");
                    if (_tc.isEntryEnabled()) {
                        if (this._nameSpaceType != 2) {
                            Tr.exit(_tc, "getParentCtxInternal: NameNotFoundException", nameNotFoundException);
                        } else {
                            Tr.exit(_tc, "getParentCtxInternal: NameNotFoundException", "Cache name space: " + nameNotFoundException.getMessage());
                        }
                    }
                    throw nameNotFoundException;
                }
            } else {
                if (object instanceof Context) {
                    bl = true;
                    break;
                }
                NotContextException notContextException = new NotContextException("The object bound to " + stringBuffer.toString() + " in the context \"" + uuidContext2.getNameInNamespace() + "\" is not a context.");
                Tr.exit(_tc, "getParentCtxInternal: NotContextException", notContextException);
                throw notContextException;
            }
            uuidContext = (UuidContext)((Object)cannotProceedException);
        }
        if (bl) {
            object2 = name2.getPrefix(n + 1);
            comparable = name2.getSuffix(n);
            object = comparable;
            Object object3 = object2;
            cannotProceedException = new CannotProceedException();
            cannotProceedException.setAltName((Name)object3);
            cannotProceedException.setRemainingNewName((Name)object);
            if (uuidContext instanceof Context) {
                cannotProceedException.setAltNameCtx((Context)((Object)uuidContext));
                cannotProceedException.setEnvironment(((Context)((Object)uuidContext)).getEnvironment());
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getParentCtxInternal", "Cannot proceed. Alt name=" + object2.toString() + ", Rem name=" + comparable.toString() + ", Base ctx=" + uuidContext2.getNameInNamespace());
            }
            throw cannotProceedException;
        }
        if (bindingsTableData != null) {
            bindingsTableData.copyBindingData(bindingsTableData2);
        }
        Tr.exit(_tc, "getParentCtxInternal", uuidContext.getNameInNamespace());
        return uuidContext;
    }

    private Object getUuidContextReference(UuidContext uuidContext) throws NamingException {
        Object object = null;
        ContextID contextID = uuidContext.getContextID();
        String string = ((Object)contextID).toString();
        UuidContext uuidContext2 = (UuidContext)this._contextsTable.get(string);
        object = uuidContext2 != null ? uuidContext.getContextID() : uuidContext.cloneContext();
        return object;
    }

    private UuidContext lookUpRootContext(String string, BindingsTableData bindingsTableData) throws NameNotFoundException {
        Object object;
        Tr.entry(_tc, "lookUpRootContext");
        UuidContext uuidContext = null;
        BindingsTableKey bindingsTableKey = new BindingsTableKey(ROOT_PARENT_CONTEXT_ID, string);
        BindingsTableData bindingsTableData2 = (BindingsTableData)this._bindingsTable.get(bindingsTableKey);
        if (bindingsTableData2 != null) {
            Object v;
            object = bindingsTableData2.getObject();
            if (object instanceof ContextID && (v = this._contextsTable.get(((Object)((ContextID)object)).toString())) != null) {
                uuidContext = (UuidContext)v;
            }
            if (bindingsTableData != null) {
                bindingsTableData.copyBindingData(bindingsTableData2);
            }
        }
        if (uuidContext == null) {
            object = new NameNotFoundException("Root context not found.");
            if (_tc.isEntryEnabled()) {
                if (this._nameSpaceType != 2) {
                    Tr.exit(_tc, "lookUpRootContext: NameNotFoundException", object);
                } else {
                    Tr.exit(_tc, "lookUpRootContext: NameNotFoundException", "Cache name space: " + ((Throwable)object).getMessage());
                }
            }
            throw object;
        }
        Tr.exit(_tc, "lookUpRootContext");
        return uuidContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recursivelyRemoveBindings(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "recursivelyRemoveBindings: ctxID = " + string);
        }
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            Set set = this._bindingsTable.keySet();
            Object[] objectArray = set.toArray();
            this.doRecursivelyRemoveBindings(objectArray, string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "recursivelyRemoveBindings");
        }
    }

    private void doRecursivelyRemoveBindings(Object[] objectArray, String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doRecursivelyRemoveBindings, ctxID = " + string);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            BindingsTableKey bindingsTableKey = (BindingsTableKey)objectArray[i];
            BindingsTableData bindingsTableData = (BindingsTableData)this._bindingsTable.get(bindingsTableKey);
            if (!bindingsTableKey.isPartialKeyMatch(string)) continue;
            if (bindingsTableData.getBindingType() == 1) {
                String string2 = bindingsTableData.getObject().toString();
                this.doRecursivelyRemoveBindings(objectArray, string2);
                this._contextsTable.remove(string2);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Context " + string2 + " is removed from the context table");
                }
            }
            this._bindingsTable.remove(bindingsTableKey);
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Binding =" + bindingsTableKey.toString() + " is removed from the binding table");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doRecursivelyRemoveBindings");
        }
    }

    private void traceDebugInfo(String string, UuidContext uuidContext, Name name2) {
        try {
            String string2 = null;
            string2 = uuidContext != null ? "nsID=" + this._nameSpaceID + ", currCtx=" + uuidContext.getNameInNamespace() + ", name=" + name2.toString() + ", ctxID=" + ((Object)uuidContext.getContextID()).toString() : "nsID=" + this._nameSpaceID + ", currCtx=null" + ", name=" + name2.toString();
            Tr.debug(_tc, string, string2);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.ipbase.NameSpace.traceDebugInfo", "1715", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpNameSpace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        if (printStream == null) {
            printStream2 = System.out;
        }
        printStream2.println(ROOT_PARENT_CONTEXT_ID);
        printStream2.println("DUMP OF NAME SPACE");
        printStream2.println("==================");
        printStream2.println(ROOT_PARENT_CONTEXT_ID);
        if (this._nameSpaceType == 1) {
            printStream2.println("Name space type: PRIMARY");
        } else {
            printStream2.println("Name space type: CACHE");
        }
        printStream2.println(ROOT_PARENT_CONTEXT_ID);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            BindingsTableData bindingsTableData;
            StringBuffer stringBuffer;
            int n;
            Set set = this._bindingsTable.keySet();
            Object[] objectArray = set.toArray();
            Arrays.sort(objectArray);
            printStream2.println("BINDINGS TABLE (size: " + objectArray.length + "):");
            for (n = 0; n < objectArray.length; ++n) {
                stringBuffer = new StringBuffer(128);
                stringBuffer.append("BINDING: ");
                stringBuffer.append("Key=");
                stringBuffer.append(((BindingsTableKey)objectArray[n]).toString());
                printStream2.println(stringBuffer.toString());
                stringBuffer = new StringBuffer(128);
                bindingsTableData = (BindingsTableData)this._bindingsTable.get(objectArray[n]);
                int n2 = bindingsTableData.getBindingType();
                String string = null;
                switch (n2) {
                    case 1: {
                        string = "CREATE";
                        break;
                    }
                    case 2: {
                        string = "BIND";
                        break;
                    }
                    case 99: {
                        string = "DON'T CARE";
                        break;
                    }
                    default: {
                        string = "<INVALID BINDING TYPE (" + n2 + ")!!!>";
                    }
                }
                stringBuffer.append("   Binding type=");
                stringBuffer.append(string);
                printStream2.println(stringBuffer.toString());
                stringBuffer = new StringBuffer(128);
                Object object = bindingsTableData.getObject();
                stringBuffer.append("   Bound object type=");
                if (object instanceof ContextID) {
                    stringBuffer.append("LOCAL CONTEXT,");
                    stringBuffer.append(" ID=" + ((Object)((ContextID)object)).toString());
                } else if (object instanceof Context) {
                    stringBuffer.append("REMOTE CONTEXT,");
                    stringBuffer.append(" Class name=" + object.getClass().getName());
                    try {
                        stringBuffer.append(" Context name=" + ((Context)object).getNameInNamespace());
                    }
                    catch (NamingException namingException) {
                        FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.ipbase.NameSpace.dumpNameSpace", "1802", this);
                    }
                } else {
                    stringBuffer.append("OBJECT, ");
                    if (object != null) {
                        if (object instanceof byte[]) {
                            stringBuffer.append("Class name=<serialized object>, ");
                        } else {
                            stringBuffer.append("Class name=" + object.getClass().getName() + ", ");
                        }
                        stringBuffer.append("Data=" + object.toString());
                    } else {
                        stringBuffer.append("null object");
                    }
                }
                printStream2.println(stringBuffer.toString());
                stringBuffer = new StringBuffer(128);
                Object object2 = bindingsTableData.getAdditionalData();
                stringBuffer.append("   Additional data: ");
                if (object2 == null) {
                    stringBuffer.append("<NULL>");
                } else {
                    stringBuffer.append("Class name=");
                    stringBuffer.append(object2.getClass().getName() + ", ");
                    stringBuffer.append("Data=");
                    stringBuffer.append(object2.toString());
                }
                printStream2.println(stringBuffer.toString());
            }
            set = this._contextsTable.keySet();
            objectArray = set.toArray();
            Arrays.sort(objectArray);
            printStream2.println(ROOT_PARENT_CONTEXT_ID);
            printStream2.println("CONTEXTS TABLE (size: " + objectArray.length + "):");
            for (n = 0; n < objectArray.length; ++n) {
                stringBuffer = new StringBuffer(128);
                stringBuffer.append("CONTEXT: ");
                stringBuffer.append("Key=");
                stringBuffer.append((String)objectArray[n]);
                stringBuffer.append(", ");
                bindingsTableData = this._contextsTable.get(objectArray[n]);
                printStream2.println(stringBuffer.toString());
                stringBuffer = new StringBuffer(128);
                stringBuffer.append("   Type=");
                if (bindingsTableData instanceof UnresolvedContext) {
                    stringBuffer.append("UNRESOLVED, ID=");
                    stringBuffer.append(((Object)((UnresolvedContext)((Object)bindingsTableData)).getContextID()).toString());
                    stringBuffer.append(", name=");
                    try {
                        stringBuffer.append(((UuidContext)((Object)bindingsTableData)).getNameInNamespace());
                    }
                    catch (NamingException namingException) {
                        FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.ipbase.NameSpace.dumpNameSpace", "1868", this);
                    }
                } else if (bindingsTableData instanceof UuidContext) {
                    stringBuffer.append("RESOLVED, ID=");
                    stringBuffer.append(((Object)((UuidContext)((Object)bindingsTableData)).getContextID()).toString());
                    stringBuffer.append(", name=");
                    try {
                        stringBuffer.append(((UuidContext)((Object)bindingsTableData)).getNameInNamespace());
                    }
                    catch (NamingException namingException) {
                        FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.ipbase.NameSpace.dumpNameSpace", "1882", this);
                    }
                } else {
                    stringBuffer.append("unknown. class name=");
                    stringBuffer.append(bindingsTableData.getClass().getName());
                }
                printStream2.println(stringBuffer.toString());
            }
        }
        printStream2.println("\nEND OF NAME SPACE DUMP");
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/ipbase/NameSpace.java, WAS.naming.client, WAS61.SERV1, cf311012.09, ver. 1.35");
        }
        _nameSpaceCount = 0;
    }
}

