/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.ipbase;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.ipbase.BindingsTableData;
import com.ibm.ws.naming.ipbase.BindingsTableKey;
import com.ibm.ws.naming.ipbase.ContextID;
import com.ibm.ws.naming.ipbase.NameSpace;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.ipbase.NameSpaceBindingDataImpl;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.util.DestroyedContext;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import javax.naming.NamingException;

public class NameSpaceEnumeration
implements Enumeration {
    private static final int BATCH_SIZE_DEFAULT = 100;
    private static final TraceComponent _tc = Tr.register(NameSpace.class, "Naming");
    private static final String _sourceInfo = "SERV1/ws/code/naming.client/src/com/ibm/ws/naming/ipbase/NameSpaceEnumeration.java, WAS.naming.client, WAS61.SERV1, cf311012.09, ver. 1.7";
    private Object _lock;
    private HashMap _bindingsTable;
    private HashMap _contextsTable;
    private UuidContext _baseContext;
    private String _baseContextIDString;
    private Set _bindingKeys;
    private Iterator _bindingKeyIterator;
    private NameSpaceBindingData _nextBinding;
    private int _batchSize;
    private Vector _batch;
    private int _batchIndex;

    public NameSpaceEnumeration(Object object, HashMap hashMap, HashMap hashMap2, UuidContext uuidContext) throws NamingException {
        Tr.entry(_tc, "NameSpaceEnumeration", _sourceInfo);
        this._lock = object;
        this._bindingsTable = hashMap;
        this._contextsTable = hashMap2;
        this._baseContext = uuidContext;
        this._baseContextIDString = ((Object)uuidContext.getContextID()).toString();
        this._batchSize = 100;
        this.nextBatch();
        Tr.exit(_tc, "NameSpaceEnumeration");
    }

    public boolean hasMoreElements() {
        Tr.entry(_tc, "hasMoreElements");
        if (this._batchIndex >= this._batch.size()) {
            if (this._batch.size() == this._batchSize) {
                this.nextBatch();
            } else {
                this._batchIndex = -1;
            }
        }
        boolean bl = this._batchIndex != -1;
        Tr.exit(_tc, "hasMoreElements: more=" + bl);
        return bl;
    }

    public Object nextElement() throws NoSuchElementException {
        Tr.entry(_tc, "nextElement");
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        Tr.exit(_tc, "nextElement");
        return this._batch.elementAt(this._batchIndex++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextBatch() {
        Tr.entry(_tc, "nextBatch");
        this._batch = new Vector();
        Object object = this._lock;
        synchronized (object) {
            if (this._bindingKeyIterator == null) {
                this._bindingKeys = this._bindingsTable.entrySet();
                this._bindingKeyIterator = this._bindingKeys.iterator();
            }
            int n = 0;
            while (n < this._batchSize && this._bindingKeyIterator.hasNext()) {
                Object object2;
                BindingsTableData bindingsTableData;
                Map.Entry entry = (Map.Entry)this._bindingKeyIterator.next();
                BindingsTableKey bindingsTableKey = (BindingsTableKey)entry.getKey();
                if (!bindingsTableKey.isPartialKeyMatch(this._baseContextIDString) || (bindingsTableData = (BindingsTableData)entry.getValue()) == null) continue;
                Object object3 = bindingsTableData.getObject();
                if (object3 instanceof ContextID) {
                    object2 = (ContextID)object3;
                    if ((object3 = this._contextsTable.get(object2.toString())) != null) {
                        try {
                            object3 = ((UuidContext)object3).copyContext(this._baseContext);
                        }
                        catch (NamingException namingException) {
                            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.ipbase.NameSpaceEnumeration.nextBatch", "183", this);
                        }
                    } else {
                        object3 = new DestroyedContext(object2.toString());
                    }
                }
                if (bindingsTableData == null) continue;
                ++n;
                object2 = new NameSpaceBindingDataImpl(bindingsTableKey.getKeyPart2(), object3, bindingsTableData.getAdditionalData(), bindingsTableData.getBindingType());
                this._batch.add(object2);
            }
        }
        this._batchIndex = this._batch.size() == 0 ? -1 : 0;
        Tr.exit(_tc, "nextBatch");
    }
}

