/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.WsnBatchModeContext;
import com.ibm.websphere.naming.WsnOptimizedJndiContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.jbatch.BatchModeNotSupported;
import com.ibm.ws.naming.ldap.WsnLdapBindingEnumeration;
import com.ibm.ws.naming.ldap.WsnLdapContextPerTreeInfo;
import com.ibm.ws.naming.ldap.WsnLdapHelpers;
import com.ibm.ws.naming.ldap.WsnLdapNamingEnumeration;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.WsnName;
import com.ibm.ws.naming.util.WsnNameParser;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;

public class WsnLdapContextImpl
implements Context,
WsnOptimizedJndiContext {
    private static NameComponent[] _emptyCosNameComponent = null;
    protected WsnNameParser _parser;
    protected DirContext _ldapCtx;
    protected Hashtable _env;
    protected WsnLdapContextPerTreeInfo _pti;
    private String _pathFromContainer;
    private static final TraceComponent tc = Tr.register(WsnLdapContextImpl.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_ctor = "WsnLdapContextImpl(Hashtable,DirContext,WsnLdapContextPerTreeInfo) constructor";
    private static final String CLASS_ctor_1 = "WsnLdapContextImpl(Hashtable,DirContext,WsnLdapContextPerTreeInfo, WsnNameParser) constructor";
    private static final String METHOD_init = "init(Hashtable, DirContext, WsnLdapContextPerTreeInfo, WsnNameParser)";
    private static final String METHOD_bind = "bind(Name,Object)";
    private static final String METHOD_bindS = "bind(String,Object)";
    private static String METHOD_rebind;
    private static final String METHOD_rebindS = "rebind(String,Object)";
    private static final String METHOD_unbind = "unbind(Name)";
    private static final String METHOD_unbindS = "unbind(String)";
    private static final String METHOD_composeName = "composeName(Name,Name)";
    private static final String METHOD_composeNameS = "composeName(String,String)";
    private static final String METHOD_createSubcontext = "createSubcontext(Name)";
    private static final String METHOD_createSubcontextS = "createSubcontext(String)";
    private static final String METHOD_destroySubcontext = "destroySubcontext(Name)";
    private static final String METHOD_destroySubcontextS = "destroySubcontext(String)";
    private static final String METHOD_getNameParser = "getNameParser(Name)";
    private static final String METHOD_getNameParserS = "getNameParser(String)";
    private static final String METHOD_list = "list(Name)";
    private static final String METHOD_listS = "list(String)";
    private static final String METHOD_listBindings = "listBindings(Name)";
    private static final String METHOD_listBindingsS = "listBindings(String)";
    private static final String METHOD_lookup = "lookup(Name)";
    private static final String METHOD_lookupS = "lookup(String)";
    private static final String METHOD_rename = "rename(Name,Name)";
    private static final String METHOD_renameS = "rename(String,String)";
    private static final String METHOD_addToEnvironment = "addToEnvironment(String,Object)";
    private static final String METHOD_getEnvironment = "getEnvironment()";
    private static final String METHOD_removeFromEnvironment = "removeFromEnvironment(String)";
    private static final String METHOD_close = "close()";

    private WsnLdapContextImpl() {
    }

    protected WsnLdapContextImpl(Hashtable hashtable, DirContext dirContext, WsnLdapContextPerTreeInfo wsnLdapContextPerTreeInfo) throws NamingException {
        Tr.entry(tc, CLASS_ctor);
        WsnNameParser wsnNameParser = WsnNameParser.getParser(hashtable);
        this.init(hashtable, dirContext, wsnLdapContextPerTreeInfo, wsnNameParser);
        Tr.exit(tc, CLASS_ctor);
    }

    protected WsnLdapContextImpl(Hashtable hashtable, DirContext dirContext, WsnLdapContextPerTreeInfo wsnLdapContextPerTreeInfo, WsnNameParser wsnNameParser) throws NamingException {
        Tr.debug(tc, CLASS_ctor_1);
        this.init(hashtable, dirContext, wsnLdapContextPerTreeInfo, wsnNameParser);
    }

    private void init(Hashtable hashtable, DirContext dirContext, WsnLdapContextPerTreeInfo wsnLdapContextPerTreeInfo, WsnNameParser wsnNameParser) throws NamingException {
        Tr.entry(tc, METHOD_init);
        this._env = (Hashtable)hashtable.clone();
        this._ldapCtx = dirContext;
        this._pti = wsnLdapContextPerTreeInfo;
        this._parser = wsnNameParser;
        this._pathFromContainer = null;
        if (_emptyCosNameComponent == null) {
            _emptyCosNameComponent = new NameComponent[1];
            WsnLdapContextImpl._emptyCosNameComponent[0] = new NameComponent("", "");
        }
        Tr.exit(tc, METHOD_init);
    }

    public void bind(Name name2, java.lang.Object object) throws NamingException {
        Tr.entry(tc, METHOD_bind, name2);
        Helpers.throwIfNullOrEmpty(name2, METHOD_bind, (Context)this);
        Context context = Helpers.getContextIfUrlName(name2, this._env);
        if (context != null) {
            context.bind(name2, object);
        } else {
            Attributes attributes2 = null;
            String string = null;
            try {
                String string2 = this.getEntryTypeNeededToBind(object);
                string = this.convert_to_ldapName(name2);
                attributes2 = this.initAttrsForEntryType(string2, name2, object, string);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.ldap.WsnLdapContextImpl.bind", "177", this);
                Tr.exit(tc, "caught/rethrow NamingException: " + namingException);
                throw namingException;
            }
            try {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "_ldapCtx.bind(ldapRDN, null, attrs)", new java.lang.Object[]{"ldapRDN=" + string, attributes2});
                }
                this._ldapCtx.bind(string, null, attributes2);
            }
            catch (NamingException namingException) {
                FederatedContext federatedContext = this.getCannotProceedException(namingException, name2);
                Context context2 = federatedContext.getContext();
                context2.bind(federatedContext.getRemainingName(), object);
            }
        }
        Tr.exit(tc, METHOD_bind, name2);
    }

    public void bind(String string, java.lang.Object object) throws NamingException {
        Tr.entry(tc, METHOD_bindS, string);
        String string2 = this.stripLeadingSlashFromName(string);
        Helpers.throwIfNullOrEmpty(string2, METHOD_bindS, (Context)this);
        this.bind(this._parser.parse(string2), object);
        Tr.exit(tc, METHOD_bindS, string);
    }

    public void rebind(Name name2, java.lang.Object object) throws NamingException {
        Tr.entry(tc, METHOD_rebind, name2);
        Helpers.throwIfNullOrEmpty(name2, METHOD_rebind, (Context)this);
        Context context = Helpers.getContextIfUrlName(name2, this._env);
        if (context != null) {
            context.rebind(name2, object);
        } else {
            Attributes attributes2 = null;
            String string = null;
            try {
                String string2 = this.getEntryTypeNeededToBind(object);
                string = this.convert_to_ldapName(name2);
                attributes2 = this.initAttrsForEntryType(string2, name2, object, string);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.ldap.WsnLdapContextImpl.rebind", "228", this);
                Tr.exit(tc, "caught/rethrow NamingException: " + namingException);
                throw namingException;
            }
            try {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "_ldapCtx.rebind(ldapRDN, null, attrs)", new java.lang.Object[]{"ldapRDN=" + string, attributes2});
                }
                this._ldapCtx.rebind(string, null, attributes2);
            }
            catch (NamingException namingException) {
                FederatedContext federatedContext = this.getCannotProceedException(namingException, name2);
                Context context2 = federatedContext.getContext();
                context2.rebind(federatedContext.getRemainingName(), object);
            }
        }
        Tr.exit(tc, METHOD_rebind, name2);
    }

    public void rebind(String string, java.lang.Object object) throws NamingException {
        Tr.entry(tc, METHOD_rebindS, string);
        String string2 = this.stripLeadingSlashFromName(string);
        Helpers.throwIfNullOrEmpty(string2, METHOD_rebindS, (Context)this);
        this.rebind(this._parser.parse(string2), object);
        Tr.exit(tc, METHOD_rebindS, string);
    }

    public void unbind(Name name2) throws NamingException {
        Tr.entry(tc, METHOD_unbind, name2);
        Helpers.throwIfNullOrEmpty(name2, METHOD_unbind, (Context)this);
        Context context = Helpers.getContextIfUrlName(name2, this._env);
        if (context != null) {
            context.unbind(name2);
        } else {
            String string = this.convert_to_ldapName(name2);
            try {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "_ldapCtx.unbind(ldapRDN)", new java.lang.Object[]{"ldapRDN=" + string});
                }
                this._ldapCtx.unbind(string);
            }
            catch (NamingException namingException) {
                FederatedContext federatedContext = this.getCannotProceedException(namingException, name2);
                Context context2 = federatedContext.getContext();
                context2.unbind(federatedContext.getRemainingName());
            }
        }
        Tr.exit(tc, METHOD_unbind, name2);
    }

    public void unbind(String string) throws NamingException {
        Tr.entry(tc, METHOD_unbindS, string);
        String string2 = this.stripLeadingSlashFromName(string);
        Helpers.throwIfNullOrEmpty(string2, METHOD_unbindS, (Context)this);
        this.unbind(this._parser.parse(string2));
        Tr.exit(tc, METHOD_unbindS, string);
    }

    public Name composeName(Name name2, Name name3) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, METHOD_composeName, " name=" + name2 + " prefix=" + name3);
        }
        Helpers.throwIfNull(name2, METHOD_composeName, (Context)this);
        Helpers.throwIfNull(name3, METHOD_composeName, (Context)this);
        Name name4 = null;
        Context context = Helpers.getContextIfUrlName(name2, this._env);
        if (context != null) {
            name4 = context.composeName(name2, name3);
        } else {
            name4 = this._parser.parse("");
            Enumeration<String> enumeration = name3.getAll();
            while (enumeration.hasMoreElements()) {
                name4.add(enumeration.nextElement());
            }
            enumeration = name2.getAll();
            while (enumeration.hasMoreElements()) {
                name4.add(enumeration.nextElement());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, METHOD_composeName, " returnName=" + name4);
        }
        return name4;
    }

    public String composeName(String string, String string2) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, METHOD_composeNameS, " name=" + string + " prefix=" + string2);
        }
        String string3 = this.stripLeadingSlashFromName(string);
        Helpers.throwIfNull(string3, METHOD_composeNameS, (Context)this);
        Helpers.throwIfNull(string2, METHOD_composeNameS, (Context)this);
        WsnName wsnName = (WsnName)this.composeName(this._parser.parse(string3), this._parser.parse(string2));
        String string4 = wsnName.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, METHOD_composeNameS, " returnName=" + string4);
        }
        return string4;
    }

    public Context createSubcontext(Name name2) throws NamingException {
        Tr.entry(tc, METHOD_createSubcontext, name2);
        Helpers.throwIfNullOrEmpty(name2, METHOD_createSubcontext, (Context)this);
        Context context = null;
        Context context2 = Helpers.getContextIfUrlName(name2, this._env);
        if (context2 != null) {
            context = context2.createSubcontext(name2);
        } else {
            String string = this.convert_to_ldapName(name2);
            Attributes attributes2 = this.initAttrsForEntryType("PrimaryContext", name2, null, string);
            try {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "newLdapCtx = _ldapCtx.createSubcontext(ldapRDN,attrs)", new java.lang.Object[]{"ldapRDN=" + string, attributes2});
                }
                DirContext dirContext = this._ldapCtx.createSubcontext(string, attributes2);
                context = new WsnLdapContextImpl(this._env, dirContext, this._pti, this._parser);
            }
            catch (NamingException namingException) {
                FederatedContext federatedContext = this.getCannotProceedException(namingException, name2);
                Context context3 = federatedContext.getContext();
                context = context3.createSubcontext(federatedContext.getRemainingName());
            }
        }
        Tr.exit(tc, METHOD_createSubcontext, name2);
        return context;
    }

    public Context createSubcontext(String string) throws NamingException {
        Tr.entry(tc, METHOD_createSubcontextS, string);
        String string2 = this.stripLeadingSlashFromName(string);
        Helpers.throwIfNullOrEmpty(string2, METHOD_createSubcontextS, (Context)this);
        Context context = this.createSubcontext(this._parser.parse(string2));
        Tr.exit(tc, METHOD_createSubcontextS, string);
        return context;
    }

    public void destroySubcontext(Name name2) throws NamingException {
        Tr.entry(tc, METHOD_destroySubcontext, name2);
        Helpers.throwIfNullOrEmpty(name2, METHOD_destroySubcontext, (Context)this);
        Context context = Helpers.getContextIfUrlName(name2, this._env);
        if (context != null) {
            context.destroySubcontext(name2);
        } else {
            try {
                String string = this.convert_to_ldapName(name2);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "_ldapCtx.destroySubcontext(ldapRDN)", new java.lang.Object[]{"ldapRDN=" + string});
                }
                this._ldapCtx.destroySubcontext(string);
            }
            catch (InvalidNameException invalidNameException) {
                FFDCFilter.processException((Throwable)invalidNameException, "com.ibm.ws.naming.ldap.WsnLdapContextImpl.destroySubcontext", "420", this);
                throw new ContextNotEmptyException("Cannot destroy non-empty context at " + this.nameInNamespace());
            }
            catch (NamingException namingException) {
                FederatedContext federatedContext = this.getCannotProceedException(namingException, name2);
                Context context2 = federatedContext.getContext();
                context2.destroySubcontext(federatedContext.getRemainingName());
            }
        }
        Tr.exit(tc, METHOD_destroySubcontext, name2);
    }

    public void destroySubcontext(String string) throws NamingException {
        Tr.entry(tc, METHOD_destroySubcontextS, string);
        String string2 = this.stripLeadingSlashFromName(string);
        Helpers.throwIfNullOrEmpty(string2, METHOD_destroySubcontext, (Context)this);
        this.destroySubcontext(this._parser.parse(string2));
        Tr.exit(tc, METHOD_destroySubcontextS, string);
    }

    public NameParser getNameParser(Name name2) throws NamingException {
        Tr.entry(tc, METHOD_getNameParser, name2);
        NameParser nameParser = null;
        if (Helpers.trueIfEmptyOrThrowIfNull(name2, METHOD_getNameParser, (Context)this)) {
            nameParser = this._parser;
        } else {
            Context context = Helpers.getContextIfUrlName(name2, this._env);
            if (context != null) {
                nameParser = context.getNameParser(name2);
            } else {
                Context context2 = (Context)this.lookupWithoutEmptyOrUrlChecks(name2);
                nameParser = context2.getNameParser("");
                Helpers.closeIfContext(context2);
            }
        }
        Tr.exit(tc, METHOD_getNameParser, name2);
        return nameParser;
    }

    public NameParser getNameParser(String string) throws NamingException {
        Tr.entry(tc, METHOD_getNameParserS, string);
        String string2 = this.stripLeadingSlashFromName(string);
        Helpers.throwIfNull(string2, METHOD_getNameParserS, (Context)this);
        NameParser nameParser = this.getNameParser(this._parser.parse(string2));
        Tr.exit(tc, METHOD_getNameParserS, string);
        return nameParser;
    }

    public NamingEnumeration list(Name name2) throws NamingException {
        Tr.entry(tc, METHOD_list, name2);
        Helpers.throwIfNull(name2, METHOD_list, (Context)this);
        WsnLdapNamingEnumeration wsnLdapNamingEnumeration = null;
        Context context = Helpers.getContextIfUrlName(name2, this._env);
        if (context != null) {
            wsnLdapNamingEnumeration = context.list(name2);
        } else {
            try {
                String string = this.convert_to_ldapName(name2);
                SearchControls searchControls = new SearchControls(1, 0L, 0, null, false, false);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "_ldapCtx.search(ldapRDN,objectClass=ibm-wsnEntry,sc)", "ldapRDN=" + string);
                }
                NamingEnumeration<SearchResult> namingEnumeration = this._ldapCtx.search(string, "objectClass=ibm-wsnEntry", searchControls);
                wsnLdapNamingEnumeration = new WsnLdapNamingEnumeration(this.getEnvironment(), namingEnumeration, this._parser, true);
            }
            catch (NamingException namingException) {
                FederatedContext federatedContext = this.getCannotProceedException(namingException, name2);
                Context context2 = federatedContext.getContext();
                wsnLdapNamingEnumeration = context2.list(federatedContext.getRemainingName());
            }
        }
        Tr.exit(tc, METHOD_list, name2);
        return wsnLdapNamingEnumeration;
    }

    public NamingEnumeration list(String string) throws NamingException {
        Tr.entry(tc, METHOD_listS, string);
        String string2 = this.stripLeadingSlashFromName(string);
        Helpers.throwIfNull(string2, METHOD_listS, (Context)this);
        NamingEnumeration namingEnumeration = this.list(this._parser.parse(string2));
        Tr.exit(tc, METHOD_listS, string);
        return namingEnumeration;
    }

    public NamingEnumeration listBindings(Name name2) throws NamingException {
        Tr.entry(tc, METHOD_listBindings, name2);
        Helpers.throwIfNull(name2, METHOD_listBindings, (Context)this);
        WsnLdapBindingEnumeration wsnLdapBindingEnumeration = null;
        Context context = Helpers.getContextIfUrlName(name2, this._env);
        if (context != null) {
            wsnLdapBindingEnumeration = context.listBindings(name2);
        } else if (!name2.isEmpty()) {
            Context context2 = (Context)this.lookupWithoutEmptyOrUrlChecks(name2);
            wsnLdapBindingEnumeration = context2.listBindings("");
        } else {
            try {
                SearchControls searchControls = new SearchControls(1, 0L, 0, null, false, false);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "_ldapCtx.search(ldapRDN,objectClass=ibm-wsnEntry,sc)", "ldapRDN=\"\"");
                }
                NamingEnumeration<SearchResult> namingEnumeration = this._ldapCtx.search("", "objectClass=ibm-wsnEntry", searchControls);
                wsnLdapBindingEnumeration = new WsnLdapBindingEnumeration(this, namingEnumeration);
            }
            catch (NamingException namingException) {
                FederatedContext federatedContext = this.getCannotProceedException(namingException, name2);
                Context context3 = federatedContext.getContext();
                wsnLdapBindingEnumeration = context3.listBindings(federatedContext.getRemainingName());
            }
        }
        Tr.exit(tc, METHOD_listBindings, name2);
        return wsnLdapBindingEnumeration;
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        Tr.entry(tc, METHOD_listBindingsS, string);
        String string2 = this.stripLeadingSlashFromName(string);
        Helpers.throwIfNull(string2, METHOD_listBindingsS, (Context)this);
        NamingEnumeration namingEnumeration = this.listBindings(this._parser.parse(string2));
        Tr.exit(tc, METHOD_listBindingsS, string);
        return namingEnumeration;
    }

    public java.lang.Object lookup(Name name2) throws NamingException {
        java.lang.Object object;
        Tr.entry(tc, METHOD_lookup, name2);
        java.lang.Object object2 = null;
        object2 = Helpers.trueIfEmptyOrThrowIfNull(name2, METHOD_lookup, (Context)this) ? new WsnLdapContextImpl(this._env, this._ldapCtx, this._pti, this._parser) : ((object = Helpers.getContextIfUrlName(name2, this._env)) != null ? object.lookup(name2) : this.lookupWithoutEmptyOrUrlChecks(name2));
        if (tc.isEntryEnabled()) {
            object = object2.getClass().getName();
            Tr.exit(tc, METHOD_lookup, new java.lang.Object[]{"name: " + name2, "returning object of class=" + (String)object});
        }
        return object2;
    }

    public java.lang.Object lookup(String string) throws NamingException {
        java.lang.Object object;
        Tr.entry(tc, METHOD_lookupS, string);
        String string2 = this.stripLeadingSlashFromName(string);
        java.lang.Object object2 = null;
        object2 = Helpers.trueIfEmptyOrThrowIfNull(string2, METHOD_lookupS, (Context)this) ? new WsnLdapContextImpl(this._env, this._ldapCtx, this._pti, this._parser) : ((object = Helpers.getContextIfUrlName(string2, this._env)) != null ? object.lookup(string2) : this.lookupWithoutEmptyOrUrlChecks(string2));
        if (tc.isEntryEnabled()) {
            object = object2.getClass().getName();
            Tr.exit(tc, METHOD_lookupS, new java.lang.Object[]{"name: " + string, "returning object of class=" + (String)object});
        }
        return object2;
    }

    private java.lang.Object lookupWithoutEmptyOrUrlChecks(Name name2) throws NamingException {
        java.lang.Object object = null;
        Attributes attributes2 = null;
        try {
            String string = this.convert_to_ldapName(name2);
            attributes2 = this._ldapCtx.getAttributes(string);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "attrs = _ldapCtx.getAttributes(ldapRDN)", new java.lang.Object[]{"ldapRDN=" + string, attributes2});
            }
            String string2 = WsnLdapHelpers.getStringFromAttribute(attributes2, "ibm-wsnEntryType", 1);
            object = this.getObjectFromEntry(string2, attributes2, name2);
        }
        catch (NamingException namingException) {
            FederatedContext federatedContext = this.getCannotProceedException(namingException, name2);
            Context context = federatedContext.getContext();
            object = context.lookup(federatedContext.getRemainingName());
        }
        return object;
    }

    private java.lang.Object lookupWithoutEmptyOrUrlChecks(String string) throws NamingException {
        return this.lookupWithoutEmptyOrUrlChecks(this._parser.parse(string));
    }

    public java.lang.Object lookupLink(Name name2) throws NamingException {
        String string = "The 'lookupLink(Name)' method is not supported by this implementation, called with Name=" + name2;
        Tr.event(tc, string);
        throw new OperationNotSupportedException(string);
    }

    public java.lang.Object lookupLink(String string) throws NamingException {
        String string2 = "The 'lookupLink(String)' method is not supported by this implementation, called with Name=" + string;
        Tr.event(tc, string2);
        throw new OperationNotSupportedException(string2);
    }

    public void rename(Name name2, Name name3) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, METHOD_rename, "oldName=" + name2 + " newName=" + name3);
        }
        Helpers.throwIfNullOrEmpty(name2, METHOD_rename, (Context)this);
        Helpers.throwIfNullOrEmpty(name3, METHOD_rename, (Context)this);
        if (name3.compareTo(name2) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, METHOD_rename, "oldName=newName=" + name3 + " - no processing performed");
            }
            return;
        }
        boolean bl = NameFormatHelper.isUrl(name2);
        boolean bl2 = NameFormatHelper.isUrl(name3);
        if (bl && bl2) {
            Context context = Helpers.getContextIfUrlName(name2, this._env);
            context.rename(name2, name3);
        } else if (!bl && !bl2) {
            java.lang.Object object = this.lookup(name2);
            this.unbind(name2);
            try {
                this.bind(name3, object);
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
                FFDCFilter.processException((Throwable)nameAlreadyBoundException, "com.ibm.ws.naming.ldap.WsnLdapContextImpl.rename", "759", this);
                Tr.event(tc, "rename failure - NameAlreadyBoundException, restoring binding for oldName");
                this.bind(name2, object);
                String string = "newName=" + name3 + " already bound to context " + this.toString();
                Tr.exit(tc, METHOD_rename, "NameAlreadyBoundException: " + string);
                throw new NameAlreadyBoundException(string);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.ldap.WsnLdapContextImpl.rename", "768", this);
                Tr.event(tc, "rename failure - other NamingException, restoring binding for oldName");
                this.bind(name2, object);
                Tr.exit(tc, METHOD_rename, "rethrowing NamingException=" + namingException);
                throw namingException;
            }
        } else {
            String string = "rename(Name,Name) cannot mix URL and non-URL names: oldName=" + name2 + " newName=" + name3;
            Tr.exit(tc, string);
            throw new OperationNotSupportedException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, METHOD_rename, "oldName=" + name2 + " newName=" + name3);
        }
    }

    public void rename(String string, String string2) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, METHOD_renameS, "oldName=" + string + " newName=" + string2);
        }
        String string3 = this.stripLeadingSlashFromName(string);
        String string4 = this.stripLeadingSlashFromName(string2);
        Helpers.throwIfNullOrEmpty(string, METHOD_renameS, (Context)this);
        Helpers.throwIfNullOrEmpty(string2, METHOD_renameS, (Context)this);
        this.rename(this._parser.parse(string), this._parser.parse(string2));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, METHOD_renameS, " oldName=" + string + " newName=" + string2);
        }
    }

    public java.lang.Object addToEnvironment(String string, java.lang.Object object) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, METHOD_addToEnvironment, " propName=" + string + " Object=" + object);
        }
        if (string == null || object == null) {
            throw new NamingException("addToEnvironment(String,Object) called with null parameter, propName=" + string + " Object=" + object);
        }
        java.lang.Object object2 = this._env.put(string, object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, METHOD_addToEnvironment, " propName=" + string + " Object=" + object + " old value was=" + object2);
        }
        return object2;
    }

    public Hashtable getEnvironment() throws NamingException {
        Tr.entry(tc, METHOD_getEnvironment);
        Hashtable hashtable = (Hashtable)this._env.clone();
        Tr.exit(tc, METHOD_getEnvironment);
        return hashtable;
    }

    public java.lang.Object removeFromEnvironment(String string) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, METHOD_removeFromEnvironment, " propName=" + string);
        }
        if (string == null) {
            throw new NamingException("removeFromEnvironment(String) called with null parameter, propName=" + string);
        }
        java.lang.Object v = this._env.remove(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, METHOD_removeFromEnvironment, " propName=" + string + " old value was=" + v);
        }
        return v;
    }

    public void close() throws NamingException {
        Tr.entry(tc, METHOD_close);
        if (tc.isEventEnabled()) {
            Tr.event(tc, "_ldapCtx.close()");
        }
        this._ldapCtx.close();
        this._ldapCtx = null;
        this._env = null;
        this._parser = null;
        Tr.exit(tc, METHOD_close);
    }

    public String getNameInNamespace() throws NamingException {
        String string = this.nameInNamespace();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getNameInNamespace()-->>" + string);
        }
        return string;
    }

    public String toString() {
        String string = "";
        try {
            string = this.nameInNamespace();
        }
        catch (NamingException namingException) {
            string = "????? nameInNamespace failed ?????";
        }
        return this.getClass().getName() + "(" + string + ")";
    }

    private String nameInNamespace() throws NamingException {
        String string = this.getPathFromContainer();
        return string;
    }

    private String convert_to_ldapName(Name name2) throws NamingException {
        String string = "";
        try {
            Name name3 = NameFormatHelper.convertInsJndiNameToLdapJndiName(name2);
            string = NameFormatHelper.convertLdapJndiNameToLdapStringName(name3);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.ldap.WsnLdapContextImpl.convert_to_ldapName", "951", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occured somewhere in convert_to_ldapName, will rethrow as InvalidNameException, original exception follows:", exception);
            }
            Tr.warning(tc, "jldapJndiToLdapConv", name2.toString());
            String string2 = "Cannot convert the JNDI name " + name2.toString() + " to an LDAP name string.";
            InvalidNameException invalidNameException = new InvalidNameException(string2);
            invalidNameException.setRootCause(exception);
            throw invalidNameException;
        }
        return string;
    }

    private String convert_to_ldapName(String string) throws NamingException {
        return this.convert_to_ldapName(this._parser.parse(string));
    }

    private String convert_to_ldapNameComponentValue(String string) throws NamingException {
        String string2 = null;
        if (string.length() == 0) {
            Name name2 = this._parser.ncToName(_emptyCosNameComponent);
            string2 = this.convert_to_ldapName(name2);
        } else {
            string2 = this.convert_to_ldapName(string);
        }
        int n = "ibm-wsnName=".length();
        String string3 = string2.substring(n);
        String string4 = "";
        for (int i = 0; i < string3.length(); ++i) {
            String string5 = string3.substring(i, i + 1);
            if (string5.equals("\\")) {
                String string6 = string3.substring(i, i + 2);
                if (!string6.equals("\\\\")) continue;
                string4 = string4.concat("\\");
                ++i;
                continue;
            }
            string4 = string4.concat(string5);
        }
        return string4;
    }

    private String fixAliasObjectDN(String string) throws NamingException {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            String string3 = string.substring(i, i + 1);
            if (string3.equals("\\")) {
                String string4 = string.substring(i, i + 3);
                if (string4.equals("\\\\.")) {
                    string2 = string2.concat("\\\\\\.");
                    i += 2;
                    continue;
                }
                string2 = string2.concat(string3);
                continue;
            }
            string2 = string2.concat(string3);
        }
        string2 = string2.concat(string.substring(string.length()));
        return string2;
    }

    private java.lang.Object toCorba(java.lang.Object object) {
        if (object instanceof Remote) {
            Remote remote = (Remote)object;
            try {
                Object object2 = (Object)PortableRemoteObject.toStub((Remote)remote);
                return object2;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                Tr.exit(tc, "toCorba: exception");
                return null;
            }
        }
        return object;
    }

    String getEntryTypeNeededToBind(java.lang.Object object) throws NamingException {
        Tr.entry(tc, "getEntryTypeNeededToBind");
        if (object == null || object instanceof Remote || object instanceof Object) {
            Tr.exit(tc, "getEntryTypeNeededToBind - Type: IORLeaf");
            return "IORLeaf";
        }
        if (object instanceof WsnLdapContextImpl) {
            WsnLdapContextImpl wsnLdapContextImpl = (WsnLdapContextImpl)object;
            if (this._pti._masterServerUrl.equals(wsnLdapContextImpl._pti._masterServerUrl) && this._pti._nameTreeContainerDN.equals(wsnLdapContextImpl._pti._nameTreeContainerDN)) {
                Tr.exit(tc, "getEntryTypeNeededToBind - Type: LinkedContext");
                return "LinkedContext";
            }
            Tr.exit(tc, "getEntryTypeNeededToBind - We don't yet support Federation of name spaces");
            throw new SchemaViolationException("We don't yet support Federation of name spaces");
        }
        if (object instanceof Referenceable || object instanceof Reference || object instanceof Serializable) {
            Tr.exit(tc, "getEntryTypeNeededToBind - Type: SerializableLeaf");
            return "SerializableLeaf";
        }
        Tr.exit(tc, "getEntryTypeNeededToBind - Throwing NamingException - Don't know how to bind this type of object");
        throw new NamingException("Don't know how to bind this type of object");
    }

    Attributes initAttrsForEntryType(String string, Name name2, java.lang.Object object, String string2) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes();
        BasicAttribute basicAttribute = new BasicAttribute("objectClass");
        basicAttributes.put(basicAttribute);
        basicAttribute.add("ibm-wsnEntry");
        BasicAttribute basicAttribute2 = new BasicAttribute("ibm-wsnEntryType");
        basicAttributes.put(basicAttribute2);
        basicAttribute2.add(string);
        BasicAttribute basicAttribute3 = new BasicAttribute("ibm-wsnName");
        basicAttributes.put(basicAttribute3);
        String string3 = name2.get(name2.size() - 1);
        String string4 = this.convert_to_ldapNameComponentValue(string3);
        basicAttribute3.add(string4);
        BasicAttribute basicAttribute4 = new BasicAttribute("javaClassName");
        basicAttributes.put(basicAttribute4);
        if (string.equals("IORLeaf")) {
            this.initAttrsForIORLeaf(basicAttributes, basicAttribute, basicAttribute4, object);
        } else if (string.equals("SerializableLeaf")) {
            this.initAttrsForSerializableLeaf(basicAttributes, basicAttribute, basicAttribute4, object);
        } else if (string.equals("PrimaryContext")) {
            this.initAttrsForPrimaryContext(basicAttributes, basicAttribute, basicAttribute4, string2);
        } else if (string.equals("LinkedContext")) {
            this.initAttrsForLinkedContext(basicAttributes, basicAttribute, basicAttribute4, (WsnLdapContextImpl)object);
        }
        return basicAttributes;
    }

    void initAttrsForIORLeaf(Attributes attributes2, Attribute attribute, Attribute attribute2, java.lang.Object object) throws NamingException {
        attribute.add("corbaObjectReference");
        String string = "";
        if (object != null) {
            string = object.getClass().getName();
        }
        attribute2.add(string);
        BasicAttribute basicAttribute = new BasicAttribute("corbaIor");
        String string2 = this._pti._orb.object_to_string((Object)this.toCorba(object));
        basicAttribute.add(string2);
        attributes2.put(basicAttribute);
    }

    void initAttrsForPrimaryContext(Attributes attributes2, Attribute attribute, Attribute attribute2, String string) throws NamingException {
        attribute.add("ibm-wsnPrimaryContextLocation");
        String string2 = "javax.naming.Context";
        attribute2.add(string2);
        BasicAttribute basicAttribute = new BasicAttribute("ibm-wsnNameTreeContainerDN");
        attributes2.put(basicAttribute);
        basicAttribute.add(this._pti._nameTreeContainerDN);
        BasicAttribute basicAttribute2 = new BasicAttribute("ibm-wsnPathFromContainer");
        attributes2.put(basicAttribute2);
        String string3 = string + "," + this.getPathFromContainer();
        basicAttribute2.add(string3);
    }

    void initAttrsForLinkedContext(Attributes attributes2, Attribute attribute, Attribute attribute2, WsnLdapContextImpl wsnLdapContextImpl) throws NamingException {
        attribute.add("aliasObject");
        String string = "javax.naming.Context";
        attribute2.add(string);
        BasicAttribute basicAttribute = new BasicAttribute("aliasedObjectName");
        attributes2.put(basicAttribute);
        String string2 = wsnLdapContextImpl.getPathFromContainer() + "," + wsnLdapContextImpl._pti._nameTreeContainerDN;
        basicAttribute.add(string2);
    }

    void initAttrsForSerializableLeaf(Attributes attributes2, Attribute attribute, Attribute attribute2, java.lang.Object object) throws NamingException {
        attribute.add("javaSerializedObject");
        BasicAttribute basicAttribute = new BasicAttribute("javaSerializedData");
        StringBuffer stringBuffer = new StringBuffer(64);
        byte[] byArray = null;
        try {
            byArray = (byte[])Helpers.processJavaObjectForBinding(object, true, stringBuffer);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.naming.ldap.WsnLdapContextImpl.initAttrsForSerializableLeaf", "1223", this);
            NamingException namingException = new NamingException("initAttrsForSerializedLeaf received IO Exception from processJavaObjectForBinding");
            namingException.setRootCause(iOException);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initAttrsForSerializableLeaf: I/O error occurred in processJavaObjectForBinding");
            }
            throw namingException;
        }
        basicAttribute.add(byArray);
        attributes2.put(basicAttribute);
        attribute2.add(stringBuffer.toString());
    }

    java.lang.Object getObjectFromEntry(String string, Attributes attributes2, Name name2) throws NamingException {
        if (string.equals("IORLeaf")) {
            String string2 = WsnLdapHelpers.getStringFromAttribute(attributes2, "corbaIor", 1);
            Object object = this._pti._orb.string_to_object(string2);
            return object;
        }
        if (string.equals("SerializableLeaf")) {
            Attribute attribute = attributes2.get("javaSerializedData");
            byte[] byArray = (byte[])attribute.get();
            String string3 = WsnLdapHelpers.getStringFromAttribute(attributes2, "javaClassName", 2);
            BooleanWrapper booleanWrapper = new BooleanWrapper(false);
            java.lang.Object object = Helpers.processSerializedObjectForLookup(byArray, this, name2.toString(), string3, this._env, new JavaObjectHolder(), booleanWrapper);
            return object;
        }
        if (string.equals("PrimaryContext")) {
            String string4 = this.convert_to_ldapName(name2);
            Context context = this.getNewWsnLdapContextImpl(this._ldapCtx, string4);
            return context;
        }
        if (string.equals("LinkedContext")) {
            String string5 = WsnLdapHelpers.getStringFromAttribute(attributes2, "aliasedObjectName", 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getObjectFromEntry: ldapDN=" + string5);
            }
            String string6 = this.fixAliasObjectDN(string5);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getObjectFromEntry: fixedLdapDN=" + string6);
            }
            Context context = this.getNewWsnLdapContextImpl(this._pti._initialLdapCtx, string6);
            return context;
        }
        if (string.equals("InvisibleContext")) {
            String string7 = this.convert_to_ldapName(name2);
            Context context = this.getNewWsnLdapContextImpl(this._ldapCtx, string7);
            return context;
        }
        throw new NamingException("getObjectFromEntry - unknown Entry Type: " + string + "for Name: " + name2);
    }

    private Context getNewWsnLdapContextImpl(DirContext dirContext, String string) throws NamingException {
        SearchResult searchResult;
        java.lang.Object object;
        NamingEnumeration<SearchResult> namingEnumeration;
        WsnLdapContextImpl wsnLdapContextImpl = null;
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        searchControls.setReturningObjFlag(true);
        if (tc.isEventEnabled()) {
            Tr.event(tc, "ne = parentDirCtxsearch(newDirCtxRdn, \"objectClass=*\", sc);", new java.lang.Object[]{"parentDirCtx: " + dirContext.getNameInNamespace(), "newDirCtxRdn: " + string, "sc=" + searchControls.toString()});
        }
        if ((namingEnumeration = dirContext.search(string, "objectClass=*", searchControls)).hasMore() && (object = (searchResult = namingEnumeration.next()).getObject()) != null && object instanceof DirContext) {
            wsnLdapContextImpl = new WsnLdapContextImpl(this._env, (DirContext)object, this._pti, this._parser);
        }
        if (wsnLdapContextImpl == null) {
            throw new NamingException("Object at " + string + " from " + dirContext.getNameInNamespace() + " is not a DirContext");
        }
        return wsnLdapContextImpl;
    }

    private String getPathFromContainer() throws NamingException {
        if (this._pathFromContainer == null) {
            Name name2;
            String string;
            NameParser nameParser = this._ldapCtx.getNameParser("");
            Name name3 = nameParser.parse(string = this._ldapCtx.getNameInNamespace());
            if (!name3.startsWith(name2 = nameParser.parse(this._pti._nameTreeContainerDN))) {
                throw new NamingException("getPathFromContainer - containerDN not prefix of myDN, myDN= " + string + "  containerDN= " + this._pti._nameTreeContainerDN);
            }
            Name name4 = name3.getSuffix(name2.size());
            this._pathFromContainer = name4.toString();
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "getPathFromContainer, returning: ", "_pathFromContainer = " + this._pathFromContainer);
        }
        return this._pathFromContainer;
    }

    public FederatedContext getCannotProceedException(NamingException namingException, Name name2) throws NamingException {
        java.lang.Object object;
        Name name3 = namingException.getRemainingName();
        Name name4 = namingException.getResolvedName();
        java.lang.Object object2 = namingException.getResolvedObj();
        if (name2.size() <= 1) {
            throw namingException;
        }
        Context context = this;
        int n = 0;
        for (n = 0; n < name2.size() - 1; ++n) {
            object = name2.get(n);
            Name name5 = this._parser.parse("");
            name5.add((String)object);
            java.lang.Object object3 = null;
            try {
                if (context instanceof WsnLdapContextImpl) {
                    WsnLdapContextImpl wsnLdapContextImpl = context;
                    object3 = wsnLdapContextImpl.lookupWithoutEmptyOrUrlChecks(name5);
                } else {
                    object3 = context.lookup(name5);
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                FFDCFilter.processException((Throwable)nameNotFoundException, "com.ibm.ws.naming.ldap.WsnLdapContextImpl.getCannotProceedException", "1467", this);
                NameNotFoundException nameNotFoundException2 = new NameNotFoundException("An intermediate node in the name \"" + name2.toString() + "\" does not exist");
                nameNotFoundException2.setRootCause(nameNotFoundException);
                throw nameNotFoundException2;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.ldap.WsnLdapContextImpl.getCannotProceedException", "1474", this);
                NamingException namingException2 = new NamingException("Accessing an intermediate node in the name \"" + name2.toString() + "\" caused an exception");
                namingException2.setRootCause(exception);
                throw namingException2;
            }
            if (!(object3 instanceof Context)) {
                throw new NotContextException("An intermediate node in the name \"" + name2.toString() + "\" is not a Context, it is a " + object3.getClass().getName());
            }
            context = (Context)object3;
        }
        object = new FederatedContext();
        ((FederatedContext)object).setContext(context);
        ((FederatedContext)object).setRemainingName(name2.getSuffix(n));
        return object;
    }

    public boolean supportsBatchMode() {
        return false;
    }

    public WsnBatchModeContext getBatchModeContext() throws NamingException {
        throw new BatchModeNotSupported("Server does not support batch operations.");
    }

    public boolean isLocal() {
        return false;
    }

    private String stripLeadingSlashFromName(String string) {
        if (string.substring(0, 1).equals("/")) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/ldap/WsnLdapContextImpl.java, WAS.naming.client, WAS61.SERV1, cf311012.09, ver. 1.37");
        }
        METHOD_rebind = "rebind(Name,Object)";
    }

    private class FederatedContext {
        public Context ctx;
        public Name remainingName;

        private FederatedContext() {
        }

        public void setContext(Context context) {
            this.ctx = context;
        }

        public void setRemainingName(Name name2) {
            this.remainingName = name2;
        }

        public Context getContext() {
            return this.ctx;
        }

        public Name getRemainingName() {
            return this.remainingName;
        }
    }
}

