/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.mbean;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.naming.DumpNameSpace;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.odc.util.ApplicationServerServiceFinder;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ContainerComponentMetaData;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.ws.runtime.service.MetaDataService;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class NameServerMBeanImpl
extends J2EEManagedObjectCollaborator {
    private static final TraceComponent _tc = Tr.register(NameServerMBeanImpl.class, "Naming", "com.ibm.websphere.naming.DumpNameSpaceMessages");
    private static ResourceBundle _msgs;
    private static final String PARAM_PREFIX = "-";
    private static final String LOCAL_NAMESPACE_ROOT = "local:";
    private static final String DIST_NAMESPACE_ROOT = "";
    private static final String CORBALOC_URL = "corbaloc:rir:/";
    private int _reportForm = 1;
    private String _startAt = null;
    private String _format = "jndi";
    private String _urlKey = "NameServiceCellRoot";
    private String _logFile;
    private static final String METHOD_dumpJavaNameSpace = "dumpJavaNameSpace()";
    private static final String METHOD_dumpLocalNameSpace = "dumpLocalNameSpace()";
    private static final String METHOD_dumpServerNameSpace = "dumpServerNameSpace()";
    private static final String METHOD_dumpNameSpace = "dumpNameSpace()";

    private NameServerMBeanImpl() {
    }

    public NameServerMBeanImpl(String string) {
        this._logFile = string + "/DumpNameSpace.log";
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "*** NameServerMBeanImpl() log file: " + this._logFile);
        }
    }

    public synchronized String[] dumpJavaNameSpace(String string, String string2, String string3, String string4) {
        String[] stringArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_dumpJavaNameSpace);
        }
        MetaDataService metaDataService = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            stringArray = new InitialContext();
            metaDataService = (MetaDataService)stringArray.lookup("services:websphere/MetaData");
        }
        catch (NamingException namingException) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "dumpJavaNameSpace(): Got naming exception during MetaDataService lookup: " + namingException);
            }
            arrayList.add(NameServerMBeanImpl.fmtMsg("unexpectedError", new String[]{Helpers.getStackTrace(namingException)}));
        }
        if (metaDataService != null) {
            Object object;
            Object object2;
            ComponentMetaData componentMetaData;
            stringArray = (MetaDataFactoryMgr)((Object)metaDataService);
            J2EEName j2EEName = stringArray.getJ2EENameFactory().create(string, string2, string3);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "*** dumpJavaNameSpace() " + ((Object)j2EEName).toString() + " options=" + string4);
            }
            if ((componentMetaData = metaDataService.getComponentMetaData(j2EEName)) == null) {
                object2 = (EJBContainer)this.getAppSvrService(EJBContainer.class);
                if (object2 != null) {
                    object2.getClassLoader(j2EEName);
                    componentMetaData = metaDataService.getComponentMetaData(j2EEName);
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "dumpJavaNameSpace(): Failed to get the EJBContainer service while activating the bean " + ((Object)j2EEName).toString());
                    }
                    object = new Exception("Could not obtain EJB Container service.");
                    arrayList.add(NameServerMBeanImpl.fmtMsg("unexpectedError", new String[]{Helpers.getStackTrace((Throwable)object)}));
                }
            }
            if (componentMetaData != null) {
                if (componentMetaData instanceof ContainerComponentMetaData) {
                    object2 = (ContainerComponentMetaData)componentMetaData;
                    if (this.parseOptions(METHOD_dumpJavaNameSpace, string4, arrayList)) {
                        object = null;
                        if (this._startAt != null && this._startAt.length() != 0) {
                            try {
                                object = (Context)object2.getJavaNameSpaceContext().lookup(this._startAt);
                            }
                            catch (Exception exception) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "dumpJavaNameSpace(): Received exception on startAt context lookup: " + exception);
                                }
                                arrayList.add(NameServerMBeanImpl.fmtMsg("startAtError", new String[]{this._startAt, Helpers.getStackTrace(exception)}));
                            }
                        } else {
                            object = object2.getJavaNameSpaceContext();
                        }
                        if (object != null && this.writeResult(METHOD_dumpJavaNameSpace, (Context)object, arrayList)) {
                            this.readResult(METHOD_dumpJavaNameSpace, arrayList);
                        }
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "dumpJavaNameSpace(): ComponentMetaData not expected type: " + componentMetaData.getClass().getName());
                    }
                    object2 = new Exception("ComponentMetaData not expected type: " + componentMetaData.getClass().getName());
                    arrayList.add(NameServerMBeanImpl.fmtMsg("unexpectedError", new String[]{Helpers.getStackTrace((Throwable)object2)}));
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "dumpJavaNameSpace(): Component not found.");
                }
                arrayList.add(NameServerMBeanImpl.fmtMsg("compNotFound", new String[]{((Object)j2EEName).toString()}));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_dumpJavaNameSpace);
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        return new String[0];
    }

    public synchronized String[] dumpLocalNameSpace(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_dumpLocalNameSpace);
        }
        return this.dumpNameSpace(METHOD_dumpLocalNameSpace, LOCAL_NAMESPACE_ROOT, string);
    }

    public synchronized String[] dumpServerNameSpace(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_dumpServerNameSpace);
        }
        return this.dumpNameSpace(METHOD_dumpServerNameSpace, DIST_NAMESPACE_ROOT, string);
    }

    private String[] dumpNameSpace(String string, String string2, String string3) {
        String[] stringArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "dumpNameSpace(), root=" + string2);
        }
        Context context = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.parseOptions(string, string3, arrayList)) {
            Context context2;
            stringArray = CORBALOC_URL + this._urlKey;
            String string4 = "com.ibm.websphere.naming.WsnInitialContextFactory";
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "dumpNameSpace(), provider URL=" + (String)stringArray);
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("java.naming.provider.url", stringArray);
            hashtable.put("java.naming.factory.initial", string4);
            hashtable.put("com.ibm.websphere.naming.name.syntax", this._format);
            hashtable.put("com.ibm.websphere.naming.namespace.connection", "eager");
            try {
                context2 = new InitialContext(hashtable);
                context = (Context)context2.lookup(string2);
            }
            catch (Exception exception) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "dumpNameSpace() Received exception during \"" + string + "\" name space lookup: " + exception);
                }
                arrayList.add(NameServerMBeanImpl.fmtMsg("initCtxError", new String[]{Helpers.getStackTrace(exception)}));
            }
            if (context != null) {
                context2 = null;
                if (this._startAt != null && this._startAt.length() != 0) {
                    try {
                        context2 = (Context)context.lookup(this._startAt);
                    }
                    catch (Exception exception) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "dumpNameSpace(): Received exception on startAt context lookup: " + exception);
                        }
                        arrayList.add(NameServerMBeanImpl.fmtMsg("startAtError", new String[]{this._startAt, Helpers.getStackTrace(exception)}));
                    }
                } else {
                    context2 = context;
                }
                if (context2 != null && this.writeResult(METHOD_dumpNameSpace, context2, arrayList)) {
                    this.readResult(METHOD_dumpNameSpace, arrayList);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "dumpNameSpace()\n");
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        return new String[0];
    }

    private boolean parseOptions(String string, String string2, ArrayList arrayList) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseOptions: options=" + string2);
        }
        this._reportForm = 1;
        this._startAt = null;
        this._format = "jndi";
        this._urlKey = "NameServiceCellRoot";
        boolean bl = true;
        boolean bl2 = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (bl2 || stringTokenizer.hasMoreTokens()) {
            if (!bl2) {
                string3 = stringTokenizer.nextToken();
            } else {
                bl2 = false;
            }
            if (string3.equals("-report")) {
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                    if (string5.startsWith(PARAM_PREFIX)) {
                        bl2 = true;
                        string3 = string5;
                        continue;
                    }
                    if (string5.toLowerCase().equals("short")) {
                        this._reportForm = 1;
                        continue;
                    }
                    if (string5.toLowerCase().equals("long")) {
                        this._reportForm = 2;
                        continue;
                    }
                    arrayList.add(NameServerMBeanImpl.fmtMsg("reportOptBad"));
                    continue;
                }
                arrayList.add(NameServerMBeanImpl.fmtMsg("reportOptBad"));
                continue;
            }
            if (string3.equals("-startAt")) {
                if (!stringTokenizer.hasMoreTokens()) continue;
                string5 = stringTokenizer.nextToken();
                if (string5.startsWith(PARAM_PREFIX)) {
                    bl2 = true;
                    string3 = string5;
                    continue;
                }
                this._startAt = string5;
                continue;
            }
            if (string3.equals("-root")) {
                if (!string.equals(METHOD_dumpServerNameSpace)) {
                    arrayList.add(NameServerMBeanImpl.fmtMsg("optionBad") + " " + string3);
                    bl = false;
                    break;
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string5 = stringTokenizer.nextToken();
                if (string5.startsWith(PARAM_PREFIX)) {
                    bl2 = true;
                    string3 = string5;
                    continue;
                }
                string4 = string5.toLowerCase();
                if (string4.equals("tree")) {
                    this._urlKey = "NameServiceTreeRoot";
                    continue;
                }
                if (string4.equals("host")) {
                    this._urlKey = "NameServiceHostRoot";
                    continue;
                }
                if (string4.equals("legacy")) {
                    this._urlKey = "NameServiceLegacyRoot";
                    continue;
                }
                if (string4.equals("node")) {
                    this._urlKey = "NameServiceNodeRoot";
                    continue;
                }
                if (string4.equals("server")) {
                    this._urlKey = "NameServiceServerRoot";
                    continue;
                }
                if (string4.equals("cell")) {
                    this._urlKey = "NameServiceCellRoot";
                    continue;
                }
                if (string4.equals("default")) {
                    this._urlKey = "NameService";
                    continue;
                }
                arrayList.add(NameServerMBeanImpl.fmtMsg("treeOptBad"));
                bl = false;
                break;
            }
            if (string3.equals("-format")) {
                if (!string.equals(METHOD_dumpServerNameSpace)) {
                    arrayList.add(NameServerMBeanImpl.fmtMsg("optionBad") + " " + string3);
                    bl = false;
                    break;
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string5 = stringTokenizer.nextToken();
                if (string5.startsWith(PARAM_PREFIX)) {
                    bl2 = true;
                    string3 = string5;
                    continue;
                }
                if (string5.equals("jndi") || string5.equals("ins")) {
                    this._format = string5;
                    continue;
                }
                arrayList.add(NameServerMBeanImpl.fmtMsg("formatOptBad", new String[]{"jndi", "ins"}));
                bl = false;
                break;
            }
            arrayList.add(NameServerMBeanImpl.fmtMsg("optionBad") + " " + string3);
            bl = false;
            break;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseOptions: returned " + (bl ? "true" : "false") + ", report=" + this._reportForm + ", startAt=" + this._startAt + ", root=" + string4 + ", format=" + this._format);
        }
        return bl;
    }

    private boolean writeResult(String string, Context context, ArrayList arrayList) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "writeResult: caller=" + string);
        }
        FileOutputStream fileOutputStream = null;
        PrintStream printStream = null;
        boolean bl = true;
        try {
            fileOutputStream = new FileOutputStream(this._logFile);
            printStream = new PrintStream(fileOutputStream);
            DumpNameSpace dumpNameSpace = new DumpNameSpace(printStream, this._reportForm);
            dumpNameSpace.generateDump(context);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            arrayList.add("*** " + string + " - Cannot write to log file \"" + this._logFile + "\".");
            bl = false;
        }
        catch (SecurityException securityException) {
            arrayList.add("*** " + string + " - Access denies when writing to log file \"" + this._logFile + "\".");
            bl = false;
        }
        catch (IOException iOException) {
            arrayList.add("*** " + string + " - Got unexpected IOException: " + iOException);
            bl = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "writeResult: returned " + (bl ? "true" : "false"));
        }
        return bl;
    }

    private boolean readResult(String string, ArrayList arrayList) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "readResult: caller=" + string);
        }
        BufferedReader bufferedReader = null;
        FileInputStream fileInputStream = null;
        boolean bl = true;
        try {
            String string2;
            fileInputStream = new FileInputStream(this._logFile);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            fileInputStream.close();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            arrayList.add("*** " + string + " - Cannot read from log file \"" + this._logFile + "\".");
            bl = false;
        }
        catch (SecurityException securityException) {
            arrayList.add("*** " + string + " - Access denies when reading from log file \"" + this._logFile + "\".");
            bl = false;
        }
        catch (IOException iOException) {
            arrayList.add("*** " + string + " - Got unexpected IOException: " + iOException);
            bl = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "readResult: returned " + (bl ? "true" : "false"));
        }
        return bl;
    }

    private static String fmtMsg(String string) {
        String string2 = null;
        try {
            ResourceBundle resourceBundle = NameServerMBeanImpl.getMsgs();
            if (resourceBundle != null) {
                return MessageFormat.format(resourceBundle.getString(string), null);
            }
            string2 = "Message table not found.";
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "Message or message table not found.";
        }
        return string2;
    }

    private static String fmtMsg(String string, String[] stringArray) {
        String string2 = null;
        try {
            ResourceBundle resourceBundle = NameServerMBeanImpl.getMsgs();
            if (resourceBundle != null) {
                return MessageFormat.format(resourceBundle.getString(string), stringArray);
            }
            string2 = "Message table not found.";
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "Message or message table not found.";
        }
        return string2;
    }

    private static synchronized ResourceBundle getMsgs() {
        if (_msgs == null) {
            _msgs = ResourceBundle.getBundle("com.ibm.websphere.naming.DumpNameSpaceMessages");
        }
        return _msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAppSvrService(Class clazz) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getService, serviceKey = " + clazz);
        }
        Object object = null;
        try {
            object = ApplicationServerServiceFinder.getApplicationServerService(clazz);
        }
        finally {
            ApplicationServerServiceFinder.releaseApplicationServerService(clazz);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getService, service = " + object);
        }
        return object;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.server/src/com/ibm/ws/naming/mbean/NameServerMBeanImpl.java, WAS.naming.server, WAS61.SERV1, cf311012.09, ver. 1.14");
        }
        _msgs = null;
    }
}

