/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.urlbase;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.ipbase.ContextID;
import com.ibm.ws.naming.ipbase.NameNotAtomicException;
import com.ibm.ws.naming.ipbase.NameSpace;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.ipbase.NameSpaceEnumeration;
import com.ibm.ws.naming.ipbase.NameSpaceException;
import com.ibm.ws.naming.ipbase.NameSpaceInconsistentException;
import com.ibm.ws.naming.ipbase.StringContextID;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.urlbase.UrlBindingEnumeration;
import com.ibm.ws.naming.urlbase.UrlContext;
import com.ibm.ws.naming.urlbase.UrlContextHelper;
import com.ibm.ws.naming.urlbase.UrlNameEnumeration;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.WsnNameParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public abstract class UrlContextImpl
implements UrlContext,
Serializable {
    protected transient NameSpace _ns = null;
    protected transient StringContextID _strCtxID = null;
    protected transient UuidContext _parentCtx = null;
    protected transient WsnNameParser _parser = null;
    protected transient ORB _orb = null;
    protected Hashtable _env = null;
    protected String _schemeId = null;
    protected static final int STRINGBUFFER_SIZE = 64;
    private static final TraceComponent tc = Tr.register(UrlContextImpl.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_ctor = "UrlContextImpl() Ctor";
    private static final String METHOD_bind = "bind(Name, Object)";
    private static final String METHOD_bindS = "bind(String, Object)";
    private static final String METHOD_rebind = "rebind(Name, Object)";
    private static final String METHOD_rebindS = "rebind(String, Object)";
    private static final String METHOD_unbind = "unbind(Name, Object)";
    private static final String METHOD_unbindS = "unbind(String, Object)";
    private static final String METHOD_composeName = "ComposeName(Name, Name)";
    private static final String METHOD_composeNameS = "ComposeName(String, String)";
    private static final String METHOD_createSubcontext = "createSubcontext(Name)";
    private static final String METHOD_createSubcontextS = "createSubcontext(String)";
    private static final String METHOD_destroySubcontext = "destroySubcontext(Name)";
    private static final String METHOD_destroySubcontextS = "destroySubcontext(String)";
    private static final String METHOD_getNameParser = "getNameParser(Name)";
    private static final String METHOD_getNameParserS = "getNameParser(String)";
    private static final String METHOD_list = "list(Name)";
    private static final String METHOD_listS = "list(String)";
    private static final String METHOD_listBindings = "listBinding(Name)";
    private static final String METHOD_listBindingsS = "listBindings(String)";
    private static final String METHOD_lookup = "lookup(Name)";
    private static final String METHOD_lookupS = "lookup(String)";
    private static final String METHOD_rename = "rename(Name, Name)";
    private static final String METHOD_renameS = "rename(String, String)";
    private static final String METHOD_addToEnvironment = "addToEnvironment(String, Object)";
    private static final String METHOD_getEnvironment = "getEnvironment()";
    private static final String METHOD_removeFromEnvironment = "removeEnvironment()";
    private static final String METHOD_close = "close()";
    private static final String METHOD_getParentBindingData = "getParentBindingData(Name)";
    private static final String METHOD_writeObject = "writeObject(ObjectOutputStream)";
    private static final String METHOD_readObject = "readObject(ObjectInputStream)";
    private static final String METHOD_processBoundObjectForLookup = "processBoundObjectForLookup";

    public UrlContextImpl(NameSpace nameSpace, Hashtable hashtable, StringContextID stringContextID, UuidContext uuidContext) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, CLASS_ctor);
        }
        this._env = hashtable != null ? (Hashtable)hashtable.clone() : new Hashtable();
        this._ns = nameSpace;
        this._strCtxID = stringContextID;
        this._parentCtx = uuidContext;
        this._parser = WsnNameParser.getParser(hashtable);
        this._orb = Helpers.getOrb(this._env);
        Tr.exit(tc, CLASS_ctor);
    }

    public ContextID getContextID() {
        return this._strCtxID;
    }

    public UuidContext getParentCtx() {
        return this._parentCtx;
    }

    public void bind(Name name2, java.lang.Object object) throws NamingException {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, METHOD_bind, new String[]{"inName=" + name2 + ", obj=" + object});
            }
            try {
                Helpers.throwIfNullOrEmpty(name2, METHOD_bind, (Context)this);
                Name name3 = this.stripSchemeIdForUrlRootContext(name2);
                Context context = Helpers.getContextIfUrlName(name3, this._env);
                if (context != null) {
                    context.bind(name3, object);
                    break block15;
                }
                try {
                    NameSpaceBindingData nameSpaceBindingData = this.getParentBindingData(name3);
                    if (this.isThisContextUpdatable(nameSpaceBindingData)) {
                        java.lang.Object object2;
                        String string = null;
                        java.lang.Object object3 = null;
                        if ((object = Helpers.processRemoteObjectForBinding(object, this._orb)) instanceof Object) {
                            string = object.getClass().getName();
                            object3 = this.getStringifiedIOR((Object)object);
                        } else if (object instanceof Context) {
                            object3 = object;
                            string = "javax.naming.Context";
                        } else {
                            object2 = new StringBuffer(64);
                            object3 = Helpers.processJavaObjectForBinding(object, this.isThisContextRemote(), (StringBuffer)object2);
                            string = ((StringBuffer)object2).toString();
                        }
                        object2 = this.createAdditionalData(nameSpaceBindingData, string);
                        UrlContextImpl urlContextImpl = nameSpaceBindingData != null ? (UuidContext)nameSpaceBindingData.getBoundObject() : this;
                        this._ns.bind(urlContextImpl, name3.getSuffix(name3.size() - 1), object3, object2);
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.naming.urlbase.UrlContextImpl.bind", "236", this);
                    NamingException namingException = new NamingException("java.io.IOException occurred during the serialization and the object cannot be bound.name=" + name3);
                    namingException.setRootCause(iOException);
                    Tr.debug(tc, "Serialization failed and the object cannot be bound: " + iOException.getClass().getName());
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, METHOD_bind, " name=" + name3);
                    }
                    throw namingException;
                }
                catch (NameNotAtomicException nameNotAtomicException) {
                    FFDCFilter.processException((Throwable)nameNotAtomicException, "com.ibm.ws.naming.urlbase.UrlContextImpl.bind", "262", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_bind, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameNotAtomicException: " + nameNotAtomicException.toString());
                    namingException.setRootCause(nameNotAtomicException);
                    Tr.exit(tc, METHOD_bind);
                    throw namingException;
                }
                catch (NameSpaceInconsistentException nameSpaceInconsistentException) {
                    FFDCFilter.processException((Throwable)nameSpaceInconsistentException, "com.ibm.ws.naming.urlbase.UrlContextImpl.bind", "273", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_bind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceInconsistentException: " + nameSpaceInconsistentException.toString());
                    namingException.setRootCause(nameSpaceInconsistentException);
                    Tr.exit(tc, METHOD_bind);
                    throw namingException;
                }
                catch (NameSpaceException nameSpaceException) {
                    FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.urlbase.UrlContextImpl.bind", "284", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_bind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceException: " + nameSpaceException.toString());
                    namingException.setRootCause(nameSpaceException);
                    Tr.exit(tc, METHOD_bind);
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.bind", "298", this);
                Tr.exit(tc, "bind(Name, Object): exception");
                throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_bind, name2, "Object to bind: " + object);
            }
        }
        Tr.exit(tc, METHOD_bind);
    }

    public void bind(String string, java.lang.Object object) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bind(String, Object) name=" + string);
        }
        try {
            Helpers.throwIfNullOrEmpty(string, METHOD_bindS, (Context)this);
            this.bind(this._parser.parse(string), object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.bind", "320", this);
            Tr.exit(tc, "bind(String, Object): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_bindS, string, "Object to bind: " + object);
        }
        Tr.exit(tc, METHOD_bindS);
    }

    public void rebind(Name name2, java.lang.Object object) throws NamingException {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, METHOD_rebind, new String[]{"inName=" + name2 + ", obj=" + object});
            }
            try {
                Helpers.throwIfNullOrEmpty(name2, METHOD_rebind, (Context)this);
                Name name3 = this.stripSchemeIdForUrlRootContext(name2);
                Context context = Helpers.getContextIfUrlName(name3, this._env);
                if (context != null) {
                    context.rebind(name3, object);
                    break block15;
                }
                try {
                    NameSpaceBindingData nameSpaceBindingData = this.getParentBindingData(name3);
                    if (this.isThisContextUpdatable(nameSpaceBindingData)) {
                        java.lang.Object object2;
                        String string = null;
                        java.lang.Object object3 = null;
                        if ((object = Helpers.processRemoteObjectForBinding(object, this._orb)) instanceof Object) {
                            string = object.getClass().getName();
                            object3 = this.getStringifiedIOR((Object)object);
                        } else if (object instanceof Context) {
                            object3 = object;
                            string = "javax.naming.Context";
                        } else {
                            object2 = new StringBuffer(64);
                            object3 = Helpers.processJavaObjectForBinding(object, this.isThisContextRemote(), (StringBuffer)object2);
                            string = ((StringBuffer)object2).toString();
                        }
                        object2 = this.createAdditionalData(nameSpaceBindingData, string);
                        UrlContextImpl urlContextImpl = nameSpaceBindingData != null ? (UuidContext)nameSpaceBindingData.getBoundObject() : this;
                        this._ns.rebind(urlContextImpl, name3.getSuffix(name3.size() - 1), object3, object2);
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.naming.urlbase.UrlContextImpl.rebind", "407", this);
                    NamingException namingException = new NamingException("java.io.IOException occurred during the serialization and the object cannot be bound.name=" + name3);
                    namingException.setRootCause(iOException);
                    Tr.debug(tc, "Serialization failed and the object cannot be bound: " + iOException.getClass().getName());
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, METHOD_rebind, " name=" + name3);
                    }
                    throw namingException;
                }
                catch (NameNotAtomicException nameNotAtomicException) {
                    FFDCFilter.processException((Throwable)nameNotAtomicException, "com.ibm.ws.naming.urlbase.UrlContextImpl.rebind", "431", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_rebind, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameNotAtomicException: " + nameNotAtomicException.toString());
                    namingException.setRootCause(nameNotAtomicException);
                    Tr.exit(tc, METHOD_rebind);
                    throw namingException;
                }
                catch (NameSpaceInconsistentException nameSpaceInconsistentException) {
                    FFDCFilter.processException((Throwable)nameSpaceInconsistentException, "com.ibm.ws.naming.urlbase.UrlContextImpl.rebind", "442", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_rebind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceInconsistentException: " + nameSpaceInconsistentException.toString());
                    namingException.setRootCause(nameSpaceInconsistentException);
                    Tr.exit(tc, METHOD_rebind);
                    throw namingException;
                }
                catch (NameSpaceException nameSpaceException) {
                    FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.urlbase.UrlContextImpl.rebind", "453", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_rebind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceException: " + nameSpaceException.toString());
                    namingException.setRootCause(nameSpaceException);
                    Tr.exit(tc, METHOD_rebind);
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.rebind", "467", this);
                Tr.exit(tc, "rebind(Name, Object): exception");
                throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_rebind, name2, "Object to bind: " + object);
            }
        }
        Tr.exit(tc, METHOD_rebind);
    }

    public void rebind(String string, java.lang.Object object) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rebind(String, Object) name=" + string);
        }
        try {
            Helpers.throwIfNullOrEmpty(string, METHOD_rebindS, (Context)this);
            this.rebind(this._parser.parse(string), object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.rebind", "489", this);
            Tr.exit(tc, "rebind(String, Object): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_rebindS, string, "Object to bind: " + object);
        }
        Tr.exit(tc, METHOD_rebindS);
    }

    public void unbind(Name name2) throws NamingException {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "unbind(Name, Object) inName=" + name2);
            }
            try {
                Helpers.throwIfNullOrEmpty(name2, METHOD_unbind, (Context)this);
                Name name3 = this.stripSchemeIdForUrlRootContext(name2);
                Context context = Helpers.getContextIfUrlName(name3, this._env);
                if (context != null) {
                    context.unbind(name3);
                    break block9;
                }
                try {
                    NameSpaceBindingData nameSpaceBindingData = this.getParentBindingData(name3);
                    if (this.isThisContextUpdatable(nameSpaceBindingData)) {
                        UrlContextImpl urlContextImpl = nameSpaceBindingData != null ? (UuidContext)nameSpaceBindingData.getBoundObject() : this;
                        this._ns.unbind(urlContextImpl, name3.getSuffix(name3.size() - 1));
                    }
                }
                catch (NameNotAtomicException nameNotAtomicException) {
                    FFDCFilter.processException((Throwable)nameNotAtomicException, "com.ibm.ws.naming.urlbase.UrlContextImpl.unbind", "544", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_unbind, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameNotAtomicException: " + nameNotAtomicException.toString());
                    namingException.setRootCause(nameNotAtomicException);
                    Tr.exit(tc, METHOD_unbind);
                    throw namingException;
                }
                catch (NameSpaceInconsistentException nameSpaceInconsistentException) {
                    FFDCFilter.processException((Throwable)nameSpaceInconsistentException, "com.ibm.ws.naming.urlbase.UrlContextImpl.unbind", "555", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_unbind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceInconsistentException: " + nameSpaceInconsistentException.toString());
                    namingException.setRootCause(nameSpaceInconsistentException);
                    Tr.exit(tc, METHOD_unbind);
                    throw namingException;
                }
                catch (NameSpaceException nameSpaceException) {
                    FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.urlbase.UrlContextImpl.unbind", "566", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_unbind, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceException: " + nameSpaceException.toString());
                    namingException.setRootCause(nameSpaceException);
                    Tr.exit(tc, METHOD_unbind);
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.unbind", "580", this);
                Tr.exit(tc, "unbind(Name, Object): exception");
                throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_unbind, name2, null);
            }
        }
        Tr.exit(tc, METHOD_unbind);
    }

    public void unbind(String string) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unbind(String, Object) name=" + string);
        }
        try {
            Helpers.throwIfNullOrEmpty(string, METHOD_unbindS, (Context)this);
            this.unbind(this._parser.parse(string));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.unbind", "601", this);
            Tr.exit(tc, "unbind(String, Object): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_unbindS, string, null);
        }
        Tr.exit(tc, METHOD_unbindS);
    }

    public Name composeName(Name name2, Name name3) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ComposeName(Name, Name) name=" + name2 + " prefix=" + name3);
        }
        Name name4 = null;
        try {
            Helpers.throwIfNull(name2, METHOD_composeName, (Context)this);
            Helpers.throwIfNull(name3, METHOD_composeName, (Context)this);
            Context context = Helpers.getContextIfUrlName(name2, this._env);
            if (context != null) {
                name4 = context.composeName(name2, name3);
            } else {
                name4 = this._parser.parse("");
                Enumeration<String> enumeration = name3.getAll();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    name4.add(string);
                }
                enumeration = name2.getAll();
                while (enumeration.hasMoreElements()) {
                    name4.add(enumeration.nextElement());
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.composeName", "647", this);
            Tr.exit(tc, "ComposeName(Name, Name): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_composeName, name2, "prefix: " + name3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ComposeName(Name, Name) retName=" + name4);
        }
        return name4;
    }

    public String composeName(String string, String string2) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ComposeName(String, String) name=" + string + " prefix=" + string2);
        }
        String string3 = null;
        try {
            Helpers.throwIfNull(string, METHOD_composeNameS, (Context)this);
            Helpers.throwIfNull(string2, METHOD_composeNameS, (Context)this);
            Name name2 = this.composeName(this._parser.parse(string), this._parser.parse(string2));
            string3 = name2.toString();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.composeName", "679", this);
            Tr.exit(tc, "ComposeName(String, String): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_composeNameS, string, "prefix: " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ComposeName(String, String) retStr=" + string3);
        }
        return string3;
    }

    public Context createSubcontext(Name name2) throws NamingException {
        Context context;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createSubcontext(Name) inName=" + name2);
            }
            context = null;
            try {
                Helpers.throwIfNullOrEmpty(name2, METHOD_createSubcontext, (Context)this);
                Name name3 = this.stripSchemeIdForUrlRootContext(name2);
                Context context2 = Helpers.getContextIfUrlName(name3, this._env);
                if (context2 != null) {
                    context = context2.createSubcontext(name3);
                    break block9;
                }
                try {
                    NameSpaceBindingData nameSpaceBindingData = this.getParentBindingData(name3);
                    if (this.isThisContextUpdatable(nameSpaceBindingData)) {
                        String string = "javax.naming.Context";
                        java.lang.Object object = this.createAdditionalData(nameSpaceBindingData, string);
                        UrlContextImpl urlContextImpl = nameSpaceBindingData != null ? (UuidContext)nameSpaceBindingData.getBoundObject() : this;
                        UuidContext uuidContext = this.createNewSubcontext(name3, urlContextImpl);
                        this._ns.createSubcontext(urlContextImpl, name3.getSuffix(name3.size() - 1), uuidContext, object);
                        context = (Context)((java.lang.Object)uuidContext);
                    }
                }
                catch (NameNotAtomicException nameNotAtomicException) {
                    FFDCFilter.processException((Throwable)nameNotAtomicException, "com.ibm.ws.naming.urlbase.UrlContextImpl.createSubcontext", "756", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_createSubcontext, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameNotAtomicException: " + nameNotAtomicException.toString());
                    namingException.setRootCause(nameNotAtomicException);
                    Tr.exit(tc, METHOD_createSubcontext);
                    throw namingException;
                }
                catch (NameSpaceInconsistentException nameSpaceInconsistentException) {
                    FFDCFilter.processException((Throwable)nameSpaceInconsistentException, "com.ibm.ws.naming.urlbase.UrlContextImpl.createSubcontext", "767", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_createSubcontext, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceInconsistentException: " + nameSpaceInconsistentException.toString());
                    namingException.setRootCause(nameSpaceInconsistentException);
                    Tr.exit(tc, METHOD_createSubcontext);
                    throw namingException;
                }
                catch (NameSpaceException nameSpaceException) {
                    FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.urlbase.UrlContextImpl.createSubcontext", "778", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_createSubcontext, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceException: " + nameSpaceException.toString());
                    namingException.setRootCause(nameSpaceException);
                    Tr.exit(tc, METHOD_createSubcontext);
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "createSubcontext(Name): exception");
                throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_createSubcontext, name2, null);
            }
        }
        Tr.exit(tc, METHOD_createSubcontext);
        return context;
    }

    public Context createSubcontext(String string) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSubcontext(String) name=" + string);
        }
        Context context = null;
        try {
            Helpers.throwIfNullOrEmpty(string, METHOD_createSubcontextS, (Context)this);
            context = this.createSubcontext(this._parser.parse(string));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.createSubcontext", "814", this);
            Tr.exit(tc, "createSubcontext(String): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_createSubcontextS, string, null);
        }
        Tr.exit(tc, METHOD_createSubcontextS);
        return context;
    }

    public void destroySubcontext(Name name2) throws NamingException {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "destroySubcontext(Name) inName=" + name2);
            }
            try {
                Helpers.throwIfNullOrEmpty(name2, METHOD_destroySubcontext, (Context)this);
                Name name3 = this.stripSchemeIdForUrlRootContext(name2);
                Context context = Helpers.getContextIfUrlName(name3, this._env);
                if (context != null) {
                    context.destroySubcontext(name3);
                    break block9;
                }
                try {
                    NameSpaceBindingData nameSpaceBindingData = this.getParentBindingData(name3);
                    if (this.isThisContextUpdatable(nameSpaceBindingData)) {
                        UrlContextImpl urlContextImpl = nameSpaceBindingData != null ? (UuidContext)nameSpaceBindingData.getBoundObject() : this;
                        this._ns.destroySubcontext(urlContextImpl, name3.getSuffix(name3.size() - 1));
                    }
                }
                catch (NameNotAtomicException nameNotAtomicException) {
                    FFDCFilter.processException((Throwable)nameNotAtomicException, "com.ibm.ws.naming.urlbase.UrlContextImpl.destroySubcontext", "867", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_destroySubcontext, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameNotAtomicException: " + nameNotAtomicException.toString());
                    namingException.setRootCause(nameNotAtomicException);
                    Tr.exit(tc, METHOD_destroySubcontext);
                    throw namingException;
                }
                catch (NameSpaceInconsistentException nameSpaceInconsistentException) {
                    FFDCFilter.processException((Throwable)nameSpaceInconsistentException, "com.ibm.ws.naming.urlbase.UrlContextImpl.destroySubcontext", "878", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_destroySubcontext, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceInconsistentException: " + nameSpaceInconsistentException.toString());
                    namingException.setRootCause(nameSpaceInconsistentException);
                    Tr.exit(tc, METHOD_destroySubcontext);
                    throw namingException;
                }
                catch (NameSpaceException nameSpaceException) {
                    FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.urlbase.UrlContextImpl.destroySubcontext", "889", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_destroySubcontext, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceException: " + nameSpaceException.toString());
                    namingException.setRootCause(nameSpaceException);
                    Tr.exit(tc, METHOD_destroySubcontext);
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.destroySubcontext", "903", this);
                Tr.exit(tc, "destroySubcontext(Name): exception");
                throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_destroySubcontext, name2, null);
            }
        }
        Tr.exit(tc, METHOD_destroySubcontext);
    }

    public void destroySubcontext(String string) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroySubcontext(String) name=" + string);
        }
        Helpers.throwIfNullOrEmpty(string, METHOD_destroySubcontextS, (Context)this);
        try {
            this.destroySubcontext(this._parser.parse(string));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.destroySubcontext", "924", this);
            Tr.exit(tc, "destroySubcontext(String): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_destroySubcontextS, string, null);
        }
        Tr.exit(tc, METHOD_destroySubcontextS);
    }

    public NameParser getNameParser(Name name2) throws NamingException {
        NameParser nameParser;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNameParser(Name) inName=" + name2);
            }
            nameParser = null;
            try {
                if (Helpers.trueIfEmptyOrThrowIfNull(name2, METHOD_getNameParser, (Context)this)) {
                    nameParser = this._parser;
                    break block6;
                }
                Name name3 = this.stripSchemeIdForUrlRootContext(name2);
                Context context = Helpers.getContextIfUrlName(name2, this._env);
                if (context != null) {
                    nameParser = context.getNameParser(name3);
                    break block6;
                }
                java.lang.Object object = this.lookup(name3);
                if (object instanceof Context) {
                    nameParser = ((Context)object).getNameParser("");
                    break block6;
                }
                String string = "The bound object by " + name3.toString() + " is not a context";
                Tr.exit(tc, METHOD_getNameParser);
                throw new NotContextException(string);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.getNameParser", "975", this);
                Tr.exit(tc, "getNameParser(Name): exception");
                throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_getNameParser, name2, null);
            }
        }
        Tr.exit(tc, METHOD_getNameParser);
        return nameParser;
    }

    public NameParser getNameParser(String string) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNameParser(String) name=" + string);
        }
        NameParser nameParser = null;
        try {
            nameParser = Helpers.trueIfEmptyOrThrowIfNull(string, METHOD_getNameParserS, (Context)this) ? this._parser : this.getNameParser(this._parser.parse(string));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.getNameParser", "1000", this);
            Tr.exit(tc, "getNameParser(String): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_getNameParserS, string, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNameParser(String) retParser=" + nameParser);
        }
        return nameParser;
    }

    public NamingEnumeration list(Name name2) throws NamingException {
        UrlNameEnumeration urlNameEnumeration;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "list(Name) inName=" + name2);
            }
            urlNameEnumeration = null;
            try {
                Helpers.throwIfNull(name2, METHOD_list, (Context)this);
                Name name3 = this.stripSchemeIdForUrlRootContext(name2);
                Context context = Helpers.getContextIfUrlName(name2, this._env);
                if (context != null) {
                    urlNameEnumeration = context.list(name3);
                    break block6;
                }
                try {
                    urlNameEnumeration = new UrlNameEnumeration(this, this._parser, (NameSpaceEnumeration)this._ns.list(this, name3));
                }
                catch (NameSpaceException nameSpaceException) {
                    FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.urlbase.UrlContextImpl.list", "1041", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_list, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceException: " + nameSpaceException.toString());
                    namingException.setRootCause(nameSpaceException);
                    Tr.exit(tc, METHOD_list);
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.list", "1055", this);
                Tr.exit(tc, "list(Name): exception");
                throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_list, name2, null);
            }
        }
        Tr.exit(tc, METHOD_list);
        return urlNameEnumeration;
    }

    public NamingEnumeration list(String string) throws NamingException {
        NamingEnumeration namingEnumeration;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "list(String) name=" + string);
        }
        try {
            Helpers.throwIfNull(string, METHOD_listS, (Context)this);
            namingEnumeration = this.list(this._parser.parse(string));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.list", "1078", this);
            Tr.exit(tc, "list(String): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_listS, string, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "list(String) name=" + string);
        }
        return namingEnumeration;
    }

    public NamingEnumeration listBindings(Name name2) throws NamingException {
        UrlBindingEnumeration urlBindingEnumeration;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listBinding(Name) inName=" + name2);
            }
            urlBindingEnumeration = null;
            try {
                Helpers.throwIfNull(name2, METHOD_listBindings, (Context)this);
                Name name3 = this.stripSchemeIdForUrlRootContext(name2);
                Context context = Helpers.getContextIfUrlName(name2, this._env);
                if (context != null) {
                    urlBindingEnumeration = context.listBindings(name3);
                    break block6;
                }
                try {
                    urlBindingEnumeration = new UrlBindingEnumeration(this, this._parser, (NameSpaceEnumeration)this._ns.list(this, name3));
                }
                catch (NameSpaceException nameSpaceException) {
                    FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.urlbase.UrlContextImpl.listBindings", "1120", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_listBindings, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name3});
                    NamingException namingException = new NamingException("Received unexpected NameSpaceException: " + nameSpaceException.toString());
                    namingException.setRootCause(nameSpaceException);
                    Tr.exit(tc, METHOD_listBindings);
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.listBindings", "1134", this);
                Tr.exit(tc, "listBinding(Name): exception");
                throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_listBindings, name2, null);
            }
        }
        Tr.exit(tc, METHOD_listBindings);
        return urlBindingEnumeration;
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        NamingEnumeration namingEnumeration;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listBindings(String) name=" + string);
        }
        try {
            Helpers.throwIfNull(string, METHOD_listBindingsS, (Context)this);
            namingEnumeration = this.listBindings(this._parser.parse(string));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.listBindings", "1157", this);
            Tr.exit(tc, "listBindings(String): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_listBindingsS, string, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listBindings(String) name=" + string);
        }
        return namingEnumeration;
    }

    public java.lang.Object lookup(Name name2) throws NamingException {
        java.lang.Object object;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "lookup(Name) inName=" + name2);
            }
            object = null;
            try {
                if (Helpers.trueIfEmptyOrThrowIfNull(name2, METHOD_lookup, (Context)this)) {
                    object = this.cloneContext();
                    break block8;
                }
                Name name3 = this.stripSchemeIdForUrlRootContext(name2);
                Context context = Helpers.getContextIfUrlName(name2, this._env);
                if (context != null) {
                    object = context.lookup(name3);
                    break block8;
                }
                NameSpaceBindingData nameSpaceBindingData = null;
                try {
                    nameSpaceBindingData = this._ns.lookup(this, name3);
                }
                catch (NameSpaceException nameSpaceException) {
                    FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.urlbase.UrlContextImpl.lookup", "1205", this);
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, METHOD_lookup, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "name=" + name3});
                    Tr.exit(tc, METHOD_lookup);
                    NamingException namingException = new NamingException("Received unexpected NameSpaceException: " + nameSpaceException.toString());
                    namingException.setRootCause(nameSpaceException);
                    throw namingException;
                }
                java.lang.Object object2 = nameSpaceBindingData.getBoundObject();
                object = this.processBoundObjectForLookup(nameSpaceBindingData, object2, name2, this._env);
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "lookup(Name): exception");
                throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_lookup, name2, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookup(Name) retObj = " + object);
        }
        return object;
    }

    public java.lang.Object lookup(String string) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookup(String) name=" + string);
        }
        java.lang.Object object = null;
        try {
            object = Helpers.trueIfEmptyOrThrowIfNull(string, METHOD_lookupS, (Context)this) ? this.cloneContext() : this.lookup(this._parser.parse(string));
        }
        catch (Throwable throwable) {
            Tr.exit(tc, "lookup(String): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_lookupS, string, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookup(String) retObj =" + object);
        }
        return object;
    }

    public java.lang.Object lookupLink(Name name2) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw Helpers.logJndiContextException((Throwable)operationNotSupportedException, (Context)this, "lookupLink(Name)", name2, null);
    }

    public java.lang.Object lookupLink(String string) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw Helpers.logJndiContextException((Throwable)operationNotSupportedException, (Context)this, "lookupLink(String)", string, null);
    }

    public void rename(Name name2, Name name3) throws NamingException {
        Name name4;
        Name name5;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "rename(Name, Name) inOldName=" + name2 + "inNewName=" + name3);
            }
            try {
                Helpers.throwIfNullOrEmpty(name2, METHOD_rename, (Context)this);
                Helpers.throwIfNullOrEmpty(name3, METHOD_rename, (Context)this);
                if (name2.compareTo(name3) == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "rename(Name, Name): The old and new names are the same");
                    }
                    return;
                }
                Name[] nameArray = this.stripSchemeIdForUrlRootContextForRename(name2, name3);
                name5 = nameArray[0];
                name4 = nameArray[1];
                boolean bl = NameFormatHelper.isUrl(name5);
                boolean bl2 = NameFormatHelper.isUrl(name4);
                String string = NameFormatHelper.getUrlScheme(name5);
                String string2 = NameFormatHelper.getUrlScheme(name4);
                if (bl && bl2 && string.equals(string2)) {
                    Context context = Helpers.getContextIfUrlName(name5, this._env);
                    context.rename(name5, name4);
                    break block13;
                }
                if (!bl && !bl2) {
                    try {
                        NameSpaceBindingData nameSpaceBindingData = this.getParentBindingData(name5);
                        NameSpaceBindingData nameSpaceBindingData2 = this.getParentBindingData(name4);
                        if (this.isThisContextUpdatable(nameSpaceBindingData) && this.isThisContextUpdatable(nameSpaceBindingData2)) {
                            UrlContextImpl urlContextImpl = nameSpaceBindingData != null ? (UuidContext)nameSpaceBindingData.getBoundObject() : this;
                            UrlContextImpl urlContextImpl2 = nameSpaceBindingData2 != null ? (UuidContext)nameSpaceBindingData2.getBoundObject() : this;
                            NameSpaceBindingData nameSpaceBindingData3 = this._ns.lookup(urlContextImpl, name5.getSuffix(name5.size() - 1));
                            this._ns.bind(urlContextImpl2, name4.getSuffix(name4.size() - 1), nameSpaceBindingData3.getBoundObject(), nameSpaceBindingData3.getAdditionalData());
                            this._ns.unbind(urlContextImpl, name5.getSuffix(name5.size() - 1));
                        }
                        break block13;
                    }
                    catch (NameNotAtomicException nameNotAtomicException) {
                        FFDCFilter.processException((Throwable)nameNotAtomicException, "com.ibm.ws.naming.urlbase.UrlContextImpl.rename", "1366", this);
                        Tr.warning(tc, "unexpectedErr");
                        Tr.debug(tc, METHOD_rename, new java.lang.Object[]{"Internal error.  Failed with NameNotAtomicException", "name=" + name4});
                        NamingException namingException = new NamingException("Received unexpected NameNotAtomicException: " + nameNotAtomicException.toString());
                        namingException.setRootCause(nameNotAtomicException);
                        Tr.exit(tc, METHOD_rename);
                        throw namingException;
                    }
                    catch (NameSpaceInconsistentException nameSpaceInconsistentException) {
                        FFDCFilter.processException((Throwable)nameSpaceInconsistentException, "com.ibm.ws.naming.urlbase.UrlContextImpl.rename", "1377", this);
                        Tr.warning(tc, "unexpectedErr");
                        Tr.debug(tc, METHOD_rename, new java.lang.Object[]{"Internal error.  Failed with NameSpaceInconsistentException", "oldName=" + name5, "newName=" + name4});
                        NamingException namingException = new NamingException("Received unexpected NameSpaceInconsistentException: " + nameSpaceInconsistentException.toString());
                        namingException.setRootCause(nameSpaceInconsistentException);
                        Tr.exit(tc, METHOD_rename);
                        throw namingException;
                    }
                    catch (NameSpaceException nameSpaceException) {
                        FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.urlbase.UrlContextImpl.rename", "1388", this);
                        Tr.warning(tc, "unexpectedErr");
                        Tr.debug(tc, METHOD_rename, new java.lang.Object[]{"Internal error.  Failed with NameSpaceException", "oldName=" + name5, "newName=" + name4});
                        NamingException namingException = new NamingException("Received unexpected NameSpaceException: " + nameSpaceException.toString());
                        namingException.setRootCause(nameSpaceException);
                        Tr.exit(tc, METHOD_rename);
                        throw namingException;
                    }
                }
                throw new OperationNotSupportedException("Do not support rename cross different name spaces:" + name5 + " " + name4);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.rename", "1406", this);
                Tr.exit(tc, "rename(Name, Name): exception");
                throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_rename, name2, "New name: " + name3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rename(Name, Name) oldName=" + name5 + "newName=" + name4);
        }
    }

    public void rename(String string, String string2) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rename(String, String) oldName=" + string + "newName=" + string2);
        }
        try {
            Helpers.throwIfNullOrEmpty(string, METHOD_renameS, (Context)this);
            Helpers.throwIfNullOrEmpty(string2, METHOD_renameS, (Context)this);
            this.rename(this._parser.parse(string), this._parser.parse(string2));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.rename", "1433", this);
            Tr.exit(tc, "rename(String, String): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_renameS, string, "New name: " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rename(String, String) oldName=" + string + "newName=" + string2);
        }
    }

    public java.lang.Object addToEnvironment(String string, java.lang.Object object) throws NamingException {
        java.lang.Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToEnvironment(String, Object) propName =" + string);
        }
        try {
            if (string == null || object == null) {
                throw new NamingException();
            }
            object2 = this._env.put(string, object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.addToEnvironment", "1460", this);
            Tr.exit(tc, "addToEnvironment(String, Object): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_addToEnvironment, (String)null, "property name: \"" + string + "\", property value: \"" + object + "\"");
        }
        Tr.exit(tc, METHOD_addToEnvironment);
        return object2;
    }

    public Hashtable getEnvironment() throws NamingException {
        Hashtable hashtable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, METHOD_getEnvironment);
        }
        try {
            hashtable = new Hashtable();
            Enumeration enumeration = this._env.keys();
            while (enumeration.hasMoreElements()) {
                java.lang.Object k = enumeration.nextElement();
                hashtable.put(k, this._env.get(k));
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.getEnvironment", "1487", this);
            Tr.exit(tc, "getEnvironment(): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_getEnvironment, (String)null, null);
        }
        Tr.exit(tc, METHOD_getEnvironment);
        return hashtable;
    }

    public java.lang.Object removeFromEnvironment(String string) throws NamingException {
        java.lang.Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEnvironment() propName =" + string);
        }
        try {
            if (string == null) {
                throw new NamingException();
            }
            v = this._env.remove(string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.urlbase.UrlContextImpl.removeFromEnvironment", "1512", this);
            Tr.exit(tc, "removeEnvironment(): exception");
            throw Helpers.logJndiContextException(throwable, (Context)this, METHOD_removeFromEnvironment, (String)null, "property name: \"" + string + "\"");
        }
        Tr.exit(tc, METHOD_removeFromEnvironment);
        return v;
    }

    public void close() throws NamingException {
        Tr.entry(tc, METHOD_close);
        this._env = null;
        this._ns = null;
        this._strCtxID = null;
        Tr.exit(tc, METHOD_close);
    }

    public String getNameInNamespace() throws NamingException {
        String string = this.doGetNameInNamespace();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getNameInNamespace()-->>" + string);
        }
        return string;
    }

    public String toString() {
        String string = this.doGetNameInNamespace();
        return this.getClass().getName() + "(" + string + ")";
    }

    private NameSpaceBindingData getParentBindingData(Name name2) throws NameSpaceException, NamingException {
        Tr.entry(tc, "getParentBindingData(Name) name=" + name2);
        NameSpaceBindingData nameSpaceBindingData = null;
        if (name2.size() > 1) {
            nameSpaceBindingData = this._ns.getParentContext(this, name2);
        } else if (this._parentCtx != null) {
            Name name3 = this.getContextName();
            name3 = name3.getSuffix(name3.size() - 1);
            nameSpaceBindingData = this._ns.lookup(this._parentCtx, name3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentBindingData(Name) name=" + name2);
        }
        return nameSpaceBindingData;
    }

    protected String getStringifiedIOR(Object object) throws NamingException {
        String string = this._orb.object_to_string(object);
        return string;
    }

    public void listNameSpace() {
        this._ns.dumpNameSpace(null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Tr.entry(tc, METHOD_writeObject);
        java.lang.Object v = this._env.get("java.naming.corba.orb");
        if (v instanceof ORB && !(v instanceof Serializable)) {
            Tr.warning(tc, "generalWithInsert", "UrlContextImpl.writeObject determined the Context " + this.toString() + " contains in it's environment Hashtable the property " + "java.naming.corba.orb" + " which contains the object " + v.toString() + " which is not Serializable. Serialization will probably fail. " + "This property value should be removed prior to serialization of this Context.");
        }
        objectOutputStream.defaultWriteObject();
        Tr.exit(tc, METHOD_writeObject);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, NamingException {
        Tr.entry(tc, METHOD_readObject);
        objectInputStream.defaultReadObject();
        this._orb = Helpers.getOrb(this._env);
        Tr.exit(tc, METHOD_readObject);
    }

    protected java.lang.Object processBoundObjectForLookup(NameSpaceBindingData nameSpaceBindingData, java.lang.Object object, Name name2, Hashtable hashtable) throws NamingException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, METHOD_processBoundObjectForLookup);
        }
        return UrlContextHelper.processBoundObjectForLookup(nameSpaceBindingData, object, this, hashtable, new BooleanWrapper(false), new JavaObjectHolder(), new BooleanWrapper(false), new JavaObjectHolder());
    }

    protected abstract boolean isThisContextUpdatable(NameSpaceBindingData var1) throws NamingException;

    protected abstract boolean isThisContextRemote();

    protected abstract java.lang.Object createAdditionalData(NameSpaceBindingData var1, String var2);

    protected abstract UuidContext createNewSubcontext(Name var1, UuidContext var2) throws NamingException;

    protected abstract String doGetNameInNamespace();

    protected abstract Name getContextName() throws NamingException;

    protected abstract Name stripSchemeIdForUrlRootContext(Name var1) throws NamingException;

    protected abstract Name[] stripSchemeIdForUrlRootContextForRename(Name var1, Name var2) throws NamingException;

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/urlbase/UrlContextImpl.java, WAS.naming.client, WAS61.SERV1, cf311012.09, ver. 1.5");
        }
    }
}

