/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosNaming.NamingContext;

public class CommonHelpers {
    private static final TraceComponent _tc = Tr.register(CommonHelpers.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String JNDI_PROVIDER_PROPERTIES_FILE = "com/ibm/websphere/naming/jndiprovider.properties";
    private static final String[] WSN_JNDI_PROPS_CACHE;
    private static final String[] WSN_JNDI_PROPS_NO_CACHE;
    private static HashMap _cachedJndiProperties;
    private static Object _propLock;
    private static String[] _propKeys;
    private static String[] _propValues;
    private static int _propSize;
    private static boolean _providerPropertiesRead;
    private static Hashtable _insEnv;
    private static Hashtable _jndiEnv;

    protected CommonHelpers() {
    }

    public static void mergeWsnJndiProperties(Hashtable hashtable) {
        CommonHelpers.mergeWsnJndiPropertiesFromSysEnv(hashtable);
        CommonHelpers.mergeJndiProviderProperties(hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeWsnJndiPropertiesFromSysEnv(Hashtable hashtable) {
        String string;
        String string2;
        int n;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "mergeWsnJndiPropertiesFromSysEnv");
        }
        Properties properties = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            properties = (Properties)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return System.getProperties();
                }
            });
            Object object = _propLock;
            synchronized (object) {
                if (_cachedJndiProperties == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "mergeWsnJndiPropertiesFromSysEnv: Caching properties");
                    }
                    _cachedJndiProperties = new HashMap();
                    for (n = 0; n < WSN_JNDI_PROPS_CACHE.length; ++n) {
                        string2 = WSN_JNDI_PROPS_CACHE[n];
                        string = (String)((Hashtable)properties).get(string2);
                        if (string == null) continue;
                        _cachedJndiProperties.put(string2, string);
                    }
                }
            }
            for (int i = 0; i < WSN_JNDI_PROPS_CACHE.length; ++i) {
                String string3 = WSN_JNDI_PROPS_NO_CACHE[i];
                string2 = (String)((Hashtable)properties).get(string3);
                if (string2 == null) continue;
                hashMap.put(string3, string2);
            }
            if (_cachedJndiProperties.size() > 0) {
                hashMap.putAll(_cachedJndiProperties);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.util.CommonHelpers.mergeWsnJndiPropertiesFromSysEnv", "1230");
            Tr.debug(_tc, "mergeWsnJndiPropertiesFromSysEnv: Exception while getting properties", throwable);
        }
        if (hashMap.size() == 0) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "mergeWsnJndiPropertiesFromSysEnv: Empty propsToAdd Hashtable");
            }
            return;
        }
        Object[] objectArray = hashMap.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string2 = (String)objectArray[n];
            string = (String)hashMap.get(string2);
            if (hashtable.containsKey(string2)) continue;
            hashtable.put(string2, string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "mergeWsnJndiPropertiesFromSysEnv");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeJndiProviderProperties(Hashtable hashtable) {
        Object object = _propLock;
        synchronized (object) {
            if (!_providerPropertiesRead) {
                Object object2;
                _providerPropertiesRead = true;
                InputStream inputStream = (InputStream)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        return classLoader.getResourceAsStream(CommonHelpers.JNDI_PROVIDER_PROPERTIES_FILE);
                    }
                });
                Properties properties = new Properties();
                if (inputStream == null) {
                    Tr.debug(_tc, "The InputStream for jndiprovider.properties is null.");
                    Tr.warning(_tc, "jndiproviderProperties");
                } else {
                    try {
                        try {
                            object2 = inputStream;
                            properties = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((InputStream)object2){
                                private final /* synthetic */ InputStream val$tmpis;
                                {
                                    this.val$tmpis = inputStream;
                                }

                                public Object run() throws Exception {
                                    Properties properties = new Properties();
                                    properties.load(this.val$tmpis);
                                    return properties;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException(privilegedActionException, "com.ibm.ws.naming.util.CommonHelpers.mergeJndiProviderProperties", "1308");
                            Exception exception = privilegedActionException.getException();
                            if (exception instanceof IOException) {
                                throw (IOException)exception;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException(iOException, "com.ibm.ws.naming.util.CommonHelpers.mergeJndiProviderProperties", "1316");
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "IOException occured while reading the property list: ", iOException);
                        }
                        Tr.warning(_tc, "jndiproviderProperties");
                    }
                }
                if (_tc.isEventEnabled()) {
                    Tr.debug(_tc, "mergeJndiProviderProperties merged properties from com/ibm/websphere/naming/jndiprovider.properties", CommonHelpers.traceHashtable(JNDI_PROVIDER_PROPERTIES_FILE, properties));
                }
                if ((_propSize = properties.size()) == 0) {
                    Tr.debug(_tc, "The file jndiprovider.properties contains no properties.");
                    Tr.warning(_tc, "jndiproviderProperties");
                }
                _propValues = new String[_propSize];
                _propKeys = new String[_propSize];
                object2 = properties.propertyNames();
                int n = 0;
                while (object2.hasMoreElements()) {
                    CommonHelpers._propKeys[n] = (String)object2.nextElement();
                    CommonHelpers._propValues[n] = properties.getProperty(_propKeys[n]);
                    ++n;
                }
            }
        }
        for (int i = 0; i < _propSize; ++i) {
            if (hashtable.containsKey(_propKeys[i])) continue;
            hashtable.put(_propKeys[i], _propValues[i]);
        }
    }

    public static Hashtable getWsnJndiProperties() throws NamingException {
        Tr.entry(_tc, "getWsnJndiProperties");
        Hashtable<?, ?> hashtable = null;
        try {
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put("java.naming.factory.initial", "com.ibm.ws.naming.util.EnvOnlyContextFactory");
            Context context = null;
            final Hashtable<String, String> hashtable3 = hashtable2;
            try {
                context = (Context)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new InitialContext(hashtable3);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException(privilegedActionException, "com.ibm.ws.naming.util.CommonHelpers.getWsnJndiProperties", "1155");
                Exception exception = privilegedActionException.getException();
                throw exception;
            }
            hashtable = context.getEnvironment();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.naming.util.CommonHelpers.getWsnJndiProperties", "1161");
            String string = "Failed to get environment. ";
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, string, exception);
            }
            Tr.warning(_tc, "generalWithInsert", "getWsnJndiProperties: " + string);
            NamingException namingException = null;
            if (exception instanceof NamingException) {
                namingException = (NamingException)exception;
            } else {
                namingException = new NamingException(string + "Please get the root cause Throwable contained in this NamingException " + "for more information.");
                namingException.setRootCause(exception);
            }
            Tr.exit(_tc, "getWsnJndiProperties");
            throw namingException;
        }
        Tr.exit(_tc, "getWsnJndiProperties");
        return hashtable;
    }

    public static Context getContextIfUrlName(Name name2, Hashtable hashtable) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContextIfUrlName(Name) name=" + name2);
        }
        Context context = null;
        if (!name2.isEmpty()) {
            context = CommonHelpers.getContextIfUrlName(name2.get(0), hashtable);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getContextIfUrlName(Name) name=" + name2);
        }
        return context;
    }

    public static Context getContextIfUrlName(String string, Hashtable hashtable) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContextIfUrlName(String) name=" + string);
        }
        Context context = null;
        if (NameFormatHelper.isUrl(string)) {
            String string2 = NameFormatHelper.getUrlScheme(string);
            try {
                context = NamingManager.getURLContext(string2, (Hashtable)hashtable.clone());
            }
            catch (NamingException namingException) {
                FFDCFilter.processException(namingException, "com.ibm.ws.naming.util.CommonHelpers.getContextIfUrlName", "385");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "NamingException occurred in NamingManager.getURLContext(): ", namingException);
                }
                Tr.warning(_tc, "urlGetUrlCtxErr", string2);
                throw namingException;
            }
            if (context == null) {
                Tr.warning(_tc, "urlNullUrlCtx", string2);
                String string3 = "NamingManager.getURLContext returned a null Context for the scheme " + string2 + ".";
                throw new ConfigurationException(string3);
            }
        }
        if (_tc.isEntryEnabled()) {
            if (context == null) {
                Tr.exit(_tc, "getContextIfUrlName(String) name=" + string + " returnCtx=NULL");
            } else {
                Tr.exit(_tc, "getContextIfUrlName(String) name=" + string + " returnCtx class=" + context.getClass().getName());
            }
        }
        return context;
    }

    public static Object extractCtxImplFromInitCtx(Object object) throws NamingException {
        if (object instanceof InitialContext) {
            Tr.debug(_tc, "extractCtxImplFromInitCtx: Extracting Context Impl from InitialContext.");
            return ((InitialContext)object).lookup("");
        }
        return object;
    }

    public static boolean isDistributedNC(NamingContext namingContext) {
        if (!(namingContext instanceof com.ibm.WsnOptimizedNaming.NamingContext)) {
            return false;
        }
        while (true) {
            try {
                return ((com.ibm.WsnOptimizedNaming.NamingContext)namingContext).get_compatibility_level() >= 1;
            }
            catch (TRANSIENT tRANSIENT) {
                if (tRANSIENT.minor != 1229066306) {
                    throw tRANSIENT;
                }
                Tr.event(_tc, "Received WLM exception signaling a retry.  Retrying get_compatibility_level.", (Object)tRANSIENT);
                continue;
            }
            break;
        }
    }

    public static String[] traceHashtable(String string, Hashtable hashtable) {
        int n = hashtable.size() + 1;
        String[] stringArray = new String[n];
        stringArray[0] = "Hashtable '" + string + "' follows, # of entries=" + hashtable.size();
        Enumeration enumeration = hashtable.keys();
        for (int i = 1; i < n; ++i) {
            if (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Object v = hashtable.get(string2);
                stringArray[i] = "  " + string2 + " --> " + v.toString();
                continue;
            }
            stringArray[i] = "";
        }
        return stringArray;
    }

    public static void handleDoPrivilegedUnmatchedException(Exception exception, TraceComponent traceComponent) {
        TraceComponent traceComponent2 = traceComponent;
        if (traceComponent2 == null) {
            traceComponent2 = _tc;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        NamingException namingException = new NamingException("Exception occurring in doPrivileged block was not properly handled.");
        namingException.setRootCause(exception);
        Tr.warning(traceComponent2, "generalWithInsert", namingException);
    }

    public static Hashtable getJNDIEnvironment() {
        return _jndiEnv;
    }

    public static Hashtable getINSEnvironment() {
        return _insEnv;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/CommonHelpers.java, WAS.naming, WAS61.SERV1, cf311012.09, ver. 1.8");
        }
        WSN_JNDI_PROPS_CACHE = new String[]{"com.ibm.websphere.naming.generic.url.schemeid", "com.ibm.websphere.naming.generic.url.package", "com.ibm.ws.naming.implementation", "com.ibm.ws.naming.ldap.masterurl", "com.ibm.ws.naming.ldap.containerdn", "com.ibm.ws.naming.ldap.noderootrdn", "com.ibm.ws.naming.ldap.config"};
        WSN_JNDI_PROPS_NO_CACHE = new String[]{"java.naming.corba.orb", "com.ibm.CORBA.ORBInit", "com.ibm.websphere.naming.namespaceroot", "com.ibm.websphere.naming.namespace.connection", "com.ibm.websphere.naming.jndicache.cacheobject", "com.ibm.websphere.naming.jndicache.cachename", "com.ibm.websphere.naming.jndicache.maxcachelife", "com.ibm.websphere.naming.jndicache.maxentrylife", "com.ibm.websphere.naming.name.syntax", "com.ibm.websphere.naming.hostname.normalizer", "com.ibm.websphere.naming.ldapprotocoltrace", "com.ibm.websphere.naming.ldapprotocoltracefile"};
        _cachedJndiProperties = null;
        _propLock = new Object();
        _propKeys = null;
        _propValues = null;
        _propSize = 0;
        _providerPropertiesRead = false;
        _insEnv = new Hashtable();
        _jndiEnv = new Hashtable();
        try {
            _insEnv.put("com.ibm.websphere.naming.name.syntax", "ins");
            _jndiEnv.put("com.ibm.websphere.naming.name.syntax", "jndi");
        }
        catch (Throwable throwable) {
            Tr.debug(_tc, "Helpers: Error creating parser", throwable);
        }
    }
}

