/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.CannotInstantiateObjectException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.CacheableReference;
import com.ibm.ws.naming.util.CannotBindObjectException;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.DestroyedContext;
import com.ibm.ws.naming.util.IndirectJndiLookupObjectFactory;
import com.ibm.ws.naming.util.InvalidNameSyntaxException;
import com.ibm.ws.naming.util.InvalidObjectException;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.Serialization;
import com.ibm.ws.naming.util.UnresolvedIORBinding;
import com.ibm.ws.naming.util.UnresolvedURLBinding;
import com.ibm.ws.naming.util.UnresolvedURLException;
import com.ibm.ws.naming.util.WsnName;
import com.ibm.ws.security.util.AccessController;
import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CosNaming.NameComponent;

public class Helpers
extends CommonHelpers {
    private static final TraceComponent tc = Tr.register(Helpers.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String[] WSN_JNDI_PROPS;
    private static final String JNDI_PROVIDER_PROPERTIES_FILE = "com/ibm/websphere/naming/jndiprovider.properties";
    private static final char CONTEXT_ID_DELIMITER = ';';
    private static final String ORB_TO_USE_FACTORY_METHOD = "getORB";
    private static final String INDIRECT_LOOKUP_OBJECT_FACTORY_CLASS_NAME;
    private static Hashtable _wsnNameProps;
    private static ResourceBundle _wsnResourceBundle;
    private static Object _propLock;
    private static String[] _propKeys;
    private static String[] _propValues;
    private static int _propSize;
    private static boolean _providerPropertiesRead;

    private Helpers() {
    }

    public static ORB getOrb(Hashtable hashtable) throws NamingException {
        Tr.entry(tc, "getOrb()");
        ORB oRB = null;
        try {
            Serializable serializable;
            Object object;
            block10: {
                if (hashtable != null) {
                    try {
                        oRB = (ORB)hashtable.get("java.naming.corba.orb");
                        if (oRB != null) {
                            Tr.exit(tc, "getOrb() - Using ORB from java.naming.corba.orb");
                            return oRB;
                        }
                        object = (String)hashtable.get("com.ibm.CORBA.ORBInit");
                        if (object == null || ((String)object).length() <= 0) break block10;
                        Object object2 = object;
                        try {
                            serializable = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((String)object2){
                                private final /* synthetic */ String val$tmpName;
                                {
                                    this.val$tmpName = string;
                                }

                                public Object run() throws Exception {
                                    return Thread.currentThread().getContextClassLoader().loadClass(this.val$tmpName);
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw privilegedActionException.getException();
                        }
                        Method method2 = ((Class)serializable).getMethod(ORB_TO_USE_FACTORY_METHOD, null);
                        oRB = (ORB)method2.invoke(null, null);
                        if (oRB != null) {
                            Tr.exit(tc, "getOrb() - Using ORB from com.ibm.CORBA.ORBInit");
                            return oRB;
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ws.naming.util.Helpers.getOrb", "275");
                        Tr.event(tc, "Failed to successfully obtain ORB from from property java.naming.corba.orb or com.ibm.CORBA.ORBInit ignoring Exception: " + exception);
                    }
                }
            }
            object = null;
            serializable = null;
            if (hashtable != null) {
                object = (Applet)hashtable.get("java.naming.applet");
                serializable = Helpers.hashtableToProperties(hashtable);
            }
            oRB = object != null ? EJSORB.init((Applet)object, null, -1, serializable) : EJSORB.init(null, -1, serializable);
            Tr.exit(tc, "getOrb() - Using ORB from EJSORB.init()");
            return oRB;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.naming.util.Helpers.getOrb", "301");
            Tr.event(tc, "Failed to initialize the ORB, Exception: " + exception);
            NamingException namingException = new NamingException("Failed to initialize the ORB");
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    public static Properties hashtableToProperties(Hashtable hashtable) {
        Properties properties = new Properties();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                properties.put(k, hashtable.get(k));
            }
        }
        return properties;
    }

    public static void throwIfNull(String string, String string2, Context context) throws NamingException {
        if (string == null) {
            String string3 = context.getNameInNamespace();
            Tr.warning(tc, "jndiNullName", new Object[]{string3, string2});
            String string4 = "The Context at name path " + string3 + " was passed a null name to the method " + string2 + ".";
            throw new InvalidNameException(string4);
        }
    }

    public static void throwIfNull(Name name2, String string, Context context) throws NamingException {
        if (name2 == null) {
            Helpers.throwIfNull((String)null, string, context);
        }
    }

    public static void throwIfNullOrEmpty(String string, String string2, Context context) throws NamingException {
        if (string == null) {
            Helpers.throwIfNull((String)null, string2, context);
        }
        if (string.equals("")) {
            String string3 = context.getNameInNamespace();
            Tr.warning(tc, "jndiEmptyName", new Object[]{string3, string2});
            String string4 = "The Context at name path " + string3 + " was passed an empty name to the method " + string2 + ".";
            throw new InvalidNameException(string4);
        }
    }

    public static void throwIfNullOrEmpty(Name name2, String string, Context context) throws NamingException {
        if (name2 == null) {
            Helpers.throwIfNull((String)null, string, context);
        }
        if (name2.isEmpty()) {
            Helpers.throwIfNullOrEmpty("", string, context);
        }
    }

    public static boolean trueIfEmptyOrThrowIfNull(String string, String string2, Context context) throws NamingException {
        if (string == null) {
            Helpers.throwIfNull((String)null, string2, context);
        }
        return string.equals("");
    }

    public static boolean trueIfEmptyOrThrowIfNull(Name name2, String string, Context context) throws NamingException {
        if (name2 == null) {
            Helpers.throwIfNull((String)null, string, context);
        }
        return name2.isEmpty();
    }

    public static String toString(NameComponent[] nameComponentArray) {
        String string = null;
        if (_wsnNameProps == null) {
            _wsnNameProps = new Hashtable();
            _wsnNameProps.put("com.ibm.websphere.naming.name.syntax", "ins");
        }
        try {
            WsnName wsnName = new WsnName(nameComponentArray, _wsnNameProps);
            string = "INSName-> " + wsnName.toString();
        }
        catch (InvalidNameException invalidNameException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "toString(NameComponent[]) caught and ignored InvalidNameException:" + invalidNameException);
            }
            Tr.warning(tc, "invCosNameIgnored");
            string = "";
        }
        catch (InvalidNameSyntaxException invalidNameSyntaxException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "toString(NameComponent[]) caught and ignored InvalidNameSyntaxException:" + invalidNameSyntaxException);
            }
            string = "";
        }
        return string;
    }

    public static String toString(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string.concat("[" + i + "]=" + stringArray[i] + " ");
        }
        return string;
    }

    public static Object processRemoteObjectForBinding(Object object, ORB oRB) throws NoSuchObjectException {
        Tr.entry(tc, "processRemoteObjectForBinding");
        Object object2 = object;
        if (object instanceof Remote) {
            block4: {
                Tr.debug(tc, "processRemoteObjectForBinding: Object is a remote object.");
                object2 = PortableRemoteObject.toStub((Remote)((Remote)object));
                try {
                    if (object2 instanceof Stub) {
                        Tr.debug(tc, "processRemoteObjectForBinding: Stub is a CORBA stub.");
                        ((Stub)object2).connect(oRB);
                    }
                }
                catch (RemoteException remoteException) {
                    FFDCFilter.processException(remoteException, "com.ibm.ws.naming.util.Helpers.processRemoteObjectForBinding", "502");
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Could not connect CORBA stub to ORB. Assuming that stub is already connected. Ignoring exception.", remoteException);
                }
            }
            Tr.exit(tc, "processRemoteObjectForBinding: Remote object");
            return object2;
        }
        Tr.exit(tc, "processRemoteObjectForBinding: Non-remote object");
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object processJavaObjectForBinding(Object object, boolean bl, StringBuffer stringBuffer) throws IOException, CannotBindObjectException, NamingException {
        Object object2;
        Tr.entry(tc, "processJavaObjectForBinding");
        if (object == null) {
            Tr.exit(tc, "processJavaObjectForBinding: null Java object");
            return null;
        }
        Object object3 = null;
        if (object instanceof Referenceable) {
            try {
                object2 = ((Referenceable)object).getReference();
                if (object2 == null) {
                    String string = object.getClass().getName();
                    String string2 = string + ".getReference() returned null in " + "violation of the JNDI API";
                    NamingException namingException = new NamingException(string2);
                    String string3 = string;
                    Object object4 = object;
                    Tr.warning(tc, "getRefReturnNull", new String[]{object4.toString(), string3});
                    Tr.exit(tc, "processJavaObjectForBinding", "getReference returns null ");
                    throw namingException;
                }
                object = object2;
            }
            catch (NamingException namingException) {
                FFDCFilter.processException(namingException, "com.ibm.ws.naming.util.Helpers.processJavaObjectForBinding", "581");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NamingException occured while getReference:", namingException);
                }
                Tr.warning(tc, "jndiGetRefErr");
                Tr.exit(tc, "processJavaObjectForBinding", "getReference error");
                throw namingException;
            }
        }
        if (object instanceof Reference) {
            stringBuffer.append(((Reference)object).getClassName());
        } else if (object instanceof Context) {
            stringBuffer.append("javax.naming.Context");
        } else {
            stringBuffer.append(object.getClass().getName());
        }
        if (bl) {
            if (!(object instanceof Serializable)) {
                Tr.warning(tc, "jndiCannotBindObj");
                Tr.exit(tc, "processJavaObjectForBinding", "Not Serializable");
                object2 = "Object is not of any type which can be bound.";
                throw new CannotBindObjectException((String)object2);
            }
            try {
                object3 = Serialization.serializeObject(object);
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.naming.util.Helpers.processJavaObjectForBinding", "604");
                Tr.exit(tc, "processJavaObjectForBinding", "IOException thrown");
                throw iOException;
            }
        } else if (!(!(object instanceof Serializable) || object instanceof String || object instanceof Number || object instanceof URL || object instanceof Boolean || object instanceof Character)) {
            try {
                object3 = Serialization.serializeObject(object);
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.naming.util.Helpers.processJavaObjectForBinding", "630");
                Tr.exit(tc, "processJavaObjectForBinding", "IOException thrown");
                throw iOException;
            }
        } else {
            object3 = object;
        }
        Tr.exit(tc, "processJavaObjectForBinding");
        return object3;
    }

    public static Object processSerializedObjectForLookup(byte[] byArray, Context context, String string, String string2, Hashtable hashtable, JavaObjectHolder javaObjectHolder, BooleanWrapper booleanWrapper) throws CannotInstantiateObjectException, InvalidObjectException, UnresolvedURLException {
        Tr.entry(tc, "processSerializedObjectForLookup");
        Object object = Helpers.processSerializedObjectForLookupExt(byArray, context, string, string2, hashtable, javaObjectHolder, booleanWrapper, new BooleanWrapper(false), new JavaObjectHolder());
        Tr.exit(tc, "processSerializedObjectForLookup");
        return object;
    }

    public static Object processSerializedObjectForLookupExt(byte[] byArray, Context context, String string, String string2, Hashtable hashtable, JavaObjectHolder javaObjectHolder, BooleanWrapper booleanWrapper, BooleanWrapper booleanWrapper2, JavaObjectHolder javaObjectHolder2) throws CannotInstantiateObjectException, InvalidObjectException, UnresolvedURLException {
        Tr.entry(tc, "processSerializedObjectForLookupExt");
        String string3 = "[not available]";
        try {
            string3 = context.getNameInNamespace();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.util.Helpers.processSerializedObjectForLookupExt", "771");
            Tr.debug(tc, "Could not get name in name space:", throwable);
        }
        booleanWrapper2.value = false;
        javaObjectHolder2.value = null;
        Object object = null;
        try {
            javaObjectHolder.value = object = Serialization.deserializeObject(byArray);
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.naming.util.Helpers.processSerializedObjectForLookupExt", "784");
            NameClassPair nameClassPair = new NameClassPair(string, string2);
            CannotInstantiateObjectException cannotInstantiateObjectException = new CannotInstantiateObjectException("I/O Exception occurred while attempting to deserialize a retrieved object.", nameClassPair);
            cannotInstantiateObjectException.setRootCause(iOException);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "I/O Exception during deserialization:", iOException);
            }
            Tr.exit(tc, "processSerializedObjectForLookupExt", "CannotInstantiateObjectException thrown (root cause: I/O exception)");
            throw cannotInstantiateObjectException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.naming.util.Helpers.processSerializedObjectForLookupExt", "798");
            NameClassPair nameClassPair = new NameClassPair(string, string2);
            CannotInstantiateObjectException cannotInstantiateObjectException = new CannotInstantiateObjectException("ClassNotFoundException occurred while attempting to deserialize retrieved object.", nameClassPair);
            cannotInstantiateObjectException.setRootCause(classNotFoundException);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ClassNotFoundException during deserialization:", classNotFoundException);
            }
            Tr.exit(tc, "processSerializedObjectForLookupExt", "CannotInstantiateObjectException thrown (root cause: Class not found)");
            throw cannotInstantiateObjectException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.naming.util.Helpers.processSerializedObjectForLookupExt", "812");
            NameClassPair nameClassPair = new NameClassPair(string, string2);
            CannotInstantiateObjectException cannotInstantiateObjectException = new CannotInstantiateObjectException("An enexpected error occurred while attempting to deserialize retrieved object.", nameClassPair);
            cannotInstantiateObjectException.setRootCause(throwable);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error during deserialization:", throwable);
            }
            Tr.exit(tc, "processSerializedObjectForLookupExt", "CannotInstantiateObjectException thrown (root cause: Unexpected error)");
            throw cannotInstantiateObjectException;
        }
        if (object instanceof DestroyedContext) {
            NameClassPair nameClassPair = new NameClassPair(string, "javax.naming.Context");
            Tr.exit(tc, "processSerializedObjectForLookupExt: Throwing InvalidObjectException");
            throw new InvalidObjectException("Some context in the name \"" + string + "\" relative to " + "the context \"" + string3 + "\" has been destroyed.", nameClassPair);
        }
        if (object instanceof UnresolvedIORBinding) {
            NameClassPair nameClassPair = new NameClassPair(string, "javax.naming.Context");
            Tr.exit(tc, "processSerializedObjectForLookupExt: Throwing InvalidObjectException");
            throw new InvalidObjectException("Some context in the name \"" + string + "\" relative to " + "the context \"" + string3 + "\" is invalid.", nameClassPair);
        }
        if (object instanceof UnresolvedURLBinding) {
            NameClassPair nameClassPair = new NameClassPair(string, string2);
            Tr.exit(tc, "processSerializedObjectForLookupExt: Throwing UnresolvedURLException");
            throw new UnresolvedURLException(string + " is an UnresolvedURLBinding ", nameClassPair, ((UnresolvedURLBinding)object).getURL());
        }
        if (object instanceof Reference) {
            Name name2 = null;
            try {
                try {
                    name2 = context.getNameParser("").parse(string);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.naming.util.Helpers.processSerializedObjectForLookupExt", "865");
                    Tr.warning(tc, "unexpectedErr");
                    Tr.debug(tc, "processSerializedObjectForLookupExt: Received an exception from the name parser while attempting to parse the name \"" + string + "\".", throwable);
                }
                String string4 = ((Reference)object).getFactoryClassName();
                Object object2 = string4 != null && string4.equals(INDIRECT_LOOKUP_OBJECT_FACTORY_CLASS_NAME) ? IndirectJndiLookupObjectFactory.getObjectInstanceExt(object, name2, context, hashtable, booleanWrapper2, javaObjectHolder2) : NamingManager.getObjectInstance(object, name2, context, hashtable);
                try {
                    final Object object3 = object2;
                    final String string5 = string3;
                    final String string6 = string;
                    final Object object4 = object;
                    final Name name3 = name2;
                    final Context context2 = context;
                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            if (object4 == object3) {
                                Tr.warning(tc, "jndiGetObjInstNoop", new String[]{string5, string6, ((Reference)object4).getFactoryClassName(), ((Reference)object4).getFactoryClassLocation(), object4.toString()});
                            }
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "result of call: retObj=NamingManager.getObjectInstance(obj,n,ctx,env);", new String[]{"obj = " + object4, "n   = " + name3, "ctx = " + context2, "retObj = " + object3});
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException(privilegedActionException, "com.ibm.ws.naming.util.Helpers.processSerializedObjectForLookupExt", "962");
                    Exception exception = privilegedActionException.getException();
                    throw exception;
                }
                if (object instanceof CacheableReference) {
                    booleanWrapper.value = true;
                }
                object = object2;
            }
            catch (NameNotFoundException nameNotFoundException) {
                String string7;
                String string8 = null;
                FFDCFilter.processException(nameNotFoundException, "com.ibm.ws.naming.util.Helpers.processSerializedObjectForLookupExt", "932");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NameNotFoundException occured in getObjectInstance()call of IndirectJndiLookupObjectFactory or NamingManager: ", nameNotFoundException);
                }
                String string9 = "/";
                if (string3.endsWith(":") || string3.endsWith("/")) {
                    string9 = "";
                }
                if ((string7 = string3 + string9 + string).startsWith("java:comp/env")) {
                    Tr.warning(tc, "indirectNameNotFound", new String[]{string7, Helpers.getStackTrace(nameNotFoundException)});
                    string8 = "A NameNotFoundException occurred on an indirect lookup on the name " + string7 + ". The name " + string7 + " maps to a " + "JNDI name in deployment descriptor bindings for the application " + "performing the JNDI lookup. Make sure that the JNDI name mapping in " + "the deployment descriptor binding is correct. If the JNDI name mapping is " + "correct, make sure the target resource can be resolved with the " + "specified name relative to the default initial context. ";
                } else {
                    Tr.warning(tc, "jndiGetObjInstErr", new String[]{string3, string, ((Reference)object).getFactoryClassName(), ((Reference)object).getFactoryClassLocation(), object.toString(), Helpers.getStackTrace(nameNotFoundException)});
                    string8 = "threw NameNotFoundException while the JNDI NamingManager was processing a javax.naming.Reference object.";
                }
                NameClassPair nameClassPair = new NameClassPair(string, string2);
                CannotInstantiateObjectException cannotInstantiateObjectException = new CannotInstantiateObjectException(string8, nameClassPair, (Reference)object);
                cannotInstantiateObjectException.setRootCause(nameNotFoundException);
                Tr.exit(tc, "processSerializedObjectForLookupExt", "NameNotFoundException thrown in IndirectJndiLookupObjectFactory.getObjectInstance");
                throw cannotInstantiateObjectException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.util.Helpers.processSerializedObjectForLookupExt", "976");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occured in NamingManager.getObjectInstance: ", throwable);
                }
                Tr.warning(tc, "jndiGetObjInstErr", new String[]{string3, string, ((Reference)object).getFactoryClassName(), ((Reference)object).getFactoryClassLocation(), object.toString(), Helpers.getStackTrace(throwable)});
                NameClassPair nameClassPair = new NameClassPair(string, string2);
                CannotInstantiateObjectException cannotInstantiateObjectException = new CannotInstantiateObjectException("Exception occurred while the JNDI NamingManager was processing a javax.naming.Reference object.", nameClassPair, (Reference)object);
                cannotInstantiateObjectException.setRootCause(throwable);
                Tr.exit(tc, "processSerializedObjectForLookupExt", "Error occurred in NamingManager.getObjectInstance");
                throw cannotInstantiateObjectException;
            }
        }
        Tr.exit(tc, "processSerializedObjectForLookupExt");
        return object;
    }

    public static Any bytesToAny(byte[] byArray, ORB oRB) {
        Tr.entry(tc, "bytesToAny");
        Any any = oRB.create_any();
        any.insert_Value((Serializable)byArray);
        Tr.exit(tc, "bytesToAny");
        return any;
    }

    public static byte[] anyToBytes(Any any) {
        return (byte[])any.extract_Value();
    }

    public static void closeIfContext(Object object) {
        block3: {
            if (object instanceof Context) {
                try {
                    Context context = (Context)object;
                    context.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.naming.util.Helpers.closeIfContext", "1059");
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "closeIfContext(obj) - caught exception, will be ignored", new String[]{"Context   = " + object.toString(), "Exception = " + exception.toString()});
                }
            }
        }
    }

    public static String formatMessage(String string) {
        ResourceBundle resourceBundle = Helpers.getWsnResourceBundle();
        String string2 = null;
        try {
            if (resourceBundle != null) {
                String string3 = MessageFormat.format(resourceBundle.getString(string), null);
                return string3;
            }
            string2 = "WebSphere Naming message table not found.";
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "WebSphere Naming message or message table not found.";
        }
        return string2;
    }

    public static String formatMessage(String string, String[] stringArray) {
        ResourceBundle resourceBundle = Helpers.getWsnResourceBundle();
        String string2 = null;
        try {
            if (resourceBundle != null) {
                String string3 = MessageFormat.format(resourceBundle.getString(string), stringArray);
                return string3;
            }
            string2 = "WebSphere Naming message table not found.";
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "WebSphere Naming message or message table not found.";
        }
        return string2;
    }

    private static ResourceBundle getWsnResourceBundle() {
        if (_wsnResourceBundle == null) {
            _wsnResourceBundle = (ResourceBundle)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return ResourceBundle.getBundle("com.ibm.ws.naming.util.WsnMessages");
                }
            });
        }
        return _wsnResourceBundle;
    }

    public static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream.toString();
    }

    public static String contextIDsToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(256);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public static String[] stringToContextIDs(String string) {
        if (string == null) {
            string = "";
        }
        int n = string.length() > 0 ? 1 : 0;
        int n2 = string.indexOf(59);
        while (n2 != -1) {
            ++n;
            ++n2;
            n2 = string.indexOf(59, n2);
        }
        String[] stringArray = new String[n];
        if (n == 0) {
            return stringArray;
        }
        int n3 = 0;
        int n4 = string.indexOf(59);
        int n5 = 0;
        while (n4 != -1) {
            stringArray[n3] = string.substring(n5, n4);
            ++n3;
            n5 = ++n4;
            n4 = string.indexOf(59, n4);
        }
        stringArray[n3] = string.substring(n5);
        return stringArray;
    }

    public static NamingException logJndiContextException(Throwable throwable, Context context, String string, Name name2, String string2) {
        String string3 = name2 == null ? null : name2.toString();
        return Helpers.logJndiContextException(throwable, context, string, string3, string2);
    }

    public static NamingException logJndiContextException(Throwable throwable, Context context, String string, String string2, String string3) {
        NamingException namingException;
        String string4;
        if (string2 == null) {
            string2 = "[N/A]";
        }
        if (string3 == null) {
            string3 = "";
        }
        try {
            string4 = context.getNameInNamespace();
        }
        catch (NamingException namingException2) {
            string4 = "[N/A]";
        }
        String string5 = "jndiNamingException";
        String[] stringArray = new String[]{context.getClass().getName(), string, string4, string2, string3, ""};
        if (!(throwable instanceof NamingException)) {
            namingException = new NamingException("The JNDI operation \"" + string + "\"on the context \"" + string4 + "\" with the name \"" + string2 + "\" failed.  Please get the root cause Throwable contained in this " + "NamingException for more information.");
            namingException.setRootCause(throwable);
        } else {
            namingException = (NamingException)throwable;
        }
        if (namingException instanceof NameNotFoundException) {
            if (tc.isDebugEnabled()) {
                stringArray[5] = Helpers.getStackTrace(throwable);
                Tr.debug(tc, string5, stringArray);
            }
        } else if (namingException instanceof NameAlreadyBoundException) {
            if (tc.isDebugEnabled()) {
                stringArray[5] = Helpers.getStackTrace(throwable);
                Tr.debug(tc, Helpers.formatMessage(string5, stringArray));
            }
        } else {
            stringArray[5] = Helpers.getStackTrace(throwable);
            Tr.warning(tc, string5, stringArray);
        }
        return namingException;
    }

    public static Object extractCtxImplFromInitCtx(Object object) throws NamingException {
        if (object instanceof InitialContext) {
            Tr.debug(tc, "extractCtxImplFromInitCtx: Extracting Context Impl from InitialContext.");
            return ((InitialContext)object).lookup("");
        }
        return object;
    }

    public static Throwable findRootCause(Throwable throwable) {
        Throwable throwable2;
        Tr.entry(tc, "findRootCause");
        Throwable throwable3 = throwable2 = throwable;
        while (throwable3 != null) {
            throwable2 = throwable3;
            Tr.debug(tc, "findRootCause unwrapping " + throwable2.getClass().getName());
            if (throwable2 instanceof RemoteException) {
                throwable3 = ((RemoteException)throwable2).detail;
                continue;
            }
            if (throwable2 instanceof UnknownException) {
                throwable3 = ((UnknownException)throwable2).originalEx;
                continue;
            }
            throwable3 = null;
        }
        Tr.exit(tc, "findRootCause");
        return throwable2;
    }

    public static UnknownException createUnknownException(Throwable throwable) {
        Throwable throwable2 = Helpers.findRootCause(throwable);
        UnknownException unknownException = new UnknownException(throwable2);
        return unknownException;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/Helpers.java, WAS.naming.client, WAS61.SERV1, cf311012.09, ver. 1.26.1.64");
        }
        WSN_JNDI_PROPS = new String[]{"java.naming.corba.orb", "com.ibm.CORBA.ORBInit", "com.ibm.websphere.naming.namespaceroot", "com.ibm.websphere.naming.namespace.connection", "com.ibm.websphere.naming.jndicache.cacheobject", "com.ibm.websphere.naming.jndicache.cachename", "com.ibm.websphere.naming.jndicache.maxcachelife", "com.ibm.websphere.naming.jndicache.maxentrylife", "com.ibm.websphere.naming.name.syntax", "com.ibm.websphere.naming.generic.url.schemeid", "com.ibm.websphere.naming.generic.url.package", "com.ibm.websphere.naming.hostname.normalizer", "com.ibm.ws.naming.implementation", "com.ibm.ws.naming.ldap.masterurl", "com.ibm.ws.naming.ldap.containerdn", "com.ibm.ws.naming.ldap.noderootrdn", "com.ibm.ws.naming.ldap.config", "com.ibm.websphere.naming.ldapprotocoltrace", "com.ibm.websphere.naming.ldapprotocoltracefile"};
        INDIRECT_LOOKUP_OBJECT_FACTORY_CLASS_NAME = IndirectJndiLookupObjectFactory.class.getName();
        _wsnNameProps = null;
        _wsnResourceBundle = null;
        _propLock = new Object();
        _propKeys = null;
        _propValues = null;
        _propSize = 0;
        _providerPropertiesRead = false;
    }
}

