/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.namebindings.EjbNameSpaceBinding;
import com.ibm.websphere.models.config.namebindings.NameSpaceBinding;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.ImportProfileUtility;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ImportProfileUtilityImpl
extends ImportProfileUtility {
    private static TraceComponent _tc = Tr.register(ImportProfileUtilityImpl.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final String NAME_BINDINGS_URI = "namebindings.xml";
    private WorkSpace _workSpace;
    private String _targetNodeName;
    private RepositoryMetaData _repMetadata;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$namebindings$EjbNameSpaceBinding;

    public ImportProfileUtilityImpl(String string, String string2) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", "workspaceID=" + string + ", targetNodeName" + string2);
        }
        try {
            this._workSpace = ImportProfileUtilityImpl.getWorkSpace(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "_workSpace = " + this._workSpace);
            }
            this._targetNodeName = string2;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "_targetNodeName = " + this._targetNodeName);
            }
            this._repMetadata = RepositoryMetaDataFactory.getRepositoryMetaData();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "_repMetadata = " + this._repMetadata);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CLASS_NAME + ".ImportProfileUtilityImpl", "85");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ImportProfileUtilityImpl failed. ", exception);
            }
            throw exception;
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ImportProfileNameBindingsUpdateImpl");
        }
    }

    public void updateNameBindings() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateNameBindings");
        }
        try {
            this.updateAllNameBindingsFilesInCell();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CLASS_NAME + ".updateNameBindings", "104");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateNameBindings failed. ", exception);
            }
            throw exception;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateNameBindings");
        }
    }

    public static WorkSpace getWorkSpace(String string) throws Exception {
        WorkSpace workSpace;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWorkSpace", new Object[]{string});
        }
        try {
            workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(string);
        }
        catch (Exception exception) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getWorkSpace", exception);
            }
            throw exception;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWorkSpace", new Object[]{workSpace});
        }
        return workSpace;
    }

    private void updateAllNameBindingsFilesInCell() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateAllNameBindingsFilesInCell");
        }
        RepositoryContext repositoryContext = this.getCellContext();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Attempting to updating naming bindings in cellCtx " + repositoryContext);
        }
        this.updateNameBindingsFile(repositoryContext);
        Collection collection = this.getNodeContexts(repositoryContext);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Attempting to update naming bindings in nodeCtx " + repositoryContext2);
            }
            this.updateNameBindingsFile(repositoryContext2);
            Collection collection2 = this.getServerContexts(repositoryContext2);
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                RepositoryContext repositoryContext3 = (RepositoryContext)iterator2.next();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Attempting to update naming bindings in serverCtx " + repositoryContext3);
                }
                this.updateNameBindingsFile(repositoryContext3);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateAllNameBindingsFilesInCell");
        }
    }

    private void updateNameBindingsFile(RepositoryContext repositoryContext) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateNameBindingsFile", "repCtx = " + repositoryContext);
        }
        if (repositoryContext != null) {
            Resource resource = this.getNameBindingsResourceFromRepositoryContext(repositoryContext);
            if (resource != null) {
                boolean bl = this.updateNameBindingsResource(resource);
                if (bl) {
                    try {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Updated node name in resource " + resource + " for repCtx " + repositoryContext);
                        }
                        resource.save(new HashMap());
                        repositoryContext.notifyChanged(1, NAME_BINDINGS_URI);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, CLASS_NAME + ".updateNameBindingsFile", "174");
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "updateNameBindingsFile failed. ", exception);
                        }
                        throw exception;
                    }
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The namebindings resource is null for repCtx " + repositoryContext);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateNameBindingsFile");
        }
    }

    private Resource getNameBindingsResourceFromRepositoryContext(RepositoryContext repositoryContext) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNameBindingsResourceFromRepositoryContext", "repCtx: " + repositoryContext);
        }
        Resource resource = null;
        ResourceSet resourceSet = repositoryContext.getResourceSet();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "ResourceSet resSet = " + resourceSet);
        }
        try {
            if (repositoryContext.isAvailable(NAME_BINDINGS_URI)) {
                if (!repositoryContext.isExtracted(NAME_BINDINGS_URI)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "extracting  namebindings.xml");
                    }
                    repositoryContext.extract(NAME_BINDINGS_URI, false);
                }
                URI uRI = URI.createURI((String)NAME_BINDINGS_URI);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "URI namebindings.xml: " + uRI);
                }
                resource = resourceSet.createResource(uRI);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "resource: " + resource);
                }
                resource.load(new HashMap());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "resource.load");
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CLASS_NAME + ".getNameBindingsResourceFromRepositoryContext", "219");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getNameBindingsResourceFromRepositoryContext failed. ", exception);
            }
            throw exception;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNameBindingsResourceFromRepositoryContext", "resource: " + resource);
        }
        return resource;
    }

    private boolean updateNameBindingsResource(Resource resource) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateNameBindingsResource", "Resource: " + resource);
        }
        boolean bl = false;
        Iterator iterator = resource.getContents().iterator();
        while (iterator.hasNext()) {
            try {
                NameSpaceBinding nameSpaceBinding = (NameSpaceBinding)iterator.next();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "NameSpaceBinding nsb = " + nameSpaceBinding);
                }
                if (!(class$com$ibm$websphere$models$config$namebindings$EjbNameSpaceBinding == null ? ImportProfileUtilityImpl.class$("com.ibm.websphere.models.config.namebindings.EjbNameSpaceBinding") : class$com$ibm$websphere$models$config$namebindings$EjbNameSpaceBinding).isInstance(nameSpaceBinding)) continue;
                EjbNameSpaceBinding ejbNameSpaceBinding = (EjbNameSpaceBinding)nameSpaceBinding;
                String string = ejbNameSpaceBinding.getApplicationNodeName();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "ejb nodeName = " + string);
                }
                if (string == null || string.equals(this._targetNodeName)) continue;
                ejbNameSpaceBinding.setApplicationNodeName(this._targetNodeName);
                bl = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASS_NAME + ".updateNameBindingsResource", "256");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "updateNameBindingsResource failed. ", exception);
                }
                throw exception;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateNameBindingsResource", "updated: " + bl);
        }
        return bl;
    }

    private RepositoryContext getCellContext() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCellContext");
        }
        RepositoryContext repositoryContext = null;
        RepositoryContextType repositoryContextType = this._repMetadata.getContextType("cells");
        repositoryContext = (RepositoryContext)this._workSpace.findContext(repositoryContextType).toArray()[0];
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCellContext", new Object[]{repositoryContext});
        }
        return repositoryContext;
    }

    private Collection getNodeContexts(RepositoryContext repositoryContext) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeContexts");
        }
        Collection collection = null;
        RepositoryContextType repositoryContextType = this._repMetadata.getContextType("nodes");
        collection = repositoryContext.findContext(repositoryContextType);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeContexts", new Object[]{collection});
        }
        return collection;
    }

    private Collection getServerContexts(RepositoryContext repositoryContext) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServerContext");
        }
        Collection collection = null;
        RepositoryContextType repositoryContextType = this._repMetadata.getContextType("servers");
        collection = repositoryContext.findContext(repositoryContextType);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getServerContext", new Object[]{collection});
        }
        return collection;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.server/src/com/ibm/ws/naming/util/ImportProfileUtilityImpl.java, WAS.naming.server, WAS61.SERV1, cf311012.09, ver. 1.1");
        }
        CLASS_NAME = ImportProfileUtilityImpl.class.getName();
    }
}

