/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.jndicos.CNContext;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.JndiLookupInfo;
import com.ibm.ws.naming.util.NullRefAddrException;
import com.ibm.ws.naming.util.Serialization;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class IndirectJndiLookupObjectFactory
implements ObjectFactory {
    private static final String INITIAL_CONTEXT_FACTORY_KEY = "java.naming.factory.initial";
    private static final String PROVIDER_URL_KEY = "java.naming.provider.url";
    private static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "com.ibm.websphere.naming.WsnInitialContextFactory";
    private static final String REALNS_INITIAL_CONTEXT_FACTORY_KEY = "com.ibm.ws.naming.java.realns.factory.initial";
    private static final String REALNS_PROVIDER_URL_KEY = "com.ibm.ws.naming.java.realns.provider.url";
    private static final String ADDR_TYPE = "JndiLookupInfo";
    private static final HashMap _jndiListProperties = new HashMap();
    private static final TraceComponent tc;
    private static final String METHOD_getObjectInstance = "getObjectInstance()";
    private static final String METHOD_getObjectInstanceExt = "getObjectInstanceExt()";

    public IndirectJndiLookupObjectFactory() {
        Tr.debug(tc, "IndirectJndiLookupObjectFactory() - Ctor");
    }

    public Object getObjectInstance(Object object, Name name2, Context context, Hashtable hashtable) throws Exception {
        Object object2;
        Tr.entry(tc, METHOD_getObjectInstance);
        try {
            object2 = IndirectJndiLookupObjectFactory.getObjectInstanceExt(object, name2, context, hashtable, new BooleanWrapper(false), new JavaObjectHolder());
        }
        catch (NamingException namingException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, METHOD_getObjectInstance, "NamingException: " + namingException);
            }
            throw namingException;
        }
        Tr.exit(tc, METHOD_getObjectInstance);
        return object2;
    }

    public static Object getObjectInstanceExt(Object object, Name name2, Context context, Hashtable hashtable, BooleanWrapper booleanWrapper, JavaObjectHolder javaObjectHolder) throws Exception {
        Tr.entry(tc, METHOD_getObjectInstanceExt);
        booleanWrapper.value = false;
        javaObjectHolder.value = null;
        Object object2 = null;
        final Object object3 = object;
        Name name3 = name2;
        final Hashtable hashtable2 = hashtable;
        final String string = IndirectJndiLookupObjectFactory.class.getName();
        final BooleanWrapper booleanWrapper2 = booleanWrapper;
        final JavaObjectHolder javaObjectHolder2 = javaObjectHolder;
        try {
            object2 = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    InitialContext initialContext;
                    Object object;
                    Object object2 = null;
                    Hashtable hashtable = null;
                    if (!(object3 instanceof Reference)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, IndirectJndiLookupObjectFactory.METHOD_getObjectInstanceExt, object3 + " is not a Reference");
                        }
                        return object2;
                    }
                    Reference reference = (Reference)object3;
                    if (!reference.getFactoryClassName().equals(string)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, IndirectJndiLookupObjectFactory.METHOD_getObjectInstanceExt, "this is not the right factory for this Reference: " + object3);
                        }
                        return object2;
                    }
                    RefAddr refAddr = reference.get(IndirectJndiLookupObjectFactory.ADDR_TYPE);
                    if (refAddr == null) {
                        NullRefAddrException nullRefAddrException = new NullRefAddrException("The address for this Reference is empty (null)");
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, IndirectJndiLookupObjectFactory.METHOD_getObjectInstanceExt, "Get NullRefAddrException!");
                        }
                        throw nullRefAddrException;
                    }
                    JndiLookupInfo jndiLookupInfo = (JndiLookupInfo)refAddr.getContent();
                    Properties properties = null;
                    refAddr = reference.get("IndirectJndiLookupAdditionalProperties");
                    if (refAddr != null) {
                        object = (byte[])refAddr.getContent();
                        try {
                            properties = (Properties)Serialization.deserializeObject((byte[])object);
                        }
                        catch (Throwable throwable) {
                            NamingException namingException = new NamingException("Error occurred while attempting to deserialize Properties object.");
                            namingException.setRootCause(throwable);
                            throw namingException;
                        }
                    }
                    if ((object = jndiLookupInfo.getJndiName()) == null || ((String)object).equals("")) {
                        throw new NamingException("Failed to lookup the object configured with a null or empty name");
                    }
                    hashtable = hashtable2 != null ? (Hashtable)hashtable2.clone() : new Hashtable();
                    IndirectJndiLookupObjectFactory.mergePropsIntoEnv(hashtable, properties);
                    String string3 = null;
                    string3 = jndiLookupInfo.getInitialContextFactory();
                    if (!(string3 != null && string3.length() != 0 || (string3 = (String)hashtable.get(IndirectJndiLookupObjectFactory.REALNS_INITIAL_CONTEXT_FACTORY_KEY)) != null && string3.length() != 0)) {
                        string3 = IndirectJndiLookupObjectFactory.DEFAULT_INITIAL_CONTEXT_FACTORY;
                    }
                    hashtable.remove(IndirectJndiLookupObjectFactory.INITIAL_CONTEXT_FACTORY_KEY);
                    hashtable.put(IndirectJndiLookupObjectFactory.INITIAL_CONTEXT_FACTORY_KEY, string3);
                    String string2 = jndiLookupInfo.getProviderUrl();
                    if (string2 == null || string2.length() == 0) {
                        string2 = (String)hashtable.get(IndirectJndiLookupObjectFactory.REALNS_PROVIDER_URL_KEY);
                    }
                    hashtable.remove(IndirectJndiLookupObjectFactory.PROVIDER_URL_KEY);
                    if (string2 != null) {
                        hashtable.put(IndirectJndiLookupObjectFactory.PROVIDER_URL_KEY, string2);
                    }
                    try {
                        initialContext = new InitialContext(hashtable);
                    }
                    catch (NamingException namingException) {
                        FFDCFilter.processException(namingException, "com.ibm.ws.naming.util.IndirectJndiLookupObjectFactory.run", "195");
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, IndirectJndiLookupObjectFactory.METHOD_getObjectInstanceExt, "Indirect Lookup NamingException: " + namingException);
                        }
                        throw namingException;
                    }
                    try {
                        Context context = (Context)initialContext.lookup("");
                        if (context instanceof CNContext) {
                            booleanWrapper2.value = true;
                            object2 = ((CNContext)context).lookupExt((String)object, javaObjectHolder2);
                        } else {
                            object2 = initialContext.lookup((String)object);
                        }
                    }
                    catch (NamingException namingException) {
                        try {
                            Object object32;
                            int n;
                            NameParser nameParser = initialContext.getNameParser("");
                            Name name2 = nameParser.parse((String)object);
                            int n2 = name2.size();
                            Context context = initialContext;
                            for (n = 0; n < n2 - 1; ++n) {
                                Object object4;
                                object32 = name2.get(n);
                                Name name3 = nameParser.parse((String)object32);
                                if (((String)object32).length() == 0) {
                                    name3.add("");
                                }
                                if (!((object4 = context.lookup(name3)) instanceof Context)) break;
                                context = (Context)object4;
                                nameParser = context.getNameParser("");
                            }
                            if (n != n2 - 1) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, IndirectJndiLookupObjectFactory.METHOD_getObjectInstanceExt, "Indirect Federated Lookup: Object bound with name " + name2.getPrefix(n + 1) + " is not a context.");
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, IndirectJndiLookupObjectFactory.METHOD_getObjectInstanceExt, "Indirect Lookup NamingException: " + namingException);
                                }
                                throw namingException;
                            }
                            object32 = name2.getSuffix(n2 - 1);
                            object2 = context.lookup((Name)object32);
                        }
                        catch (NamingException namingException2) {
                            FFDCFilter.processException(namingException2, "com.ibm.ws.naming.util.IndirectJndiLookupObjectFactory.run", "263");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, IndirectJndiLookupObjectFactory.METHOD_getObjectInstanceExt, "Indirect Federated Lookup NamingException: " + namingException2);
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, IndirectJndiLookupObjectFactory.METHOD_getObjectInstanceExt, "Indirect Lookup NamingException: " + namingException);
                            }
                            throw namingException;
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, IndirectJndiLookupObjectFactory.METHOD_getObjectInstanceExt, "retObj = " + object2);
                    }
                    return object2;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException, "com.ibm.ws.naming.util.IndirectJndiLookupObjectFactory.getObjectInstanceExt", "280");
            Exception exception = privilegedActionException.getException();
            throw exception;
        }
        return object2;
    }

    private static void mergePropsIntoEnv(Hashtable hashtable, Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object v;
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (_jndiListProperties.containsKey(string) && (v = hashtable.get(string)) instanceof String) {
                string2 = (String)v + ":" + string2;
            }
            hashtable.put(string, string2);
        }
    }

    static {
        _jndiListProperties.put("java.naming.factory.object", null);
        _jndiListProperties.put("java.naming.factory.state", null);
        _jndiListProperties.put("java.naming.factory.url.pkgs", null);
        _jndiListProperties.put("java.naming.language", null);
        tc = Tr.register(IndirectJndiLookupObjectFactory.class, "Naming");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/IndirectJndiLookupObjectFactory.java, WAS.naming, WAS61.SERV1, cf311012.09, ver. 1.23");
        }
    }
}

