/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.InsJndiNameImpl;
import com.ibm.ws.naming.util.LdapJndiNameImpl;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class NameFormatHelper {
    private static final TraceComponent tc = Tr.register(NameFormatHelper.class, "Naming");
    private static final String[] SinoJndiNameDelimiter = new String[]{"/", "\\"};
    private static final String[] InsJndiNameNeedsEscaping = new String[]{"\\", "/"};
    private static final String[] InsJndiNameEscapedSequence = new String[]{"\\\\", "\\/"};
    private static final String[] LdapJndiNameNeedsEscaping = new String[]{",", "=", "+", "<", ">", "#", ";", "\\", "\""};
    private static final String[] LdapJndiNameEscapedSequence = new String[]{"\\,", "\\=", "\\+", "\\<", "\\>", "\\#", "\\;", "\\\\\\", "\\\""};
    private static final String LdapJndiNamePrefix = "ibm-wsnName=";
    private static final String LdapJndiNameDelimiter = ",";

    private NameFormatHelper() {
    }

    public static Name convertInsJndiNameToLdapJndiName(Name name2) throws InvalidNameException {
        LdapJndiNameImpl ldapJndiNameImpl = new LdapJndiNameImpl();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < name2.size(); ++i) {
            String string = "";
            String string2 = name2.get(i);
            for (int j = 0; j < string2.length(); ++j) {
                for (int k = 0; k < LdapJndiNameNeedsEscaping.length; ++k) {
                    if (!string2.regionMatches(j, LdapJndiNameNeedsEscaping[k], 0, LdapJndiNameNeedsEscaping[k].length())) continue;
                    bl2 = true;
                    string = string + LdapJndiNameEscapedSequence[k];
                    int n = LdapJndiNameNeedsEscaping[k].length() - 1;
                    if (n <= 0) continue;
                    j += n;
                }
                if (!bl2) {
                    string = string + string2.charAt(j);
                    continue;
                }
                bl2 = false;
            }
            try {
                ldapJndiNameImpl.add(LdapJndiNamePrefix + string);
                continue;
            }
            catch (InvalidNameException invalidNameException) {
                FFDCFilter.processException(invalidNameException, "com.ibm.ws.naming.util.NameFormatHelper.convertInsJndiNameToLdapJndiName", "129");
                Tr.warning(tc, "in convertInsJndiNameToLdapJndiName, com.ibm.ws.naming.util.JndiNameImpl.add failed because the converted LdapJndiName was invalid");
                throw invalidNameException;
            }
        }
        return ldapJndiNameImpl;
    }

    public static Name convertLdapStringNameToLdapJndiName(String string) throws InvalidNameException {
        return new LdapJndiNameImpl(string);
    }

    public static Name convertLdapJndiNameToInsJndiName(Name name2) throws InvalidNameException {
        InsJndiNameImpl insJndiNameImpl = new InsJndiNameImpl();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < name2.size(); ++i) {
            String string = new String();
            String string2 = new String(name2.get(i));
            if (!string2.regionMatches(0, LdapJndiNamePrefix, 0, LdapJndiNamePrefix.length())) {
                Tr.warning(tc, "in convertLdapJndiNameToInsJndiName, input LdapJndiName did not have the expected prefix");
                throw new InvalidNameException("in convertLdapJndiNameToInsJndiName, input LdapJndiName did not have the expected prefix");
            }
            string2 = string2.substring(LdapJndiNamePrefix.length());
            for (int j = 0; j < string2.length(); ++j) {
                for (int k = 0; k < LdapJndiNameNeedsEscaping.length; ++k) {
                    if (!string2.regionMatches(j, LdapJndiNameEscapedSequence[k], 0, LdapJndiNameEscapedSequence[k].length())) continue;
                    bl2 = true;
                    string = string + LdapJndiNameNeedsEscaping[k];
                    int n = LdapJndiNameEscapedSequence[k].length() - 1;
                    if (n <= 0) continue;
                    j += n;
                }
                if (!bl2) {
                    string = string + string2.charAt(j);
                    continue;
                }
                bl2 = false;
            }
            insJndiNameImpl.add(string);
        }
        return insJndiNameImpl;
    }

    public static String convertLdapJndiNameToLdapStringName(Name name2) throws InvalidNameException {
        String string = new String();
        boolean bl = false;
        for (int i = name2.size() - 1; i >= 0; --i) {
            String string2 = name2.get(i);
            for (int j = 0; j < SinoJndiNameDelimiter.length; ++j) {
                if (string2.indexOf(LdapJndiNameDelimiter) == -1) continue;
                Tr.warning(tc, "in convertLdapJndiNameToLdapStringName, the LdapJndiName Component contained delimiters");
                throw new InvalidNameException("in convertLdapJndiNameToLdapStringName, the LdapJndiName Component contained delimiters");
            }
            string = string + string2;
            if (i == 0) continue;
            string = string + LdapJndiNameDelimiter;
        }
        return string;
    }

    public static String getUrlScheme(String string) {
        int n = string.indexOf(58);
        if (NameFormatHelper.isSchemeValid(string, n)) {
            return string.substring(0, n).toLowerCase();
        }
        return null;
    }

    public static String getUrlScheme(Name name2) {
        return !name2.isEmpty() ? NameFormatHelper.getUrlScheme(name2.get(0)) : null;
    }

    public static boolean isUrl(String string) {
        int n = string.indexOf(58);
        return NameFormatHelper.isSchemeValid(string, n);
    }

    public static boolean isUrl(Name name2) {
        return !name2.isEmpty() ? NameFormatHelper.isUrl(name2.get(0)) : false;
    }

    public static boolean isSchemeValid(String string, int n) {
        if (n < 1) {
            return false;
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }
}

