/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class Serialization {
    private static final TraceComponent _tc = Tr.register(Serialization.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");

    public static byte[] serializeObject(Object object) throws IOException {
        Tr.entry(_tc, "serializeObject");
        if (object == null) {
            Tr.debug(_tc, "serializeObject", "Null object.");
            return null;
        }
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "serializeObject", "Class name=" + object.getClass().getName());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            Tr.exit(_tc, "serializeObject");
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.naming.util.Serialization.serializeObject", "71");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "java.io.IOException occured during serialization: ", iOException);
            }
            Tr.warning(_tc, "serializationErr");
            Tr.exit(_tc, "serializeObject", "Serialization failed.");
            throw iOException;
        }
    }

    public static Object deserializeObject(byte[] byArray) throws IOException, ClassNotFoundException {
        Tr.entry(_tc, "deserializeObject");
        if (byArray == null) {
            return null;
        }
        try {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Object object = null;
            try {
                object = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
                        return wsObjectInputStream.readObject();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException(privilegedActionException, "com.ibm.ws.naming.util.Serialization.deserializeObject", "106");
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)exception;
                }
                CommonHelpers.handleDoPrivilegedUnmatchedException(exception, _tc);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "deserializeObject", "Class name=" + object.getClass().getName());
            }
            Tr.exit(_tc, "deserializeObject");
            return object;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.naming.util.Serialization.deserializeObject", "123");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "java.io.IOException occured during deserialization: ", iOException);
            }
            Tr.warning(_tc, "deserializationErr");
            Tr.exit(_tc, "deserializeObject", "IOException thrown");
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.naming.util.Serialization.deserializeObject", "134");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ClassNotFoundException occured during deserialization: ", classNotFoundException);
            }
            Tr.warning(_tc, "deserializationErr");
            Tr.exit(_tc, "deserializeObject", "ClassNotFoundException thrown");
            throw classNotFoundException;
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/Serialization.java, WAS.naming, WAS61.SERV1, cf311012.09, ver. 1.4.1.9");
        }
    }
}

