/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class URLNameHelpers {
    private static final TraceComponent _tc = Tr.register(URLNameHelpers.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String RFC2396 = "-_.!~*'();/:?@&=+$,";
    private static final String[] hex;

    protected URLNameHelpers() {
    }

    public static String encodeCorbaURL(String string) {
        String string2;
        String string3;
        int n;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "encodeCorbaURL()", "inURL = " + string);
        }
        if ((n = string.indexOf("#")) > -1) {
            string3 = URLNameHelpers.encodeString(string.substring(n + 1), false);
            string = string.substring(0, n);
        } else {
            string3 = null;
        }
        n = string.indexOf("/");
        if (n > -1) {
            string2 = URLNameHelpers.encodeString(string.substring(n + 1), false);
            string = string.substring(0, n);
        } else {
            string2 = null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string2 != null) {
            stringBuffer.append('/');
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            stringBuffer.append('#');
            stringBuffer.append(string3);
        }
        String string4 = stringBuffer.toString();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "encodeCorbaURL()", "escapedURL = " + string4);
        }
        return string4;
    }

    public static String encodeString(String string, boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "encodeString()", new String[]{"inString = " + string, "interpretPercentSignLiterally = " + bl});
        }
        String string2 = string;
        if (!bl) {
            string2 = URLNameHelpers.decodeRFC2396(string);
        }
        String string3 = URLNameHelpers.encodeRFC2396(string2);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "encodeString()", "escapedString = " + string3);
        }
        return string3;
    }

    public static String decodeString(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "decodeString()", "escaped = " + string);
        }
        String string2 = URLNameHelpers.decodeRFC2396(string);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "decodeString()", "unescaped= " + string2);
        }
        return string2;
    }

    private static String decodeRFC2396(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "decodeRFC2396()", "input=" + string);
        }
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = -1;
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < n; ++i) {
            int n5;
            char c = string.charAt(i);
            n2 = c;
            switch (c) {
                case '%': {
                    if (i + 2 >= string.length()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Incomplete escape sequence in URL.", string);
                        }
                        throw new IllegalArgumentException("Incomplete escape sequence in URL: " + string);
                    }
                    int n6 = (Character.isDigit((char)(n2 = (int)string.charAt(++i))) ? n2 - 48 : 10 + Character.toLowerCase((char)n2) - 97) & 0xF;
                    n2 = string.charAt(++i);
                    int n7 = (Character.isDigit((char)n2) ? n2 - 48 : 10 + Character.toLowerCase((char)n2) - 97) & 0xF;
                    n5 = n6 << 4 | n7;
                    break;
                }
                case '+': {
                    n5 = 32;
                    break;
                }
                default: {
                    n5 = n2;
                }
            }
            if ((n5 & 0xC0) == 128) {
                n3 = n3 << 6 | n5 & 0x3F;
                if (--n4 != 0) continue;
                stringBuffer.append((char)n3);
                continue;
            }
            if ((n5 & 0x80) == 0) {
                stringBuffer.append((char)n5);
                continue;
            }
            if ((n5 & 0xE0) == 192) {
                n3 = n5 & 0x1F;
                n4 = 1;
                continue;
            }
            if ((n5 & 0xF0) == 224) {
                n3 = n5 & 0xF;
                n4 = 2;
                continue;
            }
            if ((n5 & 0xF8) == 240) {
                n3 = n5 & 7;
                n4 = 3;
                continue;
            }
            if ((n5 & 0xFC) == 248) {
                n3 = n5 & 3;
                n4 = 4;
                continue;
            }
            n3 = n5 & 1;
            n4 = 5;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "decodeRFC2396()", "output=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String encodeRFC2396(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "encodeRFC2396()", "input=" + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('A' <= c && c <= 'Z') {
                stringBuffer.append(c);
                continue;
            }
            if ('a' <= c && c <= 'z') {
                stringBuffer.append(c);
                continue;
            }
            if ('0' <= c && c <= '9') {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                stringBuffer.append('+');
                continue;
            }
            if (RFC2396.indexOf(c) >= 0) {
                stringBuffer.append(c);
                continue;
            }
            if (c <= '\u007f') {
                stringBuffer.append(hex[c]);
                continue;
            }
            if (c <= '\u07ff') {
                stringBuffer.append(hex[0xC0 | c >> 6]);
                stringBuffer.append(hex[0x80 | c & 0x3F]);
                continue;
            }
            stringBuffer.append(hex[0xE0 | c >> 12]);
            stringBuffer.append(hex[0x80 | c >> 6 & 0x3F]);
            stringBuffer.append(hex[0x80 | c & 0x3F]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "encodeRFC2396()", "output=" + stringBuffer);
        }
        return stringBuffer.toString();
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/URLNameHelpers.java, WAS.naming.client, WAS61.SERV1, cf311012.09, ver. 1.3");
        }
        hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};
    }
}

