/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectpool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.pool.PoolableObject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.objectpool.BoundedObjectPool;
import com.ibm.ws.objectpool.pmi.ObjectPoolPerf;
import java.util.ArrayList;
import java.util.Collection;

public class FastObjectPoolImpl
implements BoundedObjectPool {
    private static final TraceComponent tc = Tr.register(FastObjectPoolImpl.class, "ObjectPoolService", "com.ibm.ws.objectpool.ObjectPoolMessages");
    ObjectPoolPerf[] pmi;
    ArrayList objectList;
    int softLimit;
    boolean isCustom;
    Class theClass;
    boolean isCollection;

    public FastObjectPoolImpl(Class clazz) throws IllegalAccessException, InstantiationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "FastObjectPoolImpl");
        }
        try {
            this.theClass = clazz;
            this.objectList = new ArrayList(50);
            Object t = clazz.newInstance();
            this.isCustom = t instanceof PoolableObject;
            this.isCollection = t instanceof Collection;
            this.objectList.add(t);
            this.pmi = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.asynchbeans.pool.FastObjectPoolImpl.FastObjectPoolImpl", "58", this);
            Tr.error(tc, "ERR_OBJPOOLINIT_ILLEGALACCESS", new Object[]{clazz.getName()});
            throw illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.asynchbeans.pool.FastObjectPoolImpl.FastObjectPoolImpl", "65", this);
            Tr.error(tc, "ERR_OBJPOOLINIT_ILLEGALACCESS", new Object[]{clazz.getName()});
            throw instantiationException;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "FastObjectPoolImpl");
            }
        }
    }

    public void setPmi(ObjectPoolPerf[] objectPoolPerfArray) {
        if (tc.isDebugEnabled() && objectPoolPerfArray != null) {
            Tr.debug(tc, "Pmi enabled for " + this.theClass.getName());
        }
        this.pmi = objectPoolPerfArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getObject", this.theClass);
        }
        try {
            Object var3_3 = null;
            if (this.objectList.isEmpty()) {
                var3_3 = this.theClass.newInstance();
                if (bl2) {
                    Tr.debug(tc, "getObject making new instance: " + var3_3);
                }
                if (this.pmi != null) {
                    this.pmi[0].objectCreated();
                    this.pmi[1].objectCreated();
                }
            } else {
                var3_3 = this.objectList.remove(this.objectList.size() - 1);
                if (bl2) {
                    Tr.debug(tc, "getObject reusing instance: " + var3_3);
                }
            }
            if (this.isCustom) {
                if (bl2) {
                    Tr.debug(tc, "getObject object being initialized: " + var3_3);
                }
                ((PoolableObject)var3_3).init();
            }
            if (this.pmi != null) {
                this.pmi[0].objectAllocated(this.objectList.size());
                this.pmi[1].objectAllocated(this.objectList.size());
            }
            Object var4_6 = var3_3;
            return var4_6;
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.asynchbeans.pool.FastObjectPoolImpl.getObject", "133", this);
            Tr.debug(tc, "Exception during getObject", illegalAccessException);
            Object var4_7 = null;
            return var4_7;
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.asynchbeans.pool.FastObjectPoolImpl.getObject", "139", this);
            Tr.debug(tc, "Exception during getObject", instantiationException);
            Object var4_8 = null;
            return var4_8;
        }
        finally {
            if (bl) {
                Tr.exit(tc, "getObject");
            }
        }
    }

    public void returnObject(Object object) {
        this.returnObject(object, -1);
    }

    public boolean returnObject(Object object, int n) {
        boolean bl;
        boolean bl2 = tc.isEntryEnabled();
        boolean bl3 = tc.isDebugEnabled();
        if (bl2) {
            Tr.entry(tc, "returnObject", new Object[]{this.theClass, object, n == -1 ? "UNBOUNDED" : Integer.toString(n)});
        }
        if (bl3 && !object.getClass().equals(this.theClass)) {
            Tr.error(tc, "ERR_OBJPOOL_RETOBJ_INCORRTYPE", new Object[]{object.getClass().getName(), this.theClass.getName()});
        }
        if (this.isCustom) {
            if (bl3) {
                Tr.debug(tc, "returnObject returned method being called");
            }
            ((PoolableObject)object).returned();
        }
        if (this.isCollection) {
            ((Collection)object).clear();
        }
        if (n == -1 || this.objectList.size() < n) {
            this.objectList.add(object);
            bl = true;
        } else {
            bl = false;
        }
        if (this.pmi != null) {
            this.pmi[0].objectFreed(this.objectList.size());
            this.pmi[1].objectFreed(this.objectList.size());
        }
        if (bl2) {
            Tr.exit(tc, "returnObject", bl ? "POOLED" : "DISCARDED");
        }
        return bl;
    }

    public void flushPool() {
        this.objectList.clear();
        this.objectList.trimToSize();
    }
}

