/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectpool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.pool.CustomObjectPool;
import com.ibm.websphere.asynchbeans.pool.ObjectPool;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.objectpool.BoundedObjectPool;
import com.ibm.ws.objectpool.FastObjectPoolImpl;
import com.ibm.ws.objectpool.ObjectPoolManagerProperties;
import com.ibm.ws.objectpool.ObjectPoolUtility;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;

public class ObjectPoolImpl
implements BoundedObjectPool {
    static final TraceComponent tc = Tr.register(ObjectPoolImpl.class, null, "com.ibm.ws.objectpool.ObjectPoolMessages");
    ObjectPool pool;
    ObjectName myObjectName;

    public ObjectPoolImpl(ObjectPoolManagerProperties objectPoolManagerProperties, ObjectPool objectPool, Class clazz) throws IllegalAccessException, InstantiationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{objectPoolManagerProperties, objectPool, clazz});
        }
        this.pool = objectPool;
        if (ObjectPoolUtility.isServerProcess()) {
            this.createObjectPoolMBean(objectPoolManagerProperties, clazz);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public synchronized Object getObject() {
        return this.pool.getObject();
    }

    public synchronized void returnObject(Object object) {
        this.pool.returnObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean returnObject(Object object, int n) {
        BoundedObjectPool boundedObjectPool;
        if (n == -1) {
            this.returnObject(object);
            return true;
        }
        try {
            boundedObjectPool = (BoundedObjectPool)this.pool;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Upper bound is not supported on object pool: " + this.pool);
        }
        ObjectPoolImpl objectPoolImpl = this;
        synchronized (objectPoolImpl) {
            return boundedObjectPool.returnObject(object, n);
        }
    }

    public synchronized void flushPool() {
        if (this.pool instanceof CustomObjectPool) {
            ((CustomObjectPool)this.pool).flushPool();
        }
        if (this.pool instanceof FastObjectPoolImpl) {
            ((FastObjectPoolImpl)this.pool).flushPool();
        }
    }

    private void createObjectPoolMBean(ObjectPoolManagerProperties objectPoolManagerProperties, Class clazz) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createObjectPoolMBean", new Object[]{objectPoolManagerProperties, clazz, Integer.toHexString(clazz.hashCode())});
        }
        String string = null;
        Properties properties = new Properties();
        properties.put("objectpoolmanager", objectPoolManagerProperties.getName());
        properties.put("pooledclass", clazz.getName());
        try {
            string = objectPoolManagerProperties.getObjectPoolMBeanName(clazz);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering MBean: " + string);
            }
            this.myObjectName = (ObjectName)AccessController.doPrivileged((PrivilegedExceptionAction)new ActivateMBeanPA("ObjectPool", new DefaultRuntimeCollaborator(this), string, null, properties));
            String string2 = objectPoolManagerProperties.getLegacyObjectPoolMBeanName(clazz);
            if (!string.equals(string2)) {
                string = string2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registering MBean: " + string);
                }
                AccessController.doPrivileged((PrivilegedExceptionAction)new ActivateMBeanPA("ObjectPool", new DefaultRuntimeCollaborator(this), string, null, properties));
            }
        }
        catch (Exception exception) {
            if (exception instanceof PrivilegedActionException) {
                Exception exception2;
                Throwable throwable;
                for (throwable = exception; throwable != null; throwable = throwable.getCause()) {
                    if (!(throwable instanceof InstanceAlreadyExistsException)) continue;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "MBean was already registered.");
                        }
                        exception2 = null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Deregistering MBean: " + string);
                        }
                        AccessController.doPrivileged((PrivilegedExceptionAction)new DeactivateMBeanPA(string));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Registering a new MBean: " + string);
                        }
                        AccessController.doPrivileged((PrivilegedExceptionAction)new ActivateMBeanPA("ObjectPool", new DefaultRuntimeCollaborator(this), string, null, properties));
                    }
                    catch (Exception exception3) {
                        FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.asynchbeans.pool.ObjectPoolImpl.createObjectPoolMBean", "138", this);
                        Tr.warning(tc, "WARN_OBJPOOL_MBEAN_ACTIVATION_EXCEPT", new Object[]{exception3, string});
                        if (!tc.isEventEnabled()) break;
                        Tr.event(tc, "Exception activating ObjectPool MBean " + string, exception3);
                    }
                    break;
                }
                if (exception2 != null) {
                    throwable = (PrivilegedActionException)exception2;
                    exception2 = ((PrivilegedActionException)throwable).getException();
                    FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.asynchbeans.pool.ObjectPoolImpl.createObjectPoolMBean", "138", this);
                    Tr.warning(tc, "WARN_OBJPOOL_MBEAN_ACTIVATION_EXCEPT", new Object[]{exception2, string});
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception activating ObjectPool MBean " + string, exception2);
                    }
                }
            }
            Tr.error(tc, "Exception activating ObjectPool MBean " + string, exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createObjectPoolMBean");
        }
    }

    private class DeactivateMBeanPA
    implements PrivilegedExceptionAction {
        private String mbeanID;

        DeactivateMBeanPA(String string) {
            this.mbeanID = string;
        }

        public Object run() throws AdminException {
            Object var1_1 = null;
            AdminServiceFactory.getMBeanFactory().deactivateMBean(this.mbeanID);
            return var1_1;
        }
    }

    private class ActivateMBeanPA
    implements PrivilegedExceptionAction {
        private MBeanFactory mbeanFactory;
        private String name;
        private RuntimeCollaborator runtimeCollaborator;
        private String mbeanID;
        private String arg;
        private Properties props;

        ActivateMBeanPA(String string, RuntimeCollaborator runtimeCollaborator, String string2, String string3, Properties properties) {
            this.name = string;
            this.runtimeCollaborator = runtimeCollaborator;
            this.mbeanID = string2;
            this.arg = string3;
            this.props = properties;
        }

        public Object run() throws AdminException {
            return AdminServiceFactory.getMBeanFactory().activateMBean(this.name, this.runtimeCollaborator, this.mbeanID, this.arg, this.props);
        }
    }
}

