/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectpool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.pool.CustomObjectPool;
import com.ibm.websphere.asynchbeans.pool.ObjectPool;
import com.ibm.websphere.asynchbeans.pool.ObjectPoolManager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.objectpool.CustomObjectPoolWrapper;
import com.ibm.ws.objectpool.FastObjectPoolImpl;
import com.ibm.ws.objectpool.ObjectPoolImpl;
import com.ibm.ws.objectpool.ObjectPoolManagerProperties;
import com.ibm.ws.objectpool.ObjectPoolProperties;
import com.ibm.ws.objectpool.ObjectPoolUtility;
import com.ibm.ws.objectpool.pmi.ObjectPoolPerf;
import com.ibm.ws.objectpool.pmi.ObjectPoolPmiModule;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;

public class ObjectPoolManagerImpl
implements ObjectPoolManager {
    static TraceComponent tc = Tr.register(ObjectPoolManagerImpl.class, "ObjectPoolService", "com.ibm.ws.objectpool.ObjectPoolMessages");
    private static final String PMI_STATS_CLASS_NAME = "com.ibm.ws.pmi.preprocess.objectpool_impl_StatsTemplateLookup";
    private static boolean arePMIStatsRegistered;
    ObjectPoolManagerProperties props;
    Map poolList;
    ObjectName myObjectName;
    Map pmiModules = new HashMap();

    public ObjectPoolManagerImpl(ObjectPoolManagerProperties objectPoolManagerProperties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", objectPoolManagerProperties);
        }
        this.poolList = new HashMap();
        this.props = objectPoolManagerProperties;
        if (ObjectPoolUtility.isServerProcess()) {
            this.createObjectPoolManagerMBean();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void flushPool() {
        this.flushPools();
    }

    public synchronized void flushPools() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flushPools", this);
        }
        Iterator iterator = this.poolList.values().iterator();
        while (iterator.hasNext()) {
            ObjectPoolImpl objectPoolImpl = (ObjectPoolImpl)iterator.next();
            objectPoolImpl.flushPool();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flushPools", this);
        }
    }

    public synchronized ObjectPool getPool(Class clazz) throws InstantiationException, IllegalAccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPool");
        }
        try {
            if (!this.poolList.containsKey(clazz)) {
                ObjectPool objectPool = null;
                objectPool = this.createFastPool(clazz);
                ObjectPoolImpl objectPoolImpl = new ObjectPoolImpl(this.props, objectPool, clazz);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Object Pool: " + clazz + "Added to hash map using key: " + clazz);
                }
                this.poolList.put(clazz, objectPoolImpl);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPool new pool was created", objectPoolImpl);
                }
                return objectPoolImpl;
            }
            ObjectPool objectPool = (ObjectPool)this.poolList.get(clazz);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPool", objectPool);
            }
            return objectPool;
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.asynchbeans.pool.ObjectPoolManagerImpl.getPool", "55", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPool", instantiationException);
            }
            throw instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.asynchbeans.pool.ObjectPoolManagerImpl.getPool", "61", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPool", illegalAccessException);
            }
            throw illegalAccessException;
        }
    }

    void createObjectPoolManagerMBean() {
        block5: {
            String string = null;
            try {
                string = this.props.getMBeanName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registering MBean: " + string);
                }
                Properties properties = new Properties();
                properties.put("objectpoolmanager", this.props.getName());
                this.myObjectName = (ObjectName)AccessController.doPrivileged(new ActivateMBeanPA(AdminServiceFactory.getMBeanFactory(), "ObjectPoolManager", new DefaultRuntimeCollaborator(this), string, null, properties));
                String string2 = this.props.getLegacyMBeanName();
                if (!string.equals(string2)) {
                    string = string2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Registering MBean: " + string);
                    }
                    AccessController.doPrivileged(new ActivateMBeanPA(AdminServiceFactory.getMBeanFactory(), "ObjectPoolManager", new DefaultRuntimeCollaborator(this), string, null, properties));
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException == null) break block5;
                Exception exception = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.asynchbeans.pool.ObjectPoolManagerImpl.createObjectPoolManagerMBean", "169", this);
                Tr.warning(tc, "WARN_OBJPOOLMGR_MBEAN_ACTIVATION_EXCEPT", new Object[]{exception, string});
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Exception activating ObjectPoolManager MBean " + string, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectPool createFastPool(Class clazz) throws InstantiationException, IllegalAccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFastPool", clazz);
        }
        final ObjectPoolProperties objectPoolProperties = this.props.getCustomObjectPoolProperties(clazz.getName());
        try {
            FastObjectPoolImpl fastObjectPoolImpl;
            ObjectPool objectPool = null;
            if (objectPoolProperties != null) {
                fastObjectPoolImpl = null;
                try {
                    fastObjectPoolImpl = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                            Class<?> clazz = Class.forName(objectPoolProperties.poolImpl, false, classLoader);
                            return clazz.newInstance();
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable == null) {
                        throw new RuntimeException(privilegedActionException.getMessage(), privilegedActionException);
                    }
                    if (throwable instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)throwable;
                    }
                    if (throwable instanceof InstantiationException) {
                        throw (InstantiationException)throwable;
                    }
                    if (throwable instanceof IllegalAccessException) {
                        throw (IllegalAccessException)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new RuntimeException(privilegedActionException.getMessage(), throwable);
                }
                objectPool = fastObjectPoolImpl instanceof CustomObjectPool ? new CustomObjectPoolWrapper(fastObjectPoolImpl) : (ObjectPool)fastObjectPoolImpl;
                ((CustomObjectPool)objectPool).setProperties(objectPoolProperties.props);
            } else {
                objectPool = fastObjectPoolImpl = new FastObjectPoolImpl(clazz);
                if (!PmiRegistry.isDisabled()) {
                    Object object;
                    if (!arePMIStatsRegistered) {
                        try {
                            arePMIStatsRegistered = true;
                            object = Class.forName(PMI_STATS_CLASS_NAME);
                            StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)((Class)object).newInstance());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            FFDCFilter.processException((Throwable)classNotFoundException, this.getClass().getName() + ".createFastPool", "242", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Generated PMI class not found:", PMI_STATS_CLASS_NAME);
                            }
                            Tr.warning(tc, "MSG_KEY_UNEX_EXCEPT", classNotFoundException);
                        }
                    }
                    object = new ObjectPoolPerf[2];
                    String string = this.props.getLegacyObjectPoolMBeanName(clazz);
                    String string2 = this.props.getObjectPoolMBeanName(clazz);
                    Map map = this.pmiModules;
                    synchronized (map) {
                        object[0] = (ObjectPoolPerf)this.pmiModules.get(string);
                        if (object[0] == null) {
                            object[0] = new ObjectPoolPmiModule(string);
                            this.pmiModules.put(string, object[0]);
                        }
                        if ((object[1] = (ObjectPoolPerf)this.pmiModules.get(string2)) == null) {
                            object[1] = new ObjectPoolPmiModule(string2);
                            this.pmiModules.put(string2, object[1]);
                        }
                    }
                    fastObjectPoolImpl.setPmi((ObjectPoolPerf[])object);
                }
            }
            fastObjectPoolImpl = objectPool;
            return fastObjectPoolImpl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Custom Pool not found " + objectPoolProperties.className);
            }
            ObjectPool objectPool = null;
            return objectPool;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createFastPool");
            }
        }
    }

    private class ActivateMBeanPA
    implements PrivilegedExceptionAction {
        private MBeanFactory mbeanFactory;
        private String name;
        private RuntimeCollaborator runtimeCollaborator;
        private String mbeanID;
        private String arg;
        private Properties props;

        ActivateMBeanPA(MBeanFactory mBeanFactory, String string, RuntimeCollaborator runtimeCollaborator, String string2, String string3, Properties properties) {
            this.mbeanFactory = mBeanFactory;
            this.name = string;
            this.runtimeCollaborator = runtimeCollaborator;
            this.mbeanID = string2;
            this.arg = string3;
            this.props = properties;
        }

        public Object run() throws AdminException {
            return this.mbeanFactory.activateMBean(this.name, this.runtimeCollaborator, this.mbeanID, this.arg, this.props);
        }
    }
}

