/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectpool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.objectpoolmanager.ObjectPool;
import com.ibm.websphere.models.config.objectpoolmanager.ObjectPoolManagerInfo;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.objectpool.ObjectPoolProperties;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class ObjectPoolManagerProperties
implements Serializable {
    private static final long serialVersionUID = 176617060156131303L;
    static TraceComponent tc = Tr.register(ObjectPoolManagerProperties.class, "ObjectPoolService", "com.ibm.ws.objectpool.ObjectPoolMessages");
    private static char[] INVALID_MBEAN_CHARS = new char[]{':', '\"', ',', '=', '*', '?'};
    private String name;
    private String jndiName;
    private Map customObjectPools;

    public ObjectPoolManagerProperties(ObjectPoolManagerInfo objectPoolManagerInfo) {
        this.customObjectPools = new HashMap();
        this.name = objectPoolManagerInfo.getName();
        this.jndiName = objectPoolManagerInfo.getJndiName();
        EList eList = objectPoolManagerInfo.getObjectPools();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ObjectPool objectPool = (ObjectPool)iterator.next();
            EList eList2 = objectPool.getProperties();
            HashMap<String, String> hashMap = new HashMap<String, String>(eList2.size());
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                Property property = (Property)iterator2.next();
                hashMap.put(property.getName(), property.getValue());
            }
            this.addCustomObjectPool(objectPool.getPoolClassName(), objectPool.getPoolImplClassName(), hashMap);
        }
    }

    public ObjectPoolManagerProperties(String string, String string2) {
        this.name = string;
        this.jndiName = string2;
        this.customObjectPools = new HashMap();
    }

    public void addCustomObjectPool(String string, String string2, Map map) {
        boolean bl = tc.isDebugEnabled();
        ObjectPoolProperties objectPoolProperties = new ObjectPoolProperties();
        objectPoolProperties.className = string;
        objectPoolProperties.poolImpl = string2;
        objectPoolProperties.props = map;
        this.customObjectPools.put(string, objectPoolProperties);
        if (bl) {
            Tr.debug(tc, "Found CustomObject Pool: " + objectPoolProperties);
        }
    }

    ObjectPoolProperties getCustomObjectPoolProperties(String string) {
        return (ObjectPoolProperties)this.customObjectPools.get(string);
    }

    final String getLegacyMBeanName() {
        return new String(new StringBuffer(50).append("ObjectPoolManager_").append(ObjectPoolManagerProperties.getMBeanValue(this.name)));
    }

    final String getLegacyObjectPoolMBeanName(Class clazz) {
        return new String(new StringBuffer(200).append("ObjectPool_").append(this.name).append('_').append(clazz.getName()));
    }

    final String getMBeanName() {
        return new String(new StringBuffer(50).append("ObjectPoolManager_").append(ObjectPoolManagerProperties.getMBeanValue(this.jndiName == null ? this.name : this.jndiName)));
    }

    private static String getMBeanValue(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        block0: for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            for (int j = 0; j < INVALID_MBEAN_CHARS.length; ++j) {
                if (INVALID_MBEAN_CHARS[j] != c) continue;
                stringBuffer.setCharAt(i, '.');
                continue block0;
            }
        }
        return stringBuffer.toString();
    }

    final String getName() {
        return this.name;
    }

    final String getObjectPoolMBeanName(Class clazz) {
        return new String(new StringBuffer(200).append("ObjectPool_").append(ObjectPoolManagerProperties.getMBeanValue(this.jndiName == null ? this.name : this.jndiName)).append('_').append(clazz.getName()).append(".class@").append(Integer.toHexString(clazz.hashCode())));
    }
}

