/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectpool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.pool.ObjectPoolManager;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.objectpool.ObjectPoolManagerImpl;
import com.ibm.ws.objectpool.ObjectPoolManagerProperties;
import com.ibm.ws.objectpool.ObjectPoolService;
import com.ibm.ws.objectpool.naming.ObjectPoolManagerBinder;
import com.ibm.ws.objectpool.naming.ObjectPoolManagerFactory;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ResourceMgr;

public class ObjectPoolServiceImpl
extends ComponentImpl
implements ObjectPoolService {
    static final TraceComponent tc = Tr.register(ObjectPoolServiceImpl.class, "ObjectPoolService", "com.ibm.ws.objectpool.ObjectPoolMessages");
    static ObjectPoolManagerImpl systemObjectPoolManager = null;
    private com.ibm.websphere.models.config.objectpoolservice.ObjectPoolService config = null;
    private boolean isConfigAvailable = false;

    public void initialize(Object object) throws ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.isConfigAvailable = object != null && object instanceof com.ibm.websphere.models.config.objectpoolservice.ObjectPoolService;
        boolean bl = true;
        if (this.isConfigAvailable) {
            this.config = (com.ibm.websphere.models.config.objectpoolservice.ObjectPoolService)object;
            bl = this.config.isEnable();
        }
        try {
            systemObjectPoolManager = ObjectPoolManagerFactory.getSystemObjectPoolManager();
            this.addService(ObjectPoolService.class, this);
            if (!bl) {
                Tr.info(tc, "OBJPOOLMGR_NOT_ENABLED");
                throw new ComponentDisabledException("The ObjectPool service is not enabled.");
            }
        }
        catch (ComponentDisabledException componentDisabledException) {
            throw componentDisabledException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.objectpool.ObjectPoolServiceImpl.initialize", "100", this);
            Tr.warning(tc, "OBJPOOLMGR_DISABLED");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while initializing the ObjectPoolService: " + throwable.getMessage(), throwable);
            }
            throw new ComponentDisabledException(throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
    }

    public ObjectPoolManager getSystemObjectPoolManager() {
        return systemObjectPoolManager;
    }

    public static ObjectPoolManagerImpl systemObjectPoolManager() {
        return systemObjectPoolManager;
    }

    public ObjectPoolManager createObjectPoolManager(ObjectPoolManagerProperties objectPoolManagerProperties) {
        return systemObjectPoolManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        ResourceMgr resourceMgr = null;
        try {
            resourceMgr = (ResourceMgr)this.getService(ResourceMgr.class);
            ObjectPoolManagerBinder objectPoolManagerBinder = new ObjectPoolManagerBinder();
            resourceMgr.addResourceBinder(objectPoolManagerBinder);
            Tr.info(tc, "OBJPOOLMGR_STARTED");
        }
        finally {
            if (resourceMgr != null) {
                this.releaseService(resourceMgr);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start");
            }
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }
}

