/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectpool.naming;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.pool.ObjectPoolManager;
import com.ibm.ws.objectpool.ArrayListObjectPool;
import com.ibm.ws.objectpool.ObjectPoolManagerImpl;
import com.ibm.ws.objectpool.ObjectPoolManagerProperties;
import com.ibm.ws.objectpool.ObjectPoolServiceImpl;
import com.ibm.ws.objectpool.naming.ObjectPoolManagerKey;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class ObjectPoolManagerFactory
implements ObjectFactory {
    static final TraceComponent tc = Tr.register(ObjectPoolManagerFactory.class, "ObjectPoolService", "com.ibm.ws.objectpool.ObjectPoolMessages");
    static Map poolManagers = new Hashtable();
    static ObjectPoolManagerImpl systemObjectPoolManager = null;

    public static synchronized ObjectPoolManagerImpl getSystemObjectPoolManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemObjectPoolManager");
        }
        if (systemObjectPoolManager == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating the system ObjectPoolManager");
            }
            ObjectPoolManagerProperties objectPoolManagerProperties = new ObjectPoolManagerProperties("ibm.system.objectpool", null);
            objectPoolManagerProperties.addCustomObjectPool(ArrayList.class.getName(), ArrayListObjectPool.class.getName(), null);
            systemObjectPoolManager = new ObjectPoolManagerImpl(objectPoolManagerProperties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemObjectPoolManager", systemObjectPoolManager);
        }
        return systemObjectPoolManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object object, Name name2, Context context, Hashtable hashtable) throws Exception {
        Reference reference = (Reference)object;
        ObjectPoolManager objectPoolManager = null;
        Map map = poolManagers;
        synchronized (map) {
            ObjectPoolManagerKey objectPoolManagerKey = new ObjectPoolManagerKey(name2, context);
            objectPoolManager = (ObjectPoolManager)poolManagers.get(objectPoolManagerKey);
            if (objectPoolManager == null) {
                BinaryRefAddr binaryRefAddr = (BinaryRefAddr)reference.get("props");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])binaryRefAddr.getContent());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                ObjectPoolManagerProperties objectPoolManagerProperties = (ObjectPoolManagerProperties)objectInputStream.readObject();
                objectPoolManager = new ObjectPoolManagerImpl(objectPoolManagerProperties);
                poolManagers.put(objectPoolManagerKey, objectPoolManager);
            }
        }
        return objectPoolManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void flushPools() {
        ObjectPoolManagerImpl objectPoolManagerImpl = ObjectPoolServiceImpl.systemObjectPoolManager();
        if (objectPoolManagerImpl != null) {
            objectPoolManagerImpl.flushPool();
        }
        Map map = poolManagers;
        synchronized (map) {
            Iterator iterator = poolManagers.values().iterator();
            while (iterator.hasNext()) {
                ObjectPoolManagerImpl objectPoolManagerImpl2 = (ObjectPoolManagerImpl)iterator.next();
                objectPoolManagerImpl2.flushPool();
            }
        }
    }
}

