/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectpool.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.objectpool.pmi.ObjectPoolPerf;

public class ObjectPoolPmiModule
extends PmiAbstractModule
implements ObjectPoolPerf {
    private static final long serialVersionUID = -2692366382585300309L;
    private static final TraceComponent tc = Tr.register(ObjectPoolPmiModule.class, "ObjectPoolService", "com.ibm.ws.objectpool.ObjectPoolMessages");
    public static final String moduleID = "objectPoolModule";
    private static final int defaultLevel = 0;
    private SpdLong numCreates = null;
    private SpdLong numAllocates = null;
    private SpdLong numReturns = null;
    private SpdLoad poolSize = null;
    public static final int NUM_CREATES = 1;
    public static final int NUM_ALLOCATES = 2;
    public static final int NUM_RETURNS = 3;
    public static final int POOL_SIZE = 4;

    public ObjectPoolPmiModule(String string) {
        super(moduleID, string);
        Tr.entry(tc, "ObjectPoolPmiModule");
        this.registerModule(this);
        Tr.exit(tc, "ObjectPoolPmiModule");
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.numCreates = spdLong;
                return true;
            }
            case 2: {
                this.numAllocates = spdLong;
                return true;
            }
            case 3: {
                this.numReturns = spdLong;
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            default: 
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 4: {
                this.poolSize = spdLoad;
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public void objectCreated() {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "objectCreated");
        }
        if (this.numCreates != null) {
            this.numCreates.increment();
        }
    }

    public void objectAllocated(int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "objectAllocated");
        }
        if (this.numAllocates != null) {
            this.numAllocates.increment();
        }
        if (this.poolSize != null) {
            this.poolSize.add(n);
        }
    }

    public void objectFreed(int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "objectFreed");
        }
        if (this.numReturns != null) {
            this.numReturns.increment();
        }
        if (this.poolSize != null) {
            this.poolSize.add(n);
        }
    }
}

