/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEventImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.WsLocalProcessProperties;
import com.ibm.wsspi.odc.ODCEdge;
import com.ibm.wsspi.odc.ODCEventEdgeChange;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTree;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class ODCEventEdgeChangeImpl
extends ODCEventImpl
implements ODCEventEdgeChange,
Externalizable {
    private static final TraceComponent tc = TrUtil.register(ODCEventEdgeChangeImpl.class);
    static final long serialVersionUID = 1L;
    private boolean add;
    private ODCEdge edge;
    public String parentPath;
    public String childPath;

    public ODCEventEdgeChangeImpl() {
    }

    public ODCEventEdgeChangeImpl(boolean bl, ODCEdge oDCEdge, boolean bl2, String string) {
        super(oDCEdge.getType(), bl2, string);
        this.add = bl;
        this.edge = oDCEdge;
        this.setEventType(oDCEdge.getType());
        this.parentPath = oDCEdge.getSrcNode().getPath();
        this.childPath = oDCEdge.getDstNode().getPath();
    }

    public boolean isAdd() {
        return this.add;
    }

    public ODCEdge getEdge() {
        return this.edge;
    }

    public ODCNode getSrcNode() {
        return this.edge.getSrcNode();
    }

    public ODCNode getDstNode() {
        return this.edge.getDstNode();
    }

    public void performEvent(ODCTree oDCTree) throws ODCException {
        if (this.edge == null) {
            throw new IllegalStateException("edge is null; should not be performing deserialized edge change event");
        }
        ODCNode oDCNode = null;
        ODCNode oDCNode2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performEvent", this);
        }
        oDCNode = this.getSrcNode();
        oDCNode2 = this.getDstNode();
        if (this.add) {
            oDCNode.addEdge(oDCNode2);
        } else {
            oDCNode.removeEdge(oDCNode2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performEvent", this);
        }
    }

    public void reverseEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reverseEvent", this);
        }
        boolean bl = this.add = !this.add;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reverseEvent", this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.add ? "addEdge " : "removeEdge ");
        stringBuffer.append(this.parentPath).append(" --> ").append(this.childPath);
        return stringBuffer.toString();
    }

    public boolean isReverse(ODCEventImpl oDCEventImpl) {
        boolean bl = false;
        if (oDCEventImpl instanceof ODCEventEdgeChangeImpl) {
            ODCEventEdgeChangeImpl oDCEventEdgeChangeImpl = (ODCEventEdgeChangeImpl)oDCEventImpl;
            if (oDCEventEdgeChangeImpl.parentPath.equals(this.parentPath) && oDCEventEdgeChangeImpl.childPath.equals(this.childPath)) {
                bl = oDCEventEdgeChangeImpl.add != this.add;
            }
        } else {
            bl = super.isReverse(oDCEventImpl);
        }
        return bl;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object v = WsLocalProcessProperties.getPropertiesMap().get("GROUP_VERSION");
        int n = v == null ? 2 : (Integer)v;
        if (n < 2) {
            String string = "/cellGroup/" + this.getSrcNode().getTreeName();
            Serial serial = new Serial();
            serial.parentPath = string + this.parentPath;
            serial.childPath = string + this.childPath;
            serial.edgePath = string + this.edge.getSrcNode().getPath() + "::" + string + this.edge.getDstNode().getPath();
            serial.local = this.isLocal();
            serial.add = this.add;
            objectOutput.writeObject(serial);
        } else {
            objectOutput.writeShort(n);
            objectOutput.writeObject(this.getCause());
            objectOutput.writeShort(n);
            objectOutput.writeBoolean(this.add);
            objectOutput.writeObject(this.parentPath);
            objectOutput.writeObject(this.childPath);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        try {
            objectInput.readShort();
            n = 2;
        }
        catch (Exception exception) {
            n = 0;
        }
        if (n < 2) {
            Serial serial = (Serial)objectInput.readObject();
            this.parentPath = serial.parentPath;
            this.parentPath = this.parentPath.replaceFirst("^/cellGroup/.*?/", "/");
            this.childPath = serial.childPath;
            this.childPath = this.childPath.replaceFirst("^/cellGroup/.*?/", "/");
            this.add = serial.add;
        } else {
            this.setCause((String)objectInput.readObject());
            objectInput.readShort();
            this.add = objectInput.readBoolean();
            this.parentPath = (String)objectInput.readObject();
            this.childPath = (String)objectInput.readObject();
        }
    }

    class Serial
    implements Serializable {
        private static final long serialVersionUID = -3647086044051418098L;
        String parentPath;
        String childPath;
        String edgePath;
        boolean add;
        boolean local;

        Serial() {
        }
    }
}

