/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEventImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.WsLocalProcessProperties;
import com.ibm.wsspi.odc.ODCEventNodeChange;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTree;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ODCEventNodeChangeImpl
extends ODCEventImpl
implements ODCEventNodeChange,
Externalizable {
    private static final TraceComponent tc = TrUtil.register(ODCEventNodeChangeImpl.class);
    static final long serialVersionUID = 1L;
    private boolean add;
    private ODCNode node = null;
    public String parentPath;
    public String nodeTypeName;
    public String nodeName;

    public ODCEventNodeChangeImpl() {
    }

    public ODCEventNodeChangeImpl(boolean bl, ODCNode oDCNode, boolean bl2, String string) {
        super(oDCNode.getType(), bl2, string);
        this.node = oDCNode;
        this.add = bl;
        this.setEventType(oDCNode.getType());
        try {
            ODCNode oDCNode2 = oDCNode.getParent();
            this.parentPath = oDCNode2 != null ? oDCNode2.getPath() : "";
            this.nodeTypeName = oDCNode.getType().getName();
            this.nodeName = oDCNode.getName();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean isAdd() {
        return this.add;
    }

    public ODCNode getNode() {
        return this.node;
    }

    public void performEvent(ODCTree oDCTree) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performEvent", this);
        }
        if (this.node == null) {
            throw new IllegalStateException("node is null; should not be performing deserialized node change event");
        }
        if (this.isAdd()) {
            oDCTree.registerNode(this.node, this.isLocal());
        } else {
            oDCTree.unregisterNode(this.node, this.isLocal());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performEvent");
        }
    }

    public void reverseEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reverseEvent", this);
        }
        boolean bl = this.add = !this.add;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reverseEvent", this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.isAdd() ? "add " : "remove ");
        stringBuffer.append(this.parentPath).append("/").append(this.nodeTypeName).append("/").append(this.nodeName);
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object v = WsLocalProcessProperties.getPropertiesMap().get("GROUP_VERSION");
        int n = v == null ? 2 : (Integer)v;
        if (n < 2) {
            String string = "/cellGroup/" + this.getNode().getTreeName();
            objectOutput.writeInt(0);
            objectOutput.writeBoolean(this.isAdd());
            objectOutput.writeBoolean(this.isLocal());
            objectOutput.writeObject(this.nodeName);
            objectOutput.writeObject(string + this.getNode().getPath());
            objectOutput.writeObject(this.nodeTypeName);
            try {
                if (this.getNode().getParent() == null) {
                    objectOutput.writeObject(null);
                }
                objectOutput.writeObject(string + this.parentPath);
            }
            catch (ODCException oDCException) {
                throw new IOException(oDCException.getMessage());
            }
        } else {
            objectOutput.writeShort(n);
            objectOutput.writeObject(this.getCause());
            objectOutput.writeShort(n);
            objectOutput.writeBoolean(this.isAdd());
            objectOutput.writeObject(this.parentPath);
            objectOutput.writeObject(this.nodeTypeName);
            objectOutput.writeObject(this.nodeName);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readShort();
        if (n < 2) {
            try {
                short s = objectInput.readShort();
            }
            catch (Exception exception) {
                n = 2;
            }
        }
        if (n < 2) {
            this.add = objectInput.readBoolean();
            objectInput.readBoolean();
            this.nodeName = (String)objectInput.readObject();
            objectInput.readObject();
            this.nodeTypeName = (String)objectInput.readObject();
            this.parentPath = (String)objectInput.readObject();
            if (this.parentPath != null) {
                if (this.parentPath.matches("/cellGroup/[^/]+")) {
                    this.parentPath = "";
                } else {
                    this.parentPath = this.parentPath.replaceFirst("^/cellGroup/.*?/", "/");
                    if (this.parentPath.equals("/")) {
                        this.parentPath = "";
                    }
                }
            } else {
                this.parentPath = "";
            }
        } else {
            this.setCause((String)objectInput.readObject());
            objectInput.readShort();
            this.add = objectInput.readBoolean();
            this.parentPath = (String)objectInput.readObject();
            this.nodeTypeName = (String)objectInput.readObject();
            this.nodeName = (String)objectInput.readObject();
        }
    }
}

