/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEventEdgeChangeImpl;
import com.ibm.ws.odc.ODCEventImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.WsLocalProcessProperties;
import com.ibm.wsspi.odc.ODCEventSetProperty;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCPropertyValueWrapper;
import com.ibm.wsspi.odc.ODCTree;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ODCEventSetPropertyImpl
extends ODCEventImpl
implements ODCEventSetProperty,
Externalizable {
    private static final TraceComponent tc = TrUtil.register(ODCEventEdgeChangeImpl.class);
    static final long serialVersionUID = 1L;
    private ODCNode node;
    private Object newVal;
    private Object oldVal;
    public String nodePath;
    public String propertyName;

    public ODCEventSetPropertyImpl() {
    }

    public ODCEventSetPropertyImpl(ODCPropertyDescriptor oDCPropertyDescriptor, ODCNode oDCNode, Object object, boolean bl, String string) {
        super(oDCPropertyDescriptor, bl, string);
        this.node = oDCNode;
        this.newVal = object;
        this.oldVal = null;
        this.nodePath = oDCNode.getPath();
        this.propertyName = oDCPropertyDescriptor.getName();
    }

    public void setNode(ODCNode oDCNode) {
        this.node = oDCNode;
    }

    public ODCNode getNode() {
        return this.node;
    }

    public ODCPropertyDescriptor getPropertyDescriptor() {
        return (ODCPropertyDescriptor)this.getEventType();
    }

    public Object getOldValue() {
        return this.unwrapValue(this.oldVal);
    }

    public Object getRawOldValue() {
        return this.oldVal;
    }

    public void setOldValue(Object object) {
        this.oldVal = object;
    }

    public Object getNewValue() {
        return this.unwrapValue(this.newVal);
    }

    public Object getRawNewValue() {
        return this.newVal;
    }

    public void setNewValue(Object object) {
        this.newVal = object;
    }

    protected Object unwrapValue(Object object) {
        if (object instanceof ODCPropertyValueWrapper) {
            return ((ODCPropertyValueWrapper)object).getPropVal();
        }
        return object;
    }

    public void performEvent(ODCTree oDCTree) throws ODCException {
        if (this.node == null) {
            throw new IllegalStateException("node is null; should not be performing deserialized setProperty event");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performEvent", this);
        }
        this.node.setProperty(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performEvent", this);
        }
    }

    public void reverseEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reverseEvent", this);
        }
        Object object = this.oldVal;
        this.oldVal = this.newVal;
        this.newVal = object;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reverseEvent", this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("setProperty ").append(this.propertyName).append(" on ").append(this.nodePath);
        stringBuffer.append(" ").append(this.nodePath);
        stringBuffer.append(", oldVal=").append(this.oldVal);
        stringBuffer.append(", newVal=").append(this.newVal);
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object v = WsLocalProcessProperties.getPropertiesMap().get("GROUP_VERSION");
        int n = v == null ? 2 : (Integer)v;
        if (n < 2) {
            try {
                String string = "/cellGroup/" + this.node.getTreeName();
                objectOutput.writeInt(0);
                objectOutput.writeObject(this.node.getName());
                objectOutput.writeObject(string + this.node.getPath());
                objectOutput.writeObject(this.node.getType().getName());
                objectOutput.writeObject(this.node.getParent() == null ? null : string + this.node.getParent().getPath());
                objectOutput.writeObject(this.oldVal);
                objectOutput.writeObject(this.newVal);
                objectOutput.writeBoolean(this.isLocal());
                ODCPropertyDescriptor oDCPropertyDescriptor = (ODCPropertyDescriptor)this.getEventType();
                objectOutput.writeObject(oDCPropertyDescriptor.getNodeType().getName());
                objectOutput.writeObject(oDCPropertyDescriptor.getName());
            }
            catch (ODCException oDCException) {
                throw new IOException(oDCException.getMessage());
            }
        } else {
            objectOutput.writeShort(n);
            objectOutput.writeObject(this.getCause());
            objectOutput.writeShort(n);
            objectOutput.writeObject(this.nodePath);
            objectOutput.writeObject(this.propertyName);
            objectOutput.writeObject(this.newVal);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readShort();
        if (n < 2) {
            try {
                objectInput.readShort();
            }
            catch (Exception exception) {
                n = 2;
            }
        }
        if (n < 2) {
            objectInput.readObject();
            this.nodePath = (String)objectInput.readObject();
            this.nodePath = this.nodePath.replaceFirst("^/cellGroup/.*?/", "/");
            objectInput.readObject();
            objectInput.readObject();
            objectInput.readObject();
            this.newVal = objectInput.readObject();
            this.setLocal(objectInput.readBoolean());
            objectInput.readObject();
            this.propertyName = (String)objectInput.readObject();
        } else {
            this.setCause((String)objectInput.readObject());
            objectInput.readShort();
            this.nodePath = (String)objectInput.readObject();
            this.propertyName = (String)objectInput.readObject();
            this.newVal = objectInput.readObject();
        }
    }
}

