/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.channel.framework.impl.CFEndPointImpl;
import com.ibm.ws.odc.ODCEdgeImpl;
import com.ibm.ws.odc.ODCEdgeTypeImpl;
import com.ibm.ws.odc.ODCEventEdgeChangeImpl;
import com.ibm.ws.odc.ODCEventNodeChangeImpl;
import com.ibm.ws.odc.ODCEventSetPropertyImpl;
import com.ibm.ws.odc.ODCNodeTypeImpl;
import com.ibm.ws.odc.ODCObjectImpl;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.ws.odc.ODCSchemaImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.util.Base64;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCEventSetProperty;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCProperties;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCPropertyType;
import com.ibm.wsspi.odc.ODCPropertyValueWrapper;
import com.ibm.wsspi.odc.ODCTree;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ODCNodeImpl
extends ODCObjectImpl
implements ODCNode {
    private static final TraceComponent tc = TrUtil.register(ODCNodeImpl.class);
    private String name;
    private String typedName;
    private ODCNodeTypeImpl type;
    private int index;
    private final ODCNodeImpl parent;
    private final boolean local;
    private ODCTree tree;
    private String treeName;
    private ODCProperties props;
    private NodeList allParents = new NodeList();
    private NodeList[] typedParents;
    private NodeList allChildren = new NodeList();
    private NodeList[] typedChildren;
    private boolean registered;
    private final Properties transientProperties = new Properties();
    private Object sync;
    private static final ODCNodeImpl[] nullNodeArray = new ODCNodeImpl[0];
    private final boolean onMyCell;
    private final boolean onMyNode;
    private final boolean onMyServer;

    public ODCNodeImpl(String string, ODCNodeType oDCNodeType, ODCTree oDCTree) {
        this.parent = null;
        this.local = false;
        this.setTree(oDCTree);
        this.init(string, (ODCNodeTypeImpl)oDCNodeType, null);
        this.onMyServer = false;
        this.onMyNode = false;
        this.onMyCell = false;
    }

    public ODCNodeImpl(String string, ODCNodeType oDCNodeType, ODCNode oDCNode, boolean bl) throws ODCException {
        ODCHelper oDCHelper;
        this.parent = (ODCNodeImpl)oDCNode;
        this.local = bl;
        this.setTree(oDCNode.getTree());
        this.init(string, (ODCNodeTypeImpl)oDCNodeType, oDCNode.getPath());
        AdminService adminService = AdminServiceFactory.getAdminService();
        try {
            oDCHelper = ODCHelper.getInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.onMyCell = oDCNodeType == oDCHelper.cell ? string.equals(adminService.getCellName()) : oDCNode.isOnMyCell();
        this.onMyNode = oDCNodeType == oDCHelper.node ? this.onMyCell & string.equals(adminService.getNodeName()) : oDCNode.isOnMyNode();
        this.onMyServer = oDCNodeType == oDCHelper.server ? this.onMyNode & string.equals(adminService.getProcessName()) : oDCNode.isOnMyServer();
    }

    public boolean isOnMyCell() {
        return this.onMyCell;
    }

    public boolean isOnMyNode() {
        return this.onMyNode;
    }

    public boolean isOnMyServer() {
        return this.onMyServer;
    }

    private void init(String string, ODCNodeTypeImpl oDCNodeTypeImpl, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{string, oDCNodeTypeImpl, string2});
        }
        this.name = string;
        this.type = oDCNodeTypeImpl;
        this.typedName = "/" + oDCNodeTypeImpl.name + "/" + string;
        this.longName = string2 == null ? "" : string2 + this.typedName;
        this.index = oDCNodeTypeImpl.index;
        this.sync = this;
        this.registered = false;
        this.initTypedParents(oDCNodeTypeImpl.schema);
        this.initTypedChildren(oDCNodeTypeImpl.schema);
        this.props = oDCNodeTypeImpl.propertiesFactory.create();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getTypedName() {
        return this.typedName;
    }

    public String getPath() {
        return this.longName;
    }

    public ODCNodeType getType() {
        return this.type;
    }

    public boolean is(ODCNodeType oDCNodeType) {
        return this.type == oDCNodeType;
    }

    public Properties getTransientProperties() {
        return this.transientProperties;
    }

    public ODCTree getTree() {
        return this.tree;
    }

    public String getTreeName() {
        return this.treeName;
    }

    public void setTree(ODCTree oDCTree) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTree", oDCTree);
        }
        this.tree = oDCTree;
        if (oDCTree != null) {
            this.sync = oDCTree;
            this.treeName = oDCTree.getName();
        } else {
            this.sync = this;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTree");
        }
    }

    public ODCNode[] getNodes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodes");
        }
        ODCNode[] oDCNodeArray = this.getParents();
        ODCNode[] oDCNodeArray2 = this.getChildren();
        ODCNode[] oDCNodeArray3 = new ODCNode[oDCNodeArray.length + oDCNodeArray2.length];
        System.arraycopy(oDCNodeArray, 0, oDCNodeArray3, 0, oDCNodeArray.length);
        System.arraycopy(oDCNodeArray2, 0, oDCNodeArray3, oDCNodeArray.length, oDCNodeArray2.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodes", oDCNodeArray3);
        }
        return oDCNodeArray3;
    }

    public int nodeCount() {
        return this.allParents.size() + this.allChildren.size();
    }

    public ODCNode getNode(ODCNodeType oDCNodeType) throws ODCException {
        if (oDCNodeType == null) {
            return null;
        }
        ODCNodeImpl.oneCheck(this.type, oDCNodeType);
        NodeList nodeList = this.getTypedList(oDCNodeType);
        if (nodeList.size() == 0) {
            return null;
        }
        return nodeList.get(0);
    }

    public ODCNode getNode(ODCNodeType oDCNodeType, String string) throws ODCException {
        if (oDCNodeType == null) {
            return null;
        }
        ODCNode[] oDCNodeArray = this.getNodes(oDCNodeType);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            if (!string.equals(oDCNodeArray[i].getName())) continue;
            return oDCNodeArray[i];
        }
        return null;
    }

    public ODCNode[] getNodes(ODCNodeType oDCNodeType) throws ODCException {
        ODCNodeImpl.manyCheck(this.type, oDCNodeType);
        int n = ((ODCNodeTypeImpl)oDCNodeType).index;
        return this.getTypedList(oDCNodeType).toArray();
    }

    public int nodeCount(ODCNodeType oDCNodeType) throws ODCException {
        NodeList nodeList = this.typedParents[((ODCNodeTypeImpl)oDCNodeType).index];
        NodeList nodeList2 = this.typedChildren[((ODCNodeTypeImpl)oDCNodeType).index];
        if (nodeList != null) {
            if (nodeList2 != null) {
                return nodeList.size() + nodeList2.size();
            }
            return nodeList.size();
        }
        if (nodeList2 != null) {
            return nodeList2.size();
        }
        throw new ODCException(this.type.getName() + " has no relationship to " + oDCNodeType.getName());
    }

    public void addNode(ODCNode oDCNode) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNode", oDCNode);
        }
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNode;
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNode.getType();
        ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCNodeTypeImpl);
        if (oDCEdgeType == null) {
            throw new ODCException("a '" + this.type.name + "' can have no relationship to a '" + oDCNodeTypeImpl.name + "'");
        }
        if (oDCEdgeType.isParent() && oDCEdgeType.isChild()) {
            throw new ODCException("a '" + this.type.name + "' can be both a parent and a child of a '" + oDCNodeTypeImpl.name + "'; must use addChild() to disambiguate");
        }
        if (oDCEdgeType.isParent()) {
            oDCNode.addChild(this);
        } else {
            this.addChild(oDCNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNode");
        }
    }

    public void removeNode(ODCNode oDCNode) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNode", oDCNode);
        }
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNode;
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNode.getType();
        ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCNodeTypeImpl);
        if (oDCEdgeType == null) {
            throw new ODCException("a '" + this.type.name + "' can have no relationship to a '" + oDCNodeTypeImpl.name + "'");
        }
        if (oDCEdgeType.isParent() && oDCEdgeType.isChild()) {
            throw new ODCException("a '" + this.type.name + "' can be both a parent and a child of a '" + oDCNodeTypeImpl.name + "'; must use removeChild() to disambiguate");
        }
        if (oDCEdgeType.isParent()) {
            oDCNode.removeChild(this);
        } else {
            this.removeChild(oDCNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNode");
        }
    }

    public void addChild(ODCNode oDCNode) throws ODCException {
        if (this.tree != null) {
            this.tree.obtainEdge(this, (ODCNodeImpl)oDCNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEdge(ODCNode oDCNode) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEdge", oDCNode);
        }
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNode;
        Object object = this.sync;
        synchronized (object) {
            ODCNodeImpl oDCNodeImpl2;
            ODCNodeTypeImpl oDCNodeTypeImpl = oDCNodeImpl.type;
            ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCNodeTypeImpl);
            if (oDCEdgeType == null) {
                throw new ODCException("a '" + this.type.name + "' can have no relationship to a '" + oDCNodeTypeImpl.name + "'");
            }
            if (!oDCEdgeType.isChild()) {
                throw new ODCException("a '" + this.type.name + "' can not have a '" + oDCNodeTypeImpl.name + "' as a child");
            }
            if (this.allChildren.contains(oDCNodeImpl)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addEdge", "already a child");
                }
                return false;
            }
            NodeList nodeList = this.typedChildren[oDCNodeTypeImpl.index];
            NodeList nodeList2 = oDCNodeImpl.typedParents[this.type.index];
            if (nodeList.size() > 0 && !oDCEdgeType.toMany()) {
                oDCNodeImpl2 = nodeList.get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "to-one ODC schema violation: parent=" + this + ", curChild=" + oDCNodeImpl2 + ", newChild=" + oDCNodeImpl);
                }
                this.removeChild(oDCNodeImpl2);
            }
            if (nodeList2.size() > 0 && !oDCEdgeType.fromMany()) {
                oDCNodeImpl2 = nodeList2.get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "from-one schema violation: child=" + oDCNodeImpl + ", curParent=" + oDCNodeImpl2 + ", newParent=" + this);
                }
                oDCNodeImpl2.removeChild(oDCNodeImpl);
            }
            this.allChildren.add(oDCNodeImpl);
            nodeList.add(oDCNodeImpl);
            oDCNodeImpl.allParents.add(this);
            nodeList2.add(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEdge");
        }
        return true;
    }

    public void removeChild(ODCNode oDCNode) throws ODCException {
        if (oDCNode.getParent() == this) {
            oDCNode.remove();
        } else if (this.tree != null) {
            this.tree.releaseEdge(this, (ODCNodeImpl)oDCNode);
        }
    }

    public void remove() throws ODCException {
        this.remove(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object object) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove - " + this);
        }
        Object object2 = this.sync;
        synchronized (object2) {
            ODCTree oDCTree = this.tree;
            ODCNode[] oDCNodeArray = this.getParents();
            for (int i = 0; i < oDCNodeArray.length; ++i) {
                ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNodeArray[i];
                if (oDCTree == null) continue;
                oDCTree.releaseEdge(oDCNodeImpl, this, object);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing children of " + this);
            }
            ODCNode[] oDCNodeArray2 = this.getChildren();
            for (int i = 0; i < oDCNodeArray2.length; ++i) {
                ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNodeArray2[i];
                ODCEdgeTypeImpl oDCEdgeTypeImpl = (ODCEdgeTypeImpl)oDCNodeImpl.type.getEdgeType(this.type);
                if (oDCTree != null) {
                    oDCTree.releaseEdge(this, oDCNodeImpl, object);
                }
                if (oDCEdgeTypeImpl.linked) continue;
                oDCNodeImpl.remove();
            }
            if (oDCTree != null) {
                oDCTree.releaseNode(this, object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEdge(ODCNode oDCNode) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEdge", new Object[]{this, oDCNode});
        }
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNode;
        Object object = this.sync;
        synchronized (object) {
            boolean bl;
            ODCNodeTypeImpl oDCNodeTypeImpl = oDCNodeImpl.type;
            ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCNodeImpl.type);
            if (oDCEdgeType == null) {
                throw new ODCException("a '" + this.type.name + "' has no relationship to a '" + oDCNodeTypeImpl.name + "'");
            }
            if (!oDCEdgeType.isChild()) {
                throw new ODCException("a '" + this.type.name + "' can not have a '" + oDCNodeTypeImpl.name + "' as a child");
            }
            if (!this.allChildren.remove(oDCNodeImpl)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeEdge - edge not found");
                }
                return false;
            }
            this.typedChildren[oDCNodeTypeImpl.index].remove(oDCNodeImpl);
            oDCNodeImpl.allParents.remove(this);
            oDCNodeImpl.typedParents[this.type.index].remove(this);
            boolean bl2 = bl = oDCNodeImpl.getParent() == this;
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "force removal of " + oDCNodeImpl);
                }
                oDCNodeImpl.remove();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEdge - done");
        }
        return true;
    }

    public ODCPropertyDescriptor[] getPropertyDescriptors() throws ODCException {
        return this.props.getDescriptors();
    }

    public Object getProperty(ODCPropertyDescriptor oDCPropertyDescriptor) throws ODCException {
        if (oDCPropertyDescriptor == null) {
            throw new IllegalArgumentException("propertyDescriptor is null");
        }
        ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl = (ODCPropertyDescriptorImpl)oDCPropertyDescriptor;
        this.propDescriptorCheck(oDCPropertyDescriptorImpl);
        return this.props.getProperty(oDCPropertyDescriptorImpl);
    }

    public void setProperty(ODCPropertyDescriptor oDCPropertyDescriptor, Object object) throws ODCException {
        this.setProperty(oDCPropertyDescriptor, object, true);
    }

    public void setProperties(Map map, boolean bl) throws ODCException {
        for (Map.Entry entry : map.entrySet()) {
            this.setProperty((String)entry.getKey(), entry.getValue(), bl);
        }
    }

    public ODCPropertyDescriptor setProperty(String string, Object object) throws ODCException {
        ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl = (ODCPropertyDescriptorImpl)this.type.getPropertyDescriptor(string, true);
        if (oDCPropertyDescriptorImpl.type != ODCPropertyType.STRING && object instanceof String) {
            object = oDCPropertyDescriptorImpl.fromString((String)object);
        }
        this.setProperty(oDCPropertyDescriptorImpl, object);
        return oDCPropertyDescriptorImpl;
    }

    public void setProperty(String string, Object object, boolean bl) throws ODCException {
        ODCPropertyDescriptor oDCPropertyDescriptor = this.type.getPropertyDescriptor(string);
        if (oDCPropertyDescriptor == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setProperty: ignoring '" + string + "'");
            }
        } else {
            this.setProperty(oDCPropertyDescriptor, object, bl);
        }
    }

    public void setProperty(ODCPropertyDescriptor oDCPropertyDescriptor, Object object, boolean bl) throws ODCException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setProperty: local=" + bl + ", desc=" + oDCPropertyDescriptor + ", value=" + object);
        }
        String string = this.tree != null ? this.tree.getCurrentTransactionName() : "setProperty (no tree)";
        this.setProperty(new ODCEventSetPropertyImpl(oDCPropertyDescriptor, this, object, bl, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(ODCEventSetProperty oDCEventSetProperty) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperty", oDCEventSetProperty);
        }
        ODCEventSetPropertyImpl oDCEventSetPropertyImpl = (ODCEventSetPropertyImpl)oDCEventSetProperty;
        ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl = (ODCPropertyDescriptorImpl)oDCEventSetPropertyImpl.getEventType();
        this.propDescriptorCheck(oDCPropertyDescriptorImpl);
        Object object = oDCEventSetPropertyImpl.getRawNewValue();
        if (!(!this.isOnMyServer() || this.tree != null && this.tree.isPerformingRemoteEvents() || object instanceof ODCPropertyValueWrapper)) {
            object = new ODCPropertyValueWrapper(object, 1);
            oDCEventSetPropertyImpl.setNewValue(object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting local server property with priority 1");
            }
        }
        Object object2 = this.sync;
        synchronized (object2) {
            Object object3 = this.props.getProperty(oDCPropertyDescriptorImpl);
            boolean bl = this.props.setProperty(oDCPropertyDescriptorImpl, object);
            if (bl && this.tree != null) {
                oDCEventSetPropertyImpl.setOldValue(object3);
                this.tree.notifyListeners(oDCEventSetProperty);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperty");
        }
    }

    public boolean getBooleanProperty(ODCPropertyDescriptor oDCPropertyDescriptor) throws ODCException {
        Object object = this.getProperty(oDCPropertyDescriptor);
        if (object == null) {
            throw new ODCException("property '" + oDCPropertyDescriptor.getName() + "' has no value for " + this.longName);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new ODCException("property '" + oDCPropertyDescriptor.getName() + "' of " + this.longName + " must be a Boolean; found a " + object.getClass().getName());
    }

    public void setBooleanProperty(ODCPropertyDescriptor oDCPropertyDescriptor, boolean bl) throws ODCException {
        this.setProperty(oDCPropertyDescriptor, (Object)new Boolean(bl));
    }

    public int getIntProperty(ODCPropertyDescriptor oDCPropertyDescriptor) throws ODCException {
        Object object = this.getProperty(oDCPropertyDescriptor);
        if (object == null) {
            throw new ODCException("property '" + oDCPropertyDescriptor.getName() + "' has no value for " + this.longName);
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new ODCException("property '" + oDCPropertyDescriptor.getName() + "' of " + this.longName + " must be a Integer; found a " + object.getClass().getName());
    }

    public void setIntProperty(ODCPropertyDescriptor oDCPropertyDescriptor, int n) throws ODCException {
        this.setProperty(oDCPropertyDescriptor, (Object)new Integer(n));
    }

    public Map getProperties() {
        return this.props.getProperties();
    }

    public Map getProperties(boolean bl) {
        return this.props.getProperties(bl);
    }

    public void addProperties(Map map) {
        this.props.addProperties(map);
    }

    public ODCNode getChild() throws ODCException {
        return this.getOne(this.allChildren, "children");
    }

    public ODCNode[] getChildren() {
        return this.allChildren.toArray();
    }

    public int childCount() {
        return this.allChildren.size();
    }

    public ODCNode getChild(ODCNodeType oDCNodeType) throws ODCException {
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNodeType;
        ODCNodeImpl.oneCheck(this.type, oDCNodeType);
        return this.getOne(this.typedChildren[oDCNodeTypeImpl.index], "children");
    }

    public ODCNode getChild(ODCNodeType oDCNodeType, String string) throws ODCException {
        ODCNode[] oDCNodeArray = this.getChildren(oDCNodeType);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            if (!string.equals(oDCNodeArray[i].getName())) continue;
            return oDCNodeArray[i];
        }
        return null;
    }

    public ODCNode[] getChildren(ODCNodeType oDCNodeType) throws ODCException {
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNodeType;
        ODCNodeImpl.manyCheck(this.type, oDCNodeType);
        return this.typedChildren[oDCNodeTypeImpl.index].toArray();
    }

    public int childCount(ODCNodeType oDCNodeType) throws ODCException {
        return this.typedChildren[((ODCNodeTypeImpl)oDCNodeType).index].size();
    }

    public ODCNode getParent() throws ODCException {
        return this.parent;
    }

    public ODCNode[] getParents() {
        return this.allParents.toArray();
    }

    public int parentCount() {
        return this.allParents.size();
    }

    public ODCNode getParent(ODCNodeType oDCNodeType) throws ODCException {
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNodeType;
        ODCNodeImpl.oneCheck(this.type, oDCNodeType);
        return this.getOne(this.typedParents[oDCNodeTypeImpl.index], "parents");
    }

    public ODCNode[] getParents(ODCNodeType oDCNodeType) throws ODCException {
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNodeType;
        ODCNodeImpl.manyCheck(this.type, oDCNodeType);
        return this.typedParents[oDCNodeTypeImpl.index].toArray();
    }

    public int parentCount(ODCNodeType oDCNodeType) throws ODCException {
        return this.typedParents[((ODCNodeTypeImpl)oDCNodeType).index].size();
    }

    public void getTreeEvents(boolean bl, List list, List list2) {
        Object object;
        list.add(new ODCEventNodeChangeImpl(true, this, bl, "tree events"));
        for (int i = 0; i < this.props.size(); ++i) {
            Object object2 = this.props.getValue(i);
            if (object2 == null || object2 instanceof ODCPropertyValueWrapper && ((ODCPropertyValueWrapper)object2).getPropVal() == null) continue;
            object = (ODCPropertyDescriptorImpl)this.props.getDescriptor(i);
            list.add(new ODCEventSetPropertyImpl((ODCPropertyDescriptor)object, this, object2, bl, "tree events"));
        }
        ODCNode[] oDCNodeArray = this.getChildren();
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            object = (ODCNodeImpl)oDCNodeArray[i];
            ODCEdgeTypeImpl oDCEdgeTypeImpl = (ODCEdgeTypeImpl)this.type.getEdgeType(((ODCNodeImpl)object).getType());
            ODCEventEdgeChangeImpl oDCEventEdgeChangeImpl = new ODCEventEdgeChangeImpl(true, new ODCEdgeImpl(this, (ODCNode)object, oDCEdgeTypeImpl), bl, "tree events");
            if (oDCEdgeTypeImpl.linked) {
                list2.add(oDCEventEdgeChangeImpl);
                continue;
            }
            ((ODCNodeImpl)object).getTreeEvents(bl, list, list2);
            list.add(oDCEventEdgeChangeImpl);
        }
    }

    private ODCNode getOne(NodeList nodeList, String string) throws ODCException {
        int n = nodeList.size();
        if (n == 1) {
            return nodeList.get(0);
        }
        if (n == 0) {
            return null;
        }
        throw new ODCException("node " + this.longName + " has multiple " + string);
    }

    boolean isRegistered() {
        return this.registered;
    }

    void setRegistered(boolean bl) {
        this.registered = bl;
    }

    public void print(PrintStream printStream) throws IOException {
        this.print(printStream, 0);
    }

    public void print(PrintStream printStream, int n) throws IOException {
        this.print(printStream, null, 0);
    }

    private void print(PrintStream printStream, ODCNodeImpl oDCNodeImpl, int n) throws IOException {
        Object object;
        int n2;
        if (this.tree != null && this.tree.getNode(this.getPath()) != this) {
            Throwable throwable = new Throwable(this + " not found in tree");
            TrUtil.warning(throwable, this, "ODCNodeImpl.print", tc);
            return;
        }
        this.indent(printStream, n);
        printStream.print("<" + this.type.name + " name=\"" + this.encodePropertyValue(this.name) + "\"");
        if (!this.props.hasValues() && this.childCount() == 0) {
            printStream.println("/>");
            return;
        }
        printStream.println(">");
        for (n2 = 0; n2 < this.props.size(); ++n2) {
            Object object2 = this.props.getValue(n2);
            int n3 = -1;
            if (object2 instanceof ODCPropertyValueWrapper) {
                object = (ODCPropertyValueWrapper)object2;
                object2 = ((ODCPropertyValueWrapper)object).getPropVal();
                n3 = ((ODCPropertyValueWrapper)object).getPropPriority();
            }
            if (object2 == null) continue;
            object = (ODCPropertyDescriptorImpl)this.props.getDescriptor(n2);
            this.indent(printStream, n + 1);
            printStream.print("<property name=\"" + this.encodePropertyValue(((ODCPropertyDescriptorImpl)object).name) + "\"");
            if (n3 != -1) {
                printStream.print(" priority=\"" + n3 + "\"");
            }
            printStream.print(" value=\"");
            this.printPropertyValue(object2, printStream);
            printStream.println("\"/>");
        }
        n2 = this.type.schema.nodeTypeCount();
        for (int i = 0; i < n2; ++i) {
            ODCNodeTypeImpl oDCNodeTypeImpl;
            if (oDCNodeImpl != null && oDCNodeImpl.type.index == i || (object = (ODCEdgeTypeImpl)this.type.getEdgeType(oDCNodeTypeImpl = this.type.schema.getNodeType(i))) == null || !((ODCEdgeTypeImpl)object).isChild()) continue;
            ODCNodeImpl[] oDCNodeImplArray = this.typedChildren[i].toArray();
            if (oDCNodeImplArray.length > 0) {
                this.indent(printStream, n + 1);
                printStream.println("<!-- " + oDCNodeTypeImpl.name + " section -->");
            }
            for (int j = 0; j < oDCNodeImplArray.length; ++j) {
                ODCNodeImpl oDCNodeImpl2 = oDCNodeImplArray[j];
                if (((ODCEdgeTypeImpl)object).linked) {
                    this.indent(printStream, n + 1);
                    printStream.println("<link name=\"" + this.encodePropertyValue(oDCNodeImpl2.longName) + "\"/>");
                    continue;
                }
                oDCNodeImpl2.print(printStream, this, n + 1);
            }
        }
        this.indent(printStream, n);
        printStream.println("</" + this.type.name + ">");
    }

    private void printPropertyValue(Object object, PrintStream printStream) throws IOException {
        if (object instanceof CFEndPointImpl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Base64.encode(byArray, printStream);
        } else {
            printStream.print(this.encodePropertyValue(object.toString()));
        }
    }

    protected String encodePropertyValue(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("[NL]");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("[TB]");
                    continue block9;
                }
                case '&': {
                    stringBuffer.append("[AM]");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("[QU]");
                    continue block9;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block9;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void indent(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print("    ");
        }
    }

    private void initTypedParents(ODCSchemaImpl oDCSchemaImpl) {
        int n = oDCSchemaImpl.nodeTypeCount();
        this.typedParents = new NodeList[n];
        for (int i = 0; i < n; ++i) {
            ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCSchemaImpl.getNodeType(i));
            this.typedParents[i] = oDCEdgeType != null && oDCEdgeType.isParent() ? new NodeList() : null;
        }
    }

    private void initTypedChildren(ODCSchemaImpl oDCSchemaImpl) {
        int n = oDCSchemaImpl.nodeTypeCount();
        this.typedChildren = new NodeList[n];
        for (int i = 0; i < n; ++i) {
            ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCSchemaImpl.getNodeType(i));
            this.typedChildren[i] = oDCEdgeType != null && oDCEdgeType.isChild() ? new NodeList() : null;
        }
    }

    private void propDescriptorCheck(ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl) throws ODCException {
        if (oDCPropertyDescriptorImpl.nodeType != this.type) {
            throw new ODCException("property descriptor is from node type " + oDCPropertyDescriptorImpl.nodeType + " but this node is of type " + this.type);
        }
    }

    private NodeList getTypedList(ODCNodeType oDCNodeType) throws ODCException {
        int n = ((ODCNodeTypeImpl)oDCNodeType).index;
        NodeList nodeList = this.childCheck(oDCNodeType) ? this.typedChildren[n] : this.typedParents[n];
        if (nodeList == null) {
            throw new IllegalStateException("bad state");
        }
        return nodeList;
    }

    private boolean childCheck(ODCNodeType oDCNodeType) throws ODCException {
        ODCEdgeType oDCEdgeType = this.type.findEdgeType(oDCNodeType);
        if (oDCEdgeType.isParent() && oDCEdgeType.isChild()) {
            throw new ODCException(this.type.getName() + " can be both a child and a parent of " + oDCNodeType.getName() + "; use getParent or getChild");
        }
        return oDCEdgeType.isChild();
    }

    private static void oneCheck(ODCNodeType oDCNodeType, ODCNodeType oDCNodeType2) throws ODCException {
        ODCEdgeTypeImpl oDCEdgeTypeImpl = (ODCEdgeTypeImpl)oDCNodeType.getEdgeType(oDCNodeType2);
        if (oDCEdgeTypeImpl == null) {
            throw new ODCException("a '" + oDCNodeType.getName() + "' has no relationship with a '" + oDCNodeType2.getName() + "'");
        }
        if (oDCEdgeTypeImpl.toMany()) {
            throw new ODCException("a '" + oDCNodeType.getName() + "' has a to-many relationship with a '" + oDCNodeType2.getName() + "'");
        }
    }

    private static void manyCheck(ODCNodeType oDCNodeType, ODCNodeType oDCNodeType2) throws ODCException {
        ODCEdgeTypeImpl oDCEdgeTypeImpl = (ODCEdgeTypeImpl)oDCNodeType.getEdgeType(oDCNodeType2);
        if (oDCEdgeTypeImpl == null) {
            throw new ODCException("a '" + oDCNodeType.getName() + "' has no relationship with a '" + oDCNodeType2.getName() + "'");
        }
        if (oDCEdgeTypeImpl.toOne()) {
            throw new ODCException("a '" + oDCNodeType.getName() + "' has a to-one relationship with a '" + oDCNodeType2.getName() + "'");
        }
    }

    private class NodeList {
        private final List list = new LinkedList();
        private ODCNodeImpl[] array = null;

        public synchronized void add(Object object) {
            this.list.add(object);
            this.array = null;
        }

        public synchronized boolean remove(Object object) {
            if (this.list.remove(object)) {
                this.array = null;
                return true;
            }
            return false;
        }

        public ODCNodeImpl get(int n) {
            return (ODCNodeImpl)this.list.get(n);
        }

        public boolean contains(Object object) {
            return this.list.contains(object);
        }

        public int size() {
            return this.list.size();
        }

        public ODCNodeImpl[] toArray() {
            if (this.array == null) {
                this.array = this.list.toArray(nullNodeArray);
            }
            return this.array;
        }
    }
}

