/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ws.odc.ODCEdgeTypeImpl;
import com.ibm.ws.odc.ODCPropertiesFactory;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.ws.odc.ODCSchemaImpl;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCPropertyType;
import java.util.HashSet;
import java.util.Set;

public final class ODCNodeTypeImpl
implements ODCNodeType {
    public final String name;
    public final int index;
    public final ODCSchemaImpl schema;
    public final ODCPropertiesFactory propertiesFactory = new ODCPropertiesFactory(this);
    private static ODCPropertyDescriptor[] noPropertyDescriptors = new ODCPropertyDescriptor[0];
    private static ODCNodeType[] noNodeTypes = new ODCNodeType[0];
    private final Set requiredPropertyDescriptorsSet = new HashSet();
    private ODCPropertyDescriptor[] requiredPropertyDescriptors = noPropertyDescriptors;
    private final Set requiredParentsSet = new HashSet();
    private ODCNodeType[] requiredParents = noNodeTypes;
    private final Set requiredChildrenSet = new HashSet();
    private ODCNodeType[] requiredChildren = noNodeTypes;

    public ODCNodeTypeImpl(String string, int n, ODCSchemaImpl oDCSchemaImpl) {
        this.name = string;
        this.index = n;
        this.schema = oDCSchemaImpl;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public ODCEdgeType getEdgeType(ODCNodeType oDCNodeType) {
        return this.schema.getEdgeType(this, (ODCNodeTypeImpl)oDCNodeType);
    }

    public ODCEdgeType findEdgeType(ODCNodeType oDCNodeType) throws ODCException {
        ODCEdgeTypeImpl oDCEdgeTypeImpl = this.schema.getEdgeType(this, (ODCNodeTypeImpl)oDCNodeType);
        if (oDCEdgeTypeImpl == null) {
            throw new ODCException("there is no relationship between " + this.name + " and " + oDCNodeType.getName());
        }
        return oDCEdgeTypeImpl;
    }

    public ODCPropertyDescriptor createPropertyDescriptor(String string, ODCPropertyType oDCPropertyType, Object object, boolean bl) throws ODCException {
        ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl = new ODCPropertyDescriptorImpl(string, oDCPropertyType, object, this, bl, false);
        this.propertiesFactory.registerPropertyDescriptor(oDCPropertyDescriptorImpl);
        return oDCPropertyDescriptorImpl;
    }

    public ODCPropertyDescriptor getPropertyDescriptor(String string) {
        return this.getPropertyDescriptor(string, false);
    }

    public ODCPropertyDescriptor getPropertyDescriptor(String string, boolean bl) {
        return this.propertiesFactory.getPropertyDescriptor(string, bl);
    }

    public ODCPropertyDescriptor findPropertyDescriptor(String string) throws ODCException {
        return this.propertiesFactory.findPropertyDescriptor(string);
    }

    public ODCPropertyDescriptor[] getRequiredProperties() {
        return this.requiredPropertyDescriptors;
    }

    public ODCNodeType[] getRequiredParents() {
        return this.requiredParents;
    }

    public ODCNodeType[] getRequiredChildren() {
        return this.requiredChildren;
    }

    public void addRequiredProperty(ODCPropertyDescriptor oDCPropertyDescriptor) {
        this.requiredPropertyDescriptorsSet.add(oDCPropertyDescriptor);
        this.requiredPropertyDescriptors = this.requiredPropertyDescriptorsSet.toArray(noPropertyDescriptors);
    }

    public void addRequiredNode(ODCNodeType oDCNodeType) throws ODCException {
        ODCEdgeType oDCEdgeType = this.getEdgeType(oDCNodeType);
        if (oDCEdgeType == null) {
            throw new ODCException("a '" + this.name + "' can have no relationship to a '" + oDCNodeType.getName() + "'");
        }
        if (oDCEdgeType.isParent() && oDCEdgeType.isChild()) {
            throw new ODCException("a '" + this.name + "' can be both a parent and a child of a '" + oDCNodeType.getName() + "'; must use addRequiredParentEdge() or addRequiredChildEdge() to disambiguate");
        }
        if (oDCEdgeType.isParent()) {
            this.addRequiredParent(oDCNodeType);
        } else {
            this.addRequiredChild(oDCNodeType);
        }
    }

    public void addRequiredParent(ODCNodeType oDCNodeType) throws ODCException {
        this.requiredParentsSet.add(oDCNodeType);
        this.requiredParents = this.requiredParentsSet.toArray(noNodeTypes);
    }

    public void addRequiredChild(ODCNodeType oDCNodeType) throws ODCException {
        this.requiredChildrenSet.add(oDCNodeType);
        this.requiredChildren = this.requiredChildrenSet.toArray(noNodeTypes);
    }

    public String toString() {
        return this.name;
    }
}

