/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.models.config.pmirm.PMIRMFilter;
import com.ibm.websphere.models.config.pmirm.PMIRMFilterValue;
import com.ibm.websphere.models.config.pmirm.PMIRequestMetrics;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.proxy.ProxySettings;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.odc.cell.TargetTree;
import com.ibm.ws.odc.cell.TreeBuilderHelper;
import com.ibm.ws.odc.util.DoPrivUtil;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCManager;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCTransactionListener;
import com.ibm.wsspi.odc.ODCTree;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ODCPluginCfgGenerator
implements ODCTransactionListener,
ConfigChangeListener {
    private static final TraceComponent tc = TrUtil.register(ODCPluginCfgGenerator.class);
    private static final String ODR_CLUSTER = "ODRCluster";
    public static final String CUSTOMPROP_ODR_SESSION_AFFINITY = "odrSessionAffinityEnabled";
    public static final String CUSTOMPROP_ODR_SESSION_AFFINITY_COOKIE_NAME = "odrSessionIdCookieName";
    public static String DEFAULT_ODR_SESSION_AFFINITY_COOKIE;
    public static String ODR_SESSION_AFFINITY_COOKIE;
    public static final String ODR_MODULE_ROUTING_POLICY = "ODR_Module_Routing_Policy";
    private static final String ODCPLUGINCFG_PREFIX = "ODCPluginCfg";
    private static final String ODCPLUGINCFG_ODR_LIST_PREFIX = "ODCPluginCfgOdrList_";
    private static final String ODCPLUGINCFG_ODR_CLUSTER_LIST_PREFIX = "ODCPluginCfgOdrClusterList_";
    private static final String ODCPLUGINCFG_ODR_INCLUDED_STOPPED_PREFIX = "ODCPluginCfgOdrIncludeStopped_";
    private static final String ODCPLUGINCFG_TRUSTED_PROXY_LIST_PREFIX = "ODCPluginCfgTrustedProxyList_";
    private static final String ODCPLUGINCFG_OUTPUT_PATH_PREFIX = "ODCPluginCfgOutputPath_";
    private static final String ODCPLUGINCFG_UPDATE_SCRIPT_PREFIX = "ODCPluginCfgUpdateScript_";
    private static final String ODCPLUGINCFG_DISABLED_PREFIX = "ODCPluginCfgDisabled_";
    private static final String ODCPLUGINCFG_ODR_SESSION_AFFINITY_COOKIE_PREFIX = "ODCPluginCfgOdrSessionIdCookie_";
    private static final String ODCPLUGINCFG_IHS_CONFIG_PROPERTIES_PREFIX = "ODCPluginCfgIHSConfigProperties_";
    private long lastGenTime;
    private ODCHelper odc;
    private ODCManager mgr;
    private ODCTree targetTree;
    private String cellName = null;
    private String nodeName = null;
    private String serverName = null;
    private String myCellName = null;
    private String myNodeName = null;
    private String myServerName = null;
    private File pluginCfgFile;
    private File myPluginCfgFile;
    private Object[] trustedProxies = null;
    private String notificationCmd = null;
    private String generationScope = "none";
    private String requestMetricsStanza = null;
    private String[] notificationCmdArray = null;
    private String prevFileContents = "";
    private final String NL = System.getProperty("line.separator", "\n");
    private final String IN1 = "   ";
    private final String IN2 = "      ";
    private final String IN3 = "         ";
    private final String IN4 = "            ";
    private boolean haManaged;
    private HashMap<String, GenerationDefinition> generationDefinitions;
    private static final String serverRoot;
    private static final String PREFIX = "com.ibm.ws.odr.plugincfg.";
    private static final String[][] CONFIG_ATTRS;
    private static final String[][] LOG_ATTRS;
    private static final String[][] CLUSTER_ATTRS;
    private static String[][] SERVER_ATTRS;
    private static String[][] GLOBAL_PROPS;
    private static String[][] HTTPS_PROPS;
    public static final String CUSTOMPROP_ODR_INCLUDE_STOPPED = "com.ibm.ws.odr.plugincfg.odrIncludeStopped";
    private static boolean odrIncludeStopped;
    private static boolean odrSessionAffinityEnabled;
    private final Props configAttrs;
    private final Props logAttrs;
    private final Props clusterAttrs;
    private final Props serverAttrs;
    private final Props globalProps;
    private final Props httpsProps;
    private boolean isInitialized = Boolean.valueOf(System.getProperty("ODCPluginCfgIsInitialized", "false"));
    private static RoutingPolicy routingPolicy;

    public ODCPluginCfgGenerator(ODCTree oDCTree) throws Exception {
        this(oDCTree, null, null, null, false);
    }

    public ODCPluginCfgGenerator(ODCTree oDCTree, boolean bl) throws Exception {
        this(oDCTree, null, null, null, bl);
    }

    public ODCPluginCfgGenerator(ODCTree oDCTree, String string, String string2, String string3) throws Exception {
        this(oDCTree, string, string2, string3, false);
    }

    public ODCPluginCfgGenerator(ODCTree oDCTree, String string, String string2, String string3, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor", new Object[]{string, string2, string3, bl});
        }
        this.myCellName = DoPrivUtil.getMyCellName();
        this.myNodeName = DoPrivUtil.getMyNodeName();
        this.myServerName = DoPrivUtil.getMyServerName();
        this.cellName = string;
        this.nodeName = string2;
        this.serverName = string3;
        odrIncludeStopped = Boolean.getBoolean(CUSTOMPROP_ODR_INCLUDE_STOPPED);
        this.configAttrs = new Props("com.ibm.ws.odr.plugincfg.config.", CONFIG_ATTRS);
        this.logAttrs = new Props("com.ibm.ws.odr.plugincfg.log.", LOG_ATTRS);
        this.clusterAttrs = new Props("com.ibm.ws.odr.plugincfg.cluster.", CLUSTER_ATTRS);
        this.serverAttrs = new Props("com.ibm.ws.odr.plugincfg.server.", SERVER_ATTRS);
        this.globalProps = new Props("com.ibm.ws.odr.plugincfg.property.", GLOBAL_PROPS);
        this.httpsProps = new Props("com.ibm.ws.odr.plugincfg.property.https.", HTTPS_PROPS);
        this.haManaged = bl;
        this.generationDefinitions = new HashMap();
        this.lastGenTime = 0L;
        this.init(oDCTree);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contructor");
        }
    }

    public String getNotificationCommand() {
        return this.notificationCmd;
    }

    public void setNotificationCommand(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "notificationCmd=" + string);
        }
        this.notificationCmd = string;
        this.notificationCmdArray = string == null ? null : string.split(" ");
    }

    private void init(ODCTree oDCTree) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", oDCTree);
        }
        this.targetTree = oDCTree;
        this.odc = ODCHelper.getInstance();
        this.mgr = this.odc.mgr;
        String string = System.getProperty("ODCPluginXmlDir");
        if (string == null) {
            string = this.serverName == null ? serverRoot + "/etc" : serverRoot + "/etc/" + this.serverName;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "user-specified plugincfg directory is " + string);
        }
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            Tr.warning(tc, "Unable to access " + file);
        }
        this.pluginCfgFile = new File(file, "plugin-cfg.xml");
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string2 = adminService.getCellName() + "-" + adminService.getNodeName() + "-" + adminService.getProcessName();
        this.myPluginCfgFile = new File(file, "plugin-cfg-" + string2 + ".xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readGenerationDefinitions() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readGenerationDefinitions");
        }
        HashMap<String, GenerationDefinition> hashMap = this.generationDefinitions;
        synchronized (hashMap) {
            Iterator<GenerationDefinition> iterator = this.generationDefinitions.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().reset();
            }
            TreeBuilderHelper treeBuilderHelper = TreeBuilderHelper.getInstance();
            Repository repository2 = treeBuilderHelper.getRepository(treeBuilderHelper.myCellName, null, null);
            Cell cell = (Cell)repository2.getConfigRoot().getResource(0, "cell.xml").getContents().get(0);
            Iterator iterator2 = cell.getProperties().iterator();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            odrSessionAffinityEnabled = false;
            routingPolicy = null;
            while (iterator2.hasNext()) {
                Object object;
                Property property = (Property)iterator2.next();
                String string = property.getName();
                String string2 = property.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "custom property: name=" + string + ", value=" + string2);
                }
                String string3 = null;
                if (string.startsWith(ODCPLUGINCFG_PREFIX)) {
                    String[] stringArray;
                    string3 = string.substring(string.indexOf("_") + 1);
                    object = (GenerationDefinition)hashMap2.get(string3);
                    if (object == null) {
                        object = this.generationDefinitions.get(string3);
                    }
                    if (object == null) {
                        object = new GenerationDefinition();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "creating new definition: " + string3);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "storing " + string3);
                    }
                    hashMap2.put(string3, object);
                    if (string.startsWith(ODCPLUGINCFG_ODR_LIST_PREFIX)) {
                        for (String string4 : stringArray = string2.split(",")) {
                            ((GenerationDefinition)object).odrList.add(string4);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "adding odr target: " + string4 + " to definition: " + string3);
                        }
                    }
                    if (string.startsWith(ODCPLUGINCFG_ODR_CLUSTER_LIST_PREFIX)) {
                        for (String string4 : stringArray = string2.split(",")) {
                            ((GenerationDefinition)object).odrClusterList.add(string4);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "adding odr cluster target: " + string4 + " to definition: " + string3);
                        }
                    }
                    if (string.startsWith(ODCPLUGINCFG_TRUSTED_PROXY_LIST_PREFIX)) {
                        for (String string4 : stringArray = string2.split(",")) {
                            ((GenerationDefinition)object).trustedProxyList.add(string4);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "adding trusted proxies: " + string4 + " to definition: " + string3);
                        }
                        continue;
                    }
                    if (string.startsWith(ODCPLUGINCFG_OUTPUT_PATH_PREFIX)) {
                        if (!string2.equals(((GenerationDefinition)object).outputPath)) {
                            ((GenerationDefinition)object).clearCache();
                        }
                        ((GenerationDefinition)object).outputPath = string2;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "setting output path: " + string2 + " for definition: " + string3);
                        continue;
                    }
                    if (string.startsWith(ODCPLUGINCFG_UPDATE_SCRIPT_PREFIX)) {
                        ((GenerationDefinition)object).updateScript = string2;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "setting notification script: " + string2 + " for definition: " + string3);
                        continue;
                    }
                    if (string.startsWith(ODCPLUGINCFG_DISABLED_PREFIX)) {
                        ((GenerationDefinition)object).disabled = Boolean.valueOf(string2);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "disabled value: " + ((GenerationDefinition)object).disabled + " for definition: " + string3);
                        continue;
                    }
                    if (string.startsWith(ODCPLUGINCFG_ODR_INCLUDED_STOPPED_PREFIX)) {
                        ((GenerationDefinition)object).includeStoppedOdrs = Boolean.valueOf(string2);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "odrIncludeStopped value: " + ((GenerationDefinition)object).includeStoppedOdrs + " for definition: " + string3);
                        continue;
                    }
                    if (string.startsWith(ODCPLUGINCFG_ODR_SESSION_AFFINITY_COOKIE_PREFIX)) {
                        ((GenerationDefinition)object).odrSessionCookie = string2;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "odr session cookie: " + string2 + " for definition: " + string3);
                        continue;
                    }
                    if (!string.startsWith(ODCPLUGINCFG_IHS_CONFIG_PROPERTIES_PREFIX)) continue;
                    ((GenerationDefinition)object).setIhsConfigProperties(string2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "IHS config properties: " + string2 + " for definition: " + string3);
                    continue;
                }
                if (string.equalsIgnoreCase(CUSTOMPROP_ODR_SESSION_AFFINITY)) {
                    object = property.getValue();
                    odrSessionAffinityEnabled = object != null && ((String)object).equalsIgnoreCase("true");
                    continue;
                }
                if (!string.equals(ODR_MODULE_ROUTING_POLICY)) continue;
                object = property.getValue();
                if (object != null) {
                    ((String)object).intern();
                }
                if (routingPolicy != null && object == ODCPluginCfgGenerator.routingPolicy.desc) continue;
                routingPolicy = new RoutingPolicy((String)object);
            }
            this.generationDefinitions = hashMap2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ODR session affinity is " + (odrSessionAffinityEnabled ? "enabled" : "disabled"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readGenerationDefinitions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object;
        Admin admin2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if ((admin2 = (Admin)WsServiceRegistry.getService((Object)this, Admin.class)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add config change listener");
            }
            admin2.addConfigChangeListener(this);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "could not addConfigChangeListener");
        }
        this.readGenerationDefinitions();
        if (!this.haManaged) {
            object = Util.getClusterForServer(this.myCellName, this.myNodeName, this.myServerName);
            if (object == null) {
                this.readProxySettings("cells/" + this.myCellName + "/nodes/" + this.myNodeName + "/servers/" + this.myServerName + "/proxy-settings.xml");
            } else {
                this.readProxySettings("cells/" + this.myCellName + "/clusters/" + (String)object + "/proxy-settings.xml");
            }
        }
        object = this.targetTree;
        synchronized (object) {
            this.targetTree.addListener(this);
            this.handleEvent(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        this.targetTree.removeListener(this);
        Admin admin2 = (Admin)WsServiceRegistry.getService((Object)this, Admin.class);
        if (admin2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add config change listener");
            }
            admin2.removeConfigChangeListener(this);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "could not addConfigChangeListener");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configChanged", configRepositoryEvent);
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        if (tc.isEntryEnabled()) {
            for (n = 0; n < configChangeNotifierArray.length; ++n) {
                Tr.debug(tc, "\ni=" + n + " type=" + configChangeNotifierArray[n].getChangeType() + " uri=" + configChangeNotifierArray[n].getUri());
            }
        }
        for (n = 0; n < configChangeNotifierArray.length; ++n) {
            String string;
            ConfigChangeNotifier configChangeNotifier = configChangeNotifierArray[n];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "change=" + configChangeNotifier);
            }
            if ((string = configChangeNotifier.getUri()).endsWith("/cell.xml")) {
                try {
                    this.readGenerationDefinitions();
                    this.handleEvent(null);
                    continue;
                }
                catch (Exception exception) {
                    Tr.warning(tc, "Error processing cell.xml", exception);
                    throw new RuntimeException(exception);
                }
            }
            if (!string.endsWith("/proxy-settings.xml") || this.haManaged) continue;
            this.readProxySettings(string);
            this.handleEvent(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    private void readProxySettings(String string) {
        Object object;
        Object object2;
        Object object3;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readProxySettings", string);
        }
        String[] stringArray = string.split("/");
        try {
            Object object4;
            Object object52;
            string2 = null;
            if (stringArray.length == 7) {
                object3 = stringArray[1];
                object2 = stringArray[3];
                object = stringArray[5];
                if (((String)object).equals(this.myServerName) && ((String)object2).equals(this.myNodeName) && ((String)object3).equals(this.myCellName)) {
                    object52 = TreeBuilderHelper.getInstance().getRepository((String)object3, (String)object2, (String)object);
                    string2 = (ProxySettings)object52.getConfigRoot().getResource(4, "proxy-settings.xml").getContents().get(0);
                }
            } else if (stringArray.length == 5) {
                object3 = stringArray[1];
                object2 = stringArray[3];
                object = Util.getClusterForServer(this.myCellName, this.myNodeName, this.myServerName);
                if (((String)object2).equals(object) && ((String)object3).equals(this.myCellName)) {
                    object52 = "clusters" + File.separator + (String)object + File.separator + "proxy-settings.xml";
                    object4 = TreeBuilderHelper.getInstance().getRepository(this.myCellName, null, null);
                    string2 = (ProxySettings)object4.getConfigRoot().getResource(0, (String)object52).getContents().get(0);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Warning: the path to proxy-settings.xml is incorrect, changes not processed.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "readProxySettings", string);
                }
                return;
            }
            object3 = string2.getTrustedIntermediaryAddresses();
            if (object3 != null) {
                this.trustedProxies = object3.toArray();
            }
            object2 = string2.getPluginConfigPolicy();
            ODR_SESSION_AFFINITY_COOKIE = DEFAULT_ODR_SESSION_AFFINITY_COOKIE;
            for (Object object52 : string2.getProperties()) {
                object4 = object52.getName();
                String string3 = object52.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "custom property: name=" + (String)object4 + ", value=" + string3);
                }
                if (!((String)object4).equalsIgnoreCase(CUSTOMPROP_ODR_SESSION_AFFINITY_COOKIE_NAME)) continue;
                ODR_SESSION_AFFINITY_COOKIE = string3;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "odrSessionIdCookie=" + string3);
            }
            if (object2 != null) {
                this.setNotificationCommand(object2.getPluginConfigChangeScript());
                this.generationScope = object2.getPluginGenConfigScope().getLiteral();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set generation scope to: " + this.generationScope);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set notification command to: " + this.getNotificationCommand());
                }
                if (this.generationScope.equalsIgnoreCase("all")) {
                    this.cellName = null;
                    this.nodeName = null;
                    this.serverName = null;
                } else if (this.generationScope.equalsIgnoreCase("cell")) {
                    this.cellName = this.myCellName;
                    this.nodeName = null;
                    this.serverName = null;
                } else if (this.generationScope.equalsIgnoreCase("node")) {
                    this.cellName = this.myCellName;
                    this.nodeName = this.myNodeName;
                    this.serverName = null;
                } else if (this.generationScope.equalsIgnoreCase("server")) {
                    this.cellName = this.myCellName;
                    this.nodeName = this.myNodeName;
                    this.serverName = this.myServerName;
                }
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "Failed to access repository while processing ODCPluginCfg change", exception);
        }
        string2 = System.getProperty("ODCPluginXmlDir");
        if (string2 == null) {
            string2 = this.serverName == null ? serverRoot + "/etc" : serverRoot + "/etc/" + this.serverName;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "user-specified plugincfg directory is " + string2);
        }
        object3 = new File(string2);
        if (!((File)object3).exists() && !((File)object3).mkdirs()) {
            Tr.warning(tc, "Unable to access " + object3);
        }
        this.pluginCfgFile = new File((File)object3, "plugin-cfg.xml");
        object2 = AdminServiceFactory.getAdminService();
        object = object2.getCellName() + "-" + object2.getNodeName() + "-" + object2.getProcessName();
        this.myPluginCfgFile = new File((File)object3, "plugin-cfg-" + (String)object + ".xml");
        this.prevFileContents = "";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readProxySettings", string);
        }
    }

    public ODCEventType[] interestEventTypes() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ODCEvent oDCEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleEvent", oDCEvent);
        }
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            if (!this.haManaged && !this.generationScope.equalsIgnoreCase("none")) {
                this.generatePluginCfg();
            } else {
                HashMap<String, GenerationDefinition> hashMap = this.generationDefinitions;
                synchronized (hashMap) {
                    for (GenerationDefinition generationDefinition : this.generationDefinitions.values()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "found generator: " + generationDefinition.outputPath);
                        }
                        if (generationDefinition.disabled) continue;
                        this.generatePluginCfg(generationDefinition);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(ODCEvent[] oDCEventArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleEvents", oDCEventArray);
        }
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            if (!this.haManaged && !this.generationScope.equalsIgnoreCase("none")) {
                this.generatePluginCfg();
            } else {
                HashMap<String, GenerationDefinition> hashMap = this.generationDefinitions;
                synchronized (hashMap) {
                    for (GenerationDefinition generationDefinition : this.generationDefinitions.values()) {
                        if (generationDefinition.disabled) continue;
                        this.generatePluginCfg(generationDefinition);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleEvents");
        }
    }

    private synchronized void generatePluginCfg() {
        this.generatePluginCfg(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void generatePluginCfg(GenerationDefinition generationDefinition) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generatePluginCfg - " + (generationDefinition == null ? this.pluginCfgFile : generationDefinition));
        }
        try {
            Object object;
            int n;
            Object object2;
            Object object3;
            Object object4;
            int n2;
            if (!this.isInitialized()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "generatePluginCfg - is not initialized");
                }
                return;
            }
            if (generationDefinition != null && generationDefinition.outputPath == null && tc.isEntryEnabled()) {
                Tr.exit(tc, "generatePluginCfg - no output path for config");
            }
            HashSet hashSet = new HashSet();
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>").append(this.NL);
            stringBuffer.append("<!-- This file was automatically generated -->").append(this.NL);
            stringBuffer.append("<Config");
            if (generationDefinition == null) {
                this.configAttrs.addAttrs(stringBuffer);
            } else {
                generationDefinition.configAttrs.addAttrs(stringBuffer);
            }
            stringBuffer.append(">").append(this.NL);
            stringBuffer.append("   ").append("<Log");
            if (generationDefinition == null) {
                this.logAttrs.addAttrs(stringBuffer);
            } else {
                generationDefinition.logAttrs.addAttrs(stringBuffer);
            }
            stringBuffer.append("/>").append(this.NL);
            stringBuffer.append("   ").append("<!-- Properties -->").append(this.NL);
            if (generationDefinition == null) {
                this.globalProps.addProps("   ", stringBuffer);
            } else {
                generationDefinition.globalProps.addProps("   ", stringBuffer);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "start server clusters");
            }
            stringBuffer.append("   ").append("<!-- Server Clusters -->").append(this.NL);
            ODCNode[] oDCNodeArray = this.targetTree.getRoot().getNodes(this.odc.cell);
            for (n2 = 0; n2 < oDCNodeArray.length; ++n2) {
                boolean bl2;
                boolean bl3;
                Boolean bl4;
                ODCNode oDCNode;
                int n3;
                ODCNode[] oDCNodeArray2;
                Object object5;
                String[] stringArray;
                object4 = oDCNodeArray[n2];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell=" + object4);
                }
                stringBuffer2.append("   ").append("<!-- Virtual Host Groups -->").append(this.NL);
                object3 = object4.getNodes(this.odc.vhostGroup);
                for (int i = 0; i < ((ODCNode[])object3).length; ++i) {
                    stringArray = object3[i];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "virtualHostGroup=" + stringArray);
                    }
                    stringBuffer2.append("   ").append("<VirtualHostGroup Name=\"").append(stringArray.getLongName()).append("\">").append(this.NL);
                    object2 = stringArray.getNodes(this.odc.vhost);
                    for (n = 0; n < ((ODCNode[])object2).length; ++n) {
                        object5 = object2[n];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "virtualHost=" + object5);
                        }
                        stringBuffer2.append("      ").append("<VirtualHost Name=\"").append(object5.getName()).append("\"/>").append(this.NL);
                    }
                    stringBuffer2.append("   ").append("</VirtualHostGroup>").append(this.NL);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "start URI groups");
                }
                object = System.getProperty("ODC.IgnoreFileServing", "");
                stringArray = ((String)object).split(":");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring fileservering value for modules: " + (String)object);
                }
                stringBuffer2.append("   ").append("<!-- URI Groups -->").append(this.NL);
                object2 = object4.getNodes(this.odc.application);
                for (n = 0; n < ((ODCNode[])object2).length; ++n) {
                    object5 = object2[n];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "app=" + object5);
                    }
                    oDCNodeArray2 = object5.getNodes(this.odc.webModule);
                    for (n3 = 0; n3 < oDCNodeArray2.length; ++n3) {
                        oDCNode = oDCNodeArray2[n3];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "wm=" + oDCNode);
                        }
                        bl3 = (bl4 = (Boolean)oDCNode.getProperty(this.odc.webModuleRoutingEnabled)) != null ? bl4 : true;
                        bl2 = this.webModuleNeedsRoute(oDCNode);
                        if (!bl3 || !bl2) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "routing disabled");
                            continue;
                        }
                        boolean bl5 = this.routeThruOdr(oDCNode);
                        stringBuffer2.append("   ").append("<UriGroup Name=\"").append(oDCNode.getPath()).append("\">").append(this.NL);
                        String string = ODCPluginCfgGenerator.normalizeContextRoot((String)oDCNode.getProperty(this.odc.webModuleContextRoot));
                        ODCNode[] oDCNodeArray3 = oDCNode.getNodes(this.odc.uri);
                        for (int i = 0; i < oDCNodeArray3.length; ++i) {
                            Object object6;
                            ODCNode oDCNode2 = oDCNodeArray3[i];
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "uri=" + oDCNode2);
                            }
                            String string2 = oDCNode2.getName();
                            StringBuffer stringBuffer3 = new StringBuffer("");
                            boolean bl6 = true;
                            stringBuffer3.append("      ").append("<Uri Name=\"").append(string);
                            if (!string2.startsWith("/")) {
                                stringBuffer3.append("/");
                            }
                            stringBuffer3.append(string2 + "\"");
                            if (bl5 && odrSessionAffinityEnabled) {
                                if (generationDefinition == null || generationDefinition.odrSessionCookie == null) {
                                    stringBuffer3.append(" AffinityCookie=\"" + ODR_SESSION_AFFINITY_COOKIE + "\"");
                                } else {
                                    stringBuffer3.append(" AffinityCookie=\"" + generationDefinition.odrSessionCookie + "\"");
                                }
                            } else if (!bl5) {
                                Object object7;
                                Object object8 = null;
                                object6 = oDCNode.getType().getPropertyDescriptor("sessionAffinityCookies");
                                String string3 = (String)oDCNode.getProperty((ODCPropertyDescriptor)object6);
                                if (string3 == null) {
                                    Object[] objectArray;
                                    object7 = object5.getType().getPropertyDescriptor("sessionAffinityCookies");
                                    String string4 = (String)object5.getProperty((ODCPropertyDescriptor)object7);
                                    if (string4 == null) {
                                        ODCPropertyDescriptor oDCPropertyDescriptor;
                                        String string5;
                                        ODCNode[] oDCNodeArray4;
                                        objectArray = oDCNode.getNodes(this.odc.cluster);
                                        if (objectArray.length != 0 && (oDCNodeArray4 = objectArray[0].getChildren(this.odc.server)).length != 0 && (string5 = (String)oDCNodeArray4[0].getProperty(oDCPropertyDescriptor = oDCNodeArray4[0].getType().getPropertyDescriptor("sessionAffinityCookies"))) != null) {
                                            String[] stringArray2 = string5.split(",");
                                            if (!stringArray2[0].equals("")) {
                                                // empty if block
                                            }
                                            object8 = stringArray2[0];
                                        }
                                    } else {
                                        objectArray = string4.split(",");
                                        if (!objectArray[0].equals("")) {
                                            // empty if block
                                        }
                                        object8 = objectArray[0];
                                    }
                                } else {
                                    object7 = string3.split(",");
                                    if (!object7[0].equals("")) {
                                        // empty if block
                                    }
                                    object8 = object7[0];
                                }
                                if (object8 != null) {
                                    stringBuffer3.append(" AffinityCookie=\"" + (String)object8 + "\"");
                                }
                            }
                            stringBuffer3.append("/>").append(this.NL);
                            if (string2.equals("*") || string2.equals("/*")) {
                                boolean bl7;
                                boolean bl8 = false;
                                for (int j = 0; j < stringArray.length; ++j) {
                                    if (!oDCNode.getName().equals(stringArray[j])) continue;
                                    bl8 = true;
                                }
                                object6 = (Boolean)oDCNode.getProperty(this.odc.webModuleFileServingEnabled);
                                boolean bl9 = bl7 = object6 == null ? false : (Boolean)object6;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Processing /* pattern, ignoreFS=" + bl8 + ", fsEnabled=" + bl7);
                                }
                                if (bl8 && bl7) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Ignoring /* pattern, processing remaining patterns");
                                    }
                                    bl6 = false;
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "skipping remaining uris");
                                    }
                                    stringBuffer2.append(stringBuffer3);
                                    break;
                                }
                            }
                            if (!bl6) continue;
                            stringBuffer2.append(stringBuffer3);
                        }
                        stringBuffer2.append("   ").append("</UriGroup>").append(this.NL);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "start routes");
                }
                stringBuffer2.append("   ").append("<!-- Routes -->").append(this.NL);
                for (n = 0; n < ((Object)object3).length; ++n) {
                    object5 = object3[n];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "virtualHostGroup=" + object5);
                    }
                    oDCNodeArray2 = object5.getNodes(this.odc.webModule);
                    for (n3 = 0; n3 < oDCNodeArray2.length; ++n3) {
                        oDCNode = oDCNodeArray2[n3];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "webModule=" + oDCNode);
                        }
                        bl3 = (bl4 = (Boolean)oDCNode.getProperty(this.odc.webModuleRoutingEnabled)) != null ? bl4 : true;
                        bl2 = this.webModuleNeedsRoute(oDCNode);
                        if (!bl3 || !bl2) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "routing disabled");
                            continue;
                        }
                        String string = this.addCluster(oDCNode, stringBuffer, generationDefinition, hashSet);
                        stringBuffer2.append("   ").append("<Route").append(this.NL);
                        stringBuffer2.append("      ").append("VirtualHostGroup=\"").append(object5.getLongName()).append("\"").append(this.NL);
                        stringBuffer2.append("      ").append("UriGroup=\"").append(oDCNode.getPath()).append("\"").append(this.NL);
                        stringBuffer2.append("      ").append("ServerCluster=\"").append(string).append("\"/>").append(this.NL);
                        bl = true;
                    }
                }
            }
            stringBuffer.append("   ").append("<!-- Trusted Proxy Groups -->").append(this.NL);
            stringBuffer.append("   ").append("<TrustedProxyGroup>").append(this.NL);
            if (generationDefinition == null && this.trustedProxies != null) {
                for (n2 = 0; n2 < this.trustedProxies.length; ++n2) {
                    stringBuffer.append("      ").append("<TrustedProxy name=\"").append(this.trustedProxies[n2] + "\"/>").append(this.NL);
                }
            } else if (generationDefinition.trustedProxyList.size() > 0) {
                Iterator<String> iterator = generationDefinition.trustedProxyList.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append("      ").append("<TrustedProxy name=\"").append(iterator.next() + "\"/>").append(this.NL);
                }
            }
            stringBuffer.append("   ").append("</TrustedProxyGroup>").append(this.NL);
            stringBuffer.append(stringBuffer2);
            this.addRequestMetrics(stringBuffer);
            stringBuffer.append("</Config>");
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "does not have a route; not writing");
                }
                return;
            }
            String string = stringBuffer.toString();
            if (generationDefinition != null && string.equals(generationDefinition.prevFileContents) || generationDefinition == null && this.prevFileContents.equals(string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no change in generated plugin");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "writing generated plugin to " + this.myPluginCfgFile.getAbsolutePath());
                }
                if (generationDefinition == null) {
                    this.prevFileContents = string;
                } else {
                    generationDefinition.prevFileContents = string;
                }
                object4 = string.getBytes();
                object3 = new FileOutputStream(this.myPluginCfgFile);
                ((FileOutputStream)object3).write((byte[])object4);
                ((FileOutputStream)object3).close();
                object = null;
                object = generationDefinition != null ? new File(generationDefinition.outputPath) : this.pluginCfgFile;
                if (((File)object).exists()) {
                    if (((File)object).delete()) {
                        Tr.debug(tc, "deleted existing file " + ((File)object).getPath());
                    } else {
                        Tr.debug(tc, "failed to delete existing file " + ((File)object).getPath());
                    }
                }
                boolean bl10 = this.myPluginCfgFile.renameTo((File)object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, (bl10 ? "renamed " : "failed to rename ") + this.myPluginCfgFile.getPath() + " to " + ((File)object).getPath());
                }
                if (generationDefinition != null && generationDefinition.updateScript != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "notificationCmd: " + generationDefinition.updateScript);
                    }
                    object2 = Runtime.getRuntime().exec(generationDefinition.updateScript);
                    ((Process)object2).getOutputStream().close();
                    n = ((Process)object2).waitFor();
                    if (n != 0) {
                        Tr.warning(tc, "notification command exited with status code of " + n);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "successful notification");
                    }
                } else if (this.notificationCmd != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "notificationCmd: " + this.notificationCmd);
                        Tr.debug(tc, "notificationCmdArray: " + this.toString(this.notificationCmdArray));
                    }
                    object2 = Runtime.getRuntime().exec(this.notificationCmdArray);
                    ((Process)object2).getOutputStream().close();
                    n = ((Process)object2).waitFor();
                    if (n != 0) {
                        Tr.warning(tc, "notification command exited with status code of " + n);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "successful notification");
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        finally {
            this.lastGenTime = System.currentTimeMillis();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generatePluginCfg");
            }
        }
    }

    private boolean webModuleNeedsRoute(ODCNode oDCNode) throws ODCException {
        boolean bl = true;
        if (oDCNode.getName().matches("Default_.*_WC")) {
            ODCNode oDCNode2 = oDCNode.getParent(this.odc.application);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "application=" + oDCNode2);
            }
            if (oDCNode2.getName().endsWith("/GenericApplication")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing a generic application");
                }
                ODCNode[] oDCNodeArray = oDCNode2.getChildren(this.odc.webRouteWorkClass);
                for (int i = 0; i < oDCNodeArray.length; ++i) {
                    String string;
                    ODCNode[] oDCNodeArray2;
                    if (!this.isDefaultWorkClass(oDCNodeArray[i].getName())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "is the default workclass");
                    }
                    if ((oDCNodeArray2 = oDCNodeArray[i].getChildren(this.odc.rule)).length != 1) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "only has one rule");
                    }
                    if (!oDCNodeArray2[0].getName().equals("default")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "is the default rule");
                    }
                    if (!(string = (String)oDCNodeArray2[0].getProperty(this.odc.ruleAction)).equals("reject:404")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Ignoring default 404 route for generic application");
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean isDefaultWorkClass(String string) {
        boolean bl;
        boolean bl2 = bl = string.startsWith("Default_") && string.endsWith("_WC");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isDefault: name=" + string + ", result=" + bl);
        }
        return bl;
    }

    private boolean isInitialized() {
        if (this.isInitialized) {
            return true;
        }
        try {
            ODCNode oDCNode = TargetTree.getMyNode();
            if (oDCNode == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isInitialized?  No, myNode is null");
                }
                return false;
            }
            ODCNode[] oDCNodeArray = this.targetTree.getRoot().getNodes(this.odc.cell);
            for (int i = 0; i < oDCNodeArray.length; ++i) {
                ODCNode[] oDCNodeArray2 = oDCNodeArray[i].getNodes(this.odc.node);
                for (int j = 0; j < oDCNodeArray2.length; ++j) {
                    if (oDCNodeArray2[j] == oDCNode) continue;
                    this.isInitialized = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isInitialized?  Yes, found another node -> " + oDCNodeArray2[j]);
                    }
                    return true;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isInitialized?  No, no other node found.");
            }
            return false;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                exception.printStackTrace(System.out);
            }
            return true;
        }
    }

    private String toString(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addCluster(ODCNode oDCNode, StringBuffer stringBuffer, GenerationDefinition generationDefinition, Set set) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCluster wm=" + oDCNode);
        }
        if (this.routeThruOdr(oDCNode)) {
            if (!set.contains(ODR_CLUSTER)) {
                this.addOdrCluster(stringBuffer, generationDefinition);
                set.add(ODR_CLUSTER);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addCluster - odr cluster");
            }
            return ODR_CLUSTER;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        ArrayList<ODCNode> arrayList = new ArrayList<ODCNode>();
        Object object = this.targetTree;
        synchronized (object) {
            ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.cluster);
            for (int i = 0; i < oDCNodeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer2.append(",");
                }
                stringBuffer2.append(oDCNodeArray[i].getName());
                ODCNode[] oDCNodeArray2 = oDCNodeArray[i].getNodes(this.odc.server);
                for (int j = 0; j < oDCNodeArray2.length; ++j) {
                    arrayList.add(oDCNodeArray2[j]);
                }
            }
        }
        object = stringBuffer2.toString();
        if (!set.contains(object)) {
            stringBuffer.append("   ").append("<ServerCluster Name=\"").append((String)object).append("\"");
            if (generationDefinition == null) {
                this.clusterAttrs.addAttrs(stringBuffer);
            } else {
                generationDefinition.clusterAttrs.addAttrs(stringBuffer);
            }
            stringBuffer.append(">").append(this.NL);
            for (int i = 0; i < arrayList.size(); ++i) {
                ODCNode oDCNode2 = (ODCNode)arrayList.get(i);
                this.addServer(oDCNode2, true, stringBuffer, false, generationDefinition);
            }
            stringBuffer.append("   ").append("</ServerCluster>").append(this.NL);
            set.add(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCluster - clusterName=" + (String)object);
        }
        return object;
    }

    private void addOdrCluster(StringBuffer stringBuffer, GenerationDefinition generationDefinition) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addOdrCluster");
        }
        stringBuffer.append("   ").append("<ServerCluster Name=\"").append(ODR_CLUSTER).append("\"");
        if (generationDefinition == null) {
            this.clusterAttrs.addAttrs(stringBuffer);
        } else {
            generationDefinition.clusterAttrs.addAttrs(stringBuffer);
        }
        stringBuffer.append(">").append(this.NL);
        ODCNode[] oDCNodeArray = this.targetTree.getRoot().getNodes(this.odc.cell);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            ODCNode oDCNode = oDCNodeArray[i];
            if (!this.haManaged && this.cellName != null && !this.cellName.equals(oDCNode.getName())) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping cell; " + oDCNode.getName() + "!=" + this.cellName);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell=" + oDCNode);
            }
            ODCNode[] oDCNodeArray2 = oDCNode.getNodes(this.odc.node);
            for (int j = 0; j < oDCNodeArray2.length; ++j) {
                ODCNode oDCNode2 = oDCNodeArray2[j];
                if (!this.haManaged && this.nodeName != null && !this.nodeName.equals(oDCNode2.getName())) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "skipping node; " + oDCNode2.getName() + "!=" + this.nodeName);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node=" + oDCNode2);
                }
                ODCNode[] oDCNodeArray3 = oDCNode2.getNodes(this.odc.server);
                for (int k = 0; k < oDCNodeArray3.length; ++k) {
                    ODCNode oDCNode3 = oDCNodeArray3[k];
                    if (Util.isProxy((String)oDCNode3.getProperty(this.odc.serverType))) {
                        if (this.includeServer(oDCNode3, oDCNode.getName(), oDCNode2.getName(), generationDefinition)) {
                            boolean bl = false;
                            bl = !this.haManaged ? odrIncludeStopped : generationDefinition.includeStoppedOdrs;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "odrIncludeStopped value: " + bl);
                            }
                            if (!(bl || "STARTED".equalsIgnoreCase((String)oDCNode3.getProperty(this.odc.serverState)) && oDCNode3.getIntProperty(this.odc.serverWeight) != 0)) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "skipping server: " + oDCNode3.getName() + " because it is not started");
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding server: " + oDCNode3.getName() + " with state=" + oDCNode3.getProperty(this.odc.serverState));
                            }
                            this.addServer(oDCNode3, odrSessionAffinityEnabled, stringBuffer, true, generationDefinition);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "skipping server; " + oDCNode3.getName() + "!=" + this.serverName);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "skipping server; " + oDCNode3 + " is not an ODR");
                }
            }
        }
        stringBuffer.append("   ").append("</ServerCluster>").append(this.NL);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addOdrCluster");
        }
    }

    private boolean includeServer(ODCNode oDCNode, String string, String string2, GenerationDefinition generationDefinition) throws ODCException {
        String string3;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "includeServer", new Object[]{oDCNode, string, string2, generationDefinition});
        }
        if (!this.haManaged) {
            if (this.cellName != null && !this.cellName.equals(string)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "includeServer - cell mismatch");
                }
                return false;
            }
            if (this.nodeName != null && !this.nodeName.equals(string2)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "includeServer - node mismatch");
                }
                return false;
            }
            if (this.serverName != null && !this.serverName.equals(oDCNode.getName())) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "includeServer - server mismatch");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "includeServer - nonHa match");
            }
            return true;
        }
        String string4 = string + ":" + string2 + ":" + oDCNode.getName();
        String string5 = string + ":" + oDCNode.getParent(this.odc.cluster).getName();
        for (n = 0; n < generationDefinition.odrClusterList.size(); ++n) {
            string3 = generationDefinition.odrClusterList.get(n);
            if (!this.wildcardMatch(string3, string5)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "includeServer - cluster match " + string3);
            }
            return true;
        }
        for (n = 0; n < generationDefinition.odrList.size(); ++n) {
            string3 = generationDefinition.odrList.get(n);
            if (!this.wildcardMatch(string3, string4)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "includeServer - server match " + string3);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "includeServer - false");
        }
        return false;
    }

    private void addServer(ODCNode oDCNode, boolean bl, StringBuffer stringBuffer, boolean bl2, GenerationDefinition generationDefinition) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServer - server=" + oDCNode + ", addCloneId=" + bl);
        }
        stringBuffer.append("      ").append("<Server Name=\"").append(oDCNode.getName()).append("\"");
        if (generationDefinition == null) {
            this.serverAttrs.addAttrs(stringBuffer);
        } else {
            generationDefinition.serverAttrs.addAttrs(stringBuffer);
        }
        if (bl) {
            stringBuffer.append(" CloneID=\"" + oDCNode.getProperty(this.odc.serverCloneId) + "\"");
        }
        stringBuffer.append(" LoadBalanceWeight=\"" + oDCNode.getIntProperty(this.odc.serverWeight) + "\"");
        stringBuffer.append(">").append(this.NL);
        ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.transport);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            ODCNode oDCNode2 = oDCNodeArray[i];
            if (bl2 && !oDCNode2.getBooleanProperty(this.odc.transportODR)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping transport; " + oDCNode2 + " is not ODR");
                continue;
            }
            String string = (String)oDCNode2.getProperty(this.odc.transportProtocol);
            if (string == null || !string.equalsIgnoreCase("http") && !string.equalsIgnoreCase("https")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping transport; " + oDCNode2 + " protocol " + string + " is not http/https");
                continue;
            }
            boolean bl3 = false;
            bl3 = generationDefinition == null ? odrIncludeStopped : generationDefinition.includeStoppedOdrs;
            if (bl3) {
                if (!oDCNode2.getBooleanProperty(this.odc.transportIsConfig)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "skipping transport; " + oDCNode2 + " is not config");
                    continue;
                }
            } else if (!oDCNode2.getBooleanProperty(this.odc.transportIsConfig) || !oDCNode2.getBooleanProperty(this.odc.transportIsActive)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping transport; " + oDCNode2 + " is not enabled");
                continue;
            }
            stringBuffer.append("         ").append("<Transport");
            stringBuffer.append(" Hostname=\"").append(oDCNode2.getProperty(this.odc.transportHost)).append("\"");
            stringBuffer.append(" Port =\"").append(oDCNode2.getProperty(this.odc.transportPort)).append("\"");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "transport=" + oDCNode2 + "; protocol=" + string);
            }
            if (string.equalsIgnoreCase("https")) {
                stringBuffer.append(" Protocol =\"").append(string).append("\">").append(this.NL);
                if (generationDefinition == null) {
                    this.httpsProps.addProps("            ", stringBuffer);
                } else {
                    generationDefinition.httpsProps.addProps("            ", stringBuffer);
                }
                stringBuffer.append("         ").append("</Transport>").append(this.NL);
                continue;
            }
            stringBuffer.append(" Protocol =\"").append(oDCNode2.getProperty(this.odc.transportProtocol)).append("\"/>").append(this.NL);
        }
        stringBuffer.append("      ").append("</Server>").append(this.NL);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServer");
        }
    }

    private boolean wildcardMatch(String string, String string2) {
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wildcardMatch", new Object[]{string, string2});
        }
        if (string.equals(string2)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "wildcardMatch- true");
            }
            return true;
        }
        String[] stringArray2 = string.split(":");
        if (stringArray2.length != (stringArray = string2.split(":")).length) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "wildcardMatch- false (length mismatch)");
            }
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i]) || stringArray2[i].equals("*")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "wildcardMatch- false (" + stringArray[i] + " vs " + stringArray2[i] + ")");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "wildcardMatch- true");
        }
        return true;
    }

    private void addRequestMetrics(StringBuffer stringBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRequestMetrics");
        }
        if (this.requestMetricsStanza == null) {
            this.requestMetricsStanza = this.getRequestMetricsStanza();
        }
        if (this.requestMetricsStanza != null) {
            stringBuffer.append(this.requestMetricsStanza).append(this.NL);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRequestMetrics");
        }
    }

    private String getRequestMetricsStanza() {
        PMIRequestMetrics pMIRequestMetrics;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getRequestMetricsStanza");
        }
        if ((pMIRequestMetrics = this.getPMIRMConfiguration()) == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("   ").append("<RequestMetrics");
        stringBuffer.append(" armEnabled=\"").append(pMIRequestMetrics.isEnableARM() ? "true" : "false").append("\"");
        stringBuffer.append(" rmEnabled=\"").append(pMIRequestMetrics.isEnable() ? "true" : "false").append("\"");
        stringBuffer.append(" loggingEnabled=\"").append(pMIRequestMetrics.isEnableLog() ? "true" : "false").append("\"");
        stringBuffer.append(" traceLevel=\"").append(pMIRequestMetrics.getTraceLevel().toString()).append("\">\n");
        EList eList = pMIRequestMetrics.getFilters();
        for (int i = 0; i < eList.size(); ++i) {
            PMIRMFilter pMIRMFilter = (PMIRMFilter)eList.get(i);
            String string = pMIRMFilter.getType().getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "\tfilter type: " + string);
            }
            if (string.equals("EJB")) continue;
            boolean bl = pMIRMFilter.isEnable();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "\tenabled: " + bl);
            }
            stringBuffer.append("      ").append("<filters");
            stringBuffer.append(" enable=\"").append(bl ? "true" : "false").append("\"");
            stringBuffer.append(" type=\"").append(string).append("\">\n");
            EList eList2 = pMIRMFilter.getFilterValues();
            for (int j = 0; j < eList2.size(); ++j) {
                PMIRMFilterValue pMIRMFilterValue = (PMIRMFilterValue)eList2.get(j);
                stringBuffer.append("         ").append("<filterValues");
                stringBuffer.append(" enable=\"").append(pMIRMFilterValue.isEnable() ? "true" : "false").append("\"");
                stringBuffer.append(" value=\"").append(pMIRMFilterValue.getValue()).append("\"/>\n");
            }
            stringBuffer.append("      ").append("</filters>\n");
        }
        stringBuffer.append("      ").append("</RequestMetrics>");
        return stringBuffer.toString();
    }

    private PMIRequestMetrics getPMIRMConfiguration() {
        PMIRequestMetrics pMIRequestMetrics;
        block6: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "readPMIRMConfiguration");
            }
            pMIRequestMetrics = null;
            try {
                String string = AdminServiceFactory.getAdminService().getCellName();
                Repository repository2 = RepositoryFactory.createRepository(this.getConfigRoot(), string, null, null);
                Resource resource = repository2.getConfigRoot().getResource(0, "pmirm.xml");
                EList eList = resource.getContents();
                if (eList.size() > 0) {
                    pMIRequestMetrics = (PMIRequestMetrics)eList.get(0);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fileNotFound");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block6;
                throwable.printStackTrace(System.out);
            }
        }
        return pMIRequestMetrics;
    }

    private String getConfigRoot() throws Exception {
        String string = System.getProperty("was.repository.root");
        if (string == null) {
            throw new Exception("was.repository.root not set");
        }
        return string;
    }

    private static String normalizeContextRoot(String string) {
        if (string == null) {
            return "/";
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public long getLastGenTime() {
        return this.lastGenTime;
    }

    private boolean routeThruOdr(ODCNode oDCNode) throws Exception {
        if (routingPolicy == null) {
            return true;
        }
        return routingPolicy.routeThruOdr(oDCNode);
    }

    static {
        ODR_SESSION_AFFINITY_COOKIE = DEFAULT_ODR_SESSION_AFFINITY_COOKIE = "ODRSESSIONID";
        serverRoot = System.getProperty("server.root", "");
        CONFIG_ATTRS = new String[][]{{"TrustedProxyEnable", "false"}, {"ASDisableNagle", "false"}, {"AcceptAllContent", "false"}, {"AppServerPortPreference", "HostHeader"}, {"ChunkedResponse", "false"}, {"IISDisableNagle", "false"}, {"IISPluginPriority", "High"}, {"IgnoreDNSFailures", "false"}, {"RefreshInterval", "60"}, {"ResponseChunkSize", "64"}, {"VHostMatchingCompat", "false"}};
        LOG_ATTRS = new String[][]{{"LogLevel", "Error"}, {"Name", serverRoot + "/logs/http_plugin.log"}};
        CLUSTER_ATTRS = new String[][]{{"CloneSeparatorChange", "false"}, {"LoadBalance", "Round Robin"}, {"PostSizeLimit", "-1"}, {"RemoveSpecialHeaders", "true"}, {"RetryInterval", "60"}};
        SERVER_ATTRS = new String[][]{{"ConnectTimeout", "0"}, {"ExtendedHandshake", "false"}, {"MaxConnections", "-1"}, {"WaitForContinue", "false"}};
        GLOBAL_PROPS = new String[][]{{"ESIEnable", "false"}, {"ESIMaxCacheSize", "1024"}, {"ESIInvalidationMonitor", "false"}};
        HTTPS_PROPS = new String[][]{{"keyring", serverRoot + "/etc/plugin-key.kdb"}, {"stashfile", serverRoot + "/etc/plugin-key.sth"}};
        odrIncludeStopped = false;
        odrSessionAffinityEnabled = false;
        routingPolicy = null;
    }

    private class RoutingPolicy {
        public final String desc;
        private final Element[] elements;

        public RoutingPolicy(String string) {
            this.desc = string;
            this.elements = this.createElements(string);
        }

        public boolean routeThruOdr(ODCNode oDCNode) throws Exception {
            for (int i = 0; i < this.elements.length; ++i) {
                Element element = this.elements[i];
                if (!element.match(oDCNode)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "match element " + element);
                }
                return element.routeThruOdr;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no element match");
            }
            return true;
        }

        private Element[] createElements(String string) {
            if (string == null) {
                return new Element[0];
            }
            String[] stringArray = string.split(",");
            Element[] elementArray = new Element[stringArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                elementArray[i] = new Element(stringArray[i]);
            }
            return elementArray;
        }

        private class Element {
            public final String desc;
            public final boolean routeThruOdr;
            private final String cell;
            private final String app;
            private final String edition;
            private final String webModule;

            public Element(String string) {
                this.desc = string;
                String[] stringArray = string.split("=");
                String[] stringArray2 = stringArray[0].split("/");
                if (stringArray2.length > 4) {
                    throw new IllegalArgumentException("expecting '<cell>[/<app>[/<edition>[/<webModule>]]]' but found '" + stringArray[0] + "'");
                }
                this.cell = this.getPattern(stringArray2, 0);
                this.app = this.getPattern(stringArray2, 1);
                this.edition = this.getPattern(stringArray2, 2);
                this.webModule = this.getPattern(stringArray2, 3);
                if (stringArray.length != 2) {
                    throw new IllegalArgumentException("expecting '<webModulePattern>=<routePath>' but found '" + string + "'");
                }
                String string2 = stringArray[1];
                if (string2.equalsIgnoreCase("ODR")) {
                    this.routeThruOdr = true;
                } else if (string2.equalsIgnoreCase("direct")) {
                    this.routeThruOdr = false;
                } else {
                    throw new IllegalArgumentException("expecting value of 'ODR' or 'direct', but found '" + string2 + "'");
                }
            }

            public boolean match(ODCNode oDCNode) throws Exception {
                ODCNode oDCNode2;
                ODCNode oDCNode3;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "match wmNode=" + oDCNode);
                }
                if (!this.patternMatch(this.cell, (oDCNode3 = (oDCNode2 = oDCNode.getParent()).getParent()).getName())) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "cell mismatch");
                    }
                    return false;
                }
                if (!this.patternMatch(this.app, (String)oDCNode2.getProperty(((ODCPluginCfgGenerator)ODCPluginCfgGenerator.this).odc.appRoot))) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "app mismatch");
                    }
                    return false;
                }
                if (!this.patternMatch(this.edition, (String)oDCNode2.getProperty(((ODCPluginCfgGenerator)ODCPluginCfgGenerator.this).odc.appEdition))) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "appedition mismatch");
                    }
                    return false;
                }
                if (!this.patternMatch(this.webModule, oDCNode.getName())) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "webModule mismatch");
                    }
                    return false;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "match wmNode=" + oDCNode);
                }
                return true;
            }

            private boolean patternMatch(String string, String string2) {
                if (string == null) {
                    return true;
                }
                return string.equals(string2);
            }

            private String getPattern(String[] stringArray, int n) {
                if (n < stringArray.length) {
                    if (stringArray[n].equals("*")) {
                        return null;
                    }
                    return stringArray[n];
                }
                return null;
            }

            public String toString() {
                return this.desc;
            }
        }
    }

    private class GenerationDefinition {
        public Props configAttrs;
        public Props logAttrs;
        public Props clusterAttrs;
        public Props serverAttrs;
        public Props globalProps;
        public Props httpsProps;
        public ArrayList<String> odrList = new ArrayList();
        public ArrayList<String> odrClusterList = new ArrayList();
        public ArrayList<String> trustedProxyList = new ArrayList();
        public String outputPath = null;
        public String updateScript;
        public String prevFileContents;
        public boolean disabled = false;
        public boolean includeStoppedOdrs = false;
        public String odrSessionCookie = null;
        private String ihsConfigProperties;

        public GenerationDefinition() {
            this.setIhsConfigProperties("");
        }

        public void reset() {
            this.odrList = new ArrayList();
            this.odrClusterList = new ArrayList();
            this.trustedProxyList = new ArrayList();
            this.outputPath = null;
            this.prevFileContents = "";
            this.disabled = false;
            this.includeStoppedOdrs = false;
            this.odrSessionCookie = null;
        }

        public void clearCache() {
            this.prevFileContents = "";
        }

        public String toString() {
            return "includeStoppedOdrs: " + this.includeStoppedOdrs + " odrlist: " + this.odrList.toString() + " clusterList: " + this.odrClusterList + " output: " + this.outputPath + " update: " + this.updateScript + " disabled: " + this.disabled + " odrSessionCookie: " + this.odrSessionCookie;
        }

        public void setIhsConfigProperties(String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setIhsConfigProperties", string);
            }
            this.configAttrs = new Props(CONFIG_ATTRS, string);
            this.logAttrs = new Props(LOG_ATTRS, string);
            this.clusterAttrs = new Props(CLUSTER_ATTRS, string);
            this.serverAttrs = new Props(SERVER_ATTRS, string);
            this.globalProps = new Props(GLOBAL_PROPS, string);
            this.httpsProps = new Props(HTTPS_PROPS, string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setIhsConfigProperties");
            }
        }
    }

    private class NameValuePair {
        public final String name;
        public final String value;

        public NameValuePair(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }

    private class Props {
        private final NameValuePair[] nvPairs;

        public Props(String string, String[][] stringArray) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Props", string);
            }
            ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i][0];
                String string3 = System.getProperty(string + string2, stringArray[i][1]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + "=" + string3);
                }
                arrayList.add(new NameValuePair(string2, string3));
            }
            this.nvPairs = arrayList.toArray(new NameValuePair[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Props");
            }
        }

        public Props(String[][] stringArray, String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Props", new Object[]{string});
            }
            String[] stringArray2 = string.split(",");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < stringArray2.length; ++i) {
                String[] stringArray3 = stringArray2[i].split("=");
                if (stringArray3.length != 2) continue;
                hashMap.put(stringArray3[0], stringArray3[1]);
            }
            ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i][0];
                String string3 = (String)hashMap.get(string2);
                if (string3 == null) {
                    string3 = stringArray[i][1];
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + "=" + string3);
                }
                arrayList.add(new NameValuePair(string2, string3));
            }
            this.nvPairs = arrayList.toArray(new NameValuePair[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Props");
            }
        }

        public void addAttrs(StringBuffer stringBuffer) {
            for (int i = 0; i < this.nvPairs.length; ++i) {
                String string = this.nvPairs[i].name;
                String string2 = this.nvPairs[i].value;
                stringBuffer.append(" ").append(string).append("=\"").append(string2).append("\"");
            }
        }

        public void addProps(String string, StringBuffer stringBuffer) {
            for (int i = 0; i < this.nvPairs.length; ++i) {
                String string2 = this.nvPairs[i].name;
                String string3 = this.nvPairs[i].value;
                stringBuffer.append(string).append("<Property Name=\"").append(string2).append("\" Value=\"").append(string3).append("\"/>").append(ODCPluginCfgGenerator.this.NL);
            }
        }
    }
}

