/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCNodeTypeImpl;
import com.ibm.ws.odc.ODCPropertiesImpl;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCPropertyType;
import java.util.ArrayList;

public class ODCPropertiesFactory {
    private static final TraceComponent tc = TrUtil.register(ODCPropertiesFactory.class);
    private final ArrayList propDescriptors = new ArrayList();
    private final ODCNodeTypeImpl nodeType;
    private static final ODCPropertyDescriptor[] EMPTY = new ODCPropertyDescriptor[0];

    public ODCPropertiesFactory(ODCNodeTypeImpl oDCNodeTypeImpl) {
        this.nodeType = oDCNodeTypeImpl;
    }

    public synchronized void registerPropertyDescriptor(ODCPropertyDescriptor oDCPropertyDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerPropertyDescriptor", oDCPropertyDescriptor);
        }
        if (oDCPropertyDescriptor.getIndex() != -1) {
            throw new IllegalStateException("descriptor already registered: " + oDCPropertyDescriptor.getName());
        }
        ODCPropertyDescriptor oDCPropertyDescriptor2 = this.getPropertyDescriptor(oDCPropertyDescriptor.getName(), false);
        if (oDCPropertyDescriptor2 != null) {
            throw new IllegalArgumentException("property already registered: " + oDCPropertyDescriptor.getName());
        }
        oDCPropertyDescriptor.setIndex(this.propDescriptors.size());
        this.propDescriptors.add(oDCPropertyDescriptor);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerPropertyDescriptor");
        }
    }

    public synchronized ODCPropertyDescriptor getPropertyDescriptor(ODCPropertyDescriptor oDCPropertyDescriptor) {
        ODCPropertyDescriptor oDCPropertyDescriptor2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyDescriptor", oDCPropertyDescriptor);
        }
        if ((oDCPropertyDescriptor2 = this.getPropertyDescriptor(oDCPropertyDescriptor.getName(), false)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertyDescriptor", "found");
            }
            return oDCPropertyDescriptor2;
        }
        this.registerPropertyDescriptor(oDCPropertyDescriptor);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyDescriptor", "registered");
        }
        return oDCPropertyDescriptor;
    }

    public synchronized ODCPropertyDescriptor getPropertyDescriptor(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyDescriptor " + string);
        }
        for (int i = 0; i < this.propDescriptors.size(); ++i) {
            ODCPropertyDescriptor oDCPropertyDescriptor = (ODCPropertyDescriptor)this.propDescriptors.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "desc=" + oDCPropertyDescriptor);
            }
            if (!oDCPropertyDescriptor.getName().equals(string)) continue;
            return oDCPropertyDescriptor;
        }
        if (bl) {
            ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl = new ODCPropertyDescriptorImpl(string, ODCPropertyType.STRING, null, this.nodeType, true, false);
            oDCPropertyDescriptorImpl.setIndex(this.propDescriptors.size());
            this.propDescriptors.add(oDCPropertyDescriptorImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertyDescriptor - created");
            }
            return oDCPropertyDescriptorImpl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyDescriptor - null");
        }
        return null;
    }

    public synchronized ODCPropertyDescriptor findPropertyDescriptor(String string) {
        ODCPropertyDescriptor oDCPropertyDescriptor;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findPropertyDescriptor", string);
        }
        if ((oDCPropertyDescriptor = this.getPropertyDescriptor(string, false)) == null) {
            throw new IllegalArgumentException("unknown property name: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findPropertyDescriptor", oDCPropertyDescriptor);
        }
        return oDCPropertyDescriptor;
    }

    public synchronized ODCPropertyDescriptor[] getPropertyDescriptors() {
        return this.propDescriptors.toArray(EMPTY);
    }

    public synchronized ODCPropertyDescriptor[] getPropertyDescriptors(ODCPropertyDescriptor[] oDCPropertyDescriptorArray) {
        return this.propDescriptors.toArray(oDCPropertyDescriptorArray);
    }

    public int numberOfPropertyDescriptors() {
        return this.propDescriptors.size();
    }

    public synchronized ODCPropertiesImpl create() {
        return new ODCPropertiesImpl(this, this.nodeType);
    }

    public synchronized void clear() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clear property descriptors");
        }
        this.propDescriptors.clear();
    }
}

