/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ws.odc.ODCPropertiesFactory;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCProperties;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCPropertyType;
import com.ibm.wsspi.odc.ODCPropertyValueWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ODCPropertiesImpl
implements ODCProperties {
    private final ODCNodeType nodeType;
    private final ODCPropertiesFactory factory;
    private Object[] values;
    private static final ODCPropertyValueWrapper NULL_VALUE = new ODCPropertyValueWrapper();

    public ODCPropertiesImpl(ODCPropertiesFactory oDCPropertiesFactory, ODCNodeType oDCNodeType) {
        this.nodeType = oDCNodeType;
        this.factory = oDCPropertiesFactory;
        ODCPropertyDescriptor[] oDCPropertyDescriptorArray = oDCPropertiesFactory.getPropertyDescriptors();
        this.values = new Object[oDCPropertyDescriptorArray.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = oDCPropertyDescriptorArray[i].getDefaultValue();
        }
    }

    public Object getProperty(ODCPropertyDescriptor oDCPropertyDescriptor) {
        this.ensureCapacity(oDCPropertyDescriptor.getIndex());
        Object object = this.values[oDCPropertyDescriptor.getIndex()];
        if (object instanceof ODCPropertyValueWrapper) {
            return ((ODCPropertyValueWrapper)object).getPropVal();
        }
        return object;
    }

    public boolean setProperty(ODCPropertyDescriptor oDCPropertyDescriptor, Object object) {
        Object object2;
        Object object3 = this.values[oDCPropertyDescriptor.getIndex()];
        int n = this.getPriority(object3);
        int n2 = this.getPriority(object);
        if (n2 > n) {
            this.values[oDCPropertyDescriptor.getIndex()] = object;
            return true;
        }
        if (n > n2) {
            return false;
        }
        Object object4 = this.unwrapValue(object3);
        if (!(object4 == (object2 = this.unwrapValue(object)) || object4 != null && object2 != null && object4.equals(object2))) {
            this.values[oDCPropertyDescriptor.getIndex()] = object;
            if (object3 == null) {
                object3 = NULL_VALUE;
            }
            return true;
        }
        return false;
    }

    public int getPriority(Object object) {
        if (object instanceof ODCPropertyValueWrapper) {
            return ((ODCPropertyValueWrapper)object).getPropPriority();
        }
        return 0;
    }

    public Object unwrapValue(Object object) {
        if (object instanceof ODCPropertyValueWrapper) {
            return ((ODCPropertyValueWrapper)object).getPropVal();
        }
        return object;
    }

    public Map getProperties() {
        return this.getProperties(true);
    }

    public Map getProperties(boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ODCPropertyDescriptor[] oDCPropertyDescriptorArray = this.factory.getPropertyDescriptors();
        this.ensureCapacity(oDCPropertyDescriptorArray.length - 1);
        for (int i = 0; i < oDCPropertyDescriptorArray.length; ++i) {
            Object object = this.values[i];
            if (object == null) continue;
            if (bl && object instanceof ODCPropertyValueWrapper) {
                object = ((ODCPropertyValueWrapper)object).getPropVal();
            }
            hashMap.put(oDCPropertyDescriptorArray[i].getName(), object);
        }
        return hashMap;
    }

    public void addProperties(Map map) {
        Set set = map.keySet();
        this.values = new Object[set.size()];
        for (String string : set) {
            Object v = map.get(string);
            ODCPropertyDescriptor oDCPropertyDescriptor = new ODCPropertyDescriptorImpl(string, ODCPropertyType.STRING, null, this.nodeType, true, false);
            oDCPropertyDescriptor = this.factory.getPropertyDescriptor(oDCPropertyDescriptor);
            this.setProperty(oDCPropertyDescriptor, v);
        }
    }

    public int size() {
        return this.values.length;
    }

    public ODCPropertyDescriptor getDescriptor(int n) {
        ODCPropertyDescriptor[] oDCPropertyDescriptorArray = this.factory.getPropertyDescriptors();
        if (n >= oDCPropertyDescriptorArray.length) {
            return null;
        }
        return oDCPropertyDescriptorArray[n];
    }

    public Object getValue(int n) {
        return this.values[n];
    }

    public boolean hasValues() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            return true;
        }
        return false;
    }

    public ODCPropertyDescriptor[] getDescriptors() {
        return this.factory.getPropertyDescriptors();
    }

    public Object[] getValues() {
        return this.values;
    }

    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureCapacity(int n) {
        if (this.values.length > n) {
            return;
        }
        ODCPropertiesImpl oDCPropertiesImpl = this;
        synchronized (oDCPropertiesImpl) {
            if (this.values.length > n) {
                return;
            }
            Object[] objectArray = new Object[n + 1];
            System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
            ODCPropertyDescriptor[] oDCPropertyDescriptorArray = this.getDescriptors();
            for (int i = this.values.length; i <= n; ++i) {
                objectArray[i] = i >= oDCPropertyDescriptorArray.length ? null : oDCPropertyDescriptorArray[i].getDefaultValue();
            }
            this.values = objectArray;
        }
    }
}

