/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.odc.IODCFactory;
import com.ibm.wsspi.odc.ODCComponent;
import com.ibm.wsspi.odc.ODCFactory;
import com.ibm.wsspi.runtime.component.WsComponentImpl;

public class ODCService
extends WsComponentImpl {
    private static final TraceComponent tc = TrUtil.register(ODCService.class);
    private static IODCFactory odcFactory;
    private ODCComponent treeBuilder = null;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        if (PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ODCService disabled in z/OS CRA.");
            }
            throw new ComponentDisabledException();
        }
        try {
            odcFactory = ODCFactory.getInstance();
            this.treeBuilder = odcFactory.createODCTreeBuilder();
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Problem with Creation.");
            }
            TrUtil.error(throwable, this, "initialize", tc);
            throw new ComponentDisabledException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", new Object[]{odcFactory, this.treeBuilder});
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        try {
            this.treeBuilder.start();
        }
        catch (Throwable throwable) {
            throw new RuntimeWarning(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        try {
            this.treeBuilder.stop();
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "stop", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public static IODCFactory getODCFactory() {
        return odcFactory;
    }
}

