/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEdgeImpl;
import com.ibm.ws.odc.ODCEventEdgeChangeImpl;
import com.ibm.ws.odc.ODCEventImpl;
import com.ibm.ws.odc.ODCEventNodeChangeImpl;
import com.ibm.ws.odc.ODCEventSetPropertyImpl;
import com.ibm.ws.odc.ODCNodeImpl;
import com.ibm.ws.odc.ODCNodeTypeImpl;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.ws.odc.ODCUtil;
import com.ibm.ws.odc.XmlParser;
import com.ibm.ws.odc.cell.TreeBuilder;
import com.ibm.ws.odc.util.CellPropertyListener;
import com.ibm.ws.odc.util.DoPrivUtil;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.ws.util.Base64;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wsgroup.WsGroupMember;
import com.ibm.ws.wsgroup.WsGroupUtil;
import com.ibm.ws.wsgroup.odc.ODCGroup;
import com.ibm.ws.wsgroup.odc.ODCGroupMember;
import com.ibm.wsspi.odc.ODCEdge;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventEdgeChange;
import com.ibm.wsspi.odc.ODCEventNodeChange;
import com.ibm.wsspi.odc.ODCEventSetProperty;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCListener;
import com.ibm.wsspi.odc.ODCManager;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCPropertyValueWrapper;
import com.ibm.wsspi.odc.ODCTransaction;
import com.ibm.wsspi.odc.ODCTransactionListener;
import com.ibm.wsspi.odc.ODCTree;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPOutputStream;

public class ODCTreeImpl
implements ODCTree {
    protected static final int CHECK_SERVER_INTERVAL = Integer.parseInt(System.getProperty("ODCCheckServerInterval", "180000"));
    private static final TraceComponent tc = TrUtil.register(ODCTreeImpl.class);
    private static final TraceComponent tcSave = Save.access$000();
    private static final TraceComponent tcDebug = Debug.access$100();
    private static final ODCListener[] nullODCListenerArray = new ODCListener[0];
    private static final ODCEvent[] nullEventArray = new ODCEvent[0];
    private static final ODCNode[] nullNodeArray = new ODCNodeImpl[0];
    private static final String[] nullStringArray = new String[0];
    protected static final Timer timer = new Timer(true);
    public final ODCManager mgr;
    private final String name;
    private final ODCNode root;
    private final LinkedHashMap nodeMap = new LinkedHashMap();
    private final List listeners = new LinkedList();
    private final List listenersProperties = new LinkedList();
    private final HashMap currentContributors = new HashMap();
    private final XmlParser xmlParser;
    private boolean running;
    private File file;
    private final List transactionStack = new ArrayList();
    private boolean currentlyCancelingTransactions = false;
    private long generationNumber = 0L;
    private Set ignorableEvents = new HashSet();
    private final ODCGroup odcGroup;
    private byte[][] lastCompressedXml = new byte[5][];
    private TreeBuilder treeBuilder = null;
    public final HashMap leftGroupMap;
    public final HashMap extraGroupMap;
    public LinkedList notifyTransactionStack = new LinkedList();
    protected long lastRolledbackTransaction = -2L;
    protected int rollBackFFDCs = 0;
    protected String lastViolation = "";

    public ODCTreeImpl(ODCManager oDCManager, String string, ODCNodeType oDCNodeType) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ODCTreeImpl", string);
        }
        this.mgr = oDCManager;
        this.name = string;
        this.root = new ODCNodeImpl(string, oDCNodeType, this);
        this.nodeMap.put(this.root.getPath(), this.root);
        this.nodeMap.put("/" + oDCNodeType.getName() + "/" + string, this.root);
        this.xmlParser = new XmlParser(this, ODCHelper.getInstance());
        this.odcGroup = ODCGroup.getInstance(this);
        this.leftGroupMap = new HashMap();
        this.extraGroupMap = new HashMap();
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper.isZOS()) {
            if (platformHelper.isControlJvm()) {
                timer.schedule((TimerTask)new CheckServerStatesTask(this.odcGroup, this), CHECK_SERVER_INTERVAL);
            }
        } else {
            timer.schedule((TimerTask)new CheckServerStatesTask(this.odcGroup, this), CHECK_SERVER_INTERVAL);
        }
        this.loadFromFile();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ODCTreeImpl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile() throws ODCException {
        block10: {
            try {
                String string = System.getProperty("ODC." + this.name + ".init");
                if (string != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "loadFromFile " + string);
                    }
                    FileInputStream fileInputStream = new FileInputStream(string);
                    this.beginTransaction("load from " + string, false);
                    try {
                        this.xmlParser.parse(fileInputStream, true, nullStringArray);
                        this.commitTransaction();
                        break block10;
                    }
                    catch (Exception exception) {
                        TrUtil.error(exception, this, "Problem applying ODC events from file " + string, tc);
                        this.rollbackTransaction();
                        break block10;
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadFromFile disabled");
                }
            }
            catch (Exception exception) {
                throw new ODCException(exception);
            }
        }
    }

    public TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public void setTreeBuilder(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTreeBuilder to " + treeBuilder);
        }
    }

    public ODCGroup getODCGroup() {
        return this.odcGroup;
    }

    public long getGenerationNumber() {
        return this.generationNumber;
    }

    public boolean isConsumer() {
        return this.odcGroup.isConsumer();
    }

    public ODCEvent[] getEvents(boolean bl) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.root.getTreeEvents(bl, arrayList, arrayList2);
        arrayList.addAll(arrayList2);
        return arrayList.toArray(nullEventArray);
    }

    public void performEvents(String string, ODCEvent[] oDCEventArray) throws ODCException {
        this.performEvents(string, oDCEventArray, true);
    }

    public synchronized void performEvents(String string, InputStream inputStream, byte[] byArray, boolean bl, boolean bl2, String string2) throws Exception {
        if (tc.isEntryEnabled() && byArray != null) {
            Tr.entry(tc, "performEvents - transaction=" + string + ", local=" + bl + " BEGIN_TARGET_XML_BASE64:\n" + Base64.encode(byArray) + "\nEND_TARGET_XML_BASE64");
        }
        String[] stringArray = nullStringArray;
        if (bl2) {
            stringArray = this.getServerPathsOfMyContributors(string2);
        }
        this.beginTransaction(string, bl);
        try {
            this.xmlParser.parse(inputStream, false, stringArray);
            this.commitTransaction();
        }
        catch (Exception exception) {
            Tr.error(tc, "Exception perfoming events: " + exception);
            String string3 = null;
            if (byArray != null) {
                string3 = Base64.encode(byArray);
            }
            TrUtil.error(exception, this, "Problem applying ODC events from " + string + "; BEGIN_TARGET_XML_BASE64:\n" + string3 + "\nEND_TARGET_XML", tc);
            this.rollbackTransaction();
            throw new ODCException(exception);
        }
        finally {
            inputStream.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performEvents - transaction=" + string);
        }
    }

    public synchronized void performEvents(String string, String string2, boolean bl, boolean bl2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performEvents - transaction=" + string + ", local=" + bl, string2);
        }
        String[] stringArray = nullStringArray;
        if (bl2) {
            stringArray = this.getServerPathsOfMyContributors(string3);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(string2.getBytes("UTF-8")));
        this.beginTransaction(string, bl);
        try {
            this.xmlParser.parse(bufferedInputStream, false, stringArray);
            this.commitTransaction();
        }
        catch (Exception exception) {
            TrUtil.error(exception, this, "Problem applying ODC events from " + string + "; XML=" + string2, tc);
            this.rollbackTransaction();
            throw new ODCException(exception);
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performEvents - transaction=" + string);
        }
    }

    public synchronized void performEvents(String string, ODCEvent[] oDCEventArray, boolean bl) throws ODCException {
        this.performEvents(string, oDCEventArray, bl, null);
    }

    public synchronized void performEvents(String string, ODCEvent[] oDCEventArray, boolean bl, ODCListener oDCListener) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performEvents", "tx=" + string + " #events=" + oDCEventArray.length + " local: " + bl + " eventSource: " + oDCListener);
        }
        this.beginTransaction(string, oDCEventArray, bl);
        try {
            for (int i = 0; i < oDCEventArray.length; ++i) {
                Object object;
                Object object2;
                ODCEventImpl oDCEventImpl;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing events[" + i + "]=" + oDCEventArray[i]);
                }
                ODCEventImpl oDCEventImpl2 = (ODCEventImpl)oDCEventArray[i];
                oDCEventImpl2.setGenerationNumber(this.generationNumber);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "event=" + oDCEventImpl2);
                }
                if (oDCEventImpl2 instanceof ODCEventEdgeChange) {
                    oDCEventImpl = (ODCEventEdgeChangeImpl)oDCEventImpl2;
                    if (((ODCEventEdgeChangeImpl)oDCEventImpl).isAdd()) {
                        this.obtainEdge(((ODCEventEdgeChangeImpl)oDCEventImpl).parentPath, ((ODCEventEdgeChangeImpl)oDCEventImpl).childPath, oDCEventImpl.getAttachment());
                        continue;
                    }
                    this.releaseEdge(((ODCEventEdgeChangeImpl)oDCEventImpl).parentPath, ((ODCEventEdgeChangeImpl)oDCEventImpl).childPath, oDCEventImpl.getAttachment());
                    continue;
                }
                if (oDCEventImpl2 instanceof ODCEventNodeChange) {
                    ODCNode oDCNode;
                    oDCEventImpl = (ODCEventNodeChangeImpl)oDCEventImpl2;
                    object2 = new StringBuffer();
                    ((StringBuffer)object2).append(((ODCEventNodeChangeImpl)oDCEventImpl).parentPath).append("/").append(((ODCEventNodeChangeImpl)oDCEventImpl).nodeTypeName).append("/").append(((ODCEventNodeChangeImpl)oDCEventImpl).nodeName);
                    object = ((StringBuffer)object2).toString();
                    if (((ODCEventNodeChangeImpl)oDCEventImpl).isAdd()) {
                        oDCNode = this.obtainNode(((ODCEventNodeChangeImpl)oDCEventImpl).nodeName, ((ODCEventNodeChangeImpl)oDCEventImpl).nodeTypeName, (String)object, ((ODCEventNodeChangeImpl)oDCEventImpl).parentPath, oDCEventImpl.getAttachment());
                        if (oDCNode != null) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "obtainNode returns null");
                        }
                        this.ignorableEvents.add(oDCEventImpl2);
                        continue;
                    }
                    oDCNode = (ODCNodeImpl)this.nodeMap.get(object);
                    if (oDCNode == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ignore removeNode; not found: " + (String)object);
                        }
                        this.ignorableEvents.add(oDCEventImpl2);
                        continue;
                    }
                    oDCNode.remove(oDCEventImpl.getAttachment());
                    continue;
                }
                if (oDCEventImpl2 instanceof ODCEventSetProperty) {
                    oDCEventImpl = (ODCEventSetPropertyImpl)oDCEventImpl2;
                    object2 = (ODCNode)this.nodeMap.get(((ODCEventSetPropertyImpl)oDCEventImpl).nodePath);
                    if (object2 == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ignore setProperty on an unknown node: " + oDCEventImpl);
                        }
                        this.ignorableEvents.add(oDCEventImpl2);
                        continue;
                    }
                    object = (ODCPropertyDescriptorImpl)object2.getType().getPropertyDescriptor(((ODCEventSetPropertyImpl)oDCEventImpl).propertyName);
                    if (object == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "setProperty on an unknown property type: " + oDCEventImpl);
                        }
                        this.ignorableEvents.add(oDCEventImpl2);
                        continue;
                    }
                    ((ODCEventSetPropertyImpl)oDCEventImpl).setNode((ODCNode)object2);
                    oDCEventImpl.setEventType((ODCEventType)object);
                    ((ODCNodeImpl)object2).setProperty((ODCEventSetProperty)((Object)oDCEventImpl));
                    continue;
                }
                throw new ODCException("unsupported event type: " + oDCEventImpl2.getClass().getName());
            }
            this.commitTransaction(oDCListener);
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "performTransaction", tc);
            this.rollbackTransaction();
            if (throwable instanceof ODCException) {
                throw (ODCException)throwable;
            }
            throw new ODCException(throwable);
        }
        finally {
            this.ignorableEvents.clear();
        }
    }

    public synchronized ODCNode refreshNode(ODCNode oDCNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshNode", oDCNode);
        }
        if (oDCNode != null && oDCNode.getTree() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attempting to refresh node");
            }
            oDCNode = this.getNode(oDCNode.getPath());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshNode", oDCNode);
        }
        return oDCNode;
    }

    public ODCNodeImpl[] getAllNodes() {
        return (ODCNodeImpl[])this.nodeMap.values().toArray(nullNodeArray);
    }

    public ODCEdgeImpl[] getAllEdges() {
        throw new IllegalStateException("This method is no longer supported.  It should no longer be called because we are using ODCGroup.");
    }

    public synchronized ODCNode createNode(String string, ODCNodeType oDCNodeType, ODCNode oDCNode) throws ODCException {
        return this.createNode(string, oDCNodeType, oDCNode, true);
    }

    public synchronized ODCNode createNode(String string, ODCNodeType oDCNodeType, ODCNode oDCNode, boolean bl) throws ODCException {
        String string2;
        ODCNode oDCNode2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNode", new Object[]{string, oDCNodeType, oDCNode, new Boolean(bl)});
        }
        if ((oDCNode2 = (ODCNode)this.nodeMap.get(string2 = oDCNode == null ? "" : this.makeNodePath(string, oDCNodeType.getName(), oDCNode.getPath()))) == null) {
            oDCNode2 = this.newNode(string, oDCNodeType, oDCNode, bl, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNode", oDCNode2);
        }
        return oDCNode2;
    }

    public ODCNode obtainNode(String string, String string2, String string3, String string4) throws ODCException {
        return this.obtainNode(string, string2, string3, string4, null);
    }

    public synchronized ODCNode obtainNode(String string, String string2, String string3, String string4, Object object) throws ODCException {
        ODCNodeImpl oDCNodeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "obtainNode", new Object[]{string, string2, string3, string4});
        }
        if ((oDCNodeImpl = (ODCNodeImpl)this.nodeMap.get(string3)) == null) {
            ODCNodeImpl oDCNodeImpl2 = (ODCNodeImpl)this.nodeMap.get(string4);
            if (oDCNodeImpl2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "obtainNode", "parent node not found: " + string4);
                }
                return null;
            }
            ODCNodeType oDCNodeType = this.mgr.getNodeType(string2);
            if (oDCNodeType == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "obtainNode", "unknown node type: " + string2);
                }
                return null;
            }
            if (oDCNodeType.getEdgeType(oDCNodeImpl2.getType()) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "obtainNode", "relation " + oDCNodeImpl2.getType() + "-->" + oDCNodeType + " is unknown");
                }
                return null;
            }
            oDCNodeImpl = this.newNode(string, oDCNodeType, oDCNodeImpl2, false, object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "obtainNode", oDCNodeImpl);
        }
        return oDCNodeImpl;
    }

    private ODCNodeImpl newNode(String string, ODCNodeType oDCNodeType, ODCNode oDCNode, boolean bl, Object object) throws ODCException {
        ODCNodeImpl oDCNodeImpl = new ODCNodeImpl(string, oDCNodeType, oDCNode, bl);
        this.nodeMap.put(oDCNodeImpl.getPath(), oDCNodeImpl);
        oDCNodeImpl.setTree(this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "newNode=" + oDCNodeImpl);
        }
        ODCEventNodeChangeImpl oDCEventNodeChangeImpl = new ODCEventNodeChangeImpl(true, oDCNodeImpl, bl, this.getCurrentTransactionName());
        if (object != null) {
            oDCEventNodeChangeImpl.setAttachment(object);
        }
        this.notifyListeners(oDCEventNodeChangeImpl);
        this.obtainEdge(oDCNode, oDCNodeImpl, object);
        return oDCNodeImpl;
    }

    public boolean releaseNode(ODCNode oDCNode) throws ODCException {
        return this.releaseNode(oDCNode, null);
    }

    public synchronized boolean releaseNode(ODCNode oDCNode, Object object) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseNode", new Object[]{oDCNode, object});
        }
        if (oDCNode == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "releaseNode - null");
            }
            return false;
        }
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNode;
        if (this.nodeMap.remove(oDCNodeImpl.getPath()) != null) {
            ODCEventNodeChangeImpl oDCEventNodeChangeImpl = new ODCEventNodeChangeImpl(false, oDCNode, true, this.getCurrentTransactionName());
            if (object != null) {
                oDCEventNodeChangeImpl.setAttachment(object);
            }
            this.notifyListeners(oDCEventNodeChangeImpl);
            oDCNodeImpl.setTree(null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "releaseNode - released " + oDCNode);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseNode - not found " + oDCNode);
        }
        return false;
    }

    public synchronized boolean releaseNode(String string, Object object) throws ODCException {
        return this.releaseNode((ODCNodeImpl)this.nodeMap.get(string), object);
    }

    public ODCEdge obtainEdge(String string, String string2) throws ODCException {
        return this.obtainEdge(string, string2, null);
    }

    public synchronized ODCEdge obtainEdge(String string, String string2, Object object) throws ODCException {
        ODCNodeImpl oDCNodeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "obtainEdge", new Object[]{string, string2});
        }
        if ((oDCNodeImpl = (ODCNodeImpl)this.nodeMap.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "obtainEdge - parent not found");
            }
            return null;
        }
        ODCNodeImpl oDCNodeImpl2 = (ODCNodeImpl)this.nodeMap.get(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parent = " + oDCNodeImpl + "; child = " + oDCNodeImpl2);
        }
        if (oDCNodeImpl2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "obtainEdge - child not found");
            }
            return null;
        }
        ODCEdge oDCEdge = this.obtainEdge(oDCNodeImpl, oDCNodeImpl2, object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "obtainEdge " + oDCEdge);
        }
        return oDCEdge;
    }

    public ODCEdge obtainEdge(ODCNode oDCNode, ODCNode oDCNode2) throws ODCException {
        return this.obtainEdge(oDCNode, oDCNode2, null);
    }

    public synchronized ODCEdge obtainEdge(ODCNode oDCNode, ODCNode oDCNode2, Object object) throws ODCException {
        ODCEdgeType oDCEdgeType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "obtainEdge", new Object[]{oDCNode, oDCNode2, object});
        }
        if ((oDCEdgeType = oDCNode.getType().getEdgeType(oDCNode2.getType())) == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "edge type is not defined");
            }
            return null;
        }
        boolean bl = ((ODCNodeImpl)oDCNode).addEdge((ODCNodeImpl)oDCNode2);
        if (bl) {
            ODCEdgeImpl oDCEdgeImpl = new ODCEdgeImpl(oDCNode, oDCNode2, oDCEdgeType);
            ODCEventEdgeChangeImpl oDCEventEdgeChangeImpl = new ODCEventEdgeChangeImpl(true, oDCEdgeImpl, true, this.getCurrentTransactionName());
            if (object != null) {
                oDCEventEdgeChangeImpl.setAttachment(object);
            }
            this.notifyListeners(oDCEventEdgeChangeImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "obtainEdge", oDCEdgeImpl + " type=" + oDCEdgeType);
            }
            return oDCEdgeImpl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "edge already exists");
        }
        return null;
    }

    public boolean releaseEdge(String string, String string2) throws ODCException {
        return this.releaseEdge(string, string2, null);
    }

    public synchronized boolean releaseEdge(String string, String string2, Object object) throws ODCException {
        ODCNodeImpl oDCNodeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseEdge", new Object[]{string, string2});
        }
        if ((oDCNodeImpl = (ODCNodeImpl)this.nodeMap.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "obtainEdge - parent not found");
            }
            return false;
        }
        ODCNodeImpl oDCNodeImpl2 = (ODCNodeImpl)this.nodeMap.get(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parent = " + oDCNodeImpl + "; child = " + oDCNodeImpl2);
        }
        if (oDCNodeImpl2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "obtainEdge - child not found");
            }
            return false;
        }
        boolean bl = this.releaseEdge(oDCNodeImpl, oDCNodeImpl2, object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseEdge - " + bl);
        }
        return bl;
    }

    public boolean releaseEdge(ODCNode oDCNode, ODCNode oDCNode2) throws ODCException {
        return this.releaseEdge(oDCNode, oDCNode2, null);
    }

    public synchronized boolean releaseEdge(ODCNode oDCNode, ODCNode oDCNode2, Object object) throws ODCException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseEdge", new Object[]{oDCNode, oDCNode2});
        }
        if (!(bl = ((ODCNodeImpl)oDCNode).removeEdge((ODCNodeImpl)oDCNode2))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "releaseEdge - edge not found");
            }
            return false;
        }
        ODCEdgeType oDCEdgeType = oDCNode.getType().getEdgeType(oDCNode2.getType());
        if (oDCEdgeType == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "releaseEdge - type not found");
            }
            return false;
        }
        ODCEdgeImpl oDCEdgeImpl = new ODCEdgeImpl(oDCNode, oDCNode2, oDCEdgeType);
        ODCEventEdgeChangeImpl oDCEventEdgeChangeImpl = new ODCEventEdgeChangeImpl(false, oDCEdgeImpl, true, this.getCurrentTransactionName());
        if (object != null) {
            oDCEventEdgeChangeImpl.setAttachment(object);
        }
        this.notifyListeners(oDCEventEdgeChangeImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseEdge - done");
        }
        return true;
    }

    public String makeNodePath(String string, String string2, String string3) throws ODCException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3).append("/").append(string2).append("/").append(string);
        return stringBuffer.toString().intern();
    }

    private boolean isInTransaction() throws ODCException {
        return this.transactionStack.size() > 0;
    }

    public ODCNode getRoot() {
        return this.root;
    }

    public ODCManager getManager() {
        return this.mgr;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.flushToFile();
    }

    public String getName() {
        return this.name;
    }

    public synchronized byte[] getCompressedXml() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompressedXml");
        }
        if (this.lastCompressedXml[ODCGroup.groupVersion] != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCompressedXml - (using cache) compressed size: " + this.lastCompressedXml[ODCGroup.groupVersion].length);
            }
            return this.lastCompressedXml[ODCGroup.groupVersion];
        }
        if (ODCGroup.groupVersion < 4) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(byteArrayOutputStream), false, "UTF-8");
            this.printHeader(printStream);
            this.root.print(printStream);
            printStream.close();
            String string = byteArrayOutputStream.toString("UTF-8");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string);
            }
            this.lastCompressedXml[ODCGroup.groupVersion] = WsGroupUtil.objectToByteArray(string, true);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)new GZIPOutputStream(byteArrayOutputStream), false, "UTF-8");
            this.printHeader(printStream);
            this.root.print(printStream);
            printStream.close();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BEGIN_TARGET_XML_BASE64:\n " + Base64.encode(byteArrayOutputStream.toByteArray()) + "\nEND_TARGET_XML_BASE64");
            }
            this.lastCompressedXml[ODCGroup.groupVersion] = byteArrayOutputStream.toByteArray();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompressedXml - compressed size: " + this.lastCompressedXml[ODCGroup.groupVersion].length);
        }
        return this.lastCompressedXml[ODCGroup.groupVersion];
    }

    protected void printHeader(PrintStream printStream) throws Exception {
        printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printStream.println("<!DOCTYPE target [<!ENTITY apos \"'\"> <!ENTITY nbsp \" \">]>");
        printStream.println("<!-- ");
        printStream.print("   Automatically generated by: ");
        printStream.println(ODCUtil.getMyServerPath());
        printStream.print("   Date: ");
        printStream.println(new Date());
        printStream.print("   Generation number: ");
        printStream.println(this.generationNumber);
        printStream.print("   Potential number of contributors: ");
        printStream.println(this.odcGroup.getCurrentMemberCount());
        printStream.print("   Current number of contributors: ");
        printStream.println(this.getCurrentNumberOfContributors());
        printStream.print("   Current contributors: ");
        printStream.println(this.getMyContributorInfoList());
        printStream.println(" -->");
    }

    public void flushToFile() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flushToFile");
        }
        if (!tcSave.isDebugEnabled() && !tcDebug.isDebugEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "flushToFile", "debug is not enabled");
            }
            return;
        }
        if (this.file == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "flushToFile", "no backing file");
            }
            return;
        }
        if (this.root == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "flushToFile", "no root");
            }
            return;
        }
        try {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(DoPrivUtil.getOutputStream(this.file), 2048));
            this.printHeader(printStream);
            this.root.print(printStream);
            printStream.close();
        }
        catch (Exception exception) {
            TrUtil.warning(exception, this, "flushToFile", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flushToFile");
        }
    }

    public void print(PrintStream printStream) throws ODCException, IOException {
        this.root.print(printStream);
    }

    public void addListener(ODCListener oDCListener) {
        this.addListener(oDCListener, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ODCListener oDCListener, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addListener", oDCListener);
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(oDCListener);
            this.listenersProperties.add(properties);
            this.updateConsumerStatus();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ODCListener oDCListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListener", oDCListener);
        }
        List list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (this.listeners.get(i) != oDCListener) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing listener " + i);
                }
                this.listeners.remove(i);
                this.listenersProperties.remove(i);
            }
            this.updateConsumerStatus();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListener");
        }
    }

    private void updateConsumerStatus() {
        try {
            for (int i = 0; i < this.listenersProperties.size(); ++i) {
                Properties properties = (Properties)this.listenersProperties.get(i);
                if (!properties.getProperty("consumer", "true").equals("true")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateConsumerStatus: found consumer " + this.listeners.get(i));
                }
                this.odcGroup.setConsumer(true);
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateConsumerStatus: no consumers");
            }
            this.odcGroup.setConsumer(false);
        }
        catch (Exception exception) {
            TrUtil.error(exception, "failed to setConsumer status", this, "setConsumer", tc);
        }
    }

    public synchronized void performTransaction(ODCTransaction oDCTransaction, Object object) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTransaction passback=" + object + " tx=" + oDCTransaction);
        }
        this.beginTransaction(oDCTransaction.getClass().getName());
        try {
            oDCTransaction.performODCTransaction(object);
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "performTransaction", tc);
            this.rollbackTransaction();
            if (throwable instanceof ODCException) {
                throw (ODCException)throwable;
            }
            throw new ODCException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTransaction");
        }
    }

    public void beginTransaction(String string) {
        this.beginTransaction(string, true);
    }

    public void beginTransaction(String string, boolean bl) {
        Transaction transaction = new Transaction(string, ++this.generationNumber, bl);
        this.transactionStack.add(transaction);
        this.notifyTransactionStack.add(transaction);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BEGIN TRANSACTION: " + transaction);
        }
    }

    public synchronized void beginTransaction(String string, ODCEvent[] oDCEventArray, boolean bl) {
        Transaction transaction = new Transaction(string, ++this.generationNumber, bl);
        transaction.unFilteredEvents = oDCEventArray;
        this.transactionStack.add(transaction);
        this.notifyTransactionStack.add(transaction);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BEGIN TRANSACTION: " + transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkServerStates() throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkServerStates");
        }
        if (!this.isConsumer()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkServerStates - not a consumer");
            }
            return;
        }
        ODCTreeImpl oDCTreeImpl = this;
        synchronized (oDCTreeImpl) {
            ODCHelper oDCHelper = ODCHelper.getInstance();
            ODCNodeImpl[] oDCNodeImplArray = this.getAllNodes();
            for (int i = 0; i < oDCNodeImplArray.length; ++i) {
                String string;
                if (oDCNodeImplArray[i].getType() != oDCHelper.server || (string = (String)oDCNodeImplArray[i].getProperty(oDCHelper.serverType)) == null || !Util.isProxy(string) && !string.equals("APPLICATION_SERVER") && !string.equals("NODE_AGENT") && !string.equals("DEPLOYMENT_MANAGER") || this.odcGroup == null || !this.odcGroup.isReady() || oDCNodeImplArray[i].getType() != oDCHelper.server || !"STOPPED".equals(oDCNodeImplArray[i].getProperty(oDCHelper.serverState))) continue;
                ODCNode oDCNode = oDCNodeImplArray[i].getParent(oDCHelper.node);
                ODCNode oDCNode2 = oDCNode.getParent(oDCHelper.cell);
                String string2 = oDCNode2.getName() + "\\" + oDCNode.getName() + "\\" + oDCNodeImplArray[i].getName();
                Set set = this.odcGroup.getMemberNames();
                if (!set.contains(string2) || System.currentTimeMillis() - this.odcGroup.getMemberJoinTime(string2) <= 600000L) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server: " + string2 + " is in the ODCGroup but has a state of " + oDCNodeImplArray[i].getProperty(oDCHelper.serverState) + ", marking as started");
                }
                if (this.extraGroupMap.get(string2) != null) continue;
                HandleExtraMemberTask handleExtraMemberTask = new HandleExtraMemberTask(oDCNodeImplArray[i].getLongName(), string2, this.odcGroup, this);
                timer.schedule((TimerTask)handleExtraMemberTask, ODCGroup.LEFT_GROUP_DELAY);
                this.extraGroupMap.put(string2, handleExtraMemberTask);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkServerStates");
        }
    }

    public synchronized void commitTransaction() throws ODCException {
        this.commitTransaction(null);
    }

    public synchronized void commitTransaction(ODCListener oDCListener) throws ODCException {
        Object object;
        Transaction transaction;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commitTransaction from: " + oDCListener);
        }
        if (!"TargetSelectorImpl - initWLM".equals((transaction = this.topTransaction()).getName())) {
            this.checkForViolations(transaction);
        }
        ODCEvent[] oDCEventArray = transaction.events.toArray(nullEventArray);
        for (int i = 0; i < this.lastCompressedXml.length; ++i) {
            this.lastCompressedXml[i] = null;
        }
        transaction = this.popTransaction();
        Transaction transaction2 = this.topTransaction();
        if (transaction2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NESTED COMMIT TRANSACTION: " + transaction.name + " to " + transaction2.name);
            }
            for (int i = 0; i < transaction.events.size(); ++i) {
                transaction2.events.add(transaction.events.get(i));
            }
            this.popNotifyTransaction();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commitTransaction", "returned to enclosing transaction");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "COMMIT TRANSACTION: " + transaction);
        }
        this.flushToFile();
        ArrayList<ODCEvent> arrayList = new ArrayList<ODCEvent>();
        Iterator iterator = transaction.events.iterator();
        while (iterator.hasNext()) {
            ODCEvent oDCEvent;
            Object e2 = iterator.next();
            if (this.ignorableEvents.contains(e2)) {
                iterator.remove();
                continue;
            }
            if (e2 instanceof ODCEventSetProperty) {
                oDCEvent = (ODCEventSetProperty)e2;
                if (oDCEvent.getNode().getTree() != null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node was removed; ignoring event: " + e2);
                }
                iterator.remove();
                continue;
            }
            if (e2 instanceof ODCEventNodeChange) {
                ODCNode oDCNode;
                oDCEvent = (ODCEventNodeChange)e2;
                if (oDCEvent.isAdd() && oDCEvent.getNode().getTree() == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "node was removed; ignoring event: " + e2);
                    }
                    iterator.remove();
                    continue;
                }
                if (this.treeBuilder == null || !this.treeBuilder.inDMgr || transaction.local || !oDCEvent.isAdd() || !oDCEvent.getNode().isOnMyCell()) continue;
                ODCHelper oDCHelper = ODCHelper.getInstance();
                if (oDCEvent.getNode().getType() == oDCHelper.application) {
                    if (!oDCEvent.getNode().getBooleanProperty(oDCHelper.appIsWebSphere) || oDCEvent.getNode().getBooleanProperty(oDCHelper.applicationIsSystem) || this.treeBuilder.applicationExists(oDCEvent.getNode().getName())) continue;
                    arrayList.add(oDCEvent);
                    iterator.remove();
                    continue;
                }
                if (oDCEvent.getNode().getType() == oDCHelper.server) {
                    object = oDCEvent.getNode().getParent(oDCHelper.node);
                    oDCNode = object.getParent(oDCHelper.cell);
                    if (oDCEvent.getNode().getProperty(oDCHelper.serverType) == null || "GENERIC_CLUSTER_MEMBER".equals(oDCEvent.getNode().getProperty(oDCHelper.serverType)) || this.treeBuilder.serverExists(oDCNode, (ODCNode)object, oDCEvent.getNode().getName())) continue;
                    arrayList.add(oDCEvent);
                    iterator.remove();
                    continue;
                }
                if (oDCEvent.getNode().getType() == oDCHelper.vhostGroup) {
                    object = oDCEvent.getNode().getParent(oDCHelper.cell);
                    if (object == null) continue;
                    try {
                        if (this.treeBuilder.virtualHostGroupExists((ODCNode)object, oDCEvent.getNode())) continue;
                        arrayList.add(oDCEvent);
                        iterator.remove();
                        continue;
                    }
                    catch (Exception exception) {
                        throw new ODCException(exception);
                    }
                }
                if (oDCEvent.getNode().getType() != oDCHelper.vhost || (object = oDCEvent.getNode().getParent(oDCHelper.vhostGroup)) == null || (oDCNode = object.getParent(oDCHelper.cell)) == null) continue;
                try {
                    if (this.treeBuilder.virtualHostExists(oDCNode, oDCEvent.getNode())) continue;
                    arrayList.add(oDCEvent);
                    iterator.remove();
                    continue;
                }
                catch (Exception exception) {
                    throw new ODCException(exception);
                }
            }
            if (!(e2 instanceof ODCEventEdgeChange) || !(oDCEvent = (ODCEventEdgeChange)e2).isAdd()) continue;
            if (oDCEvent.getSrcNode().getTree() == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "src node removed; ignoring event: " + e2);
                }
                iterator.remove();
                continue;
            }
            if (oDCEvent.getDstNode().getTree() != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dst node removed; ignoring event: " + e2);
            }
            iterator.remove();
        }
        oDCEventArray = transaction.events.toArray(nullEventArray);
        long l = System.currentTimeMillis();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TRANSACTION " + transaction.generationNumber + ": event list");
            for (int i = 0; i < oDCEventArray.length; ++i) {
                Tr.debug(tc, "   (" + i + ") " + oDCEventArray[i]);
            }
            Tr.debug(tc, "TRANSACTION " + transaction.generationNumber + ": notifying listeners ...");
        }
        if (oDCEventArray.length != 0) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            object = this.getListeners();
            for (int i = 0; i < ((ODCListener[])object).length; ++i) {
                ODCListener oDCListener2 = object[i];
                if (oDCListener2 == oDCListener) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Not notifying event source listener: " + oDCListener);
                    continue;
                }
                ListenerActivationRecord listenerActivationRecord = new ListenerActivationRecord(oDCListener2.toString());
                long l2 = System.currentTimeMillis();
                if (oDCListener2 instanceof ODCTransactionListener) {
                    try {
                        long l3 = System.currentTimeMillis();
                        ((ODCTransactionListener)oDCListener2).handleEvents(oDCEventArray);
                        listenerActivationRecord.setInvocationCount(listenerActivationRecord.getInvocationCount() + 1L);
                        long l4 = System.currentTimeMillis() - l3;
                        if (listenerActivationRecord.getMaxInvocationTime() < l4) {
                            listenerActivationRecord.setMaxInvocationTime(l4);
                        }
                    }
                    catch (Throwable throwable) {
                        TrUtil.warning(throwable, this, "commitTransaction", tc);
                    }
                } else {
                    for (int j = 0; j < oDCEventArray.length; ++j) {
                        ODCEvent oDCEvent = oDCEventArray[j];
                        if (!this.isInterested(oDCListener2, oDCEvent.getEventType())) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "notify: listener=" + oDCListener2 + ", event=" + oDCEvent);
                        }
                        try {
                            long l5 = System.currentTimeMillis();
                            oDCListener2.handleEvent(oDCEvent);
                            listenerActivationRecord.setInvocationCount(listenerActivationRecord.getInvocationCount() + 1L);
                            long l6 = System.currentTimeMillis() - l5;
                            if (listenerActivationRecord.getMaxInvocationTime() >= l6) continue;
                            listenerActivationRecord.setMaxInvocationTime(l6);
                            continue;
                        }
                        catch (Throwable throwable) {
                            TrUtil.warning(throwable, this, "commitTransaction", tc);
                        }
                    }
                }
                listenerActivationRecord.setTotalInvocationTime(System.currentTimeMillis() - l2);
                if (listenerActivationRecord.getTotalInvocationTime() > CellPropertyListener.getIndividualListenerTimeThreshold() && tc.isDetailEnabled()) {
                    Tr.fireTraceEvent(2, tc, null, "Spent " + listenerActivationRecord.getTotalInvocationTime() + "ms notifying listener " + oDCListener2 + ", over threshold of " + CellPropertyListener.getIndividualListenerTimeThreshold() + "ms during transaction with " + oDCEventArray.length + " events.  Statistics: " + listenerActivationRecord.toString(), null);
                }
                linkedList.add(listenerActivationRecord);
            }
            long l7 = System.currentTimeMillis() - l;
            if (l7 > CellPropertyListener.getTotalListenerTimeThreshold()) {
                if (tc.isDetailEnabled()) {
                    Tr.fireTraceEvent(2, tc, null, "Spent " + l7 + "ms notifying " + linkedList.size() + " listeners for " + oDCEventArray.length + " events, over threshold of " + CellPropertyListener.getTotalListenerTimeThreshold() + "ms", null);
                }
                for (ListenerActivationRecord listenerActivationRecord : linkedList) {
                    if (!tc.isDetailEnabled()) continue;
                    Tr.fireTraceEvent(2, tc, null, "Listener: " + listenerActivationRecord.getName() + " stats: " + listenerActivationRecord.toString(), null);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no events, so skipping listener notification");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TRANSACTION " + transaction.generationNumber + ": done notifying listeners");
        }
        this.popNotifyTransaction();
        if (arrayList.size() != 0) {
            this.beginTransaction("invalid event reversal");
            Iterator iterator2 = arrayList.iterator();
            object = ODCHelper.getInstance();
            while (iterator2.hasNext()) {
                ODCEventNodeChange oDCEventNodeChange = (ODCEventNodeChange)iterator2.next();
                if (oDCEventNodeChange.getNode().getType() == ((ODCHelper)object).server) {
                    oDCEventNodeChange.getNode().remove();
                    continue;
                }
                if (oDCEventNodeChange.getNode().getType() == ((ODCHelper)object).application) {
                    oDCEventNodeChange.getNode().remove();
                    continue;
                }
                if (oDCEventNodeChange.getNode().getType() != ((ODCHelper)object).vhost && oDCEventNodeChange.getNode().getType() != ((ODCHelper)object).vhostGroup) continue;
                oDCEventNodeChange.getNode().remove();
            }
            this.commitTransaction();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commitTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollbackTransaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackTransaction");
        }
        Transaction transaction = this.popTransaction();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ROLLBACK TRANSACTION: " + transaction);
        }
        if (transaction == null) {
            throw new IllegalStateException("no transaction to rollback");
        }
        this.currentlyCancelingTransactions = true;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            while (transaction.events.size() > 0) {
                object4 = (ODCEventImpl)transaction.events.remove(transaction.events.size() - 1);
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RollBackTransaction: orig event=" + ((ODCEventImpl)object4).toString());
                    }
                    ((ODCEventImpl)object4).reverseEvent();
                    if (object4 instanceof ODCEventEdgeChange) {
                        object3 = (ODCEventEdgeChangeImpl)object4;
                        if (((ODCEventEdgeChangeImpl)object3).isAdd()) {
                            object2 = ((ODCEventEdgeChangeImpl)object3).getEdge();
                            this.obtainEdge(object2.getSrcNode().getPath(), object2.getDstNode().getPath(), ((ODCEventImpl)object3).getAttachment());
                            continue;
                        }
                        this.releaseEdge(((ODCEventEdgeChangeImpl)object3).parentPath, ((ODCEventEdgeChangeImpl)object3).childPath, ((ODCEventImpl)object3).getAttachment());
                        continue;
                    }
                    if (object4 instanceof ODCEventNodeChange) {
                        object3 = (ODCEventNodeChangeImpl)object4;
                        if (((ODCEventNodeChangeImpl)object3).isAdd()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "RollBackTransaction: event=" + ((ODCEventNodeChangeImpl)object3).toString() + " nc.nodeName=" + ((ODCEventNodeChangeImpl)object3).nodeName + " nc.nodeTypeName=" + ((ODCEventNodeChangeImpl)object3).nodeTypeName + " nc.nodePath=" + ((ODCEventNodeChangeImpl)object3).getNode().getPath() + " nc.parentPath=" + ((ODCEventNodeChangeImpl)object3).parentPath);
                            }
                            if ((object = this.obtainNode((object2 = ((ODCEventNodeChangeImpl)object3).getNode()).getName(), object2.getType().getName(), object2.getPath(), object2.getParent().getPath(), ((ODCEventImpl)object3).getAttachment())) == null) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "obtainNode returns null");
                                continue;
                            }
                            this.copyNodeProperties((ODCNode)object2, (ODCNode)object);
                            continue;
                        }
                        this.releaseNode(((ODCEventNodeChangeImpl)object3).getNode(), ((ODCEventImpl)object3).getAttachment());
                        continue;
                    }
                    if (!(object4 instanceof ODCEventSetProperty)) continue;
                    object3 = (ODCEventSetPropertyImpl)object4;
                    object2 = this.mgr.getNodeType(((ODCEventSetPropertyImpl)object3).propertyName);
                    if (object2 == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "node type is unknown; ignoring event: " + object4);
                        continue;
                    }
                    object = (ODCPropertyDescriptorImpl)object2.getPropertyDescriptor(((ODCEventSetPropertyImpl)object3).propertyName);
                    ODCNode oDCNode = ((ODCEventSetPropertyImpl)object3).getNode();
                    if (oDCNode == null || object == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "setProperty on an unknown node.");
                        continue;
                    }
                    ((ODCNodeImpl)oDCNode).setProperty((ODCEventSetProperty)object3);
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "rollbackTransaction", tc);
                }
            }
            this.flushToFile();
            try {
                if (tc.isDebugEnabled()) {
                    this.checkForViolations(transaction);
                }
            }
            catch (ODCException oDCException) {
                TrUtil.warning(oDCException, this, "rollbackTransaction", tc);
                throw new RuntimeException(oDCException);
            }
            if (tc.isDebugEnabled() && transaction.generationNumber != this.lastRolledbackTransaction + 1L) {
                try {
                    object4 = new ByteArrayOutputStream();
                    object3 = new PrintStream((OutputStream)object4);
                    this.print((PrintStream)object3);
                    object2 = new String(((ByteArrayOutputStream)object4).toByteArray());
                    object = new Exception("rollbackTransaction:" + transaction.name + ":" + transaction.generationNumber + " Original Tree\n" + (String)object2);
                    TrUtil.error((Throwable)object, " rollbackTransaction:" + transaction.name + "[" + transaction.generationNumber + "] ", this, " rollbackTransaction:" + transaction.name + "[" + transaction.generationNumber + "] ", tc);
                    ++this.rollBackFFDCs;
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "rollbackTransaction: exception while printing debug info", tc);
                }
            }
            this.lastRolledbackTransaction = transaction.generationNumber;
        }
        finally {
            this.popNotifyTransaction();
            this.currentlyCancelingTransactions = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackTransaction");
        }
    }

    protected int specialViolations(ODCNode oDCNode, StringBuffer stringBuffer, int n) throws ODCException {
        ODCNodeType oDCNodeType = oDCNode.getType();
        if (oDCNodeType == ODCHelper.getInstance().server) {
            String string = oDCNode.getProperty(ODCHelper.getInstance().serverType) + "";
            if (string.trim().equals("") || string.endsWith("AGENT")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server: " + oDCNode + " is exempt from checks");
                }
            } else {
                ODCNode oDCNode2 = oDCNode.getNode(ODCHelper.getInstance().cluster);
                if (oDCNode2 == null) {
                    stringBuffer.append("\nODC violation ").append(++n).append(": missing required parent 'cluster' on node ").append(oDCNode.getPath());
                }
            }
        }
        return n;
    }

    private void checkForViolations(Transaction transaction) throws ODCException {
        String string = transaction.name;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        this.addViolationPrefixInfo(string, transaction.unFilteredEvents, stringBuffer);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "checking requirements ...");
        }
        for (ODCNodeImpl oDCNodeImpl : this.nodeMap.values()) {
            ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNodeImpl.getType();
            ODCPropertyDescriptor[] oDCPropertyDescriptorArray = oDCNodeTypeImpl.getRequiredProperties();
            for (int i = 0; i < oDCPropertyDescriptorArray.length; ++i) {
                if (oDCNodeImpl.getProperty(oDCPropertyDescriptorArray[i]) != null) continue;
                stringBuffer.append("\nODC violation ").append(++n).append(": missing required property '").append(oDCPropertyDescriptorArray[i].getName()).append("' on node ").append(oDCNodeImpl.getPath());
            }
            ODCNodeType[] oDCNodeTypeArray = oDCNodeTypeImpl.getRequiredParents();
            for (int i = 0; i < oDCNodeTypeArray.length; ++i) {
                if (oDCNodeImpl.parentCount(oDCNodeTypeArray[i]) > 0) continue;
                stringBuffer.append("\nODC violation ").append(++n).append(": missing required parent '").append(oDCNodeTypeArray[i].getName()).append("' on node ").append(oDCNodeImpl.getPath());
            }
            ODCNodeType[] oDCNodeTypeArray2 = oDCNodeTypeImpl.getRequiredChildren();
            for (int i = 0; i < oDCNodeTypeArray2.length; ++i) {
                if (oDCNodeImpl.childCount(oDCNodeTypeArray2[i]) > 0) continue;
                stringBuffer.append("\nODC violation ").append(++n).append(": missing required child '").append(oDCNodeTypeArray2[i].getName()).append("' on node ").append(oDCNodeImpl.getPath());
            }
            n = this.specialViolations(oDCNodeImpl, stringBuffer, n);
        }
        if (n > 0) {
            this.throwViolationsException(transaction, stringBuffer);
        }
    }

    private void addViolationPrefixInfo(String string, ODCEvent[] oDCEventArray, StringBuffer stringBuffer) {
        stringBuffer.append("ODC violation from " + string);
    }

    private void throwViolationsException(Transaction transaction, StringBuffer stringBuffer) throws ODCException {
        int n;
        ODCEvent[] oDCEventArray = transaction.events.toArray(nullEventArray);
        String string = stringBuffer.toString();
        if (string.equalsIgnoreCase(this.lastViolation)) {
            throw new ODCException("Repeat Violation");
        }
        this.lastViolation = string;
        stringBuffer.append("\nTransaction: " + transaction.name + ":" + transaction.generationNumber);
        stringBuffer.append("\nBEGIN Filtered events\n");
        for (n = 0; n < oDCEventArray.length; ++n) {
            stringBuffer.append("(").append(n + 1).append(") ").append(oDCEventArray[n].toString()).append("\n");
        }
        stringBuffer.append("END  Filtered events");
        oDCEventArray = transaction.unFilteredEvents;
        if (oDCEventArray != null) {
            stringBuffer.append("\nBEGIN Raw events\n");
            for (n = 0; n < oDCEventArray.length; ++n) {
                stringBuffer.append("(").append(n + 1).append(") ").append(oDCEventArray[n].toString()).append("\n");
            }
            stringBuffer.append("END  Raw events");
        }
        String string2 = stringBuffer.toString();
        throw new ODCException(string2);
    }

    private Transaction popTransaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "popTransaction");
        }
        int n = this.transactionStack.size();
        Transaction transaction = null;
        if (n > 0) {
            transaction = (Transaction)this.transactionStack.remove(n - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "popTransaction", transaction);
        }
        return transaction;
    }

    private Transaction popNotifyTransaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "popNotifyTransaction");
        }
        int n = this.notifyTransactionStack.size();
        Transaction transaction = null;
        if (n > 0) {
            transaction = (Transaction)this.notifyTransactionStack.remove(n - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "popNotifyTransaction", transaction);
        }
        return transaction;
    }

    private Transaction topTransaction() {
        int n = this.transactionStack.size();
        Transaction transaction = n == 0 ? null : (Transaction)this.transactionStack.get(n - 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "top=" + transaction);
        }
        return transaction;
    }

    public void startConsumers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startConsumers");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startConsumers");
        }
    }

    public void stopConsumers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopConsumers");
        }
        if (!this.running) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopConsumers");
        }
    }

    public synchronized ODCNodeImpl getNode(String string) {
        return (ODCNodeImpl)this.nodeMap.get(string);
    }

    public synchronized ODCNode getODCNode(String string) {
        return this.getNode(string);
    }

    public ODCNodeImpl findNode(String string) throws ODCException {
        ODCNodeImpl oDCNodeImpl = this.getNode(string);
        if (oDCNodeImpl == null) {
            throw new ODCException("node not found: " + string);
        }
        return oDCNodeImpl;
    }

    public synchronized void registerNode(ODCNode oDCNode, boolean bl) throws ODCException {
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNode;
        if (oDCNodeImpl.isRegistered()) {
            return;
        }
        if (this.nodeMap.get(oDCNode.getPath()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "register " + oDCNode);
            }
            this.nodeMap.put(oDCNode.getPath(), oDCNode);
            oDCNodeImpl.setRegistered(true);
            ODCEventNodeChangeImpl oDCEventNodeChangeImpl = new ODCEventNodeChangeImpl(true, oDCNode, bl, this.getCurrentTransactionName());
            this.notifyListeners(oDCEventNodeChangeImpl);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, oDCNode + " is already registered");
        }
    }

    public synchronized void unregisterNode(ODCNode oDCNode, boolean bl) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterNode - " + oDCNode);
        }
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNode;
        if (this.nodeMap.remove(oDCNode.getPath()) != null) {
            oDCNodeImpl.setRegistered(false);
            ODCEventNodeChangeImpl oDCEventNodeChangeImpl = new ODCEventNodeChangeImpl(false, oDCNode, bl, this.getCurrentTransactionName());
            this.notifyListeners(oDCEventNodeChangeImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unregisterNode - removed");
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterNode - not found");
        }
    }

    public void notifyListeners(ODCEvent oDCEvent) throws ODCException {
        if (this.currentlyCancelingTransactions) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "notifyListeners", "canceling transaction");
            }
            return;
        }
        ((ODCEventImpl)oDCEvent).setGenerationNumber(this.generationNumber);
        if (this.transactionStack.size() > 0) {
            if (tc.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = this.transactionStack.size() - 1; i >= 0; --i) {
                    stringBuffer.append("--> " + this.transactionStack.get(i));
                }
                Tr.debug(tc, "in transaction " + stringBuffer);
            }
            this.topTransaction().addEvents((ODCEventImpl)oDCEvent);
        } else {
            this.flushToFile();
            this.notifyListenersNow(oDCEvent);
        }
    }

    private void notifyListenersNow(ODCEvent oDCEvent) {
        ODCEventType oDCEventType = oDCEvent.getEventType();
        ODCListener[] oDCListenerArray = this.getListeners();
        for (int i = 0; i < oDCListenerArray.length; ++i) {
            if (!this.isInterested(oDCListenerArray[i], oDCEventType)) continue;
            try {
                oDCListenerArray[i].handleEvent(oDCEvent);
                continue;
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "notifyListeners", tc);
            }
        }
    }

    private boolean isInterested(ODCListener oDCListener, ODCEventType oDCEventType) {
        ODCEventType[] oDCEventTypeArray = oDCListener.interestEventTypes();
        if (oDCEventTypeArray == null) {
            return true;
        }
        for (int i = 0; i < oDCEventTypeArray.length; ++i) {
            if (oDCEventTypeArray[i] != oDCEventType) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ODCListener[] getListeners() {
        List list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(nullODCListenerArray);
        }
    }

    public String toString() {
        return this.name;
    }

    public synchronized String getCurrentTransactionName() {
        String string = "unknown";
        Transaction transaction = this.topTransaction();
        if (transaction == null) {
            return "unknown";
        }
        return transaction.name;
    }

    public synchronized String getLocalTransactionName() {
        String string = "unknown";
        Transaction transaction = null;
        if (this.notifyTransactionStack.size() > 0) {
            int n = this.notifyTransactionStack.size();
            transaction = (Transaction)this.notifyTransactionStack.get(n - 1);
        }
        if (transaction != null) {
            if (!transaction.isLocal()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "remoteTransactionName=" + transaction.name);
                }
                return null;
            }
            string = transaction.name;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLocalTransactionName=" + string);
        }
        return string;
    }

    public synchronized boolean isPerformingRemoteEvents() {
        int n;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "isPerformingEvents");
        }
        if ((n = this.notifyTransactionStack.size()) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "isPerformingEvents - no transaction - false");
            }
            return false;
        }
        Transaction transaction = (Transaction)this.notifyTransactionStack.get(n - 1);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isPerformingEvents - " + !transaction.isLocal());
        }
        return !transaction.isLocal();
    }

    public synchronized int getCurrentNumberOfContributors() {
        return this.currentContributors.size();
    }

    public synchronized Map getCurrentContributorMap() {
        return (Map)this.currentContributors.clone();
    }

    public synchronized ODCGroupMember getContributor(String string) {
        return (ODCGroupMember)this.currentContributors.get(string);
    }

    public synchronized void addContributor(ODCGroupMember oDCGroupMember) {
        this.currentContributors.put(oDCGroupMember.getName(), oDCGroupMember);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addContributor - " + oDCGroupMember);
        }
    }

    public synchronized ODCGroupMember removeContributor(String string) throws Exception {
        ODCGroupMember oDCGroupMember = (ODCGroupMember)this.currentContributors.remove(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeContributor - name=" + string + ", member=" + oDCGroupMember);
        }
        return oDCGroupMember;
    }

    public synchronized void clearContributors() {
        this.currentContributors.clear();
    }

    public synchronized int getNumberOfNewContributors(WsGroupMember wsGroupMember) {
        String[] stringArray = wsGroupMember.getContributors();
        int n = 0;
        boolean bl = tc.isDebugEnabled();
        StringBuffer stringBuffer = null;
        if (bl) {
            stringBuffer = new StringBuffer();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.currentContributors.containsKey(stringArray[i])) continue;
            ++n;
            if (!bl) continue;
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[i]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "member " + wsGroupMember + " has contributions from " + n + " contributors that I do not have: " + stringBuffer.toString());
        }
        return n;
    }

    public synchronized String getMyContributorList() {
        return this.getContributorList(this.currentContributors);
    }

    public String getContributorList(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append(iterator.next());
            bl = false;
        }
        return stringBuffer.toString();
    }

    public synchronized String[] getServerPathsOfMyContributors(String string) {
        return this.getServerPathsOfContributors(this.currentContributors, string);
    }

    public String[] getServerPathsOfContributors(Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerPathsOfContributors - size=" + map.size() + ", excludeName=" + string);
        }
        int n = map.size();
        if (map.containsKey(string)) {
            --n;
        }
        String[] stringArray = new String[n];
        Iterator iterator = map.values().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            ODCGroupMember oDCGroupMember = (ODCGroupMember)iterator.next();
            String string2 = oDCGroupMember.getName();
            if (string != null && string.equals(string2)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "excluding " + string2);
                continue;
            }
            String string3 = oDCGroupMember.getMemberPath();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name=" + string2 + " path=" + string3);
            }
            stringArray[n2++] = string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerPathsOfContributors");
        }
        return stringArray;
    }

    public synchronized String getMyContributorInfoList() {
        return this.getContributorInfoList(this.currentContributors);
    }

    public String getContributorInfoList(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.values().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append(iterator.next());
            bl = false;
        }
        return stringBuffer.toString();
    }

    public synchronized boolean haveContributionsFromEveryone() {
        if (this.odcGroup == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "haveContributionsFromEveryone - no, group is null");
            }
            return false;
        }
        if (!this.odcGroup.isReady()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "haveContributionsFromEveryone - no, group is not ready");
            }
            return false;
        }
        Set set = this.odcGroup.getMemberNames();
        Iterator iterator = this.currentContributors.keySet().iterator();
        while (iterator.hasNext()) {
            set.remove(iterator.next());
        }
        boolean bl = set.isEmpty();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "haveContributionsFromEveryone?  " + (bl ? "Yes." : "No.  Not yet contributing: " + this.toString(set)));
        }
        return bl;
    }

    public synchronized boolean isInitializationCompleteAndNotify(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "isInitializationCompleteAndNotify: " + bl);
        }
        if (!this.haveContributionsFromEveryone()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isInitializationCompleteAndNotify: need more contributors");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isInitializationComplete=true");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isInitializationComplete: notify");
            }
            this.notifyAll();
        }
        return true;
    }

    public synchronized void waitForInitializationCompletion(int n) throws Exception {
        block8: {
            if (!this.odcGroup.isEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "waitForInitializationCompletion: no need to wait, odcgroup is disabled");
                }
                return;
            }
            this.odcGroup.start();
            if (!this.isInitializationCompleteAndNotify(false)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "waitForInitializationCompletion:" + n + " waiting...");
                    }
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "waitForInitializationCompletion:" + n + " got " + interruptedException);
                }
            }
        }
        if (this.isInitializationCompleteAndNotify(false)) {
            Tr.info(tc, "ODC_CompleteInfoReceived");
        } else {
            Tr.info(tc, "ODC_InCompleteInfoReceived", new Integer(n).toString());
        }
    }

    private String toString(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append(iterator.next());
            bl = false;
        }
        return stringBuffer.toString();
    }

    protected void copyNodeProperties(ODCNode oDCNode, ODCNode oDCNode2) throws ODCException {
        Map map = oDCNode.getProperties();
        for (String string : map.keySet()) {
            Object v = map.get(string);
            oDCNode2.setProperty(string, v);
        }
    }

    public void stop() {
        timer.cancel();
    }

    private class ListenerActivationRecord {
        private long invocationCount = 0L;
        private long maxInvocationTime = -1L;
        private long totalInvocationTime = -1L;
        private String name;

        public ListenerActivationRecord(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public long getInvocationCount() {
            return this.invocationCount;
        }

        public void setInvocationCount(long l) {
            this.invocationCount = l;
        }

        public long getMaxInvocationTime() {
            return this.maxInvocationTime;
        }

        public void setMaxInvocationTime(long l) {
            this.maxInvocationTime = l;
        }

        public long getTotalInvocationTime() {
            return this.totalInvocationTime;
        }

        public void setTotalInvocationTime(long l) {
            this.totalInvocationTime = l;
        }

        public String toString() {
            return "Invoked: " + this.invocationCount + " times, max: " + this.maxInvocationTime + "ms, total: " + this.totalInvocationTime + "ms";
        }
    }

    protected class CheckServerStatesTask
    extends TimerTask {
        private final ODCGroup odcGroup;
        private final ODCTreeImpl tree;

        public CheckServerStatesTask(ODCGroup oDCGroup, ODCTreeImpl oDCTreeImpl2) {
            this.odcGroup = oDCGroup;
            this.tree = oDCTreeImpl2;
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "runCheckServerStates");
            }
            try {
                this.tree.checkServerStates();
            }
            catch (Exception exception) {
                TrUtil.warning(exception, this, "CheckServerStatesTask", tc);
            }
            timer.schedule((TimerTask)new CheckServerStatesTask(this.odcGroup, this.tree), CHECK_SERVER_INTERVAL);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }
    }

    protected class HandleExtraMemberTask
    extends TimerTask {
        private final String serverPath;
        private final String memberName;
        private final ODCGroup odcGroup;
        private final ODCTreeImpl tree;

        public HandleExtraMemberTask(String string, String string2, ODCGroup oDCGroup, ODCTreeImpl oDCTreeImpl2) {
            this.serverPath = string;
            this.memberName = string2;
            this.odcGroup = oDCGroup;
            this.tree = oDCTreeImpl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "runHandleExtraMemberTask", new Object[]{this.serverPath, this.memberName});
            }
            try {
                ODCTreeImpl.this.extraGroupMap.remove(this.memberName);
                ODCTreeImpl oDCTreeImpl = this.tree;
                synchronized (oDCTreeImpl) {
                    ODCHelper oDCHelper = ODCHelper.getInstance();
                    ODCNodeImpl oDCNodeImpl = this.tree.getNode(this.serverPath);
                    if (oDCNodeImpl == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Post delay server " + this.serverPath + " not found");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "run");
                        }
                        return;
                    }
                    Set set = this.odcGroup.getMemberNames();
                    if (!set.contains(this.memberName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Post delay server: " + this.memberName + " is not in the group");
                        }
                    } else if ("STARTED".equals(oDCNodeImpl.getProperty(oDCHelper.serverState))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Post delay server: " + this.memberName + " is in group and marked STARTED");
                        }
                    } else {
                        this.tree.beginTransaction("extra group member found", false);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Post delay Server: " + this.memberName + " is in the ODCGroup but has a state of " + oDCNodeImpl.getProperty(oDCHelper.serverState) + ", marking as STARTED and requesting tree");
                        }
                        oDCNodeImpl.setProperty(oDCHelper.serverState, (Object)new ODCPropertyValueWrapper("STARTED", 1));
                        this.odcGroup.markServerForTreeRequest(this.memberName);
                        this.tree.commitTransaction();
                        this.odcGroup.perhapsSendGetTreeRequestNow();
                    }
                }
            }
            catch (Exception exception) {
                TrUtil.warning(exception, this, "HandleExtraMemberTask", tc);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runHandleExtraMemberTask");
            }
        }
    }

    protected class HandleMissingMemberTask
    extends TimerTask {
        private final String serverPath;
        private final String memberName;
        private final ODCGroup odcGroup;
        private final ODCTreeImpl tree;

        public HandleMissingMemberTask(String string, String string2, ODCGroup oDCGroup, ODCTreeImpl oDCTreeImpl2) {
            this.serverPath = string;
            this.memberName = string2;
            this.odcGroup = oDCGroup;
            this.tree = oDCTreeImpl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "runHandleMissingMemberTask", new Object[]{this.serverPath, this.memberName});
            }
            try {
                ODCTreeImpl.this.leftGroupMap.remove(this.memberName);
                ODCTreeImpl oDCTreeImpl = this.tree;
                synchronized (oDCTreeImpl) {
                    ODCHelper oDCHelper = ODCHelper.getInstance();
                    ODCNodeImpl oDCNodeImpl = this.tree.getNode(this.serverPath);
                    if (oDCNodeImpl == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Post delay server " + this.serverPath + " not found");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "run");
                        }
                        return;
                    }
                    Set set = this.odcGroup.getMemberNames();
                    if (set.contains(this.memberName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Post delay server: " + this.memberName + " is now in the group");
                        }
                    } else if ("STOPPED".equals(oDCNodeImpl.getProperty(oDCHelper.serverState))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Post delay server: " + this.memberName + " is not in group and marked STOPPED");
                        }
                    } else {
                        this.tree.beginTransaction("group member not found", false);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Post delay Server: " + this.memberName + " is not in the ODCGroup but has a state of " + oDCNodeImpl.getProperty(oDCHelper.serverState) + ", marking as stopped");
                        }
                        ODCGroup.markServerDown(oDCNodeImpl, oDCHelper);
                        this.odcGroup.markServerForTreeRequest(this.memberName);
                        this.tree.commitTransaction();
                        this.odcGroup.perhapsSendGetTreeRequestNow();
                    }
                }
            }
            catch (Exception exception) {
                TrUtil.warning(exception, this, "HandleMissingMemberTask", tc);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runHandleMissingMemberTask");
            }
        }
    }

    private static class Debug {
        private static final TraceComponent tc = TrUtil.register(Debug.class);

        private Debug() {
        }

        static /* synthetic */ TraceComponent access$100() {
            return tc;
        }
    }

    private static class Save {
        private static final TraceComponent tc = TrUtil.register(Save.class);

        private Save() {
        }

        static /* synthetic */ TraceComponent access$000() {
            return tc;
        }
    }

    public static class Transaction {
        public final String name;
        public final long generationNumber;
        public final boolean local;
        public final LinkedList events = new LinkedList();
        public ODCEvent[] unFilteredEvents = null;

        public Transaction(String string, long l, boolean bl) {
            this.name = string;
            this.generationNumber = l;
            this.local = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLocal() {
            return this.local;
        }

        public void addEvents(ODCEventImpl oDCEventImpl) {
            ODCEventImpl oDCEventImpl2 = this.events.isEmpty() ? null : this.events.getLast();
            if (oDCEventImpl2 != null && oDCEventImpl.isReverse(oDCEventImpl2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addEvents: " + oDCEventImpl + " is reverse of " + oDCEventImpl2);
                }
                this.events.removeLast();
            } else {
                this.events.addLast(oDCEventImpl);
            }
        }

        public String toString() {
            return this.name + ", local=" + this.local + ", genNo=" + this.generationNumber;
        }
    }
}

