/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEdgeTypeImpl;
import com.ibm.ws.odc.ODCNodeImpl;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.ws.util.Base64;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCManager;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCPropertyValueWrapper;
import com.ibm.wsspi.odc.ODCSchema;
import com.ibm.wsspi.odc.ODCTree;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends DefaultHandler
implements ErrorHandler {
    private final ODCManager mgr;
    private final ODCSchema schema;
    private final ODCTreeImpl tree;
    private SAXParser parser;
    private final List links = new LinkedList();
    protected Stack stack = new Stack();
    protected Stack pathStack = new Stack();
    private boolean local;
    private String[] toIgnore;
    private int ignoreDepth;
    private static final TraceComponent tc = TrUtil.register(XmlParser.class);
    private static final boolean DEBUG = Boolean.valueOf(System.getProperty("ODC.XmlParser.debug", "true"));
    protected Object sslDirect;
    protected Object sslOffLoad;
    protected Object sslOnLoad;
    private ODCHelper odc = null;

    public XmlParser(ODCTreeImpl oDCTreeImpl, ODCHelper oDCHelper) throws ODCException {
        this.tree = oDCTreeImpl;
        this.mgr = oDCTreeImpl.getManager();
        this.schema = this.mgr.getSchema();
        this.odc = oDCHelper;
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception exception) {
            throw new ODCException(exception);
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.wsspi.dwlm.client.ProtocolMap");
            this.sslDirect = clazz.getField("DIRECT").get(clazz);
            this.sslOffLoad = clazz.getField("SSL_OFFLOAD").get(clazz);
            this.sslOnLoad = clazz.getField("SSL_ONLOAD").get(clazz);
        }
        catch (Exception exception) {
            throw new ODCException("Fail to initialize ProtocolMap constants: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ODCTree parse(InputStream inputStream, boolean bl, String[] stringArray) throws Exception {
        if (DEBUG & tc.isEntryEnabled()) {
            Tr.entry(tc, "XmlParser.parse");
        }
        try {
            this.local = bl;
            this.toIgnore = stringArray;
            this.ignoreDepth = 0;
            this.links.clear();
            this.parser.parse(inputStream, (DefaultHandler)this);
            this.resolveLinks();
        }
        finally {
            this.links.clear();
        }
        if (DEBUG & tc.isEntryEnabled()) {
            Tr.exit(tc, "XmlParser.parse");
        }
        return this.tree;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
        try {
            String string4 = string3;
            if (DEBUG && tc.isDebugEnabled()) {
                Tr.debug(tc, "tag=" + string3);
            }
            if (string4.equalsIgnoreCase("property")) {
                if (this.shouldIgnore()) {
                    return;
                }
                String string5 = this.decodePropertyValue(this.getAttr(attributes2, "name"));
                String string6 = attributes2.getValue("priority");
                String string7 = this.getAttr(attributes2, "value");
                if (DEBUG && tc.isDebugEnabled()) {
                    Tr.debug(tc, "propName=" + string5 + " propValStr=" + string7);
                }
                ODCNodeImpl oDCNodeImpl = this.top();
                if (DEBUG && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ODCNodeImpl node =" + oDCNodeImpl);
                }
                ODCNodeType oDCNodeType = oDCNodeImpl.getType();
                ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl = (ODCPropertyDescriptorImpl)oDCNodeType.getPropertyDescriptor(string5);
                if (DEBUG && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ODCPropertyDescriptor=" + oDCPropertyDescriptorImpl);
                }
                if (this.odc.webModule.getName().equals(oDCNodeType.getName()) && this.odc.webModuleProtocolMap.getName().equals(string5)) {
                    oDCNodeImpl.setProperty(this.odc.webModuleProtocolMap, this.getProtocolMap(string7), this.local);
                } else if (oDCPropertyDescriptorImpl != null) {
                    Object object = null;
                    if ("CFEndpoint".equals(string5)) {
                        byte[] byArray = Base64.decode(string7);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        object = objectInputStream.readObject();
                    } else {
                        object = oDCPropertyDescriptorImpl.fromString(this.decodePropertyValue(string7));
                    }
                    object = string6 != null ? new ODCPropertyValueWrapper(object, Integer.parseInt(string6)) : new ODCPropertyValueWrapper(object, -1);
                    oDCNodeImpl.setProperty(oDCPropertyDescriptorImpl, object, this.local);
                }
            } else if (string4.equalsIgnoreCase("link")) {
                if (this.shouldIgnore()) {
                    return;
                }
                String string8 = this.decodePropertyValue(this.getAttr(attributes2, "name"));
                this.links.add(new Link(this.top(), string8));
            } else if (!string4.equalsIgnoreCase("transient")) {
                String string9 = this.canonicalPath(this.topPath());
                String string10 = this.decodePropertyValue(this.getAttr(attributes2, "name"));
                String string11 = this.canonicalPath(this.pushPath(string4, string10));
                if (this.shouldIgnore()) {
                    return;
                }
                ODCNodeImpl oDCNodeImpl = this.top();
                if (DEBUG && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ODCNodeImpl parent =" + oDCNodeImpl);
                }
                ODCNodeType oDCNodeType = this.schema.getNodeType(string4);
                if (DEBUG && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ODCNodeType childType = " + oDCNodeType);
                }
                if (oDCNodeType != null) {
                    ODCNodeImpl oDCNodeImpl2;
                    if (oDCNodeImpl == null) {
                        oDCNodeImpl2 = (ODCNodeImpl)this.tree.getRoot();
                        if (DEBUG && tc.isDebugEnabled()) {
                            Tr.debug(tc, "created new " + oDCNodeImpl2 + " with no parent");
                        }
                    } else {
                        oDCNodeImpl2 = (ODCNodeImpl)this.tree.obtainNode(string10, oDCNodeType.getName(), string11, string9, null);
                    }
                    if (oDCNodeImpl2 == null) {
                        ++this.ignoreDepth;
                    } else {
                        this.push(oDCNodeImpl2);
                    }
                } else {
                    ++this.ignoreDepth;
                }
            }
        }
        catch (SAXException sAXException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAXException: " + sAXException);
            }
            throw sAXException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Throwable: " + throwable);
            }
            throwable.printStackTrace(System.out);
            throw new SAXException(throwable.getMessage());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string3;
        if (!(string4.equalsIgnoreCase("property") || string4.equalsIgnoreCase("link") || string4.equalsIgnoreCase("transient"))) {
            if (DEBUG && tc.isDebugEnabled()) {
                Tr.debug(tc, "End of tag: " + string4);
            }
            if (!this.shouldIgnore()) {
                this.pop(string4);
            }
            this.popPath();
        }
    }

    public void error(SAXParseException sAXParseException) {
        System.out.println("ERROR: " + sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        System.out.println("FATAL: " + sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        System.out.println("WARN: " + sAXParseException);
    }

    private void push(ODCNode oDCNode) throws SAXException {
        this.stack.push(oDCNode);
    }

    private ODCNodeImpl pop(String string) throws SAXException {
        ODCNodeImpl oDCNodeImpl = null;
        if (this.top() != null && this.top().getName() != null && string != null && string.equalsIgnoreCase(this.top().getType().getName())) {
            oDCNodeImpl = (ODCNodeImpl)this.stack.pop();
        }
        if (oDCNodeImpl == null) {
            this.parseError("no matching begin for tag " + string);
        }
        return oDCNodeImpl;
    }

    private ODCNodeImpl top() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return (ODCNodeImpl)this.stack.peek();
    }

    private String getAttr(Attributes attributes2, String string) throws SAXException {
        String string2 = attributes2.getValue(string);
        if (string2 == null) {
            throw new SAXException("attribute '" + string + "' not defined");
        }
        return string2;
    }

    private void parseError(String string) throws SAXException {
        throw new SAXException(string);
    }

    private void resolveLinks() throws ODCException {
        if (DEBUG && tc.isDebugEnabled()) {
            Tr.debug(tc, "resolving links");
        }
        while (this.links.size() > 0) {
            ODCNodeType oDCNodeType;
            Link link = (Link)this.links.remove(0);
            if (this.ignore(link.toName)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ignoring link " + link);
                continue;
            }
            ODCNode oDCNode = this.tree.getODCNode(link.toName);
            if (oDCNode == null) {
                if (!DEBUG || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "can't find target node; ignoring link: " + link);
                continue;
            }
            ODCNodeType oDCNodeType2 = link.fromNode.getType();
            ODCEdgeTypeImpl oDCEdgeTypeImpl = (ODCEdgeTypeImpl)oDCNodeType2.getEdgeType(oDCNodeType = oDCNode.getType());
            if (oDCEdgeTypeImpl == null) {
                if (!DEBUG || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "edge is not allowed locally; ignoring link: " + link);
                continue;
            }
            link.fromNode.addNode(oDCNode);
            if (!DEBUG || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "resolved link: " + link);
        }
        if (DEBUG && tc.isDebugEnabled()) {
            Tr.debug(tc, "done resolving links");
        }
    }

    protected String decodePropertyValue(String string) {
        int n = string.length() - 3;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '[') {
                String string2 = string.substring(n2, n2 + 4);
                if ("[NL]".equals(string2)) {
                    stringBuffer.append('\n');
                    n2 += 4;
                    continue;
                }
                if ("[TB]".equals(string2)) {
                    stringBuffer.append('\t');
                    n2 += 4;
                    continue;
                }
                if ("[AM]".equals(string2)) {
                    stringBuffer.append('&');
                    n2 += 4;
                    continue;
                }
                if ("[QU]".equals(string2)) {
                    stringBuffer.append('\"');
                    n2 += 4;
                    continue;
                }
                stringBuffer.append(c);
                ++n2;
                continue;
            }
            stringBuffer.append(c);
            ++n2;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public Object getProtocolMap(String string) {
        if (string == null || string.equalsIgnoreCase("ClientProtocol")) {
            return this.sslDirect;
        }
        if (string.equalsIgnoreCase("HTTP") || string.equalsIgnoreCase("SSL-offload")) {
            return this.sslOffLoad;
        }
        if (string.equalsIgnoreCase("HTTPS") || string.equalsIgnoreCase("SSL-onload")) {
            return this.sslOnLoad;
        }
        return this.sslDirect;
    }

    private String pushPath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.pathStack.size() <= 1) {
            stringBuffer.append("/");
        } else {
            stringBuffer.append(this.pathStack.peek());
        }
        stringBuffer.append(string).append("/").append(string2).append("/");
        String string3 = stringBuffer.toString();
        this.pathStack.push(string3);
        if (this.ignoreDepth > 0) {
            ++this.ignoreDepth;
        } else if (this.ignore(string3)) {
            this.ignoreDepth = 1;
        } else if (string.equals("cell") && !Util.connectedToCell(string2)) {
            this.ignoreDepth = 1;
        }
        if (DEBUG && tc.isDebugEnabled()) {
            Tr.debug(tc, "pushPath path=" + string3 + ", ignoreDepth=" + this.ignoreDepth);
        }
        return string3;
    }

    private void popPath() {
        Object e2 = this.pathStack.pop();
        if (this.ignoreDepth > 0) {
            --this.ignoreDepth;
        }
        if (DEBUG && tc.isDebugEnabled()) {
            Tr.debug(tc, "popPath path=" + e2 + ", ignoreDepth=" + this.ignoreDepth);
        }
    }

    private String topPath() {
        if (this.pathStack.size() <= 0) {
            return null;
        }
        return (String)this.pathStack.peek();
    }

    private String canonicalPath(String string) {
        if (string == null) {
            return null;
        }
        return string.substring(0, string.length() - 1);
    }

    private boolean shouldIgnore() {
        return this.ignoreDepth > 0;
    }

    private boolean ignore(String string) {
        if (this.toIgnore == null) {
            return false;
        }
        for (int i = 0; i < this.toIgnore.length; ++i) {
            if (!string.equals(this.toIgnore[i])) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ignoring " + string);
            }
            return true;
        }
        return false;
    }

    private class Link {
        public final ODCNodeImpl fromNode;
        public final String toName;

        public Link(ODCNodeImpl oDCNodeImpl, String string) {
            this.fromNode = oDCNodeImpl;
            this.toName = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.fromNode.getPath()).append(" --> ").append(this.toName);
            return stringBuffer.toString();
        }
    }
}

