/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.cell;

import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.odc.util.Util;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTree;

public class TargetTree {
    private static ODCTree tree = null;
    private static ODCNode myCell = null;
    private static ODCNode myNode = null;
    private static ODCNode myServer = null;
    private static ODCNode myProxyContainer = null;

    public static ODCTree getTree() {
        if (tree == null) {
            TargetTree.createTree();
        }
        return tree;
    }

    public static ODCNode getMyCell() {
        if (myCell == null) {
            TargetTree.createMyCell();
        }
        return myCell;
    }

    public static ODCNode getMyNode() {
        if (myNode == null) {
            TargetTree.createMyNode();
        }
        return myNode;
    }

    public static ODCNode getMyServer() {
        if (myServer == null) {
            TargetTree.createMyServer();
        }
        return myServer;
    }

    public static ODCNode getMyProxyContainer() {
        if (myProxyContainer == null && Util.isProxy()) {
            TargetTree.createMyProxyContainer();
        }
        return myProxyContainer;
    }

    public static void setMyCell(ODCNode oDCNode) {
        myCell = oDCNode;
    }

    public static void setMyNode(ODCNode oDCNode) {
        myNode = oDCNode;
    }

    public static void setMyProxyContainer(ODCNode oDCNode) {
        myProxyContainer = oDCNode;
    }

    public static void setMyServer(ODCNode oDCNode) {
        myServer = oDCNode;
    }

    public static void setTree(ODCTree oDCTree) {
        tree = oDCTree;
    }

    private static synchronized void createTree() {
        if (tree == null) {
            try {
                ODCHelper oDCHelper = ODCHelper.getInstance();
                tree = oDCHelper.mgr.getTree("target", oDCHelper.cellGroup);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private static synchronized void createMyCell() {
        if (myCell == null) {
            try {
                String string = AdminServiceFactory.getAdminService().getCellName();
                ODCHelper oDCHelper = ODCHelper.getInstance();
                ODCTree oDCTree = TargetTree.getTree();
                myCell = oDCTree.createNode(string, oDCHelper.cell, oDCTree.getRoot());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private static synchronized void createMyNode() {
        if (myNode == null) {
            try {
                String string = AdminServiceFactory.getAdminService().getNodeName();
                ODCHelper oDCHelper = ODCHelper.getInstance();
                ODCTree oDCTree = TargetTree.getTree();
                myNode = oDCTree.createNode(string, oDCHelper.node, TargetTree.getMyCell());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private static synchronized void createMyServer() {
        if (myServer == null) {
            try {
                String string = AdminServiceFactory.getAdminService().getProcessName();
                ODCHelper oDCHelper = ODCHelper.getInstance();
                ODCTree oDCTree = TargetTree.getTree();
                myServer = oDCTree.createNode(string, oDCHelper.server, TargetTree.getMyNode());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private static synchronized void createMyProxyContainer() {
        if (myProxyContainer == null && Util.isProxy()) {
            try {
                ODCHelper oDCHelper = ODCHelper.getInstance();
                ODCTree oDCTree = TargetTree.getTree();
                myProxyContainer = oDCTree.createNode("proxy", oDCHelper.proxyContainer, TargetTree.getMyServer());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

