/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.cell;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.etools.portletapplication.Portlet;
import com.ibm.etools.portletapplication.PortletApplication;
import com.ibm.etools.portletapplicationext.PortletApplicationExtension;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagementHelper;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.EditionInfo;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.proxy.DeployedObjectProxyConfig;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.plugincfg.generator.VariableManager;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.odc.ODCNodeImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.ODCUtil;
import com.ibm.ws.odc.XmlParser;
import com.ibm.ws.odc.cell.TargetTree;
import com.ibm.ws.odc.cell.TreeBuilderHelper;
import com.ibm.ws.odc.util.ApplicationQuiescer;
import com.ibm.ws.odc.util.CellPropertyListener;
import com.ibm.ws.odc.util.CfUtil;
import com.ibm.ws.odc.util.FactoryHelper;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.ws.runtime.WSThreadPool;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.wsgroup.odc.ODCGroup;
import com.ibm.wsdl.ServiceImpl;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.exception.ChainGroupException;
import com.ibm.wsspi.channel.framework.exception.ChainNotInboundException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.ClusterObserver;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.odc.ODCComponent;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventNodeChange;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCListener;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCPropertyValueWrapper;
import com.ibm.wsspi.odc.ODCTree;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.ObjectName;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.xml.WSDLLocator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

public class TreeBuilder
extends TreeBuilderHelper
implements ODCComponent,
ClusterObserver,
ODCListener {
    public static final String SPEED_FACTOR_OVERRIDE_SPEC = "SpeedFactorOverrideSpec";
    protected static final String TYPE_CLUSTER_WEIGHT_UPDATE = "type.cluster.weight.update";
    private static final TraceComponent tc = TrUtil.register(TreeBuilder.class);
    public static final String NULL_CLUSTER = "null.cluster";
    protected static final String SEP = File.separator;
    protected static final String WEB_INF = "WEB-INF";
    protected static final Integer DOWN_WEIGHT = new Integer(0);
    protected static final Integer DEFAULT_UP_WEIGHT = new Integer(1);
    protected static final Integer ANY_PORT = new Integer(-1);
    protected static final boolean isZos;
    protected static final boolean isZosServantOrCRA;
    protected static final int WAIT_FOR_INIT_TIMEOUT;
    protected static final boolean JAVAX_WSDL_VERBOSE;
    protected static final Timer timer;
    protected static final PlatformHelper platformHelper;
    protected final Set vhostExcludes = new HashSet();
    protected final Set chainExcludes = new HashSet();
    protected final Set upNodes = new HashSet();
    protected final HashMap serverUpWeights = new HashMap();
    protected final VariableManager varMgr = new VariableManager();
    protected final HashMap appsRead = new HashMap();
    protected ODCNode odcMyCell = null;
    protected ODCNode odcMyNode = null;
    protected ODCNode odcMyServer = null;
    protected ODCNode odcMyProxyContainer = null;
    protected final String nodesDir;
    protected String myServerState = "STARTING";
    protected ODCTreeImpl targetTree = null;
    protected boolean listenersAdded = false;
    protected ObjectName appManagementName = null;
    protected boolean initialized = false;
    protected HashMap serverIndexCache = null;
    protected final LocalEventListener localEventListener = new LocalEventListener();
    protected Object sslDirect;
    protected Object sslOffLoad;
    protected Object sslOnLoad;
    protected ODCEventType[] interestEvents;
    public static final String APP_CHANGES = "app_changes";
    public static final String SERVICEPOLICY_UPDATE_REQD = "servicepolicy_update_reqd";
    public static final String NODEGROUP_UPDATE_REQD = "nodegroup_update_reqd";
    public static final String APPLICATION_SERVER = "APPLICATION_SERVER";
    public static final String TOMCAT_SERVER = "TOMCAT_SERVER";
    protected boolean isStaticTargetTree = false;
    protected Method encodeString = null;
    String encodeFactoryClass = "com.ibm.ws.session.utils.EncodeCloneID";
    String encodeDefaultFactoryClass = "com.ibm.ws.webcontainer.util.EncodeCloneID";
    private ODCNode _nullClusterNode = null;

    public TreeBuilder() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        this.targetTree = (ODCTreeImpl)TargetTree.getTree();
        this.targetTree.setTreeBuilder(this);
        Class<?> clazz = Class.forName("com.ibm.wsspi.dwlm.client.ProtocolMap");
        this.sslDirect = clazz.getField("DIRECT").get(clazz);
        this.sslOffLoad = clazz.getField("SSL_OFFLOAD").get(clazz);
        this.sslOnLoad = clazz.getField("SSL_ONLOAD").get(clazz);
        this.nodesDir = "cells/" + this.myCellName + "/nodes/";
        this.initSet(System.getProperty("com.ibm.ws.odc.vhostExcludes", "admin_host"), this.vhostExcludes);
        this.initSet(System.getProperty("com.ibm.ws.odc.chainExcludes", "WCInboundAdmin,WCInboundAdminSecure"), this.chainExcludes);
        if (this.inDMgr) {
            this.vhostExcludes.clear();
            this.chainExcludes.clear();
        }
        this.interestEvents = this.inNodeAgent ? new ODCEventType[]{this.odc.cluster} : null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public void start() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.localEventListener.addLocalListeners();
        new CellPropertyListener().start();
        this.init();
        if (this.inNodeAgent) {
            this.targetTree.addListener(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        block7: {
            block6: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "stop");
                }
                try {
                    this.stopODCGroup();
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "problem stopping ODCGroup: " + throwable + ": " + throwable.getMessage());
                }
            }
            try {
                this.localEventListener.removeLocalListeners();
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "problem removing local listeners: " + throwable + ": " + throwable.getMessage());
            }
        }
        this.targetTree.stop();
        timer.cancel();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        if (this.initialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "init", "already initialized");
            }
            return;
        }
        long l = System.currentTimeMillis();
        this.isStaticTargetTree = false;
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.init");
            try {
                String string = null;
                String string2 = System.getProperty("com.ibm.proxy.enable.static.routing");
                if (string2 != null) {
                    if (string2.equalsIgnoreCase("true")) {
                        this.isStaticTargetTree = true;
                    } else if (string2.equalsIgnoreCase("false")) {
                        this.isStaticTargetTree = false;
                    }
                }
                if (System.getProperty("targetTreeXmlPath") != null) {
                    string = System.getProperty("targetTreeXmlPath");
                }
                this.serverIndexCache = new HashMap();
                this.buildTargetTree();
                if (this.isStaticTargetTree) {
                    this.loadStaticTargetTree(string);
                }
                this.targetTree.commitTransaction();
                this.initialized = true;
                this.serverIndexCache = null;
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "init", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        Tr.info(tc, "INIT " + (System.currentTimeMillis() - l) + " ms. nodes:" + this.targetTree.getAllNodes().length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void processQueuedEvents() throws Exception {
        this.localEventListener.processQueuedEvents();
    }

    protected void startODCGroup() throws Exception {
        ODCGroup.getInstance(this.targetTree).start();
    }

    protected void stopODCGroup() throws Exception {
        ODCGroup.getInstance(this.targetTree).stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged", deployedObjectEvent);
        }
        if (!(string2 = deployedObjectEvent.getPropertyName()).equals("state")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stateChanged", "ignoring property " + string2);
            }
            return;
        }
        DeployedApplication deployedApplication = null;
        DeployedModule deployedModule = null;
        DeployedObject deployedObject = deployedObjectEvent.getDeployedObject();
        ModuleFile moduleFile = deployedObject.getModuleFile();
        if (moduleFile.isEARFile()) {
            deployedApplication = (DeployedApplication)deployedObject;
        } else if (moduleFile.isWARFile()) {
            deployedModule = (DeployedModule)deployedObject;
            deployedApplication = deployedModule.getDeployedApplication();
        } else if (moduleFile.isEJBJarFile()) {
            deployedModule = (DeployedModule)deployedObject;
            deployedApplication = deployedModule.getDeployedApplication();
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stateChanged", "TreeBuilder: not EAR, WAR or EJBJar file");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "doe=" + deployedObjectEvent + " dmod=" + deployedModule + " appName=" + deployedApplication.getName() + " state=" + deployedObjectEvent.getNewValue());
        }
        String string3 = deployedApplication.getName();
        if (EditionHelper.isEditionSupportEnabled()) {
            try {
                string3 = this.getAppNameOfActiveEdition(this.odcMyNode.getName(), this.odcMyServer.getName(), string3);
            }
            catch (Exception exception) {
                throw new RuntimeError("Could not determine active application edition");
            }
        }
        if ((string = this.getAppNameOfRunningEdition(deployedApplication.getName())) == null) {
            string = string3;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "config=" + string3 + " state=" + string);
        }
        String string4 = deployedModule != null ? deployedModule.getName() : "null";
        Object object = deployedObjectEvent.getNewValue();
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.stateChanged");
            try {
                if (deployedModule == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "app " + string3 + " state changed to " + object);
                    }
                    if (object.equals("STARTING")) {
                        this.obtainAppNode(string3);
                    } else if (object.equals("STARTED")) {
                        ODCNode oDCNode = this.targetTree.createNode(string3, this.odc.serverApplication, this.odcMyServer);
                        oDCNode.setProperty(this.odc.serverApplicationState, object);
                    } else if (object.equals("STOPPING") || object.equals("STOPPED") || object.equals("DESTROYING") || object.equals("DESTROYED")) {
                        ODCNode oDCNode;
                        ODCNode oDCNode2 = this.odcMyServer.getNode(this.odc.serverApplication, string);
                        if (oDCNode2 != null) {
                            oDCNode2.remove();
                        }
                        if ((oDCNode = this.odcMyCell.getNode(this.odc.application, string)) != null) {
                            ODCNode[] oDCNodeArray = oDCNode.getChildren(this.odc.webModule);
                            for (int i = 0; i < oDCNodeArray.length; ++i) {
                                this.odcMyServer.removeChild(oDCNodeArray[i]);
                            }
                            ODCNode[] oDCNodeArray2 = oDCNode.getChildren(this.odc.ejbModule);
                            for (int i = 0; i < oDCNodeArray2.length; ++i) {
                                this.odcMyServer.removeChild(oDCNodeArray2[i]);
                            }
                        }
                    } else {
                        ODCNode oDCNode = this.targetTree.createNode(string3, this.odc.serverApplication, this.odcMyServer);
                        oDCNode.setProperty(this.odc.serverApplicationState, object);
                    }
                } else if (moduleFile.isWARFile()) {
                    if (object.equals("STARTED")) {
                        ODCNode oDCNode;
                        ODCNode oDCNode3;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "webmodule started: app=" + string3 + ", webmodule=" + string4);
                        }
                        if ((oDCNode3 = this.odcMyCell.getNode(this.odc.application, string3)) != null && (oDCNode = oDCNode3.getNode(this.odc.webModule, string4)) != null) {
                            oDCNode.addNode(this.odcMyServer);
                        }
                    }
                } else if (moduleFile.isEJBJarFile() && object.equals("STARTED")) {
                    ODCNode oDCNode;
                    ODCNode oDCNode4;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ejbmodule starting: app=" + string3 + ", ejbjar=" + string4);
                    }
                    if ((oDCNode4 = this.odcMyCell.getNode(this.odc.application, string3)) != null && (oDCNode = oDCNode4.getNode(this.odc.ejbModule, string4)) != null) {
                        oDCNode.addNode(this.odcMyServer);
                    }
                }
                this.targetTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "stateChanged", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAppNameOfRunningEdition(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppNameOfRunningEdition", string);
        }
        String string2 = null;
        try {
            ODCTreeImpl oDCTreeImpl = this.targetTree;
            synchronized (oDCTreeImpl) {
                ODCNode[] oDCNodeArray = this.odcMyServer.getNodes(this.odc.serverApplication);
                if (oDCNodeArray != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, oDCNodeArray.length + "   " + this.odcMyServer);
                    }
                    for (int i = 0; i < oDCNodeArray.length; ++i) {
                        ODCNode oDCNode = oDCNodeArray[i];
                        if (!oDCNode.getName().equals(string) && (!oDCNode.getName().startsWith(string) || oDCNode.getName().indexOf("-edition") == -1)) continue;
                        string2 = oDCNode.getName();
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            TrUtil.error(exception, this, "getAppNameOfRunningEdition", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppNameOfRunningEdition - ", string2);
        }
        return string2;
    }

    protected void buildTargetTree() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildTargetTree");
        }
        this.readCell(this.targetTree.getRoot(), this.myCellName);
        if (this.inDMgr || this.inNodeAgent) {
            this.addClustersListener();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildTargetTree");
        }
    }

    protected void loadStaticTargetTree(String string) throws Exception {
        Object object;
        int n;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadStaticTargetTree", string);
        }
        if (string == null) {
            object2 = this.configRoot;
            int n2 = ((String)object2).length();
            if (this.configRoot.charAt(n2 - 1) == File.separatorChar) {
                object2 = ((String)object2).substring(0, n2 - 1);
            }
            if ((n = ((String)object2).lastIndexOf(File.separatorChar)) < 1) {
                throw new ODCException("Wrong Config Root Path" + this.configRoot);
            }
            object = this.configRoot.substring(0, n);
            string = (String)object + File.separator + "etc" + File.separator + this.myServerName + File.separator;
        }
        if (((File)(object2 = new File(string))).exists() && ((File)object2).isDirectory()) {
            File[] fileArray;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target Tree xml path is found: " + string);
            }
            if ((fileArray = ((File)object2).listFiles()).length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No tree files found in path " + string);
                }
                throw new Exception("No tree files found in path " + string);
            }
            for (n = 0; n < fileArray.length; ++n) {
                object = new FileInputStream(fileArray[n]);
                XmlParser xmlParser = new XmlParser(this.targetTree, this.odc);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "start parsing file: " + fileArray[n].getAbsolutePath());
                }
                xmlParser.parse((InputStream)object, false, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "end parsing file: " + fileArray[n].getAbsolutePath());
                }
                ((FileInputStream)object).close();
            }
        } else {
            String string2 = string + " is not found or is not a directory";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2);
            }
            throw new Exception(string2);
        }
        this.initMyNodes(this.targetTree);
        if (this.odcMyProxyContainer != null) {
            this.initProxyContainer(this.odcMyProxyContainer, this.targetTree);
        }
        this.checkStandAloneServers(this.targetTree);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadStaticTargetTree", string);
        }
    }

    protected void initMyNodes(ODCTree oDCTree) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initMyNodes", oDCTree);
        }
        this.odcMyCell = oDCTree.getRoot().getNode(this.odc.cell, this.myCellName);
        if (this.odcMyCell == null) {
            throw new Exception("cell '" + this.myCellName + "' not found");
        }
        TargetTree.setMyCell(this.odcMyCell);
        this.odcMyNode = this.odcMyCell.getNode(this.odc.node, this.myNodeName);
        if (this.odcMyNode == null) {
            throw new Exception("node '" + this.myNodeName + "' not found");
        }
        TargetTree.setMyNode(this.odcMyNode);
        this.odcMyServer = this.odcMyNode.getNode(this.odc.server, this.myServerName);
        if (this.odcMyServer == null) {
            throw new Exception("server '" + this.myServerName + "' not found");
        }
        TargetTree.setMyServer(this.odcMyServer);
        ODCNode oDCNode = this.odcMyServer.getNode(this.odc.proxyContainer);
        if (oDCNode != null) {
            this.odcMyProxyContainer = oDCNode;
            TargetTree.setMyProxyContainer(this.odcMyProxyContainer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initMyNodes", oDCTree);
        }
    }

    protected void initProxyContainer(ODCNode oDCNode, ODCTree oDCTree) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initProxyContainer", oDCTree);
        }
        for (ODCNodeImpl oDCNodeImpl : ((ODCTreeImpl)oDCTree).getAllNodes()) {
            ODCNodeType oDCNodeType = oDCNodeImpl.getType();
            String string = oDCNodeType.getName();
            if (string.equals(this.odc.serverApplication.getName())) {
                oDCNode.addChild(oDCNodeImpl);
                continue;
            }
            if (!string.equals(this.odc.application.getName())) continue;
            oDCNode.addChild(oDCNodeImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initProxyContainer", oDCTree);
        }
    }

    protected void checkStandAloneServers(ODCTree oDCTree) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkStandAloneServers", oDCTree);
        }
        for (ODCNodeImpl oDCNodeImpl : ((ODCTreeImpl)oDCTree).getAllNodes()) {
            ODCNode oDCNode;
            String string;
            ODCNodeType oDCNodeType = oDCNodeImpl.getType();
            String string2 = oDCNodeType.getName();
            if (!string2.equals(this.odc.server.getName()) || Util.isNodeAgent(string = (String)oDCNodeImpl.getProperty(this.odc.serverType)) || (oDCNode = oDCNodeImpl.getParent(this.odc.cluster)) != null) continue;
            this.addServerToCluster(oDCNodeImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkStandAloneServers", oDCTree);
        }
    }

    protected ODCNode readCell(ODCNode oDCNode, String string) throws Exception {
        int n;
        Object object;
        File file;
        Object object2;
        String string2;
        File file2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readCell", new Object[]{oDCNode, string});
        }
        ODCNode oDCNode2 = this.targetTree.createNode(string, this.odc.cell, oDCNode);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "myCell=" + this.myCellName + "; cell=" + string);
        }
        if (oDCNode2.isOnMyCell()) {
            this.odcMyCell = oDCNode2;
            TargetTree.setMyCell(oDCNode2);
        }
        Repository repository2 = this.getRepository(oDCNode2.getName(), null, null);
        Cell cell = (Cell)repository2.getConfigRoot().getResource(0, "cell.xml").getContents().get(0);
        this.initCell(cell, oDCNode2);
        oDCNode2.setBooleanProperty(this.odc.cellIsWebSphere, true);
        String string3 = this.getDir(oDCNode2.getName(), null, null);
        this.readVirtualHostGroups(oDCNode2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reading clusters directory");
        }
        if ((file2 = new File(string2 = this.joinDir(string3, "clusters"))).exists()) {
            object2 = file2.listFiles(this.directoryFilter);
            if (object2 == null) {
                throw new IOException("unable to read clusters directory: " + string2);
            }
            for (int i = 0; i < ((File[])object2).length; ++i) {
                try {
                    this.getClusterNode(oDCNode2, object2[i].getName());
                    continue;
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "readCluster", tc);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reading nodes directory");
        }
        if ((file = new File((String)(object2 = this.joinDir(string3, "nodes")))).exists()) {
            object = file.listFiles(this.directoryFilter);
            if (object == null) {
                throw new IOException("unable to read nodes directory: " + (String)object2);
            }
            for (n = 0; n < ((Object[])object).length; ++n) {
                try {
                    this.getNodeNode(((File)object[n]).getName(), false);
                    continue;
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "readCell", tc);
                }
            }
        }
        this.checkStandAloneServers(TargetTree.getTree());
        if (this.odcMyNode != null) {
            object = this.odcMyNode.getChildren();
            n = ((Object[])object).length;
            for (int i = 0; i < n; ++i) {
                if (object[i].getParent(this.odc.cluster) != null) continue;
                this.addStandaloneServerToFakeCluster((ODCNode)object[i]);
            }
        }
        if (this.inDMgr) {
            File file3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "reading applications directory");
            }
            if ((file3 = new File((String)(object = this.joinDir(string3, "applications")))).exists()) {
                File[] fileArray = file3.listFiles(this.directoryFilter);
                if (fileArray == null) {
                    throw new IOException("unable to read applications directory: " + (String)object);
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    Object object3;
                    String string4 = fileArray[i].getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ear directory name = " + string4);
                    }
                    boolean bl = false;
                    if (EditionHelper.isEditionSupportEnabled()) {
                        object3 = fileArray[i].listFiles();
                        if (object3 == null) {
                            throw new IOException("unable to read app edition directory: " + string4);
                        }
                        for (int j = 0; j < ((File[])object3).length; ++j) {
                            String string5 = object3[j].getName();
                            String string6 = null;
                            if (!string5.endsWith(".ear")) continue;
                            string6 = string5.substring(0, string5.length() - 4);
                            ODCNode oDCNode3 = this.obtainAppNode(string6);
                            if (string4.endsWith(".ear")) {
                                string4 = string4.substring(0, string4.length() - 4);
                            }
                            oDCNode3.setProperty(this.odc.appRoot, (Object)string4);
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    if (string4.endsWith(".ear")) {
                        string4 = string4.substring(0, string4.length() - 4);
                    }
                    object3 = this.obtainAppNode(string4);
                    object3.setProperty(this.odc.appRoot, (Object)string4);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readCell", oDCNode2);
        }
        return oDCNode2;
    }

    protected void initCell(Cell cell, ODCNode oDCNode) throws Exception {
        this.addCellCustomProperties(cell, oDCNode);
    }

    protected void addCellCustomProperties(Cell cell, ODCNode oDCNode) throws Exception {
        this.addCustomProperties(cell.getProperties(), oDCNode);
    }

    protected ODCNode readNode(ODCNode oDCNode, String string, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readNode", new Object[]{oDCNode, string, bl});
        }
        if (!this.shouldReadNode(oDCNode.getName(), string)) {
            return null;
        }
        ODCNode oDCNode2 = this.targetTree.createNode(string, this.odc.node, oDCNode);
        if (oDCNode2.isOnMyNode()) {
            this.odcMyNode = oDCNode2;
            TargetTree.setMyNode(oDCNode2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found my node: " + this.odcMyNode);
            }
        }
        Repository repository2 = this.getRepository(oDCNode.getName(), string, null);
        this.varMgr.setVariableMap(repository2.getConfigRoot(), 1);
        Node node = (Node)repository2.getConfigRoot().getResource(3, "node.xml").getContents().get(0);
        this.initNode(node, oDCNode2);
        ServerIndex serverIndex = this.getServerIndex(string);
        String string2 = serverIndex.getHostName();
        if (string2 == null) {
            string2 = oDCNode2.getName();
        }
        Tr.debug(tc, "retrieved hostname as: " + string2);
        string2 = this.expandVariable(string2);
        Tr.debug(tc, "expanded hostname to: " + string2);
        oDCNode2.setProperty(this.odc.nodeHostName, (Object)string2);
        String string3 = this.getDir(oDCNode.getName(), string, null);
        String string4 = this.joinDir(string3, "servers");
        File file = new File(string4);
        if (file.exists()) {
            File[] fileArray = file.listFiles(this.directoryFilter);
            if (fileArray == null) {
                throw new IOException("unable to read servers directory: " + string4);
            }
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    this.getServerNode(oDCNode2, fileArray[i].getName(), bl);
                    continue;
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "readNode", tc);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readNode", oDCNode2);
        }
        return oDCNode2;
    }

    protected void initNode(Repository repository2, Node node, ODCNode oDCNode) throws Exception {
        Resource resource;
        block3: {
            resource = null;
            try {
                resource = repository2.getConfigRoot().getResource(3, "resources.xml");
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, exception.getLocalizedMessage());
            }
        }
        if (resource != null) {
            oDCNode.setBooleanProperty(this.odc.nodeIsWebSphere, true);
        }
        this.addNodeCustomProperties(node, oDCNode);
    }

    protected void initNode(Node node, ODCNode oDCNode) throws Exception {
        oDCNode.setBooleanProperty(this.odc.nodeIsWebSphere, true);
        this.addNodeCustomProperties(node, oDCNode);
    }

    protected void addNodeCustomProperties(Node node, ODCNode oDCNode) throws Exception {
        this.addCustomProperties(node.getProperties(), oDCNode);
    }

    protected void updateTransports(ServerEntry serverEntry, ODCNode oDCNode, String string) throws Exception {
        Object object;
        if (!serverEntry.getServerName().equalsIgnoreCase(oDCNode.getName())) {
            throw new ODCException(serverEntry + " does not match " + oDCNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateTransports: " + oDCNode.getName());
        }
        List list = this.getNames(oDCNode, this.odc.transport);
        for (Object object2 : serverEntry.getSpecialEndpoints()) {
            object = this.processServerEndpoint((NamedEndPoint)object2, oDCNode, string);
            if (object == null) continue;
            list.remove(object.getName());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing " + list.size() + " old transports");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object object2;
            object2 = oDCNode.getNode(this.odc.transport, (String)iterator.next());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Transport: " + object2);
            }
            if (object2 == null) continue;
            object = (Boolean)object2.getProperty(this.odc.transportIsActive);
            boolean bl2 = bl = object == null ? false : (Boolean)object;
            if (bl) {
                object2.setBooleanProperty(this.odc.transportIsConfig, false);
                continue;
            }
            object2.remove();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateTransports: " + oDCNode.getName());
        }
    }

    public boolean applicationExists(String string) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "applicationExists", new Object[]{string});
        }
        Repository repository2 = null;
        try {
            repository2 = this.getRepository(this.odcMyCell.getName(), null, null);
        }
        catch (Exception exception) {
            throw new ODCException(exception);
        }
        ConfigRoot configRoot = repository2.getConfigRoot();
        String string2 = "";
        String[] stringArray = null;
        if (EditionHelper.isEditionSupportEnabled()) {
            stringArray = EditionHelper.getAppAndEdition(string);
            configRoot.setValue(1, stringArray[0] + ".ear");
        } else {
            configRoot.setValue(1, string + ".ear");
        }
        string2 = "deployments" + SEP + string;
        String string3 = string2 + SEP + "deployment.xml";
        try {
            configRoot.getResource(1, string3).getContents().get(0);
        }
        catch (Exception exception) {
            Tr.warning(tc, "Application not found on dmgr: " + string + " due to error: " + exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "applicationExists - false");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "applicationExists - true");
        }
        return true;
    }

    public boolean serverExists(ODCNode oDCNode, ODCNode oDCNode2, String string) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverExists", new Object[]{oDCNode, oDCNode2, string});
        }
        if (this.odcMyCell != oDCNode) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serverExists - doesn't belong to this cell - assume true");
            }
            return true;
        }
        if (this.getServerEntry(this.odcMyCell, oDCNode2, string) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serverExists - true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serverExists - false");
        }
        return false;
    }

    protected ServerEntry getServerEntry(ODCNode oDCNode, ODCNode oDCNode2, String string) throws ODCException {
        ServerIndex serverIndex = null;
        try {
            serverIndex = this.getServerIndex(oDCNode2.getName());
        }
        catch (Exception exception) {
            throw new ODCException(exception);
        }
        ServerEntry serverEntry = null;
        for (ServerEntry serverEntry2 : serverIndex.getServerEntries()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server entry for " + serverEntry2.getServerName());
            }
            if (!serverEntry2.getServerName().equals(string)) continue;
            serverEntry = serverEntry2;
            break;
        }
        return serverEntry;
    }

    protected ODCNode readServer(ODCNode oDCNode, ODCNode oDCNode2, String string, boolean bl) throws Exception {
        NamedEndPoint namedEndPoint2;
        ServerEntry serverEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readServer", new Object[]{oDCNode2, string, new Boolean(bl)});
        }
        Repository repository2 = this.getRepository(oDCNode.getName(), oDCNode2.getName(), string);
        ServerIndex serverIndex = this.getServerIndex(oDCNode2.getName());
        String string2 = serverIndex.getHostName();
        if (string2 == null) {
            string2 = oDCNode2.getName();
        }
        if ((serverEntry = this.getServerEntry(oDCNode, oDCNode2, string)) == null) {
            throw new ODCException("no server entry for " + string + " was found in serverindex.xml");
        }
        String string3 = serverEntry.getServerType();
        String string4 = AdminServiceFactory.getAdminService().getServerType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "my server type=" + string4);
        }
        if (!this.shouldReadServer(oDCNode.getName(), oDCNode2.getName(), string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readServer", "should not read");
            }
            return null;
        }
        ODCNode oDCNode3 = this.targetTree.createNode(string, this.odc.server, oDCNode2);
        if (oDCNode3.isOnMyServer()) {
            this.initMyServer(oDCNode3);
        }
        oDCNode3.setProperty(this.odc.serverType, (Object)string3);
        oDCNode3.setProperty(this.odc.serverIsODR, (Object)new Boolean(Util.isODR(string3)));
        boolean bl2 = Util.isProxy(string3);
        if (bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "is proxy");
            }
            ODCNode oDCNode4 = this.targetTree.createNode("proxy", this.odc.proxyContainer, oDCNode3);
            if (oDCNode3.isOnMyServer()) {
                this.odcMyProxyContainer = oDCNode4;
                TargetTree.setMyProxyContainer(oDCNode4);
            }
        } else {
            this.updateTransports(serverEntry, oDCNode3, string2);
        }
        for (NamedEndPoint namedEndPoint2 : serverEntry.getSpecialEndpoints()) {
            this.processServerEndpoint(namedEndPoint2, oDCNode3, string2);
        }
        namedEndPoint2 = repository2.getConfigRoot().getResource(4, "server.xml").getContents();
        if (namedEndPoint2.size() <= 0) {
            throw new ODCException("no resources for: " + oDCNode.getName() + ":" + oDCNode2.getName() + ":" + string);
        }
        com.ibm.websphere.models.config.process.Server server2 = (com.ibm.websphere.models.config.process.Server)namedEndPoint2.get(0);
        Iterator iterator = server2.getProcessDefinitions().iterator();
        ProcessDef processDef = null;
        JavaProcessDef javaProcessDef = null;
        while (iterator.hasNext()) {
            processDef = (ProcessDef)iterator.next();
            if (!(processDef instanceof JavaProcessDef)) continue;
            javaProcessDef = (JavaProcessDef)processDef;
            for (WebContainer webContainer : javaProcessDef.getJvmEntries()) {
                for (Object object2 : webContainer.getSystemProperties()) {
                    if (object2.getName().equals("GENERIC_SERVER_TYPE")) {
                        oDCNode3.setProperty(this.odc.serverType, (Object)object2.getValue());
                        continue;
                    }
                    if (!object2.getName().equals("GENERIC_SERVER_SUB_TYPE")) continue;
                    oDCNode3.setProperty(this.odc.serverSubType, (Object)object2.getValue());
                }
            }
        }
        ApplicationServer applicationServer = this.getAppServer(server2);
        if (applicationServer != null) {
            WebContainer webContainer;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processing appserver config: " + applicationServer.getName());
            }
            this.setDefaultThreadPool(oDCNode3);
            webContainer = this.getWebContainer(applicationServer);
            if (webContainer != null) {
                Object object;
                oDCNode3.setProperty(this.odc.sessionPersistenceMode, (Object)"NONE");
                for (int i = 0; i < webContainer.getServices().size(); ++i) {
                    Object object2;
                    object2 = webContainer.getServices().get(i);
                    if (!(object2 instanceof SessionManager)) continue;
                    object = (SessionManager)object2;
                    oDCNode3.setProperty(this.odc.sessionPersistenceMode, (Object)object.getSessionPersistenceMode().getName());
                }
                for (Object object2 : webContainer.getTransports()) {
                    object = object2.isSslEnabled() ? "https" : "http";
                    EndPoint endPoint = object2.getAddress();
                    ODCNode oDCNode5 = this.targetTree.createNode((String)object + "." + endPoint.getPort(), this.odc.transport, oDCNode3);
                    String string5 = endPoint.getHost();
                    if (string5 == null || string5.equals("") || string5.equals("*")) {
                        oDCNode5.setProperty(this.odc.transportHost, (Object)string2);
                    } else {
                        oDCNode5.setProperty(this.odc.transportHost, (Object)string5);
                    }
                    oDCNode5.setProperty(this.odc.transportPort, (Object)new Integer(endPoint.getPort()));
                    oDCNode5.setBooleanProperty(this.odc.transportIsConfig, true);
                    oDCNode5.setProperty(this.odc.transportProtocol, object);
                    this.addDefaultChannelChain(oDCNode5, object2.isSslEnabled());
                }
            }
            this.addCustomProperties(applicationServer.getProperties(), oDCNode3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "readingCluster=" + bl + ", serverType=" + string3);
        }
        if (!bl && !string3.equals("NODE_AGENT")) {
            this.addServerToCluster(oDCNode3);
        }
        this.processNonWasServer(oDCNode3, server2, string3, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readServer", oDCNode3);
        }
        return oDCNode3;
    }

    protected void initMyServer(ODCNode oDCNode) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initMyServer " + oDCNode);
        }
        this.odcMyServer = oDCNode;
        TargetTree.setMyServer(oDCNode);
        oDCNode.setProperty(this.odc.serverState, (Object)this.myServerState);
    }

    protected ODCNode processServerEndpoint(NamedEndPoint namedEndPoint, ODCNode oDCNode, String string) throws Exception {
        String string2 = namedEndPoint.getEndPointName();
        String string3 = namedEndPoint.getEndPoint().getPort() + "";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processServerEndpoint " + string2);
        }
        String string4 = this.hostname(namedEndPoint, string);
        ODCNode oDCNode2 = null;
        if (string2.equals("PROXY_HTTP_ADDRESS")) {
            oDCNode2 = this.targetTree.createNode("http." + string3, this.odc.transport, oDCNode);
            oDCNode2.setProperty(this.odc.transportProtocol, (Object)"http");
            oDCNode2.setProperty(this.odc.transportHost, (Object)string4);
            oDCNode2.setIntProperty(this.odc.transportPort, namedEndPoint.getEndPoint().getPort());
            oDCNode2.setProperty(this.odc.transportODR, (Object)Boolean.TRUE);
            oDCNode2.setBooleanProperty(this.odc.transportSSL, false);
        } else if (string2.equals("PROXY_HTTPS_ADDRESS")) {
            oDCNode2 = this.targetTree.createNode("https." + string3, this.odc.transport, oDCNode);
            oDCNode2.setProperty(this.odc.transportProtocol, (Object)"https");
            oDCNode2.setProperty(this.odc.transportHost, (Object)string4);
            oDCNode2.setIntProperty(this.odc.transportPort, namedEndPoint.getEndPoint().getPort());
            oDCNode2.setProperty(this.odc.transportODR, (Object)Boolean.TRUE);
            oDCNode2.setBooleanProperty(this.odc.transportSSL, true);
        } else if (string2.equalsIgnoreCase("WC_defaulthost")) {
            oDCNode2 = this.targetTree.createNode("http." + string3, this.odc.transport, oDCNode);
            oDCNode2.setProperty(this.odc.transportProtocol, (Object)"http");
            oDCNode2.setProperty(this.odc.transportHost, (Object)string4);
            oDCNode2.setIntProperty(this.odc.transportPort, namedEndPoint.getEndPoint().getPort());
            oDCNode2.setBooleanProperty(this.odc.transportSSL, false);
            oDCNode2.setProperty(this.odc.transportClass, (Object)namedEndPoint.getEndPoint().getClass().getName());
        } else if (string2.equalsIgnoreCase("WC_defaulthost_secure")) {
            oDCNode2 = this.targetTree.createNode("https." + string3, this.odc.transport, oDCNode);
            oDCNode2.setProperty(this.odc.transportProtocol, (Object)"https");
            oDCNode2.setProperty(this.odc.transportHost, (Object)string4);
            oDCNode2.setIntProperty(this.odc.transportPort, namedEndPoint.getEndPoint().getPort());
            oDCNode2.setBooleanProperty(this.odc.transportSSL, true);
            oDCNode2.setProperty(this.odc.transportClass, (Object)namedEndPoint.getEndPoint().getClass().getName());
        } else if (string2.equalsIgnoreCase("SIP_DEFAULTHOST")) {
            oDCNode2 = this.targetTree.createNode("sip." + string3, this.odc.transport, oDCNode);
            oDCNode2.setProperty(this.odc.transportProtocol, (Object)"sip");
            oDCNode2.setProperty(this.odc.transportHost, (Object)string4);
            oDCNode2.setIntProperty(this.odc.transportPort, namedEndPoint.getEndPoint().getPort());
            oDCNode2.setBooleanProperty(this.odc.transportSSL, false);
            oDCNode2.setProperty(this.odc.transportClass, (Object)namedEndPoint.getEndPoint().getClass().getName());
            oDCNode2.setBooleanProperty(this.odc.transportIsConfig, true);
            oDCNode2.setBooleanProperty(this.odc.transportIsActive, false);
            oDCNode2 = this.targetTree.createNode("sipu." + string3, this.odc.transport, oDCNode);
            oDCNode2.setProperty(this.odc.transportProtocol, (Object)"sipu");
            oDCNode2.setProperty(this.odc.transportHost, (Object)string4);
            oDCNode2.setIntProperty(this.odc.transportPort, namedEndPoint.getEndPoint().getPort());
            oDCNode2.setBooleanProperty(this.odc.transportSSL, false);
            oDCNode2.setProperty(this.odc.transportClass, (Object)namedEndPoint.getEndPoint().getClass().getName());
        } else if (string2.equalsIgnoreCase("SIP_DEFAULTHOST_SECURE")) {
            oDCNode2 = this.targetTree.createNode("sips." + string3, this.odc.transport, oDCNode);
            oDCNode2.setProperty(this.odc.transportProtocol, (Object)"sips");
            oDCNode2.setProperty(this.odc.transportHost, (Object)string4);
            oDCNode2.setIntProperty(this.odc.transportPort, namedEndPoint.getEndPoint().getPort());
            oDCNode2.setBooleanProperty(this.odc.transportSSL, true);
            oDCNode2.setProperty(this.odc.transportClass, (Object)namedEndPoint.getEndPoint().getClass().getName());
        } else if (string2.equalsIgnoreCase("PROXY_SIP_ADDRESS")) {
            oDCNode2 = this.targetTree.createNode("sip." + string3, this.odc.transport, oDCNode);
            oDCNode2.setProperty(this.odc.transportProtocol, (Object)"sip");
            oDCNode2.setProperty(this.odc.transportHost, (Object)string4);
            oDCNode2.setIntProperty(this.odc.transportPort, namedEndPoint.getEndPoint().getPort());
            oDCNode2.setBooleanProperty(this.odc.transportSSL, false);
            oDCNode2.setProperty(this.odc.transportClass, (Object)namedEndPoint.getEndPoint().getClass().getName());
            oDCNode2.setBooleanProperty(this.odc.transportIsConfig, true);
            oDCNode2.setBooleanProperty(this.odc.transportIsActive, false);
            oDCNode2 = this.targetTree.createNode("sipu." + string3, this.odc.transport, oDCNode);
            oDCNode2.setProperty(this.odc.transportProtocol, (Object)"sipu");
            oDCNode2.setProperty(this.odc.transportHost, (Object)string4);
            oDCNode2.setIntProperty(this.odc.transportPort, namedEndPoint.getEndPoint().getPort());
            oDCNode2.setBooleanProperty(this.odc.transportSSL, false);
            oDCNode2.setProperty(this.odc.transportClass, (Object)namedEndPoint.getEndPoint().getClass().getName());
        } else if (string2.equalsIgnoreCase("PROXY_SIPS_ADDRESS")) {
            oDCNode2 = this.targetTree.createNode("sips." + string3, this.odc.transport, oDCNode);
            oDCNode2.setProperty(this.odc.transportProtocol, (Object)"sips");
            oDCNode2.setProperty(this.odc.transportHost, (Object)string4);
            oDCNode2.setIntProperty(this.odc.transportPort, namedEndPoint.getEndPoint().getPort());
            oDCNode2.setBooleanProperty(this.odc.transportSSL, true);
            oDCNode2.setProperty(this.odc.transportClass, (Object)namedEndPoint.getEndPoint().getClass().getName());
        }
        if (oDCNode2 != null) {
            oDCNode2.setBooleanProperty(this.odc.transportIsConfig, true);
            if (((String)oDCNode2.getProperty(this.odc.transportProtocol)).startsWith("http")) {
                this.addDefaultChannelChain(oDCNode2, oDCNode2.getBooleanProperty(this.odc.transportSSL));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processServerEndpoint " + string2, oDCNode2);
        }
        return oDCNode2;
    }

    protected String hostname(NamedEndPoint namedEndPoint, String string) {
        String string2 = namedEndPoint.getEndPoint().getHost();
        if (string2 == null || string2.equals("*")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "defaultHostname=" + string);
            }
            return string;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "hostname=" + string2);
        }
        return string2;
    }

    protected void processNonWasServer(ODCNode oDCNode, com.ibm.websphere.models.config.process.Server server2, String string, String string2) throws Exception {
    }

    protected void setDefaultThreadPool(ODCNode oDCNode) throws Exception {
        ChannelFrameworkService channelFrameworkService;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultThreadPool", oDCNode);
        }
        if ((channelFrameworkService = (ChannelFrameworkService)WsServiceRegistry.getService((Object)this, ChannelFrameworkService.class)) != null) {
            WSThreadPool wSThreadPool = (WSThreadPool)channelFrameworkService.getDefaultThreadPool();
            ThreadPool threadPool = null;
            if (wSThreadPool != null) {
                threadPool = wSThreadPool.getBackingThreadPool();
            }
            if (threadPool != null) {
                oDCNode.setIntProperty(this.odc.serverThreadPoolMin, threadPool.getMinimumPoolSize());
                oDCNode.setIntProperty(this.odc.serverThreadPoolMax, threadPool.getMaximumPoolSize());
                oDCNode.setBooleanProperty(this.odc.serverThreadPoolIsGrowable, threadPool.isGrowAsNeeded());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setDefaultThreadPool", "success");
                }
            } else if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setDefaultThreadPool", "null default thread pool");
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultThreadPool", "ChannelFrameworkService not found");
        }
    }

    protected void readVirtualHostGroups(ODCNode oDCNode) throws Exception {
        VirtualHost virtualHost2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readVirtualHostGroups", oDCNode);
        }
        List list = this.getNames(oDCNode, this.odc.vhostGroup);
        Repository repository2 = this.getRepository(oDCNode.getName(), null, null);
        for (VirtualHost virtualHost2 : repository2.getConfigRoot().getResource(0, "virtualhosts.xml").getContents()) {
            list.remove(virtualHost2.getName());
            this.readVirtualHostGroup(oDCNode, virtualHost2);
        }
        virtualHost2 = list.iterator();
        while (virtualHost2.hasNext()) {
            ODCNode oDCNode2 = oDCNode.getNode(this.odc.vhostGroup, (String)virtualHost2.next());
            if (oDCNode2 == null) continue;
            oDCNode.removeNode(oDCNode2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readVirtualHostGroups");
        }
    }

    protected ODCNode readVirtualHostGroup(ODCNode oDCNode, String string) throws Exception {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readVirtualHostGroup", new Object[]{oDCNode, string});
        }
        Repository repository2 = this.getRepository(oDCNode.getName(), null, null);
        for (Object object2 : repository2.getConfigRoot().getResource(0, "virtualhosts.xml").getContents()) {
            if (!object2.getName().equals(string)) continue;
            ODCNode oDCNode2 = this.readVirtualHostGroup(oDCNode, (VirtualHost)object2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readVirtualHostGroup");
            }
            return oDCNode2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating empty vhostGroup: " + string);
        }
        object2 = this.targetTree.createNode(string, this.odc.vhostGroup, oDCNode);
        return object2;
    }

    protected ODCNode readVirtualHostGroup(ODCNode oDCNode, VirtualHost virtualHost) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readVirtualHostGroup", new Object[]{oDCNode, virtualHost});
        }
        if (this.vhostExcludes.contains(virtualHost.getName())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readVirtualHostGroup", "excluded");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processing " + virtualHost.getName());
        }
        ODCNode oDCNode2 = this.targetTree.createNode(virtualHost.getName(), this.odc.vhostGroup, oDCNode);
        List list = this.getNames(oDCNode2, this.odc.vhost);
        for (HostAlias hostAlias : virtualHost.getAliases()) {
            String string;
            String string2 = hostAlias.getHostname() + ":" + hostAlias.getPort();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processing vhost " + string2);
            }
            if ((object = hostAlias.getHostname()) != null && (((String)object).equals("") || ((String)object).equals("*"))) {
                object = null;
            }
            Integer n = (string = this.expandVariable(hostAlias.getPort())) == null || string.equals("") || string.equals("*") ? ANY_PORT : new Integer(string);
            ODCNode oDCNode3 = this.targetTree.createNode(string2, this.odc.vhost, oDCNode2);
            oDCNode3.setProperty(this.odc.vhostHost, object);
            oDCNode3.setProperty(this.odc.vhostPort, (Object)n);
            list.remove(string2);
        }
        for (String string2 : list) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing " + string2);
            }
            if ((object = oDCNode2.getNode(this.odc.vhost, string2)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing vhost " + string2);
                }
                oDCNode2.removeNode((ODCNode)object);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "vhost not found to remove: " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readVirtualHostGroup", oDCNode2);
        }
        return oDCNode2;
    }

    public boolean virtualHostGroupExists(ODCNode oDCNode, ODCNode oDCNode2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "virtualHostExists", new Object[]{oDCNode, oDCNode2});
        }
        Repository repository2 = this.getRepository(oDCNode.getName(), null, null);
        Iterator iterator = repository2.getConfigRoot().getResource(0, "virtualhosts.xml").getContents().iterator();
        VirtualHost virtualHost = null;
        while (iterator.hasNext()) {
            virtualHost = (VirtualHost)iterator.next();
            if (!oDCNode2.getName().equals(virtualHost.getName())) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "virtualHostGroupExists - true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "virtualHostGroupExists - false");
        }
        return false;
    }

    public boolean virtualHostExists(ODCNode oDCNode, ODCNode oDCNode2) throws Exception {
        ODCNode oDCNode3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "virtualHostExists", new Object[]{oDCNode, oDCNode2});
        }
        if ((oDCNode3 = oDCNode2.getParent(this.odc.vhostGroup)) != null) {
            String string = oDCNode3.getName();
            String string2 = (String)oDCNode2.getProperty(this.odc.vhostHost);
            Integer n = (Integer)oDCNode2.getProperty(this.odc.vhostPort);
            Repository repository2 = this.getRepository(oDCNode.getName(), null, null);
            Iterator iterator = repository2.getConfigRoot().getResource(0, "virtualhosts.xml").getContents().iterator();
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                VirtualHost virtualHost = (VirtualHost)iterator.next();
                if (!string.equals(virtualHost.getName())) continue;
                bl = true;
                for (HostAlias hostAlias : virtualHost.getAliases()) {
                    String string3 = hostAlias.getHostname();
                    String string4 = this.expandVariable(hostAlias.getPort());
                    if (string3 != null && (string3.equals("") || string3.equals("*"))) {
                        string3 = null;
                    }
                    if (string4 == null || string4.equals("") || string4.equals("*")) {
                        string4 = ANY_PORT.toString();
                    }
                    if (string3 == null) {
                        if (string2 != null || !string4.equals(n.toString())) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "virtualHostExists - true");
                        }
                        return true;
                    }
                    if (!string3.equals(string2) || !string4.equals(n.toString())) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "virtualHostExists - true");
                    }
                    return true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "virtualHostExists - false");
        }
        return false;
    }

    protected ODCNode readCluster(ODCNode oDCNode, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readCluster", new Object[]{oDCNode, string});
        }
        ODCNode oDCNode2 = this.targetTree.createNode(string, this.odc.cluster, oDCNode);
        this.readCluster(oDCNode2);
        oDCNode2.setProperty(this.odc.clusterType, (Object)"static");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readCluster", oDCNode2);
        }
        return oDCNode2;
    }

    protected void readCluster(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readCluster", oDCNode);
        }
        try {
            Set set = this.getNodes(oDCNode, this.odc.server);
            ODCNode oDCNode2 = oDCNode.getParent();
            Repository repository2 = this.getRepository(oDCNode2.getName(), null, null);
            String string = "clusters" + SEP + oDCNode.getName() + SEP + "cluster.xml";
            for (ServerCluster serverCluster : repository2.getConfigRoot().getResource(0, string).getContents()) {
                Object object = serverCluster.getMembers().iterator();
                boolean bl = false;
                while (object.hasNext()) {
                    ClusterMember clusterMember = (ClusterMember)object.next();
                    String string2 = clusterMember.getNodeName();
                    String string3 = clusterMember.getMemberName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cluster member: node=" + string2 + ",server=", string3);
                    }
                    boolean bl2 = string2.equals(this.myNodeName);
                    if (!this.inDMgr && !bl2) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "skipping ... not my node: " + string2);
                        continue;
                    }
                    ODCNode oDCNode3 = this.getServerNode(string2, string3, true);
                    if (oDCNode3 == null) continue;
                    if (!set.remove(oDCNode3)) {
                        ODCNode oDCNode4;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adding server " + oDCNode3.getPath() + " to cluster " + oDCNode.getPath());
                        }
                        if ((oDCNode4 = oDCNode3.getNode(this.odc.cluster)) != null) {
                            oDCNode4.removeNode(oDCNode3);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "removed server " + oDCNode3.getPath() + " from cluster " + oDCNode4.getPath() + " prior to adding");
                            }
                            if (!oDCNode4.getBooleanProperty(this.odc.clusterIsReal)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "deleting fake cluster " + oDCNode4.getPath());
                                }
                                oDCNode4.remove();
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "add server " + oDCNode3.getPath() + " to cluster " + oDCNode.getPath());
                        }
                        oDCNode.addNode(oDCNode3);
                    }
                    this.setServerPropsByCluster(oDCNode3, clusterMember);
                    if (bl) continue;
                    bl = this.copySpeedFactorPropertyFromServerToCluster(oDCNode, oDCNode3);
                }
            }
            for (Object object : set) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing server reference " + object.getPath() + " from cluster " + oDCNode.getPath());
                }
                oDCNode.removeNode((ODCNode)object);
                if (object.getNode(this.odc.cluster) != null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "add server " + object.getPath() + " to a fake cluster");
                }
                this.getFakeClusterNode(object.getParent().getName(), object.getName());
            }
        }
        catch (Exception exception) {
            Tr.warning(tc, "Failed to process cluster with name " + oDCNode.getPath());
            FFDCFilter.processException(exception, "com.ibm.ws.odc.nd.cell.TreeBuilder.readCluster", "1589");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readCluster");
        }
    }

    protected boolean copySpeedFactorPropertyFromServerToCluster(ODCNode oDCNode, ODCNode oDCNode2) throws Exception {
        String string;
        if (oDCNode == null || oDCNode2 == null) {
            return false;
        }
        ODCPropertyDescriptor oDCPropertyDescriptor = oDCNode2.getType().getPropertyDescriptor("cp.SpeedFactorOverrideSpec");
        if (oDCPropertyDescriptor != null && (string = (String)oDCNode2.getProperty(oDCPropertyDescriptor)) != null && string.length() > 0) {
            oDCNode.setProperty(this.odc.clusterSpeedFactorOverrideSpec, (Object)string);
            Properties properties = oDCNode.getTransientProperties();
            properties.setProperty(SPEED_FACTOR_OVERRIDE_SPEC, string);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ODCNode readApplication(ODCNode oDCNode, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readApplication", new Object[]{oDCNode, string});
        }
        ODCNode oDCNode2 = null;
        EARFile eARFile = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        SessionManager sessionManager = null;
        try {
            ODCNode[] oDCNodeArray;
            Module module;
            String string5;
            ODCNode oDCNode3;
            Object object;
            int n;
            int n2;
            Deployment deployment;
            Object object2;
            ConfigRoot configRoot;
            Deployment deployment2;
            Object object3;
            Repository repository2 = this.getRepository(oDCNode.getName(), null, null);
            ConfigRoot configRoot2 = repository2.getConfigRoot();
            String string6 = "";
            ApplicationDeployment applicationDeployment = null;
            String[] stringArray = null;
            boolean bl = this.isSystemApp(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initial systemapp check: " + bl);
            }
            if (bl) {
                string2 = this.getSystemAppDeploymentPath(repository2, string);
                object3 = (Deployment)this.getResource(configRoot2, string2 + SEP + "deployment.xml").getContents().get(0);
                applicationDeployment = (ApplicationDeployment)object3.getDeployedObject();
                if (!applicationDeployment.isUseMetadataFromBinaries() && string2.equals(string3 = this.expandVariable(applicationDeployment.getBinariesURL()))) {
                    string3 = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "earURL and binariesURL are identical; setting binariesURL to " + string3);
                    }
                }
            } else {
                block65: {
                    if (EditionHelper.isEditionSupportEnabled()) {
                        stringArray = EditionHelper.getAppAndEdition(string);
                        configRoot2.setValue(1, stringArray[0] + ".ear");
                    } else {
                        configRoot2.setValue(1, string + ".ear");
                    }
                    string6 = "deployments" + SEP + string;
                    object3 = string6 + SEP + "deployment.xml";
                    try {
                        deployment2 = (Deployment)configRoot2.getResource(1, (String)object3).getContents().get(0);
                        applicationDeployment = (ApplicationDeployment)deployment2.getDeployedObject();
                        if (!applicationDeployment.isUseMetadataFromBinaries()) {
                            string2 = configRoot2.getAbsolutePath(1, "") + SEP + string6;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "not using metadata from binaries, loading ear from: " + string2);
                            }
                            string3 = this.expandVariable(applicationDeployment.getBinariesURL());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "binariesURL (deployment.xml): " + string3);
                            }
                            if (string3 != null && !new File(string3).exists()) {
                                string3 = configRoot2.getAbsolutePath(1, "") + SEP + string + ".ear";
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "binariesURL (relative): " + string3);
                                }
                                if (!new File(string3).exists()) {
                                    string3 = null;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "binariesURL cannot be resolved; using null");
                                    }
                                }
                            }
                            if (string2.equals(string3)) {
                                string3 = null;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "earURL and binariesURL are identical; setting binariesURL to " + string3);
                                }
                            }
                        } else if (applicationDeployment.isZeroEarCopy() || applicationDeployment.isZeroBinaryCopy()) {
                            string2 = this.expandVariable(applicationDeployment.getBinariesURL());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "using metadata from binaries, Zero*Copy, loading ear from: " + string2);
                            }
                        } else {
                            string2 = configRoot2.getAbsolutePath(1, "") + SEP + string + ".ear";
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "using metadata from binaries, not Zero*Copy, loading ear from: " + string2);
                            }
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        string3 = null;
                        configRoot = repository2.getConfigRoot();
                        string2 = this.expandVariable("${WAS_INSTALL_ROOT}" + SEP + "systemApps" + SEP + string + ".ear");
                        object2 = object3;
                        object3 = string2 + SEP + "deployment.xml";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to load from: " + (String)object2 + ", trying: " + (String)object3);
                        }
                        if ((applicationDeployment = (ApplicationDeployment)(deployment = (Deployment)this.getResource(configRoot, (String)object3).getContents().get(0)).getDeployedObject()).isUseMetadataFromBinaries() || !string2.equals(string3 = this.expandVariable(applicationDeployment.getBinariesURL()))) break block65;
                        string3 = null;
                        if (!tc.isDebugEnabled()) break block65;
                        Tr.debug(tc, "earURL and binariesURL are identical; setting binariesURL to " + string3);
                    }
                }
                if (this.isLooselyConfigured(string, applicationDeployment)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting loosely configured earFile: " + string);
                    }
                    this.registerLooseConfig(string, applicationDeployment, bl);
                }
            }
            eARFile = this.getEAR(string2, false, string3);
            if (!bl) {
                bl = AppManagementHelper.isSystemApp(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Secondary systemapp check: " + bl);
                }
            }
            object3 = applicationDeployment.getConfigs();
            deployment2 = null;
            if (object3 != null && object3.size() > 0 && (n2 = 0) < object3.size()) {
                object2 = (EditionInfo[])object3.get(n2);
                deployment2 = object2;
            }
            if (deployment2 != null && (sessionManager = deployment2.getSessionManagement()).isEnableCookies() && (configRoot = sessionManager.getDefaultCookieSettings()) != null) {
                string4 = configRoot.getName();
            }
            configRoot = eARFile.getDeploymentDescriptor();
            oDCNode2 = this.targetTree.createNode(string, this.odc.application, oDCNode);
            oDCNode2.setBooleanProperty(this.odc.applicationIsSystem, bl);
            if (string4 != null && sessionManager.isEnable()) {
                oDCNode2.setProperty(this.odc.appSessionAffinityCookie, (Object)string4);
                oDCNode2.setBooleanProperty(this.odc.appSessionOverride, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "application " + string + " session affinity cookie name changed to " + string4);
                }
            }
            if (this.ownsConfig) {
                oDCNode2.setProperty(this.odc.appLastChangeTime, (Object)new Long(System.currentTimeMillis()));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "application " + string + " has changed at " + System.currentTimeMillis());
                }
            }
            if (stringArray != null && !bl) {
                oDCNode2.setProperty(this.odc.appEdition, (Object)stringArray[1]);
                object2 = EditionHelper.getApplicationEditions(stringArray[0]);
                for (int i = 0; i < ((EditionInfo[])object2).length; ++i) {
                    String string7 = EditionHelper.getCompositeName(object2[i].getAppName(), ((EditionInfo)object2[i]).getEdition());
                    if (!string7.equalsIgnoreCase(string)) continue;
                    oDCNode2.setProperty(this.odc.appState, (Object)((EditionInfo)object2[i]).getEditionState());
                    break;
                }
            }
            oDCNode2.setProperty(this.odc.appRoot, (Object)string.split("-edition")[0]);
            object2 = this.getNodes(oDCNode2, this.odc.webModule);
            object2.addAll(this.getNodes(oDCNode2, this.odc.ejbModule));
            deployment = applicationDeployment.getModules();
            for (n = 0; n < deployment.size(); ++n) {
                object = (ModuleDeployment)deployment.get(n);
                oDCNode3 = null;
                string5 = null;
                try {
                    module = configRoot.getModule(object.getUri(), object.getAltDD());
                    if (module == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "module " + object.getUri() + " not found");
                        continue;
                    }
                    if (!module.isWebModule()) continue;
                    string5 = object.getUri();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing module " + string5);
                    }
                    if ((oDCNodeArray = this.getTargetClusters((ModuleDeployment)object, bl)).length == 0) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "module " + module.getUri() + " not deployed to cluster or server");
                        continue;
                    }
                    oDCNode3 = this.processWebModule(configRoot2, module, string5, (Set)object2, oDCNodeArray, oDCNode2, eARFile, string6, (List)deployment);
                    if (!bl || !this.inDMgr || oDCNode3 == null) continue;
                    oDCNode3.addNode(this.odcMyServer);
                    continue;
                }
                catch (Throwable throwable) {
                    oDCNodeArray = null;
                    if (string5 != null && (oDCNodeArray = oDCNode2.getNode(this.odc.webModule, string5)) != null) {
                        oDCNodeArray.remove();
                    }
                    TrUtil.warning(throwable, this, "readWebModule remove: " + oDCNodeArray, tc);
                }
            }
            for (n = 0; n < deployment.size(); ++n) {
                object = (ModuleDeployment)deployment.get(n);
                oDCNode3 = null;
                string5 = null;
                try {
                    module = configRoot.getModule(object.getUri(), object.getAltDD());
                    if (module == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "module " + object.getUri() + " not found");
                        continue;
                    }
                    if (!module.isEjbModule()) continue;
                    string5 = object.getUri();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing module " + string5);
                    }
                    if ((oDCNodeArray = this.getTargetClusters((ModuleDeployment)object, bl)).length == 0) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "module " + module.getUri() + " not deployed to cluster or server");
                        continue;
                    }
                    oDCNode3 = this.processEjbModule(configRoot2, module, string5, (Set)object2, oDCNodeArray, oDCNode2, eARFile, (ModuleDeployment)object, string, (List)deployment);
                    if (!bl || !this.inDMgr || oDCNode3 == null) continue;
                    oDCNode3.addNode(this.odcMyServer);
                    continue;
                }
                catch (Throwable throwable) {
                    oDCNodeArray = null;
                    if (string5 != null && (oDCNodeArray = oDCNode2.getNode(this.odc.ejbModule, string5)) != null) {
                        oDCNodeArray.remove();
                    }
                    TrUtil.warning(throwable, this, "readEjbModule remove:" + oDCNodeArray, tc);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing modules which no longer exist");
            }
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (ODCNode)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "remove " + object);
                }
                oDCNode2.removeNode((ODCNode)object);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                throwable.printStackTrace(System.out);
            }
            try {
                oDCNode2 = oDCNode.getNode(this.odc.application, string);
                if (oDCNode2 != null) {
                    TrUtil.warning(throwable, this, "Removing: " + oDCNode2, tc);
                    oDCNode2.remove();
                    oDCNode2 = null;
                }
            }
            catch (Throwable throwable2) {
                TrUtil.warning(throwable2, this, "readApplicationCleanup", tc);
            }
        }
        finally {
            if (eARFile != null) {
                eARFile.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readApplication", oDCNode2);
        }
        return oDCNode2;
    }

    private void registerLooseConfig(String string, ApplicationDeployment applicationDeployment, boolean bl) {
        String string2 = null;
        for (Property property : applicationDeployment.getProperties()) {
            if (property == null || !property.getName().equals("was.loose.config")) continue;
            string2 = applicationDeployment.getBinariesURL();
            String string3 = property.getValue();
            if (bl && (string2 = string).endsWith("deployment.xml")) {
                string2 = string2.substring(0, string2.lastIndexOf("deployment.xml") - 1);
            }
            string2 = this.expandVariable(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "registerLooseConfig: binariesURL=" + string2 + " looseConfigXmiURL=" + string3);
            }
            LooseConfigRegister.singleton().addLooseMapping(string2, string3);
        }
    }

    private boolean isLooselyConfigured(String string, ApplicationDeployment applicationDeployment) {
        for (Property property : applicationDeployment.getProperties()) {
            if (property == null || !property.getName().equals("was.loose.config")) continue;
            return true;
        }
        return false;
    }

    protected ODCNode[] getTargetClusters(ModuleDeployment moduleDeployment, boolean bl) throws Exception {
        ODCNode[] oDCNodeArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetClusters", new Object[]{moduleDeployment, new Boolean(bl)});
        }
        String string = moduleDeployment.getUri();
        ArrayList<ODCNode> arrayList = new ArrayList<ODCNode>();
        ODCNode oDCNode = null;
        Iterator iterator = moduleDeployment.getTargetMappings().iterator();
        while (iterator.hasNext()) {
            oDCNodeArray = ((DeploymentTargetMapping)iterator.next()).getTarget();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target=" + oDCNodeArray);
            }
            if (oDCNodeArray instanceof ServerTarget) {
                ServerTarget serverTarget = (ServerTarget)oDCNodeArray;
                if (bl && this.ownsConfig) {
                    oDCNode = this.getFakeClusterNode(this.odcMyNode.getName(), this.odcMyServer.getName());
                } else {
                    String string2 = serverTarget.getNodeName();
                    String string3 = serverTarget.getName();
                    if (string2 == null && string3 == null && this.odcMyServer != null) {
                        oDCNode = this.odcMyServer.getNode(this.odc.cluster);
                    }
                    if (oDCNode == null) {
                        oDCNode = this.getFakeClusterNode(string2, string3);
                    }
                }
            } else if (oDCNodeArray != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "target class is " + oDCNodeArray.getClass().getName());
                }
                oDCNode = this.getClusterNode(oDCNodeArray.getName());
            }
            if (oDCNode == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add cluster " + oDCNode);
            }
            arrayList.add(oDCNode);
        }
        oDCNodeArray = arrayList.toArray(new ODCNode[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetClusters");
        }
        return oDCNodeArray;
    }

    protected void addPortletURIs(EARFile eARFile, ODCNode oDCNode, String string, ConfigRoot configRoot) throws Exception {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPortletURIs", oDCNode);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "search for portlet URIs");
        }
        if ((list = eARFile.getWebModuleRefs()) != null && list.size() > 0) {
            for (WebModuleRef webModuleRef : list) {
                ODCNode oDCNode2;
                String string2 = webModuleRef.getUri();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module=" + string2);
                }
                if ((oDCNode2 = oDCNode.getNode(this.odc.webModule, string2)) == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "module " + string2 + " not found; skipping");
                    continue;
                }
                Method method2 = Class.forName("com.ibm.ws.portletcontainer.util.PortletModelHelper").getMethod("getPortletApplication", WebModuleRef.class);
                PortletApplication portletApplication = (PortletApplication)method2.invoke(null, webModuleRef);
                if (portletApplication == null || !this.portletServingEnabled(string, string2, configRoot)) continue;
                for (Portlet portlet : portletApplication.getPortlets()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "portlet=" + portlet.getPortletName());
                    }
                    this.targetTree.createNode("/" + portlet.getPortletName() + "/*", this.odc.uri, oDCNode2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPortletURIs", oDCNode);
        }
    }

    protected boolean portletServingEnabled(String string, ConfigRoot configRoot) {
        boolean bl;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "portletServingEnabled", string);
            }
            bl = true;
            try {
                String string2 = string + SEP + "ibm-portlet-ext.xmi";
                PortletApplicationExtension portletApplicationExtension = (PortletApplicationExtension)configRoot.getResource(1, string2).getContents().get(0);
                bl = portletApplicationExtension.isPortletServingEnabled();
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "portletServingEnabled exception");
                throwable.printStackTrace(System.out);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "portletServingEnabled", new Boolean(bl));
        }
        return bl;
    }

    protected boolean portletServingEnabled(String string, String string2, ConfigRoot configRoot) {
        boolean bl;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "portletServingEnabled", new Object[]{string, string2});
            }
            bl = true;
            try {
                String string3 = string + SEP + string2 + SEP + WEB_INF + SEP + "ibm-portlet-ext.xmi";
                PortletApplicationExtension portletApplicationExtension = (PortletApplicationExtension)configRoot.getResource(1, string3).getContents().get(0);
                bl = portletApplicationExtension.isPortletServingEnabled();
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "portletServingEnabled exception, ignore because web module does not have an ibm-portlet-ext.xmi file.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "portletServingEnabled", new Boolean(bl));
        }
        return bl;
    }

    protected ODCNode processWebModule(ConfigRoot configRoot, Module module, String string, Set set, ODCNode[] oDCNodeArray, ODCNode oDCNode, EARFile eARFile, String string2, List list) throws Exception {
        Object object2;
        ODCNode oDCNode2;
        ODCNode oDCNode3;
        EList eList;
        block19: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Web module: " + string);
            }
            eList = null;
            String string3 = string2 + SEP + "proxy-deployment.xml";
            try {
                eList = configRoot.getResource(1, string3).getContents();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug(tc, string3 + " was not found");
            }
        }
        DeployedObjectProxyConfig deployedObjectProxyConfig = this.getProxyDeployment(eList, string);
        Boolean bl = Boolean.TRUE;
        String string4 = null;
        if (deployedObjectProxyConfig != null) {
            if (!deployedObjectProxyConfig.isEnableProxy()) {
                bl = Boolean.FALSE;
            }
            if (deployedObjectProxyConfig.getTransportProtocol() != null) {
                string4 = deployedObjectProxyConfig.getTransportProtocol().getName();
            }
        }
        ODCNode oDCNode4 = null;
        WebModule webModule = (WebModule)module;
        String string5 = ((WebAppBinding)eARFile.getBindings(module)).getVirtualHostName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "virtual host: " + string5);
        }
        if (string5 == null || string5.equals("")) {
            string5 = "default_host";
        }
        if ((oDCNode3 = this.getVHostGroupNode(string5)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "virtual host group not found; skipping web module");
            }
            return oDCNode4;
        }
        oDCNode4 = this.createWebModuleNode(string, oDCNode);
        oDCNode4.setProperty(this.odc.webModuleRoutingEnabled, (Object)bl);
        this.setWebModuleProtocolMap(oDCNode4, string4);
        set.remove(oDCNode4);
        this.removeClusters(oDCNode4);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            oDCNode4.addNode(oDCNodeArray[i]);
        }
        String string6 = TreeBuilder.normalizeContextRoot(webModule.getContextRoot());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "context root: " + string6);
        }
        if ((oDCNode2 = oDCNode4.getNode(this.odc.vhostGroup)) != oDCNode3) {
            if (oDCNode2 != null) {
                oDCNode4.removeNode(oDCNode2);
            }
            oDCNode4.addNode(oDCNode3);
        }
        WebAppExtension webAppExtension = eARFile.getExtensions(webModule);
        oDCNode4.setProperty(this.odc.webModuleContextRoot, (Object)string6);
        oDCNode4.setProperty(this.odc.webModuleFileServingEnabled, (Object)new Boolean(webAppExtension.isFileServingEnabled()));
        oDCNode4.setProperty(this.odc.webModuleServeServletsByName, (Object)new Boolean(webAppExtension.isSetServeServletsByClassnameEnabled()));
        if (webAppExtension.isFileServingEnabled()) {
            this.addURI(oDCNode4, "/*");
        }
        this.addURI(oDCNode4, "/*.jsp");
        this.addURI(oDCNode4, "/*.jsv");
        this.addURI(oDCNode4, "/*.jsw");
        if (webAppExtension.isSetServeServletsByClassnameEnabled()) {
            this.addURI(oDCNode4, "/servlet/*");
        }
        for (Object object2 : eARFile.getDeploymentDescriptor(webModule).getServletMappings()) {
            this.addURI(oDCNode4, object2.getUrlPattern());
        }
        object2 = this.getWebServicesUrlPatterns(eARFile, list, (Module)webModule).iterator();
        String string7 = null;
        while (object2.hasNext()) {
            string7 = (String)object2.next();
            this.addURI(oDCNode4, string7);
        }
        if (string7 != null) {
            this.processWSDLs(eARFile, webModule, oDCNode4);
        }
        return oDCNode4;
    }

    protected ODCNode processEjbModule(ConfigRoot configRoot, Module module, String string, Set set, ODCNode[] oDCNodeArray, ODCNode oDCNode, EARFile eARFile, ModuleDeployment moduleDeployment, String string2, List list) throws Exception {
        block15: {
            PlatformHelper platformHelper;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EJB module: " + string);
            }
            ODCNode oDCNode2 = null;
            EjbModule ejbModule = (EjbModule)module;
            String string3 = this.getRouterModuleName(eARFile, ejbModule);
            if (string3 != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "router module name: " + string3);
            }
            if ((platformHelper = PlatformHelperFactory.getPlatformHelper()).isZOS()) {
                Tr.debug(tc, "done with ejbModule on Z: " + oDCNode2);
                return oDCNode2;
            }
            try {
                if (string3 != null) {
                    ODCNode oDCNode3 = oDCNode.getNode(this.odc.webModule, string3);
                    if (oDCNode3 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "begin webservice processing: " + oDCNode3);
                        }
                        ModuleFile moduleFile = eARFile.getModuleRef(module).getModuleFile();
                        Iterator iterator = this.getWsdls(eARFile, (Module)ejbModule).iterator();
                        while (iterator.hasNext()) {
                            this.processWsdl((String)iterator.next(), moduleFile, oDCNode3);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adding web service patterns");
                        }
                        for (String string4 : this.getWebServicesUrlPatterns(eARFile, list, (Module)ejbModule)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "webservice pattern =" + string4);
                            }
                            this.addURI(oDCNode3, string4);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "end webservice processing: " + oDCNode3);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string3 + " has not been read");
                    }
                }
            }
            catch (Throwable throwable) {
                ODCNode oDCNode4 = oDCNode.getNode(this.odc.webModule, string3);
                if (oDCNode4 == null) break block15;
                TrUtil.warning(throwable, this, "Removing " + oDCNode4, tc);
                oDCNode4.remove();
            }
        }
        return null;
    }

    protected ODCNode createWebModuleNode(String string, ODCNode oDCNode) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createWebModuleNode: " + string);
        }
        ODCNode oDCNode2 = this.targetTree.createNode(string, this.odc.webModule, oDCNode);
        oDCNode2.setProperty(this.odc.webModuleId, (Object)this.getModuleId(oDCNode2));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "end createWebModuleNode: " + string);
        }
        return oDCNode2;
    }

    protected String getModuleId(ODCNode oDCNode) throws Exception {
        int n;
        ODCNode oDCNode2 = oDCNode.getParent();
        ODCNode oDCNode3 = oDCNode2.getParent();
        String string = oDCNode2.getName();
        String string2 = (String)oDCNode2.getProperty(this.odc.appEdition);
        if (string2 != null && (n = string2.length()) > 0) {
            string = string.substring(0, string.length() - (n + 8));
        }
        String string3 = oDCNode3.getName() + "/" + string + "/" + oDCNode.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "modId='" + string3 + ", modPath=" + oDCNode.getPath());
        }
        return string3;
    }

    protected void removeClusters(ODCNode oDCNode) throws Exception {
        ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.cluster);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            oDCNode.removeNode(oDCNodeArray[i]);
        }
    }

    protected void processWSDLs(EARFile eARFile, WebModule webModule, ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processWSDLs", new Object[]{eARFile, webModule, oDCNode});
        }
        ModuleFile moduleFile = eARFile.getModuleRef((Module)webModule).getModuleFile();
        Iterator iterator = this.getWsdls(eARFile, (Module)webModule).iterator();
        while (iterator.hasNext()) {
            this.processWsdl((String)iterator.next(), moduleFile, oDCNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processWSDLs");
        }
    }

    protected void processWsdl(String string, ModuleFile moduleFile, ODCNode oDCNode) {
        Definition definition;
        WSDLReaderImpl wSDLReaderImpl;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processWsdl", new Object[]{string, oDCNode});
            }
            wSDLReaderImpl = new WSDLReaderImpl();
            wSDLReaderImpl.setFeature("javax.wsdl.verbose", JAVAX_WSDL_VERBOSE);
            definition = null;
            try {
                definition = wSDLReaderImpl.readWSDL(string);
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "processWsdl: file not found at " + string + ". Trying to locate JAR file.");
            }
        }
        try {
            Object object;
            Iterator iterator2;
            Object object2;
            if (definition == null) {
                int n = string.indexOf(".jar");
                if (n < 0) {
                    return;
                }
                Object object3 = string.substring(n += 5);
                object2 = moduleFile.getFile((String)object3);
                InputStream inputStream = object2.getInputStream();
                Object object4 = moduleFile.getLoadStrategy();
                Class<?> clazz = Class.forName("com.ibm.ws.webservices.client.ModuleWSDLLocator");
                iterator2 = clazz.getConstructor(Class.forName("java.lang.String"), Class.forName("java.io.InputStream"), Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy"));
                object = ((Constructor)((Object)iterator2)).newInstance(object3, inputStream, object4);
                definition = wSDLReaderImpl.readWSDL((WSDLLocator)object);
            }
            for (Object object3 : definition.getServices().values()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing webservice: " + ((ServiceImpl)object3).getQName().getLocalPart());
                }
                object2 = this.targetTree.createNode(((ServiceImpl)object3).getQName().getLocalPart(), this.odc.webService, oDCNode);
                block7: for (Object object4 : ((ServiceImpl)object3).getPorts().values()) {
                    Object object5;
                    Class[] classArray;
                    block8: for (Iterator iterator2 : object4.getBinding().getBindingOperations()) {
                        for (Object object6 : iterator2.getExtensibilityElements()) {
                            if (!(object6 instanceof SOAPOperation) || (classArray = ((SOAPOperation)object6).getSoapActionURI()) == null || classArray.length() <= 0) continue;
                            object5 = this.targetTree.createNode(iterator2.getName(), this.odc.webServiceOperation, (ODCNode)object2);
                            object5.setProperty(this.odc.SOAPAction, (Object)classArray);
                            continue block8;
                        }
                    }
                    if (!oDCNode.is(this.odc.webModule)) continue;
                    iterator2 = object4.getExtensibilityElements().iterator();
                    while (iterator2.hasNext()) {
                        object = (ExtensibilityElement)iterator2.next();
                        if (!(object instanceof SOAPAddress)) continue;
                        try {
                            Object object6;
                            object6 = Class.forName("com.ibm.ws.webservices.engine.types.URI");
                            classArray = new Class[]{String.class};
                            object5 = ((Class)object6).getConstructor(classArray);
                            Object t = ((Constructor)object5).newInstance(((SOAPAddress)object).getLocationURI());
                            Method method2 = ((Class)object6).getMethod("getPath", null);
                            String string2 = (String)method2.invoke(t, (Object[])null);
                            String string3 = (String)oDCNode.getProperty(this.odc.webModuleContextRoot);
                            if (string3 == null) {
                                throw new ODCException("no context root for " + oDCNode.getPath());
                            }
                            if (string2.indexOf(string3) == 0) {
                                string2 = string2.substring(string3.length());
                            }
                            ODCNode oDCNode2 = this.targetTree.createNode(string2, this.odc.uri, oDCNode);
                            object2.addNode(oDCNode2);
                        }
                        catch (Exception exception) {
                            Tr.warning(tc, "Invalid uri " + ((SOAPAddress)object).getLocationURI() + " in module " + oDCNode.getPath(), exception);
                        }
                        continue block7;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "processWsdl", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processWsdl", oDCNode);
        }
    }

    protected List getWsdls(EARFile eARFile, Module module) throws Exception {
        String string;
        AnnotatedElement annotatedElement;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWsdls", new Object[]{eARFile, module});
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        ModuleFile moduleFile = eARFile.getModuleRef(module).getModuleFile();
        WebServices webServices = null;
        Class<?> clazz = Class.forName("com.ibm.ws.webservices.WSConstants");
        if (module.isWebModule()) {
            annotatedElement = clazz.getDeclaredField("WSKEY_WSWEBSERVER_XMLFILE");
            string = (String)((Field)annotatedElement).get(null);
        } else {
            string = (String)clazz.getField("WSKEY_WSSERVER_XMLFILE").get(null);
        }
        try {
            annotatedElement = Class.forName("com.ibm.wsspi.webservices.models.WSModels");
            Class[] classArray = new Class[]{LoadStrategy.class, String.class};
            Method method2 = ((Class)annotatedElement).getMethod("getWebServices", classArray);
            webServices = (WebServices)method2.invoke(null, moduleFile.getLoadStrategy(), string);
            for (WebServiceDescription webServiceDescription : webServices.getWebServiceDescriptions()) {
                String string2 = webServiceDescription.getWsdlFile();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wsdlFile=" + string2);
                }
                if (SEP.equals("\\")) {
                    string2.replaceAll("/", "\\\\");
                } else {
                    string2.replaceAll("/", SEP);
                }
                String string3 = moduleFile.getAbsolutePath() + SEP + string2;
                linkedList.add(string3);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.PluginCfgHelper.getWebServicesUrlPatterns", "155");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWsdls", new Object[]{eARFile, module});
        }
        return linkedList;
    }

    protected DeployedObjectProxyConfig getProxyDeployment(EList eList, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProxyDeployment", new Object[]{eList, string});
        }
        if (eList != null) {
            for (int i = 0; i < eList.size(); ++i) {
                DeployedObjectProxyConfig deployedObjectProxyConfig = (DeployedObjectProxyConfig)eList.get(i);
                if (!deployedObjectProxyConfig.getDeployedObjectConfigName().equals(string)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getProxyDeployment", deployedObjectProxyConfig);
                }
                return deployedObjectProxyConfig;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProxyDeployment", "null");
        }
        return null;
    }

    protected void addDefaultChannelChain(ODCNode oDCNode, boolean bl) throws Exception {
        this.addDefaultChannelChain(oDCNode, bl, false);
    }

    protected void addDefaultChannelChain(ODCNode oDCNode, boolean bl, boolean bl2) throws Exception {
        ODCNode oDCNode2;
        String string = bl ? "https" : "http";
        ODCNode oDCNode3 = this.targetTree.createNode(string, this.odc.channelChain, oDCNode, bl2);
        ODCNode oDCNode4 = this.targetTree.createNode("http", this.odc.channel, oDCNode3, bl2);
        oDCNode4.setProperty(this.odc.channelFactoryClass, (Object)"com.ibm.ws.http.channel.outbound.impl.HttpOutboundChannelFactory");
        if (bl) {
            oDCNode2 = this.targetTree.createNode("ssl", this.odc.channel, oDCNode3, bl2);
            oDCNode2.setProperty(this.odc.channelFactoryClass, (Object)"com.ibm.ws.ssl.channel.impl.SSLChannelFactory");
        }
        oDCNode2 = this.targetTree.createNode("tcp", this.odc.channel, oDCNode3, bl2);
        oDCNode2.setProperty(this.odc.channelFactoryClass, (Object)"com.ibm.ws.tcp.channel.impl.TCPChannelFactory");
    }

    protected void addURI(ODCNode oDCNode, String string) throws ODCException {
        if (!string.startsWith("*") && !string.startsWith("/")) {
            string = "/" + string;
        }
        this.targetTree.createNode(string, this.odc.uri, oDCNode);
    }

    protected List getWebServicesUrlPatterns(EARFile eARFile, List list, Module module) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWebServicesUrlPatterns", new Object[]{eARFile, module});
        }
        ArrayList arrayList = new ArrayList();
        Class<?> clazz = Class.forName("com.ibm.ws.webservices.deploy.PluginCfgHelper");
        Class[] classArray = new Class[]{EARFile.class, List.class, Module.class};
        Method method2 = clazz.getMethod("getWebServicesUrlPatterns", classArray);
        List list2 = (List)method2.invoke(null, eARFile, list, module);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWebServicesUrlPatterns");
        }
        return list2;
    }

    protected String getRouterModuleName(EARFile eARFile, EjbModule ejbModule) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRouterModuleName", new Object[]{eARFile, ejbModule});
        }
        Class<?> clazz = Class.forName("com.ibm.ws.webservices.deploy.PluginCfgHelper");
        Class[] classArray = new Class[]{EARFile.class, EjbModule.class};
        Method method2 = clazz.getMethod("getRouterModuleName", classArray);
        String string = (String)method2.invoke(null, eARFile, ejbModule);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRouterModuleName", string);
        }
        return string;
    }

    protected ApplicationServer getAppServer(com.ibm.websphere.models.config.process.Server server2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppServer", server2);
        }
        for (Object e2 : server2.getComponents()) {
            if (!(e2 instanceof ApplicationServer)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppServer", e2);
            }
            return (ApplicationServer)e2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppServer", "null");
        }
        return null;
    }

    protected WebContainer getWebContainer(ApplicationServer applicationServer) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWebContainer", applicationServer);
        }
        for (Object e2 : applicationServer.getComponents()) {
            if (!(e2 instanceof WebContainer)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWebContainer", e2);
            }
            return (WebContainer)e2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWebContainer", "null");
        }
        return null;
    }

    protected ODCNode getNodeNode(String string, boolean bl) {
        return this.getNodeNode(this.odcMyCell, string, bl);
    }

    protected ODCNode getNodeNode(ODCNode oDCNode, String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeNode", new Object[]{oDCNode, string, bl});
        }
        ODCNode oDCNode2 = null;
        try {
            oDCNode2 = oDCNode.getNode(this.odc.node, string);
            if (oDCNode2 == null || !this.initialized && oDCNode2.isOnMyNode()) {
                oDCNode2 = this.readNode(oDCNode, string, bl);
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "getNodeNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeNode", oDCNode2);
        }
        return oDCNode2;
    }

    protected ODCNode getServerNode(String string, String string2, boolean bl) {
        return this.getServerNode(this.getNodeNode(string, bl), string2, bl);
    }

    protected ODCNode getServerNode(ODCNode oDCNode, String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerNode", new Object[]{oDCNode, string, bl});
        }
        ODCNode oDCNode2 = null;
        try {
            if (oDCNode != null && ((oDCNode2 = oDCNode.getNode(this.odc.server, string)) == null || !this.initialized && oDCNode2.isOnMyServer())) {
                oDCNode2 = this.readServer(this.odcMyCell, oDCNode, string, bl);
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "getServerNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerNode", oDCNode2);
        }
        return oDCNode2;
    }

    protected ODCNode getClusterNode(ODCNode oDCNode, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterNode", new Object[]{oDCNode, string});
        }
        ODCNode oDCNode2 = null;
        try {
            if (oDCNode != null && (oDCNode2 = oDCNode.getNode(this.odc.cluster, string)) == null) {
                oDCNode2 = this.readCluster(oDCNode, string);
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "getClusterNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterNode", oDCNode2);
        }
        return oDCNode2;
    }

    protected ODCNode getVHostGroupNode(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVhostGroupNode", string);
        }
        if (this.vhostExcludes.contains(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getVhostGroupNode", "excluded");
            }
            return null;
        }
        ODCNode oDCNode = null;
        try {
            oDCNode = this.odcMyCell.getNode(this.odc.vhostGroup, string);
            if (oDCNode == null) {
                oDCNode = this.readVirtualHostGroup(this.odcMyCell, string);
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "getVHostGroupNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVhostGroupNode", oDCNode);
        }
        return oDCNode;
    }

    protected ODCNode obtainAppNode(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "obtainAppNode", string);
        }
        ODCNode oDCNode = null;
        oDCNode = (ODCNode)this.appsRead.get(string);
        if (oDCNode == null) {
            try {
                oDCNode = this.targetTree.createNode(string, this.odc.application, this.odcMyCell);
                if (oDCNode != null) {
                    this.appsRead.put(string, oDCNode);
                }
                this.readApplication(this.odcMyCell, string);
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "obtainAppNode:" + string, tc);
                this.appsRead.remove(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "obtainAppNode", oDCNode);
        }
        return oDCNode;
    }

    protected void removeAppNode(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAppNode", string);
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeAppNode - null");
            }
            return;
        }
        try {
            this.appsRead.remove(string);
            ODCNode oDCNode = this.odcMyCell.getNode(this.odc.application, string);
            this.appsRead.remove(string);
            if (oDCNode != null) {
                oDCNode.remove();
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "removeAppNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAppNode");
        }
    }

    protected ODCNode getClusterNode(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterNode", string);
        }
        ODCNode oDCNode = null;
        try {
            oDCNode = this.odcMyCell.getNode(this.odc.cluster, string);
            if (oDCNode == null) {
                oDCNode = this.readCluster(this.odcMyCell, string);
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "getClusterNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterNode", oDCNode);
        }
        return oDCNode;
    }

    protected ODCNode getFakeClusterNode(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFakeClusterNode", new Object[]{string, string2});
        }
        ODCNode oDCNode = null;
        String string3 = string + ":" + string2;
        try {
            oDCNode = this.targetTree.createNode(string3, this.odc.cluster, this.odcMyCell);
            oDCNode.setProperty(this.odc.clusterType, (Object)"single-server");
            oDCNode.setBooleanProperty(this.odc.clusterIsReal, false);
            ODCNode oDCNode2 = this.getServerNode(string, string2, true);
            if (oDCNode2 != null) {
                oDCNode.addNode(oDCNode2);
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "getFakeClusterNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFakeClusterNode", oDCNode);
        }
        return oDCNode;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getNewValue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "propertyChange server state: " + string);
        }
        this.setMyServerState(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configChanged", configRepositoryEvent);
        }
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.configChanged");
            try {
                this.handleConfigChange(configRepositoryEvent);
                this.targetTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "TreeBuilder.configChanged", tc);
                this.targetTree.rollbackTransaction();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Fail to handle ConfigChange - starting to rebuild TargetTree");
                }
                try {
                    this.refresh();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "TreeBuilder.configChanged", "2473");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    public void handleConfigChange(ConfigRepositoryEvent configRepositoryEvent) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleConfigChange", configRepositoryEvent);
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        if (tc.isEntryEnabled()) {
            for (int i = 0; i < configChangeNotifierArray.length; ++i) {
                Tr.debug(tc, "\ni=" + i + " type=" + configChangeNotifierArray[i].getChangeType() + " uri=" + configChangeNotifierArray[i].getUri());
            }
        }
        ArrayList arrayList = new ArrayList();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put(APP_CHANGES, arrayList);
        hashMap.put(SERVICEPOLICY_UPDATE_REQD, Boolean.FALSE);
        hashMap.put(NODEGROUP_UPDATE_REQD, Boolean.FALSE);
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            ConfigChangeNotifier configChangeNotifier = configChangeNotifierArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "change=" + configChangeNotifier);
            }
            if (configChangeNotifier.getChangeType() != 1 && this.deletedLater(configChangeNotifier.getUri(), i + 1, configChangeNotifierArray)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ignore this event because this document was deleted later in the same transaction");
                continue;
            }
            this.handleDocChange(configChangeNotifier, hashMap);
        }
        this.doConfigChangePostProcessing(this.odcMyCell, hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleConfigChange");
        }
    }

    protected boolean deletedLater(String string, int n, ConfigChangeNotifier[] configChangeNotifierArray) {
        for (int i = n; i < configChangeNotifierArray.length; ++i) {
            ConfigChangeNotifier configChangeNotifier = configChangeNotifierArray[i];
            if (configChangeNotifier.getChangeType() != 1 || !configChangeNotifier.getUri().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected void handleDocChange(ConfigChangeNotifier configChangeNotifier, HashMap hashMap) throws Exception {
        String string = configChangeNotifier.getUri();
        if (string.endsWith("/cell.xml")) {
            this.handleCellChange(configChangeNotifier);
        } else if (string.endsWith("/cluster.xml")) {
            this.handleClusterChange(configChangeNotifier);
        } else if (string.endsWith("/node.xml") && string.indexOf("/nodes/") != -1) {
            this.handleNodeChange(configChangeNotifier);
        } else if (string.startsWith(this.nodesDir) && string.endsWith("/server.xml")) {
            this.handleServerChange(configChangeNotifier);
        } else if (string.endsWith("/serverindex.xml")) {
            this.handleServerIndexChange(configChangeNotifier);
        } else if (string.endsWith("/virtualhosts.xml")) {
            this.readVirtualHostGroups(this.odcMyCell);
        } else if (string.startsWith(this.applicationsDir)) {
            Object object;
            List list = (List)hashMap.get(APP_CHANGES);
            String[] stringArray = string.split("/");
            Object object2 = stringArray[3];
            if (EditionHelper.isEditionSupportEnabled()) {
                if (string.endsWith("ibm-edition-metadata.props")) {
                    if (configChangeNotifier.getChangeType() == 1) {
                        return;
                    }
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 4);
                    EditionInfo[] editionInfoArray = EditionHelper.getApplicationEditions((String)object2);
                    for (int i = 0; i < editionInfoArray.length; ++i) {
                        String string2 = EditionHelper.getCompositeName(editionInfoArray[i].getAppName(), editionInfoArray[i].getEdition());
                        if (!this.ownsConfig && this.appsRead.get(string2) == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "edition '" + string2 + "' not read; ignoring app change");
                            continue;
                        }
                        int n = configChangeNotifier.getChangeType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "change to application " + string2);
                        }
                        AppChange appChange = null;
                        for (int j = 0; j < list.size(); ++j) {
                            AppChange appChange2 = (AppChange)list.get(j);
                            if (!string2.equals(appChange2.appName) || n != appChange2.change) continue;
                            appChange = appChange2;
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "event already exists: " + appChange);
                            break;
                        }
                        if (appChange != null) continue;
                        appChange = new AppChange(string2, n);
                        list.add(appChange);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "new event: " + appChange);
                    }
                    return;
                }
                String string3 = this.applicationsDir + (String)object2 + "/" + "deltas" + "/";
                if (string.indexOf(string3) != -1) {
                    return;
                }
                object = null;
                if (string.endsWith(".ear")) {
                    object = string.split("/")[4];
                    object = ((String)object).substring(0, ((String)object).length() - 4);
                } else {
                    object = string.split("/")[5];
                }
                object2 = object;
            } else {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 4);
            }
            int n = configChangeNotifier.getChangeType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "change to application " + (String)object2);
            }
            if (n == 1 && !stringArray[stringArray.length - 1].equals("application.xml")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ignoring delete of " + string);
                }
                return;
            }
            if (!this.ownsConfig && this.appsRead.get(object2) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "application '" + (String)object2 + "' not read; ignoring app change");
                }
                return;
            }
            object = null;
            for (int i = 0; i < list.size(); ++i) {
                AppChange appChange = (AppChange)list.get(i);
                if (!((String)object2).equals(appChange.appName) || n != appChange.change) continue;
                object = appChange;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "event already exists: " + object);
                break;
            }
            if (object == null) {
                object = new AppChange((String)object2, n);
                list.add(object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new event: " + object);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not process " + configChangeNotifier);
        }
    }

    protected void doConfigChangePostProcessing(ODCNode oDCNode, HashMap hashMap) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "doConfigChangePostProcessing: processing application changes");
        }
        List list = (List)hashMap.get(APP_CHANGES);
        for (AppChange appChange : list) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appchange:" + appChange);
            }
            switch (appChange.change) {
                case 0: {
                    this.readApplication(oDCNode, appChange.appName);
                    break;
                }
                case 2: {
                    this.readApplication(oDCNode, appChange.appName);
                    break;
                }
                case 1: {
                    ODCNode oDCNode2 = oDCNode.getNode(this.odc.application, appChange.appName);
                    if (oDCNode2 == null) break;
                    this.handleAppNodeDeletion(oDCNode2);
                }
            }
        }
    }

    protected void handleCellChange(ConfigChangeNotifier configChangeNotifier) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleCellChange " + configChangeNotifier);
        }
        String string = configChangeNotifier.getUri();
        String[] stringArray = string.split("/");
        String string2 = null;
        if (stringArray.length > 1 && stringArray[0].equalsIgnoreCase("cells")) {
            string2 = stringArray[1];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellName=" + string2);
        }
        if (string2 == null) {
            return;
        }
        switch (configChangeNotifier.getChangeType()) {
            case 0: {
                this.readCell(this.targetTree.getRoot(), string2);
                break;
            }
            case 2: {
                ODCNode oDCNode = this.targetTree.getRoot().getNode(this.odc.cell, string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell=" + oDCNode);
                }
                if (oDCNode == null) break;
                this.readCellXml(oDCNode);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("unknown change type: " + configChangeNotifier.getChangeType());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleCellChange complete");
        }
    }

    protected void handleServerChange(ConfigChangeNotifier configChangeNotifier) throws Exception {
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleServerChange", configChangeNotifier);
        }
        String string = configChangeNotifier.getUri();
        String[] stringArray = string.split("/");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (stringArray.length > 6 && stringArray[stringArray.length - 7].equalsIgnoreCase("cells") && stringArray[stringArray.length - 5].equalsIgnoreCase("nodes") && stringArray[stringArray.length - 3].equalsIgnoreCase("servers")) {
            string2 = stringArray[stringArray.length - 6];
            string3 = stringArray[stringArray.length - 4];
            string4 = stringArray[stringArray.length - 2];
        }
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleServerChange: cellName is ", string2);
            }
            return;
        }
        if (string3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleServerChange: nodeName is ", string3);
            }
            return;
        }
        if (string4 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleServerChange: serverName is ", string4);
            }
            return;
        }
        if (!this.shouldReadServer(string2, string3, string4)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleServerChange", "ignore change");
            }
            return;
        }
        ODCNode oDCNode2 = this.targetTree.getRoot().getNode(this.odc.cell, string2);
        ODCNode oDCNode3 = oDCNode2 != null ? oDCNode2.getNode(this.odc.node, string3) : null;
        ODCNode oDCNode4 = oDCNode = oDCNode3 != null ? oDCNode3.getNode(this.odc.server, string4) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell=" + oDCNode2 + ", node=" + oDCNode3 + ", server=" + oDCNode);
        }
        switch (configChangeNotifier.getChangeType()) {
            case 0: 
            case 2: {
                if (oDCNode2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server change: Cell does not exist for the server: " + string + ". Loading cell, node and server");
                    }
                    this.readCell(this.targetTree.getRoot(), string2);
                    break;
                }
                if (oDCNode3 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server change: Node does not exist for the server: " + string + ". Loading node and server");
                    }
                    this.readNode(oDCNode2, string3, false);
                    break;
                }
                this.readServer(oDCNode2, oDCNode3, string4, false);
                break;
            }
            case 1: {
                if (oDCNode != null) {
                    oDCNode3.removeNode(oDCNode);
                }
                if (oDCNode2 == null || oDCNode3 == null || oDCNode == null) break;
                String string5 = oDCNode3.getName() + ":" + oDCNode.getName();
                ODCNode oDCNode5 = oDCNode2.getChild(this.odc.cluster, string5);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleServerChange: clusterEntry=" + oDCNode5 + " for clusterName=" + string5);
                }
                if (oDCNode5 == null) break;
                oDCNode2.removeNode(oDCNode5);
                break;
            }
            default: {
                throw new IllegalStateException("unknown change type: " + configChangeNotifier.getChangeType());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleServerChange");
        }
    }

    protected void handleServerIndexChange(ConfigChangeNotifier configChangeNotifier) throws Exception {
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleServerIndexChange", configChangeNotifier);
        }
        String string = configChangeNotifier.getUri();
        String[] stringArray = string.split("/");
        String string2 = null;
        String string3 = null;
        if (stringArray.length > 4 && stringArray[0].equalsIgnoreCase("cells") && stringArray[2].equalsIgnoreCase("nodes")) {
            string2 = stringArray[1];
            string3 = stringArray[3];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handling cell=" + string2 + " node=" + string3);
        }
        if (string2 == null || string3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "null cell=" + string2 + " node=" + string3);
            }
            return;
        }
        if (!this.shouldReadNode(string2, string3)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Not reading cell=" + string2 + " node=" + string3);
            }
            return;
        }
        ODCNode oDCNode2 = this.targetTree.getRoot();
        ODCNode oDCNode3 = oDCNode2 != null ? oDCNode2.getNode(this.odc.cell, string2) : null;
        ODCNode oDCNode4 = oDCNode = oDCNode3 != null ? oDCNode3.getNode(this.odc.node, string3) : null;
        if (oDCNode != null && configChangeNotifier.getChangeType() == 2) {
            Repository repository2 = this.getRepository(oDCNode3.getName(), oDCNode.getName(), this.myServerName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Repository=" + repository2);
            }
            ServerIndex serverIndex = (ServerIndex)repository2.getConfigRoot().getResource(3, "serverindex.xml").getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerIndex=" + serverIndex);
            }
            for (ServerEntry serverEntry : serverIndex.getServerEntries()) {
                ODCNode oDCNode5;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server entry for " + serverEntry);
                }
                if ((oDCNode5 = oDCNode.getChild(this.odc.server, serverEntry.getServerName())) != null) {
                    String string4 = serverIndex.getHostName() != null ? serverIndex.getHostName() : oDCNode.getName();
                    this.updateTransports(serverEntry, oDCNode5, string4);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Serverentry=" + serverEntry + " being added to config");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not processing " + configChangeNotifier);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleServerIndexChange");
        }
    }

    protected void handleClusterChange(ConfigChangeNotifier configChangeNotifier) throws Exception {
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleClusterChange", configChangeNotifier);
        }
        String string = configChangeNotifier.getUri();
        String[] stringArray = string.split("/");
        String string2 = null;
        String string3 = null;
        if (stringArray.length > 3 && stringArray[0].equalsIgnoreCase("cells") && stringArray[2].equalsIgnoreCase("clusters")) {
            string2 = stringArray[1];
            string3 = stringArray[3];
        }
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleClusterChange: cellName is ", string2);
            }
            return;
        }
        if (string3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleClusterChange: clusterName is ", string3);
            }
            return;
        }
        ODCNode oDCNode2 = this.targetTree.getRoot().getNode(this.odc.cell, string2);
        ODCNode oDCNode3 = oDCNode = oDCNode2 != null ? oDCNode2.getNode(this.odc.cluster, string3) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell=" + oDCNode2 + ", cluster=" + oDCNode);
        }
        ODCNode oDCNode4 = null;
        if (configChangeNotifier.getChangeType() != 1) {
            ServerCluster serverCluster = (ServerCluster)this.loadRootObject(string);
            if (serverCluster == null) {
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "Fail to add/change cluster: " + string + " is not found");
                }
                return;
            }
            String string4 = serverCluster.getNodeGroupName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Obtained nodeGroupName of cluster = " + string4);
            }
            if (string4 != null && (oDCNode4 = oDCNode2.getNode(this.odc.nodeGroup, string4)) == null) {
                oDCNode4 = this.targetTree.createNode(string4, this.odc.nodeGroup, oDCNode2);
                this.readNodeGroup(oDCNode2, oDCNode4.getPath(), string4);
            }
        }
        if (oDCNode4 != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Obtained nodeGroup ODCNode. name=." + oDCNode4.getName() + " path=" + oDCNode4.getPath());
        }
        switch (configChangeNotifier.getChangeType()) {
            case 0: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "add cluster: " + string2 + "/" + string3);
                }
                if (oDCNode2 == null) {
                    this.readCell(this.targetTree.getRoot(), string2);
                    break;
                }
                oDCNode = this.readCluster(oDCNode2, string3);
                this.clusterAdded(oDCNode);
                if (oDCNode4 != null) {
                    oDCNode.addNode(oDCNode4);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster created. name=" + oDCNode.getName() + " path = " + oDCNode.getPath());
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "cluster children of type nodeGroup=" + oDCNode.childCount(this.odc.nodeGroup));
                break;
            }
            case 2: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mod cluster: " + string2 + "/" + string3);
                }
                if (oDCNode2 == null) {
                    this.readCell(this.targetTree.getRoot(), string2);
                    break;
                }
                if (oDCNode == null) {
                    oDCNode = this.readCluster(oDCNode2, string3);
                    this.clusterAdded(oDCNode);
                    if (oDCNode4 != null) {
                        oDCNode.addNode(oDCNode4);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cluster created. name=" + oDCNode.getName() + " path = " + oDCNode.getPath());
                    }
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "cluster children of type nodeGroup=" + oDCNode.childCount(this.odc.nodeGroup));
                    break;
                }
                this.readCluster(oDCNode);
                this.clusterModified(oDCNode);
                if (!oDCNode.getProperty(this.odc.clusterType).equals("static")) break;
                oDCNode.addNode(oDCNode4);
                break;
            }
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "del cluster: " + string2 + "/" + string3);
                }
                if (oDCNode == null) break;
                this.clusterRemoved(oDCNode);
                break;
            }
            default: {
                throw new IllegalStateException("unknown change type: " + configChangeNotifier.getChangeType());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleClusterChange");
        }
    }

    protected void clusterAdded(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clusterAdded", oDCNode);
        }
        if (this.inDMgr || this.inNodeAgent) {
            this.registerServerWeightListener(oDCNode.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clusterAdded", oDCNode);
        }
    }

    protected void clusterModified(ODCNode oDCNode) throws Exception {
    }

    protected void clusterRemoved(ODCNode oDCNode) throws Exception {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clusterRemoved:" + oDCNode);
        }
        ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.server);
        ODCNode[] oDCNodeArray2 = oDCNode.getNodes(this.odc.webModule);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, oDCNode + " has " + oDCNodeArray2.length + " webModules deployed on it");
        }
        ODCNode[] oDCNodeArray3 = oDCNode.getNodes(this.odc.ejbModule);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, oDCNode + " has " + oDCNodeArray3.length + " ejbModules deployed on it");
        }
        oDCNode.remove();
        for (n = 0; n < oDCNodeArray2.length; ++n) {
            this.getNullCluster().addNode(oDCNodeArray2[n]);
        }
        for (n = 0; n < oDCNodeArray3.length; ++n) {
            this.getNullCluster().addNode(oDCNodeArray3[n]);
        }
        for (ODCNode oDCNode2 : oDCNodeArray) {
            this.addStandaloneServerToFakeCluster(oDCNode2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clusterRemoved:" + oDCNode);
        }
    }

    public ODCEventType[] interestEventTypes() {
        return this.interestEvents;
    }

    public void handleEvent(ODCEvent oDCEvent) {
        ODCEventNodeChange oDCEventNodeChange;
        ODCEventType oDCEventType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleEvent", oDCEvent);
        }
        if ((oDCEventType = oDCEvent.getEventType()) == this.odc.cluster && (oDCEventNodeChange = (ODCEventNodeChange)oDCEvent).isAdd()) {
            try {
                ODCNode oDCNode = oDCEventNodeChange.getNode();
                this.clusterAdded(oDCNode);
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "OCSP_Exception", throwable);
                FFDCFilter.processException(throwable, this.getClass().getName(), "621", this);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleEvent");
        }
    }

    protected void handleNodeChange(ConfigChangeNotifier configChangeNotifier) throws Exception {
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNodeChange", configChangeNotifier);
        }
        String string = configChangeNotifier.getUri();
        String[] stringArray = string.split("/");
        String string2 = null;
        String string3 = null;
        if (stringArray.length > 3 && stringArray[0].equalsIgnoreCase("cells") && stringArray[2].equalsIgnoreCase("nodes")) {
            string2 = stringArray[1];
            string3 = stringArray[3];
        }
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNodeChange: cellName is ", string2);
            }
            return;
        }
        if (string3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNodeChange: nodeName is ", string3);
            }
            return;
        }
        if (!this.shouldReadNode(string2, string3)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNodeChange", "ignore change");
            }
            return;
        }
        ODCNode oDCNode2 = this.targetTree.getRoot().getNode(this.odc.cell, string2);
        ODCNode oDCNode3 = oDCNode = oDCNode2 != null ? oDCNode2.getNode(this.odc.node, string3) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell=" + oDCNode2 + ", node=" + oDCNode);
        }
        switch (configChangeNotifier.getChangeType()) {
            case 0: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "add node: " + string2 + "/" + string3);
                }
                if (oDCNode2 == null) {
                    this.readCell(this.targetTree.getRoot(), string2);
                    break;
                }
                this.readNode(oDCNode2, string3, false);
                break;
            }
            case 2: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mod cluster: " + string2 + "/" + string3);
                }
                if (oDCNode2 == null) {
                    this.readCell(this.targetTree.getRoot(), string2);
                    break;
                }
                if (oDCNode == null) {
                    this.readNode(oDCNode2, string3, false);
                    break;
                }
                Repository repository2 = this.getRepository(oDCNode2.getName(), string3, null);
                Node node = (Node)repository2.getConfigRoot().getResource(3, "node.xml").getContents().get(0);
                this.initNode(repository2, node, oDCNode);
                break;
            }
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "del cluster: " + string2 + "/" + string3);
                }
                if (oDCNode == null) break;
                oDCNode.remove();
                break;
            }
            default: {
                throw new IllegalStateException("unknown change type: " + configChangeNotifier.getChangeType());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleClusterChange");
        }
    }

    protected void handleAppNodeDeletion(ODCNode oDCNode) throws Exception {
        this.odcMyCell.removeNode(oDCNode);
    }

    protected void appOnServerChange(ODCNode oDCNode, ODCNode oDCNode2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appOnServerChange", new Object[]{oDCNode, oDCNode2, new Boolean(bl)});
        }
        try {
            ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.webModule);
            for (int i = 0; i < oDCNodeArray.length; ++i) {
                ODCNode oDCNode3 = oDCNodeArray[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "webmodule=" + oDCNode3);
                }
                ODCNode[] oDCNodeArray2 = oDCNode3.getNodes(this.odc.cluster);
                for (int j = 0; j < oDCNodeArray2.length; ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cluster=" + oDCNodeArray2[j]);
                    }
                    ODCNode[] oDCNodeArray3 = oDCNodeArray2[j].getNodes(this.odc.server);
                    for (int k = 0; k < oDCNodeArray3.length; ++k) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "server=" + oDCNodeArray3[k]);
                        }
                        if (oDCNode2 != oDCNodeArray3[k]) continue;
                        if (bl) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "linking " + oDCNode2 + " to " + oDCNode3);
                            }
                            oDCNode2.addNode(oDCNode3);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unlinking " + oDCNode2 + " from " + oDCNode3);
                        }
                        oDCNode2.removeNode(oDCNode3);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "appOnServerChange", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appOnServerChange");
        }
    }

    protected String getODRCloneId(ODCNode oDCNode) throws ODCException {
        String string = oDCNode.getLongName();
        Integer n = null;
        ODCNode[] oDCNodeArray = oDCNode.getChildren(this.odc.transport);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            String string2;
            boolean bl = oDCNodeArray[i].getBooleanProperty(this.odc.transportODR);
            if (!bl || !"http".equalsIgnoreCase(string2 = (String)oDCNodeArray[i].getProperty(this.odc.transportProtocol))) continue;
            string = (String)oDCNodeArray[i].getProperty(this.odc.transportHost);
            n = (Integer)oDCNodeArray[i].getProperty(this.odc.transportPort);
            break;
        }
        return Integer.toHexString((string + "-" + n).hashCode());
    }

    protected void setServerPropsByCluster(ODCNode oDCNode, ClusterMember clusterMember) throws ODCException {
        Object object;
        String string = "";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setServerPropsByCluster: server=" + oDCNode + ", member=" + clusterMember + ", uniqueId=" + clusterMember.getUniqueId());
        }
        if (clusterMember.getUniqueId() != null) {
            try {
                if (this.encodeString == null) {
                    object = FactoryHelper.loadClass(this.encodeFactoryClass, this.encodeDefaultFactoryClass);
                    this.encodeString = ((Class)object).getMethod("encodeString", String.class);
                }
                string = (String)this.encodeString.invoke(null, clusterMember.getUniqueId());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cloneId from encodeString: " + string);
                }
            }
            catch (Exception exception) {
                throw new ODCException(exception);
            }
        }
        if (Util.isProxy((String)(object = (String)oDCNode.getProperty(this.odc.serverType)))) {
            string = this.getODRCloneId(oDCNode);
        }
        oDCNode.setProperty(this.odc.serverCloneId, (Object)string);
        Integer n = new Integer(clusterMember.getWeight());
        this.setServerUpWeight(oDCNode, n);
        oDCNode.setProperty(this.odc.serverStaticWeight, (Object)n);
        if (oDCNode.getProperty(this.odc.serverState).equals("STARTED")) {
            oDCNode.setProperty(this.odc.serverWeight, (Object)this.getServerUpWeight(oDCNode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getServerUpWeight(ODCNode oDCNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerUpWeight", oDCNode);
        }
        Integer n = null;
        HashMap hashMap = this.serverUpWeights;
        synchronized (hashMap) {
            n = (Integer)this.serverUpWeights.get(oDCNode.getPath());
            if (n == null) {
                n = DEFAULT_UP_WEIGHT;
                this.serverUpWeights.put(oDCNode.getPath(), n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerUpWeight", n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setServerUpWeight(ODCNode oDCNode, Integer n) throws ODCException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setServerUpWeight: server=" + oDCNode + ",weight=" + n);
        }
        HashMap hashMap = this.serverUpWeights;
        synchronized (hashMap) {
            this.serverUpWeights.put(oDCNode.getPath(), n);
        }
    }

    public void addCustomProperties(EList eList, ODCNode oDCNode) throws Exception {
        Object object;
        Object object2;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCustomProperties", oDCNode);
        }
        ODCNodeType oDCNodeType = oDCNode.getType();
        ODCPropertyDescriptor[] oDCPropertyDescriptorArray = oDCNode.getPropertyDescriptors();
        HashSet<String> hashSet = new HashSet<String>();
        if (oDCPropertyDescriptorArray != null) {
            int n = oDCPropertyDescriptorArray.length;
            for (int i = 0; i < n; ++i) {
                string2 = oDCPropertyDescriptorArray[i].getName();
                if (!string2.startsWith("cp.") && !oDCPropertyDescriptorArray[i].isCustom()) continue;
                hashSet.add(string2);
            }
        }
        for (Property property : eList) {
            try {
                string2 = property.getName();
                object2 = property.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "custom property: name=" + string2 + ", value=" + (String)object2);
                }
                if ((object = oDCNodeType.getPropertyDescriptor(string2)) == null) {
                    string2 = "cp." + string2;
                }
                if ((object == null || !object.isCustom()) && !string2.startsWith("cp.")) continue;
                if (string2.equalsIgnoreCase("server.maintenancemode")) {
                    ODCPropertyValueWrapper oDCPropertyValueWrapper = new ODCPropertyValueWrapper(object2, 1);
                    oDCNode.setProperty(string2, (Object)oDCPropertyValueWrapper);
                } else {
                    oDCNode.setProperty(string2, object2);
                }
                hashSet.remove(string2);
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "addCustomProperty", tc);
            }
        }
        for (String string2 : hashSet) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "custom property: name=" + string2 + " is removed");
            }
            try {
                object2 = oDCNodeType.getPropertyDescriptor(string2);
                if (object2 == null || !object2.isCustom() && !string2.startsWith("cp.")) continue;
                object = object2.getDefaultValue();
                if (object instanceof ODCPropertyValueWrapper) {
                    object = ((ODCPropertyValueWrapper)object).getPropVal();
                }
                oDCNode.setProperty((ODCPropertyDescriptor)object2, object);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "custom property: name=" + string2 + " is removed");
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "addCustomProperty", tc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCustomProperties", oDCNode);
        }
    }

    public static String getCustomValue(EList eList, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomValue", string);
        }
        for (Property property : eList) {
            String string2 = property.getName();
            if (!string2.equals(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCustomValue", property.getValue());
            }
            return property.getValue();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomValue", "null");
        }
        return null;
    }

    protected String getEARPath(ODCNode oDCNode, String string) throws Exception {
        ConfigRoot configRoot;
        String string2;
        String string3;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEARPath", string);
            }
            string3 = null;
            string2 = string + ".ear";
            Repository repository2 = this.getRepository(oDCNode.getName(), null, null);
            configRoot = repository2.getConfigRoot();
            configRoot.setValue(1, string2);
            String string4 = "deployments" + SEP + string;
            String string5 = string4 + SEP + "deployment.xml";
            try {
                Deployment deployment = (Deployment)configRoot.getResource(1, string5).getContents().get(0);
                ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                string3 = applicationDeployment.isUseMetadataFromBinaries() ? configRoot.getAbsolutePath(1, "") + SEP + string + ".ear" : configRoot.getAbsolutePath(1, "") + SEP + string4;
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "failed to read app through deployments", throwable);
            }
        }
        if (string3 == null) {
            string3 = configRoot.getAbsolutePath(1, "") + SEP + string2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEARPath", string3);
        }
        return string3;
    }

    protected EARFile getEAR(String string) throws Exception {
        return this.getEAR(string, false);
    }

    protected EARFile getEAR(String string, boolean bl) throws Exception {
        return this.getEAR(string, bl, null);
    }

    protected EARFile getEAR(String string, boolean bl, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEAR", new Object[]{string, bl, string2});
        }
        CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
        ArchiveOptions archiveOptions = new ArchiveOptions();
        archiveOptions.setIsReadOnly(true);
        archiveOptions.setUseJavaReflection(bl);
        if (string2 != null) {
            archiveOptions.setAltBinariesPath(this.expandVariable(string2));
        }
        EARFile eARFile = commonarchiveFactory.openEARFile(archiveOptions, string);
        eARFile.getDeploymentDescriptor();
        eARFile.getBindings();
        eARFile.getExtensions();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEAR", eARFile);
        }
        return eARFile;
    }

    protected Set getNodes(ODCNode oDCNode, ODCNodeType oDCNodeType) throws ODCException {
        HashSet<ODCNode> hashSet = new HashSet<ODCNode>();
        ODCNode[] oDCNodeArray = oDCNode.getNodes(oDCNodeType);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            hashSet.add(oDCNodeArray[i]);
        }
        return hashSet;
    }

    protected List getNames(ODCNode oDCNode, ODCNodeType oDCNodeType) throws ODCException {
        LinkedList<String> linkedList = new LinkedList<String>();
        ODCNode[] oDCNodeArray = oDCNode.getNodes(oDCNodeType);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            linkedList.add(oDCNodeArray[i].getName());
        }
        return linkedList;
    }

    public void chainInitialized(ChainData chainData) {
    }

    public void chainStarted(ChainData chainData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chainStarted", new Object[]{chainData});
        }
        try {
            ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)WsServiceRegistry.getService((Object)this, ChannelFrameworkService.class);
            if (channelFrameworkService != null) {
                CFEndPoint cFEndPoint = channelFrameworkService.getEndPoint(chainData.getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CFEndPoint=", cFEndPoint);
                }
                if (cFEndPoint != null) {
                    this.addChannelChain(this.odcMyServer, cFEndPoint);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cound not find ChannelFrameworkService");
            }
        }
        catch (ChainNotInboundException chainNotInboundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "chain not inbound: " + (Object)((Object)chainNotInboundException));
            }
        }
        catch (NoCFEndPointException noCFEndPointException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no CF endpoint: " + (Object)((Object)noCFEndPointException));
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "chainStarted", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainStarted ");
        }
    }

    public void chainStopped(ChainData chainData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chainStopped", new Object[]{chainData});
        }
        try {
            ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)WsServiceRegistry.getService((Object)this, ChannelFrameworkService.class);
            if (channelFrameworkService != null) {
                CFEndPoint cFEndPoint = channelFrameworkService.getEndPoint(chainData.getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CFEndPoint=", cFEndPoint);
                }
                if (cFEndPoint != null) {
                    this.removeChannelChain(this.odcMyServer, cFEndPoint);
                }
            }
        }
        catch (ChainNotInboundException chainNotInboundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "chain not inbound: " + (Object)((Object)chainNotInboundException));
            }
        }
        catch (NoCFEndPointException noCFEndPointException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no CF endpoint: " + (Object)((Object)noCFEndPointException));
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "chainStopped", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainStopped ");
        }
    }

    public void chainUpdated(ChainData chainData) {
    }

    public void chainDestroyed(ChainData chainData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChannelChain(ODCNode oDCNode, CFEndPoint cFEndPoint) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChannelChain", new Object[]{oDCNode, cFEndPoint});
        }
        if (cFEndPoint.isLocal()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addChannelChain", "chain is local");
            }
            return;
        }
        if (this.chainExcludes.contains(cFEndPoint.getName())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addChannelChain", "chain excluded");
            }
            return;
        }
        if (this.vhostExcludes.contains(cFEndPoint.getVhost())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addChannelChain", "vhost excluded");
            }
            return;
        }
        String string = CfUtil.getTransportName(cFEndPoint);
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.addChannelChain");
            try {
                ODCNode oDCNode2 = this.targetTree.createNode(string, this.odc.transport, oDCNode, cFEndPoint.isLocal());
                oDCNode2.setProperty(this.odc.transportProtocol, (Object)(cFEndPoint.isSSLEnabled() ? "https" : "http"));
                oDCNode2.setProperty(this.odc.transportHost, (Object)cFEndPoint.getAddress().getHostName());
                oDCNode2.setIntProperty(this.odc.transportPort, cFEndPoint.getPort());
                oDCNode2.setBooleanProperty(this.odc.transportIsActive, true);
                ODCNode oDCNode3 = this.targetTree.createNode(cFEndPoint.getName(), this.odc.channelChain, oDCNode2, cFEndPoint.isLocal());
                oDCNode3.setProperty(this.odc.channelChainCFEndpoint, (Object)cFEndPoint);
                this.targetTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "addChannelChain", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChannelChain");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChannelChain(ODCNode oDCNode, CFEndPoint cFEndPoint) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeChannelChain", new Object[]{oDCNode, cFEndPoint});
        }
        String string = CfUtil.getTransportName(cFEndPoint);
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.removeChannelChain");
            try {
                ODCNode oDCNode2 = oDCNode.getNode(this.odc.transport, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "transport=" + oDCNode2);
                }
                if (oDCNode2 != null) {
                    ODCNode oDCNode3 = oDCNode2.getNode(this.odc.channelChain, cFEndPoint.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "chain=" + oDCNode3);
                    }
                    if (oDCNode3 != null) {
                        oDCNode3.remove();
                    }
                    if (oDCNode2.getBooleanProperty(this.odc.transportIsConfig)) {
                        oDCNode2.setBooleanProperty(this.odc.transportIsActive, false);
                    } else {
                        oDCNode2.remove();
                    }
                }
                this.targetTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "removeChannelChain", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeChannelChain");
        }
    }

    protected boolean serverAppStateChange(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverAppStateChange", new Object[]{string, string2});
        }
        if (!string2.equals("STARTING") && !string2.equals("STARTED") && ApplicationQuiescer.isQuiesceState(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serverAppStateChange", "no change");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serverAppStateChange", "change");
        }
        return true;
    }

    protected void setWebModuleProtocolMap(ODCNode oDCNode, String string) throws Exception {
        oDCNode.setProperty(this.odc.webModuleProtocolMap, this.getProtocolMap(string));
    }

    public Object getProtocolMap(String string) {
        if (string == null || string.equalsIgnoreCase("ClientProtocol")) {
            return this.sslDirect;
        }
        if (string.equalsIgnoreCase("HTTP")) {
            return this.sslOffLoad;
        }
        if (string.equalsIgnoreCase("HTTPS")) {
            return this.sslOnLoad;
        }
        return this.sslDirect;
    }

    protected void initSet(String string, Set set) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            set.add(stringArray[i]);
        }
    }

    protected static String normalizeContextRoot(String string) {
        if (string == null) {
            return "/";
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected String getAppNameOfActiveEdition(String string, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getAppNameOfActiveEdition", new Object[]{string, string2, string3});
        }
        final String string4 = string;
        final String string5 = string2;
        final String string6 = string3;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        String string7 = (String)contextManager.runAsSystem(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return TreeBuilder.this.getAppNameOfActiveEditionWithSecurity(string4, string5, string6);
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getAppNameOfActiveEdition: " + string7);
        }
        return string7;
    }

    protected String getAppNameOfActiveEditionWithSecurity(String string, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getAppNameOfActiveEditionWithSecurity", new Object[]{string, string2, string3});
        }
        List list = this.getDeployedApplicationEditions(string, string2, string3);
        String string4 = EditionHelper.getActiveEditionOnServer(string3, list);
        String string5 = EditionHelper.getCompositeName(string3, string4);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getAppNameOfActiveEditionWithSecurity: " + string5);
        }
        return string5;
    }

    protected List getDeployedApplicationEditions(String string, String string2, String string3) throws Exception {
        Object object3;
        Repository repository2 = this.getRepository(this.odcMyCell.getName(), string, string2);
        ServerIndex serverIndex = (ServerIndex)repository2.getConfigRoot().getResource(3, "serverindex.xml").getContents().get(0);
        String string4 = serverIndex.getHostName();
        if (string4 == null) {
            string4 = string;
        }
        Object object2 = null;
        for (Object object3 : serverIndex.getServerEntries()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server entry for " + object3.getServerName());
            }
            if (!object3.getServerName().equals(string2)) continue;
            object2 = object3;
            break;
        }
        object3 = new ArrayList();
        if (object2 != null) {
            object3 = object2.getDeployedApplications();
        }
        return object3;
    }

    protected ServerEntry getServerEntry(String string) throws Exception {
        Resource resource;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerEntry", string);
        }
        Repository repository2 = this.getRepository(this.myCellName, this.myNodeName, this.myServerName);
        try {
            resource = repository2.getConfigRoot().getResource(3, string);
        }
        catch (Exception exception) {
            if (string.equals("systemapps.xml")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No systemapps.xml on node " + this.myNodeName);
                }
                return null;
            }
            throw new ConfigurationWarning("Error loading " + string, exception);
        }
        EList eList = ((ServerIndex)resource.getContents().get(0)).getServerEntries();
        ServerEntry serverEntry = null;
        for (int i = 0; i < eList.size() && serverEntry == null; ++i) {
            ServerEntry serverEntry2 = (ServerEntry)eList.get(i);
            if (!serverEntry2.getServerName().equals(this.myServerName)) continue;
            serverEntry = serverEntry2;
            break;
        }
        if (serverEntry == null) {
            if (string.equals("systemapps.xml")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No server " + this.myServerName + " in " + string);
                }
                return null;
            }
            throw new ConfigurationWarning("Error loading server " + this.myServerName + " in " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerEntry", serverEntry);
        }
        return serverEntry;
    }

    protected boolean isSystemApp(String string) throws Exception {
        ServerEntry serverEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSystemApp", string);
        }
        if ((serverEntry = this.getServerEntry("systemapps.xml")) == null) {
            return false;
        }
        EList eList = serverEntry.getDeployedApplications();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)eList.get(i);
            if (!string.equals(string2 = this.getApplicationName(string2))) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSystemApp", "true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSystemApp", "false");
        }
        return false;
    }

    protected String getSystemAppDeploymentPath(Repository repository2, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemAppDeploymentPath", string);
        }
        ServerEntry serverEntry = this.getServerEntry("systemapps.xml");
        EList eList = serverEntry.getDeployedApplications();
        String string2 = null;
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)eList.get(i);
            String string4 = this.getApplicationName(string3);
            if (!string.equals(string4)) continue;
            string2 = this.expandVariable(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemAppDeploymentPath", string2);
        }
        return string2;
    }

    protected String expandVariable(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandVariable", string);
        }
        VariableMap variableMap = null;
        String string2 = string;
        try {
            variableMap = (VariableMap)WsServiceRegistry.getService((Object)this, VariableMap.class);
            if (variableMap != null) {
                string2 = variableMap.expand(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandVariable", string2);
        }
        return string2;
    }

    protected String getApplicationName(String string) {
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        return string2.substring(0, string2.lastIndexOf(".ear"));
    }

    protected boolean isApplicationsDirName(String string) {
        return string.equals("applications") || string.equals("systemApps");
    }

    protected void readNodeGroup(ODCNode oDCNode, String string, String string2) throws Exception {
    }

    protected void readCellXml(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readCellXml", oDCNode);
        }
        Repository repository2 = this.getRepository(oDCNode.getName(), null, null);
        Cell cell = (Cell)repository2.getConfigRoot().getResource(0, "cell.xml").getContents().get(0);
        this.initCell(cell, oDCNode);
        oDCNode.setBooleanProperty(this.odc.cellIsWebSphere, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readCellXml", oDCNode);
        }
    }

    protected boolean shouldReadNode(String string, String string2) throws Exception {
        if (!string.equals(this.myCellName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "don't read node: not my cell");
            }
            return false;
        }
        if (this.ownsConfig) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read node: config owner");
            }
            return true;
        }
        if (!string2.equals(this.myNodeName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "don't read node: not my node");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read node: my node");
        }
        return true;
    }

    protected boolean shouldReadServer(String string, String string2, String string3) throws Exception {
        if (!string.equals(this.myCellName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "don't read server: not my cell");
            }
            return false;
        }
        if (this.ownsConfig) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read server: config owner");
            }
            return true;
        }
        if (!string2.equals(this.myNodeName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "don't read server: not my node");
            }
            return false;
        }
        if (!string3.equals(this.myServerName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "don't read server: not my server");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read server: my server");
        }
        return true;
    }

    protected boolean isMyCell(String string) throws Exception {
        if (!string.equals(this.myCellName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "not my cell");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "is my cell");
        }
        return true;
    }

    protected boolean isMyNode(String string, String string2) throws Exception {
        if (!this.isMyCell(string)) {
            return false;
        }
        if (!string2.equals(this.myNodeName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "not my node");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "is my node");
        }
        return true;
    }

    protected boolean isMyServer(String string, String string2, String string3) throws Exception {
        if (!this.isMyNode(string, string2)) {
            return false;
        }
        if (!string3.equals(this.myServerName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "not my server");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "is my server");
        }
        return true;
    }

    protected Object loadRootObject(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadRootObject", string);
        }
        Object object = null;
        try {
            DocumentContentSource documentContentSource = ConfigRepositoryFactory.getConfigRepository().extract(string);
            if (documentContentSource != null) {
                WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
                URI uRI = URI.createFileURI((String)documentContentSource.getDocument().getURI());
                Resource resource = wASResourceSetImpl.createResource(uRI);
                resource.load(documentContentSource.getSource(), new HashMap());
                object = resource.getContents().get(0);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TreeBuilder::loadRootObject:: Exception caught loading URI " + string + ". Exception " + exception.getClass().getName() + " " + exception.getMessage());
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.odc.TreeBuilder", "598", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadRootObject", object);
        }
        return object;
    }

    protected Resource getResource(ConfigRoot configRoot, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource");
        }
        Resource resource = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.ws.runtime.service.ConfigRootImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.debug(tc, classNotFoundException.toString(), classNotFoundException);
        }
        Class[] classArray = new Class[]{String.class};
        Object[] objectArray = new Object[]{string};
        try {
            Method method2 = clazz.getMethod("getResourceAbsolute", classArray);
            resource = (Resource)method2.invoke((Object)configRoot, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.debug(tc, noSuchMethodException.toString(), noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.debug(tc, illegalAccessException.toString(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Tr.debug(tc, invocationTargetException.toString(), invocationTargetException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource");
        }
        return resource;
    }

    protected ServerIndex getServerIndex(String string) throws Exception {
        ServerIndex serverIndex = null;
        boolean bl = false;
        if (this.serverIndexCache != null) {
            serverIndex = (ServerIndex)this.serverIndexCache.get(string);
            boolean bl2 = bl = serverIndex == null;
        }
        if (serverIndex == null) {
            Repository repository2 = this.getRepository(this.myCellName, string, null);
            serverIndex = (ServerIndex)repository2.getConfigRoot().getResource(3, "serverindex.xml").getContents().get(0);
        }
        if (bl && serverIndex != null) {
            this.serverIndexCache.put(string, serverIndex);
        }
        return serverIndex;
    }

    public static synchronized ODCPropertyDescriptor setODCCustomProperty(ODCNode oDCNode, String string, String string2) throws ODCException {
        if (oDCNode != null) {
            return oDCNode.setProperty(string, (Object)string2);
        }
        return null;
    }

    protected synchronized ODCNode getNullCluster() throws ODCException {
        if (this._nullClusterNode == null) {
            this._nullClusterNode = this.targetTree.createNode(NULL_CLUSTER, this.odc.cluster, this.odcMyCell);
            this._nullClusterNode.setProperty(this.odc.clusterType, (Object)"generic");
        }
        return this._nullClusterNode;
    }

    protected ODCNode addServerToCluster(ODCNode oDCNode) throws Exception {
        String string;
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServerToCluster - " + oDCNode);
        }
        ODCNode oDCNode2 = null;
        String string2 = oDCNode.getName();
        String string3 = oDCNode.getParent().getName();
        ODCNode oDCNode3 = oDCNode.getParent().getParent();
        String string4 = this.getDir(oDCNode3.getName(), null, null);
        Repository repository2 = this.getRepository(oDCNode3.getName(), null, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reading clusters directory");
        }
        if ((file = new File(string = this.joinDir(string4, "clusters"))).exists()) {
            File[] fileArray = file.listFiles(this.directoryFilter);
            if (fileArray == null) {
                throw new IOException("unable to read clusters directory: " + string);
            }
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    String string5 = fileArray[i].getName();
                    String string6 = "clusters" + SEP + string5 + SEP + "cluster.xml";
                    for (ServerCluster serverCluster : repository2.getConfigRoot().getResource(0, string6).getContents()) {
                        for (ClusterMember clusterMember : serverCluster.getMembers()) {
                            if (!clusterMember.getNodeName().equals(string3) || !clusterMember.getMemberName().equals(string2)) continue;
                            oDCNode2 = oDCNode3.getChild(this.odc.cluster, serverCluster.getName());
                            if (oDCNode2 == null) {
                                oDCNode2 = this.readCluster(oDCNode3, serverCluster.getName());
                            }
                            oDCNode2.addNode(oDCNode);
                            this.setServerPropsByCluster(oDCNode, clusterMember);
                        }
                    }
                    if (oDCNode2 != null) continue;
                    oDCNode2 = this.addStandaloneServerToFakeCluster(oDCNode);
                    continue;
                }
                catch (Throwable throwable) {
                    TrUtil.error(throwable, this, "addServerToCluster", tc);
                }
            }
        } else {
            oDCNode2 = this.addStandaloneServerToFakeCluster(oDCNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServerToCluster", "added to cluster " + oDCNode2.getPath());
        }
        return oDCNode2;
    }

    protected ODCNode addStandaloneServerToFakeCluster(ODCNode oDCNode) throws Exception {
        ODCNode oDCNode2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addStandaloneServerToFakeCluster - " + oDCNode);
        }
        if ((oDCNode2 = oDCNode.getNode(this.odc.cluster)) == null) {
            String string = oDCNode.getParent().getName() + ":" + oDCNode.getName();
            oDCNode2 = this.targetTree.createNode(string, this.odc.cluster, oDCNode.getParent().getParent());
            oDCNode2.setProperty(this.odc.clusterType, (Object)"single-server");
            oDCNode2.setBooleanProperty(this.odc.clusterIsReal, false);
            oDCNode2.addNode(oDCNode);
            String string2 = null;
            string2 = Util.isProxy((String)oDCNode.getProperty(this.odc.serverType)) ? this.getODRCloneId(oDCNode) : Integer.toHexString(oDCNode.getPath().hashCode());
            oDCNode.setProperty(this.odc.serverCloneId, (Object)string2);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, oDCNode + " already member of " + oDCNode2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addStandaloneServerToFakeCluster - " + oDCNode2);
        }
        return oDCNode2;
    }

    public void notify(Identity identity, String string, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notify", new Object[]{identity, string, object});
        }
        try {
            if (string.equals(TYPE_CLUSTER_WEIGHT_UPDATE) && object instanceof Identity) {
                Identity identity2 = (Identity)object;
                ClusterManagement clusterManagement = ClusterManagementFactory.getClusterManagement();
                int n = clusterManagement.getDesiredWeight(identity, identity2);
                String string2 = (String)identity2.getProperties().get("NODENAME");
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "nodeName=" + string2);
                }
                if (string2 != null && string2.equals(this.odcMyNode.getName())) {
                    ODCNode oDCNode;
                    String string3 = (String)identity2.getProperties().get("MEMBERNAME");
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "serverName=" + string3);
                    }
                    if ((oDCNode = this.odcMyNode.getNode(this.odc.server, string3)) != null) {
                        ODCPropertyValueWrapper oDCPropertyValueWrapper = new ODCPropertyValueWrapper(n, 1);
                        oDCNode.setProperty(this.odc.serverWeight, (Object)oDCPropertyValueWrapper);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "notify", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notify");
        }
    }

    protected void addClustersListener() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addClustersListener");
        }
        ODCNode[] oDCNodeArray = this.odcMyCell.getNodes(this.odc.cluster);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            this.registerServerWeightListener(oDCNodeArray[i].getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addClustersListener");
        }
    }

    protected void registerServerWeightListener(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServerWeightListener", string);
        }
        Identity identity = TreeBuilder.getClusterIdentityFromClusterName(this.myCellName, string);
        timer.schedule((TimerTask)new RegisterClusterWeightListenerTask(identity, this), 0L);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServerWeightListener", string);
        }
    }

    public static Identity getClusterIdentityFromClusterName(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CELLNAME", string);
        hashMap.put("CLUSTERNAME", string2);
        Identity identity = ClusterServiceFactory.getClusterService().getIdentity(hashMap);
        return identity;
    }

    public void refresh() throws Exception {
        this.startODCGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMyServerState(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMyServerState", string);
        }
        if (string.equals(this.myServerState)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setMyServerState", "no change");
            }
            return;
        }
        String string2 = this.myServerState;
        this.myServerState = string;
        if (this.odcMyServer == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setMyServerState", "my server is null");
            }
            return;
        }
        boolean bl = false;
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            try {
                this.targetTree.beginTransaction("TreeBuilder.setMyServerState");
                this.odcMyServer.setProperty(this.odc.serverState, (Object)string);
                if (string2.equals("STARTED")) {
                    Integer n = (Integer)this.odcMyServer.getProperty(this.odc.serverWeight);
                    if (n != 0) {
                        this.setServerUpWeight(this.odcMyServer, n);
                    }
                    this.odcMyServer.setProperty(this.odc.serverWeight, (Object)DOWN_WEIGHT);
                } else if (string.equals("STARTED")) {
                    this.odcMyServer.setProperty(this.odc.serverWeight, (Object)this.getServerUpWeight(this.odcMyServer));
                    this.odcMyServer.setProperty(this.odc.serverReachable, (Object)new ODCPropertyValueWrapper(true, 0));
                    bl = true;
                }
                this.targetTree.commitTransaction();
                if (bl) {
                    this.startODCGroup();
                }
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "setMyServerState", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMyServerState");
        }
    }

    public LocalEventListener getLocalEventListener() {
        return this.localEventListener;
    }

    public ODCNode getOdcMyCell() {
        return this.odcMyCell;
    }

    public ODCNode getOdcMyNode() {
        return this.odcMyNode;
    }

    public ODCNode getOdcMyServer() {
        return this.odcMyServer;
    }

    static {
        WAIT_FOR_INIT_TIMEOUT = Integer.parseInt(System.getProperty("WaitForInitTimeout", "10000"));
        JAVAX_WSDL_VERBOSE = Boolean.getBoolean("javax.wsdl.verbose");
        timer = new Timer(true);
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        isZos = platformHelper.isZOS();
        isZosServantOrCRA = platformHelper.isZOS() && (platformHelper.isServantJvm() || platformHelper.isCRAJvm());
        TreeBuilder.platformHelper = PlatformHelperFactory.getPlatformHelper();
    }

    protected class RegisterClusterWeightListenerTask
    extends TimerTask {
        private final Identity clusterID;
        private final TreeBuilder listener;

        public RegisterClusterWeightListenerTask(Identity identity, TreeBuilder treeBuilder2) {
            this.clusterID = identity;
            this.listener = treeBuilder2;
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerClusterWeightListenerTask");
            }
            ClusterServiceFactory.getClusterService().registerInterest(this.listener, this.clusterID, TreeBuilder.TYPE_CLUSTER_WEIGHT_UPDATE);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerClusterWeightListenerTask");
            }
        }
    }

    private class LocalEventListener
    implements DeployedObjectListener,
    PropertyChangeListener,
    ConfigChangeListener,
    ChainEventListener {
        private final ArrayList startupEventQueue = new ArrayList();
        private boolean processLocalEvents = true;

        public void addLocalListeners() throws Exception {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addLocalListeners");
            }
            if (!isZosServantOrCRA) {
                object = (Server)WsServiceRegistry.getService((Object)this, Server.class);
                if (object != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "add property change listener");
                    }
                    object.addPropertyChangeListener("state", this);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "could not addPropertyChangeListener");
                }
                if (TreeBuilder.this.ownsConfig) {
                    Admin admin2 = (Admin)WsServiceRegistry.getService((Object)this, Admin.class);
                    if (admin2 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "add config change listener");
                        }
                        admin2.addConfigChangeListener(this);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "could not addConfigChangeListener");
                    }
                }
            }
            if (!TreeBuilder.this.inNodeAgent && !isZosServantOrCRA) {
                object = (ChannelFrameworkService)WsServiceRegistry.getService((Object)this, ChannelFrameworkService.class);
                if (object != null) {
                    block29: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "add chain event listener");
                        }
                        try {
                            object.addGroupEventListener((ChainEventListener)this, "com.ibm.ws.runtime.WebContainerImpl");
                        }
                        catch (ChainGroupException chainGroupException) {
                            if (!tc.isDebugEnabled()) break block29;
                            Tr.debug(tc, "WebContainer chain not configured.");
                        }
                    }
                    if (Util.isProxy()) {
                        try {
                            object.addGroupEventListener((ChainEventListener)this, "com.ibm.ws.proxy.channel.http.WSHttpProxyInboundChannelFactory");
                        }
                        catch (ChainGroupException chainGroupException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Proxy http/https chain not configured.");
                            }
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "could not addGroupEventListener");
                }
            }
            if (TreeBuilder.this.inNodeAgent || platformHelper.isZOS() && platformHelper.isControlJvm()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not registering with ApplicationMgr");
                }
            } else {
                object = (ApplicationMgr)WsServiceRegistry.getService((Object)this, ApplicationMgr.class);
                if (object != null) {
                    object.addDeployedObjectListener(this);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ApplicationMgr not found");
                }
            }
            ODCUtil.manageTree(TreeBuilder.this.targetTree);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addLocalListeners");
            }
        }

        public void removeLocalListeners() throws Exception {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "removeLocalListeners");
            }
            if (!isZosServantOrCRA) {
                object = (Server)WsServiceRegistry.getService((Object)this, Server.class);
                if (object != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remove property change listener");
                    }
                    object.removePropertyChangeListener("state", this);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "could not removePropertyChangeListener");
                }
                Admin admin2 = (Admin)WsServiceRegistry.getService((Object)this, Admin.class);
                if (admin2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remove config change listener");
                    }
                    admin2.removeConfigChangeListener(this);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "could not removeConfigChangeListener");
                }
            }
            if (!TreeBuilder.this.inNodeAgent && !isZosServantOrCRA) {
                object = (ChannelFrameworkService)WsServiceRegistry.getService((Object)this, ChannelFrameworkService.class);
                if (object != null) {
                    block26: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "remove chain event listener");
                        }
                        try {
                            object.removeGroupEventListener((ChainEventListener)this, "com.ibm.ws.runtime.WebContainerImpl");
                        }
                        catch (ChainGroupException chainGroupException) {
                            if (!tc.isDebugEnabled()) break block26;
                            Tr.debug(tc, "WebContainer chain not configured.");
                        }
                    }
                    if (Util.isProxy()) {
                        try {
                            object.removeGroupEventListener((ChainEventListener)this, "com.ibm.ws.proxy.channel.http.WSHttpProxyInboundChannelFactory");
                        }
                        catch (ChainGroupException chainGroupException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Proxy http/https chain not configured.");
                            }
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "could not removeGroupEventListener");
                }
            }
            if (!(TreeBuilder.this.inNodeAgent || platformHelper.isZOS() && platformHelper.isControlJvm())) {
                object = (ApplicationMgr)WsServiceRegistry.getService((Object)this, ApplicationMgr.class);
                if (object != null) {
                    object.removeDeployedObjectListener(this);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ApplicationMgr not found");
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeLocalListeners");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
            String string = deployedObjectEvent.getPropertyName();
            if (!string.equals("state")) {
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stateChanged " + deployedObjectEvent);
            }
            ArrayList arrayList = this.startupEventQueue;
            synchronized (arrayList) {
                if (!this.processLocalEvents) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "not initialized; queueing " + deployedObjectEvent);
                    }
                    this.startupEventQueue.add(deployedObjectEvent);
                    return;
                }
            }
            TreeBuilder.this.stateChanged(deployedObjectEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "propertyChange - " + propertyChangeEvent);
            }
            ArrayList arrayList = this.startupEventQueue;
            synchronized (arrayList) {
                if (!this.processLocalEvents) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "not initialized; queueing " + propertyChangeEvent);
                    }
                    this.startupEventQueue.add(propertyChangeEvent);
                    return;
                }
            }
            TreeBuilder.this.propertyChange(propertyChangeEvent);
        }

        public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configChanged - " + configRepositoryEvent);
            }
            if (!this.processLocalEvents) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not initialized; ignoring " + configRepositoryEvent);
                }
                return;
            }
            TreeBuilder.this.configChanged(configRepositoryEvent);
        }

        public void chainInitialized(ChainData chainData) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void chainStarted(ChainData chainData) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "chainStarted - " + chainData);
            }
            ArrayList arrayList = this.startupEventQueue;
            synchronized (arrayList) {
                if (!this.processLocalEvents) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "not initialized; queueing " + chainData);
                    }
                    this.startupEventQueue.add(new ChainDataStarted(chainData));
                    return;
                }
            }
            TreeBuilder.this.chainStarted(chainData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void chainStopped(ChainData chainData) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "chainStopped - " + chainData);
            }
            ArrayList arrayList = this.startupEventQueue;
            synchronized (arrayList) {
                if (!this.processLocalEvents) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "not initialized; queueing " + chainData);
                    }
                    this.startupEventQueue.add(new ChainDataStopped(chainData));
                    return;
                }
            }
            TreeBuilder.this.chainStopped(chainData);
        }

        public void chainDestroyed(ChainData chainData) {
        }

        public void chainUpdated(ChainData chainData) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processQueuedEvents() throws Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processQueuedEvents");
            }
            ArrayList arrayList = this.startupEventQueue;
            synchronized (arrayList) {
                if (this.processLocalEvents) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "local events already being processed");
                    }
                    return;
                }
                this.processLocalEvents = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "replaying queued local events");
                }
                TreeBuilder.this.targetTree.beginTransaction("TreeBuilder.queuedEvents");
                try {
                    for (Object e2 : this.startupEventQueue) {
                        if (e2 instanceof DeployedObjectEvent) {
                            TreeBuilder.this.stateChanged((DeployedObjectEvent)e2);
                            continue;
                        }
                        if (e2 instanceof PropertyChangeEvent) {
                            TreeBuilder.this.propertyChange((PropertyChangeEvent)e2);
                            continue;
                        }
                        if (e2 instanceof ChainDataStarted) {
                            TreeBuilder.this.chainStarted(((ChainDataStarted)e2).getData());
                            continue;
                        }
                        if (!(e2 instanceof ChainDataStopped)) continue;
                        TreeBuilder.this.chainStarted(((ChainDataStopped)e2).getData());
                    }
                    TreeBuilder.this.targetTree.commitTransaction();
                }
                catch (Exception exception) {
                    TrUtil.error(exception, this, "processQueuedEvents", tc);
                    TreeBuilder.this.targetTree.rollbackTransaction();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processQueuedEvents");
            }
        }

        private class ChainDataStopped {
            ChainData data;

            public ChainDataStopped(ChainData chainData) {
                this.data = chainData;
            }

            public ChainData getData() {
                return this.data;
            }
        }

        private class ChainDataStarted {
            ChainData data;

            public ChainDataStarted(ChainData chainData) {
                this.data = chainData;
            }

            public ChainData getData() {
                return this.data;
            }
        }
    }

    protected class AppChange {
        public final String appName;
        public final int change;

        public AppChange(String string, int n) {
            this.appName = string;
            this.change = n;
        }

        public boolean equals(Object object) {
            AppChange appChange = (AppChange)object;
            return this.appName.equals(appChange.appName) && this.change == appChange.change;
        }

        public String toString() {
            switch (this.change) {
                case 0: {
                    return "app doc added for app " + this.appName;
                }
                case 2: {
                    return "app doc modified for app " + this.appName;
                }
                case 1: {
                    return "app doc deleted for app " + this.appName;
                }
            }
            return "unknown change to application " + this.appName;
        }
    }
}

