/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.cell;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.wsspi.odc.ODCHelper;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Iterator;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class TreeBuilderHelper {
    private static TraceComponent tc = TrUtil.register(TreeBuilderHelper.class);
    protected static final String SEP = File.separator;
    private static TreeBuilderHelper instance = null;
    public final ODCHelper odc;
    public final AdminService adminService;
    public final String myCellName;
    public final String myNodeName;
    public final String myServerName;
    public final String myProcessType;
    public final boolean inDMgr;
    public final boolean inNodeAgent;
    public final boolean inStandAlone;
    public final boolean ownsConfig;
    public final String installRoot;
    public final String configRoot;
    public final String applicationsDir;
    public final FileFilter directoryFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };

    public static synchronized TreeBuilderHelper getInstance() throws Exception {
        if (instance == null) {
            instance = new TreeBuilderHelper();
        }
        return instance;
    }

    public TreeBuilderHelper() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        this.adminService = AdminServiceFactory.getAdminService();
        this.myProcessType = this.adminService.getProcessType();
        this.myCellName = this.adminService.getCellName();
        this.myNodeName = this.adminService.getNodeName();
        this.myServerName = this.adminService.getProcessName();
        this.inDMgr = this.myProcessType.equals("DeploymentManager");
        this.inNodeAgent = this.myProcessType.equals("NodeAgent");
        this.inStandAlone = this.myProcessType.equals("UnManagedProcess");
        this.ownsConfig = this.inDMgr || this.inStandAlone;
        this.installRoot = this.initInstallRoot();
        this.configRoot = this.initConfigRoot();
        this.applicationsDir = "cells/" + this.myCellName + "/applications/";
        this.odc = ODCHelper.getInstance();
        instance = this;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public AdminService getAdminService() {
        return this.adminService;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    public Repository getRepository(String string, String string2, String string3) throws Exception {
        Class<?> clazz = Class.forName("com.ibm.ws.runtime.service.RepositoryImpl");
        Constructor<?> constructor = clazz.getConstructor(String.class, String.class, String.class, String.class, String.class);
        Field field = clazz.getField("DEFAULT_APPLICATION_TYPE");
        String string4 = (String)field.get(null);
        return (Repository)constructor.newInstance(string4, this.configRoot, string, string2, string3);
    }

    public String getDir(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDir", new Object[]{string, string2, string3});
        }
        StringBuffer stringBuffer = new StringBuffer(this.configRoot);
        if (string != null) {
            stringBuffer.append(SEP).append("cells").append(SEP).append(string);
            if (string2 != null) {
                stringBuffer.append(SEP).append("nodes").append(SEP).append(string2);
                if (string3 != null) {
                    stringBuffer.append(SEP).append("servers").append(SEP).append(string3);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDir", stringBuffer);
        }
        return stringBuffer.toString();
    }

    public ObjectName getMBeanName(String string, String string2) throws Exception {
        ObjectName objectName;
        Iterator iterator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanName", new Object[]{string, string2});
        }
        if (!(iterator = this.adminService.queryNames(objectName = new ObjectName(string), null).iterator()).hasNext()) {
            throw new Exception(string2 + " mbean not found: " + string);
        }
        ObjectName objectName2 = (ObjectName)iterator.next();
        if (iterator.hasNext()) {
            throw new Exception("multiple " + string2 + " mbeans found: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanName", objectName2);
        }
        return objectName2;
    }

    public NotificationFilterSupport getFilter(String string) {
        return this.getFilter(new String[]{string});
    }

    public NotificationFilterSupport getFilter(String string, String string2) {
        return this.getFilter(new String[]{string, string2});
    }

    public NotificationFilterSupport getFilter(String[] stringArray) {
        NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
        for (int i = 0; i < stringArray.length; ++i) {
            notificationFilterSupport.enableType(stringArray[i]);
        }
        return notificationFilterSupport;
    }

    public String joinDir(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        return stringBuffer.append(File.separator).append(string2).toString();
    }

    private String initInstallRoot() throws Exception {
        String string = System.getProperty("server.root");
        if (string == null && (string = System.getProperty("user.install.root")) == null) {
            throw new Exception("server.root not set");
        }
        return string;
    }

    private String initConfigRoot() throws Exception {
        String string = System.getProperty("was.repository.root");
        if (string == null) {
            throw new Exception("was.repository.root not set");
        }
        return string;
    }
}

