/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.mbean;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.odc.ODCManagerImpl;
import com.ibm.ws.odc.ODCNodeImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.XmlParser;
import com.ibm.ws.odc.cell.TargetTree;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCPropertyValueWrapper;
import com.ibm.wsspi.odc.ODCTree;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.management.ObjectName;

public class TargetTreeMbean {
    private static final TraceComponent tc = TrUtil.register(TargetTreeMbean.class);
    private static final String MBEAN = "TargetTreeMbean";
    private static final String DESCRIPTOR = "com/ibm/ws/odc/mbean/TargetTreeMbean.xml";
    private final String SUCCESS_MSG = "Operation Successful";
    protected static final String SEP = File.separator;
    public final AdminService adminService = AdminServiceFactory.getAdminService();
    public final String myCellName = this.adminService.getCellName();
    public final String myNodeName = this.adminService.getNodeName();
    public final String myServerName = this.adminService.getProcessName();
    private ODCHelper odc = null;

    public String getTargetTree() {
        try {
            ODCTree oDCTree = TargetTree.getTree();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            oDCTree.getRoot().print(printStream);
            printStream.close();
            return byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            TrUtil.warning(iOException, this, "getTargetTree", tc);
            return null;
        }
    }

    public void initialize() throws Exception {
        this.activateMBean(MBEAN, this, MBEAN, DESCRIPTOR);
    }

    private ObjectName activateMBean(String string, Object object, String string2, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activateMBean");
        }
        RuntimeCollaborator runtimeCollaborator = null;
        ObjectName objectName = null;
        try {
            if (!(object instanceof RuntimeCollaborator)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "using DefaultRuntimeCollaborator.");
                }
                runtimeCollaborator = new DefaultRuntimeCollaborator(object, string2);
            } else {
                runtimeCollaborator = (RuntimeCollaborator)object;
            }
            objectName = AdminServiceFactory.getMBeanFactory().activateMBean(string, runtimeCollaborator, string2, string3);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "activateMBean");
            }
            return objectName;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.odc.TargetTreeMbean.activateMBean", "85", this);
            throw new AdminException(exception, "MBean could not be registered.");
        }
    }

    public ODCTree cloneTargetTree() throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cloneTree");
        }
        try {
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            PrintStream printStream = new PrintStream(pipedOutputStream);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saving tree");
            }
            ODCTree oDCTree = TargetTree.getTree();
            ODCTreeSaveThread oDCTreeSaveThread = new ODCTreeSaveThread(printStream);
            oDCTreeSaveThread.start();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "done saving tree");
            }
            if (this.odc == null) {
                this.odc = ODCHelper.getInstance();
            }
            XmlParser xmlParser = new XmlParser(new ODCTreeImpl((ODCManagerImpl)this.odc.mgr, "target", this.odc.cellGroup), this.odc);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cloneTree(): start parsing");
            }
            ODCTree oDCTree2 = xmlParser.parse(pipedInputStream, false, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cloneTree(): end parsing");
            }
            pipedInputStream.close();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "cloneTree");
            }
            return oDCTree2;
        }
        catch (Exception exception) {
            TrUtil.warning(exception, this, "cloneTree", tc);
            throw new ODCException(exception);
        }
    }

    public void adjustTargetTree(ODCTree oDCTree) throws ODCException {
        for (ODCNodeImpl oDCNodeImpl : ((ODCTreeImpl)oDCTree).getAllNodes()) {
            ODCNodeType oDCNodeType = oDCNodeImpl.getType();
            String string = oDCNodeType.getName();
            if (!string.equals(this.odc.server.getName())) continue;
            ODCPropertyDescriptor oDCPropertyDescriptor = oDCNodeType.findPropertyDescriptor(this.odc.serverState.getName());
            oDCNodeImpl.setProperty(oDCPropertyDescriptor, (Object)"STARTED");
            this.adjustServerWeight(oDCNodeImpl);
            String string2 = (String)oDCNodeImpl.getProperty(this.odc.serverType);
            ODCNode[] oDCNodeArray = oDCNodeImpl.getNodes(this.odc.transport);
            for (int i = 0; i < oDCNodeArray.length; ++i) {
                oDCNodeArray[i].setBooleanProperty(this.odc.transportIsActive, true);
            }
            if (!Util.isRoutableServerType(string2)) continue;
            this.adjustApplicationServer(oDCTree, oDCNodeImpl);
        }
    }

    protected void adjustApplicationServer(ODCTree oDCTree, ODCNode oDCNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "adjustApplicationServer", oDCNode);
        }
        try {
            ODCNode oDCNode2 = oDCNode.getNode(this.odc.cluster);
            if (oDCNode2 != null) {
                ODCNode oDCNode3;
                ODCNode[] oDCNodeArray = oDCNode2.getNodes(this.odc.webModule);
                for (int i = 0; i < oDCNodeArray.length; ++i) {
                    oDCNode.addNode(oDCNodeArray[i]);
                    ODCNode oDCNode4 = oDCNodeArray[i].getParent();
                    oDCNode3 = oDCTree.createNode(oDCNode4.getName(), this.odc.serverApplication, oDCNode);
                    oDCNode3.setProperty(this.odc.serverApplicationState, (Object)"STARTED");
                }
                ODCNode[] oDCNodeArray2 = oDCNode2.getNodes(this.odc.ejbModule);
                for (int i = 0; i < oDCNodeArray2.length; ++i) {
                    oDCNode.addNode(oDCNodeArray2[i]);
                    oDCNode3 = oDCNodeArray2[i].getParent();
                    ODCNode oDCNode5 = oDCTree.createNode(oDCNode3.getName(), this.odc.serverApplication, oDCNode);
                    oDCNode5.setProperty(this.odc.serverApplicationState, (Object)"STARTED");
                }
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "adjustApplicationServer", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adjustApplicationServer");
        }
    }

    protected void adjustServerWeight(ODCNode oDCNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "adjustServerWeight", oDCNode);
        }
        try {
            int n = (Integer)oDCNode.getProperty(this.odc.serverStaticWeight);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server static value: ", n);
            }
            oDCNode.setProperty(this.odc.serverWeight, (Object)n);
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "adjustServerWeight", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adjustServerWeight");
        }
    }

    public String exportTargetTree() throws ODCException {
        int n;
        int n2;
        String string = System.getProperty("was.repository.root");
        if (string == null || string.length() < 1) {
            throw new ODCException("was.repository.root not set");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configRoot=" + string);
        }
        if (string.charAt((n2 = string.length()) - 1) == File.separatorChar) {
            string = string.substring(0, n2 - 1);
        }
        if ((n = string.lastIndexOf(File.separatorChar)) < 1) {
            throw new ODCException("Wrong Config Root Path" + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string2 + File.separator + "etc" + File.separator + this.myServerName + File.separator + "target.xml";
        return this.exportTargetTree(string3);
    }

    public String exportTargetTree(String string) throws ODCException {
        if (string == null || string.length() == 0) {
            TrUtil.warning(new Exception("Wrong path: " + string), this, "exportTargetTree", tc);
        }
        try {
            Object object;
            String string2;
            int n = string.lastIndexOf(File.separatorChar);
            String string3 = string2 = n > 0 ? string.substring(0, n) : null;
            if (string2 != null) {
                object = new File(string2);
                if (!((File)object).exists()) {
                    ((File)object).mkdir();
                }
                if (!((File)object).isDirectory()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + " is not directory");
                    }
                    throw new ODCException("exportTargetTree(): " + string2 + " is not directory");
                }
            }
            object = new FileOutputStream(string);
            PrintStream printStream = new PrintStream((OutputStream)object);
            ODCTree oDCTree = this.cloneTargetTree();
            this.adjustTargetTree(oDCTree);
            oDCTree.print(printStream);
            printStream.close();
            return string;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exportTargetTree() Exception: " + exception.getMessage());
            }
            throw new ODCException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeNode(String string) throws Exception {
        ODCTree oDCTree;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNode");
        }
        String string2 = "Operation Successful";
        String string3 = "Operation removeODCNode failed.";
        string = this.removeTrailingFwdSlash(string);
        ODCTree oDCTree2 = oDCTree = TargetTree.getTree();
        synchronized (oDCTree2) {
            oDCTree.beginTransaction("removeNode debug transaction for node: " + string);
            try {
                ODCNode oDCNode = oDCTree.getNode(string);
                if (oDCNode != null) {
                    oDCNode.remove();
                } else {
                    string2 = string3 + "\nNode " + string + " does not exist.";
                }
                oDCTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "removeNode", tc);
                oDCTree.rollbackTransaction();
                throw new ODCException(string3 + "\n" + throwable.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "removeNode");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addNode(String string, String string2, String string3, String ... stringArray) throws Exception {
        ODCTreeImpl oDCTreeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNode");
        }
        String string4 = "Operation Successful";
        String string5 = "Operation addODCNode failed.";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (stringArray.length > 0) {
            stringArray = this.parseArgs(stringArray);
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].compareTo("--p") == 0) {
                        arrayList.add(this.removeTrailingFwdSlash(stringArray[i + 1]));
                        arrayList.add(this.removeTrailingFwdSlash(stringArray[i + 2]));
                        i += 2;
                        continue;
                    }
                    if (stringArray[i].compareTo("--l") != 0) continue;
                    arrayList2.add(this.removeTrailingFwdSlash(stringArray[i + 1]));
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ArrayIndexOutOfBoundsException(string5 + "\n" + "Wrong number of arguments for addODCNode operation.\n" + arrayIndexOutOfBoundsException.getMessage());
            }
        }
        arrayList.trimToSize();
        arrayList2.trimToSize();
        string = this.removeTrailingFwdSlash(string);
        string2 = this.removeTrailingFwdSlash(string2);
        string3 = this.removeTrailingFwdSlash(string3);
        ODCTreeImpl oDCTreeImpl2 = oDCTreeImpl = (ODCTreeImpl)TargetTree.getTree();
        synchronized (oDCTreeImpl2) {
            oDCTreeImpl.beginTransaction("addNode debug transaction for node: " + string + "/" + string2 + "/" + string3);
            try {
                ODCNodeImpl oDCNodeImpl = oDCTreeImpl.getNode(string);
                if (oDCNodeImpl != null) {
                    this.odc = ODCHelper.getInstance();
                    ODCNodeType oDCNodeType = this.odc.schema.getNodeType(string2);
                    if (oDCNodeType != null) {
                        Object object;
                        ODCNode oDCNode = oDCTreeImpl.createNode(string3, oDCNodeType, oDCNodeImpl);
                        String string62 = null;
                        StringBuffer stringBuffer = new StringBuffer();
                        for (String string62 : arrayList2) {
                            object = oDCTreeImpl.getNode(string62);
                            if (object != null) {
                                object.addNode(oDCNode);
                                continue;
                            }
                            stringBuffer.append("Failed to create link from " + string62 + ". The node does not exist.\n");
                        }
                        stringBuffer.trimToSize();
                        if (stringBuffer.length() > 0) {
                            throw new ODCException(stringBuffer.toString());
                        }
                        object = arrayList.iterator();
                        while (object.hasNext()) {
                            this.modifyProperty(oDCNode, (String)object.next(), (String)object.next());
                        }
                    }
                } else {
                    string4 = string5 + "\nNode " + string + " does not exist.";
                }
                oDCTreeImpl.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "addNode", tc);
                oDCTreeImpl.rollbackTransaction();
                throw new ODCException(string5 + "\n" + throwable.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "addNode");
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addEdge(String string, String string2) throws Exception {
        ODCTree oDCTree;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEdge");
        }
        String string3 = "Operation Successful";
        String string4 = "Operation addODCEdge failed.";
        string = this.removeTrailingFwdSlash(string);
        string2 = this.removeTrailingFwdSlash(string2);
        ODCTree oDCTree2 = oDCTree = TargetTree.getTree();
        synchronized (oDCTree2) {
            oDCTree.beginTransaction("addEdge debug transaction for: " + string + " to " + string2);
            try {
                ODCNode oDCNode = oDCTree.getNode(string);
                ODCNode oDCNode2 = oDCTree.getNode(string2);
                if (oDCNode == null || oDCNode2 == null) {
                    string3 = oDCNode == null && oDCNode2 == null ? "Nodes " + string + " and " + string2 + " do not exist." : (oDCNode == null ? "Node " + string + " does not exist." : "Node " + string2 + " does not exist.");
                    throw new ODCException(string3);
                }
                oDCNode.addNode(oDCNode2);
                oDCTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "addEdge", tc);
                oDCTree.rollbackTransaction();
                throw new ODCException(string4 + "\n" + throwable.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "addEdge");
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeEdge(String string, String string2) throws Exception {
        ODCTree oDCTree;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEdge");
        }
        String string3 = "Operation Successful";
        String string4 = "Operation removeODCEdge failed.";
        string = this.removeTrailingFwdSlash(string);
        string2 = this.removeTrailingFwdSlash(string2);
        ODCTree oDCTree2 = oDCTree = TargetTree.getTree();
        synchronized (oDCTree2) {
            oDCTree.beginTransaction("removeEdge debug transaction for: " + string + " to " + string2);
            try {
                ODCNode oDCNode = oDCTree.getNode(string);
                ODCNode oDCNode2 = oDCTree.getNode(string2);
                if (oDCNode == null || oDCNode2 == null) {
                    string3 = oDCNode == null && oDCNode2 == null ? "Nodes " + string + " and " + string2 + " do not exist." : (oDCNode == null ? "Node " + string + " does not exist." : "Node " + string2 + " does not exist.");
                    throw new ODCException(string3);
                }
                oDCNode.removeNode(oDCNode2);
                oDCTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "removeEdge", tc);
                oDCTree.rollbackTransaction();
                throw new ODCException(string4 + "\n" + throwable.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "removeEdge");
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String modifyProperty(String string, String string2, String string3) throws Exception {
        ODCTree oDCTree;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modeifyProperty");
        }
        String string4 = "Operation Successful";
        String string5 = "Operation modifyODCProperty failed.";
        string = this.removeTrailingFwdSlash(string);
        string2 = this.removeTrailingFwdSlash(string2);
        string3 = this.removeTrailingFwdSlash(string3);
        ODCTree oDCTree2 = oDCTree = TargetTree.getTree();
        synchronized (oDCTree2) {
            oDCTree.beginTransaction("modifyProperty debug transaction for: " + string + " ODCPropertyDescriptor: " + string2 + " Value: " + string3);
            try {
                ODCNode oDCNode = oDCTree.getNode(string);
                string4 = oDCNode != null ? this.modifyProperty(oDCNode, string2, string3) : string5 + "\nNode " + string + " does not exist.";
                oDCTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "modifyProperty", tc);
                oDCTree.rollbackTransaction();
                if (throwable.getMessage() != null) {
                    throw new ODCException(string5 + "\n" + throwable.getMessage());
                }
                string4 = string5 + "\nNode " + string + " does not exist.";
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "modifyProperty");
        }
        return string4;
    }

    private String modifyProperty(ODCNode oDCNode, String string, String string2) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modeifyProperty", oDCNode);
        }
        String string3 = "Operation Successful";
        Integer n = null;
        if (string2.contains("::")) {
            string2.trim();
            try {
                n = new Integer(string2.substring(0, string2.indexOf(":")));
                string2 = string2.substring(string2.indexOf("::") + 2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("Unable to determine priority. Check the modifyODCProperty syntax.\n" + numberFormatException.getMessage());
            }
        }
        if (oDCNode != null) {
            object = string2;
            if (n != null) {
                object = new ODCPropertyValueWrapper(object, n);
            }
        } else {
            throw new ODCException((String)null);
        }
        oDCNode.setProperty(string, object);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "modifyProperty", oDCNode);
        }
        return string3;
    }

    private String removeTrailingFwdSlash(String string) {
        if (string != null) {
            string = string.trim();
            while (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
                string.trim();
            }
        }
        return string;
    }

    private String[] parseArgs(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].matches("'.+',|'.+'") ? stringArray[i].substring(stringArray[i].indexOf("'") + 1, stringArray[i].lastIndexOf("'")) : stringArray[i];
        }
        return stringArray2;
    }

    public class ODCTreeSaveThread
    extends Thread {
        private PrintStream ps;

        public ODCTreeSaveThread(PrintStream printStream) {
            this.ps = printStream;
        }

        public void run() {
            block2: {
                try {
                    ODCTree oDCTree = TargetTree.getTree();
                    oDCTree.print(this.ps);
                    this.ps.close();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block2;
                    Tr.debug(tc, "ODCTreeSaveThread - Exception: " + exception.getMessage());
                }
            }
        }
    }
}

