/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.cell.TargetTree;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCListener;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTree;

public class ApplicationQuiescer
implements ODCListener {
    public static final String QUIESCING_STATE = "QUIESCING";
    public static final String QUIESCED_STATE = "QUIESCED";
    private static TraceComponent tc = TrUtil.register(ApplicationQuiescer.class);
    private final ODCHelper odc;
    private final ODCNode serverApp;
    private final ODCEdgeType proxyContainer2ServerApp;
    private final ODCEventType[] interestEvents;

    public static void quiesceMyApplication(String string) throws Exception {
        ODCNode oDCNode = TargetTree.getMyServer();
        if (oDCNode == null) {
            throw new RuntimeException("myServer is null");
        }
        ApplicationQuiescer.quiesceApplication(oDCNode, string);
    }

    public static void quiesceApplication(ODCNode oDCNode, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesceApplication", new Object[]{oDCNode, string});
        }
        ApplicationQuiescer applicationQuiescer = new ApplicationQuiescer(oDCNode, string);
        applicationQuiescer.quiesceApplication();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesceApplication", new Object[]{oDCNode, string});
        }
    }

    public static boolean isQuiesceState(String string) {
        return string.equals(QUIESCING_STATE) || string.equals(QUIESCED_STATE);
    }

    private ApplicationQuiescer(String string) throws Exception {
        this(TargetTree.getMyServer(), string);
    }

    private ApplicationQuiescer(ODCNode oDCNode, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor", new Object[]{oDCNode, string});
        }
        this.odc = ODCHelper.getInstance();
        this.proxyContainer2ServerApp = this.odc.mgr.findEdgeType(this.odc.proxyContainer, this.odc.serverApplication);
        this.interestEvents = new ODCEventType[]{this.proxyContainer2ServerApp};
        this.serverApp = oDCNode.getNode(this.odc.serverApplication, string);
        if (this.serverApp == null) {
            throw new Exception("'" + string + "' is not running on server " + oDCNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor", string);
        }
    }

    private void quiesceApplication() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesce", this);
        }
        this.serverApp.setProperty(this.odc.serverApplicationState, (Object)QUIESCING_STATE);
        this.waitForQuiesceCompletion();
        this.serverApp.setProperty(this.odc.serverApplicationState, (Object)QUIESCED_STATE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesce", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void waitForQuiesceCompletion() throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForQuiesceCompletion", this);
        }
        if (!this.isQuiesced()) {
            ODCTree oDCTree = this.serverApp.getTree();
            oDCTree.addListener(this);
            try {
                if (!this.isQuiesced()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "waiting for quiesce for complete for " + this);
                    }
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                oDCTree.removeListener(this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "done waiting for quiesce completion of " + this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForQuiesceCompletion", this);
        }
    }

    public ODCEventType[] interestEventTypes() {
        return this.interestEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ODCEvent oDCEvent) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleEvent " + oDCEvent);
        }
        if (this.isQuiesced()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "notifying that quiesce is complete");
            }
            ApplicationQuiescer applicationQuiescer = this;
            synchronized (applicationQuiescer) {
                this.notify();
            }
        }
    }

    private boolean isQuiesced() throws ODCException {
        int n = this.serverApp.nodeCount(this.odc.proxyContainer);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, n + " ODR(s) are routing to " + this);
        }
        return n == 0;
    }

    public String toString() {
        return this.serverApp.toString();
    }
}

