/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.odc.cell.TreeBuilderHelper;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class CellPropertyListener
implements ConfigChangeListener {
    private static final TraceComponent tc = TrUtil.register(CellPropertyListener.class);
    public static final String INDIVIDUAL_LISTENER_TIME_THRESHOLD_KEY = "ODCIndividualListenerTimeThreshold";
    public static final String TOTAL_LISTENER_TIME_THRESHOLD_KEY = "ODCTotalListenerTimeThreshold";
    private static List keys = new ArrayList();
    public static long INDIVIDUAL_LISTENER_TIME_THRESHOLD_DEFAULT;
    public static long TOTAL_LISTENER_TIME_THRESHOLD_DEFAULT;
    private static long individualListenerTimeThreshold;
    private static long totalListenerTimeThreshold;

    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.loadConfig();
        try {
            Admin admin2 = (Admin)WsServiceRegistry.getService((Object)this, Admin.class);
            if (admin2 != null) {
                admin2.addConfigChangeListener(this);
            }
        }
        catch (Exception exception) {
            TrUtil.error(exception, this, "start", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    private void loadConfig() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadConfig");
            }
            try {
                Repository repository2 = TreeBuilderHelper.getInstance().getRepository(AdminServiceFactory.getAdminService().getCellName(), null, null);
                Cell cell = (Cell)repository2.getConfigRoot().getResource(0, "cell.xml").getContents().get(0);
                EList eList = cell.getProperties();
                for (Property property : eList) {
                    this.validateType(property.getName(), property.getValue());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.odc.utils.CellPropertyListener", "148", this);
                if (!tc.isDebugEnabled()) break block5;
                exception.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfig");
        }
    }

    private boolean validateType(String string, String string2) {
        boolean bl = false;
        if (keys.contains(string)) {
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "valid config prop found: ", new Object[]{string, string2});
            }
            if (string.equals(INDIVIDUAL_LISTENER_TIME_THRESHOLD_KEY)) {
                CellPropertyListener.setIndividualListenerTimeThreshold(Long.valueOf(string2));
            } else if (string.equals(TOTAL_LISTENER_TIME_THRESHOLD_KEY)) {
                CellPropertyListener.setTotalListenerTimeThreshold(Long.valueOf(string2));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalid config prop found: ", new Object[]{string});
        }
        return bl;
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configChanged", configRepositoryEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onChangeCompletion");
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            ConfigChangeNotifier configChangeNotifier = configChangeNotifierArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Change Type: " + configChangeNotifier.getChangeType() + " Change URI: " + configChangeNotifier.getUri());
            }
            if (configChangeNotifier.getChangeType() != 2 || !configChangeNotifier.getUri().endsWith("cell.xml")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell config modified");
            }
            this.loadConfig();
            i = configChangeNotifierArray.length;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onRepositoryEpochRefresh() {
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public static long getIndividualListenerTimeThreshold() {
        return individualListenerTimeThreshold;
    }

    public static void setIndividualListenerTimeThreshold(long l) {
        individualListenerTimeThreshold = l;
    }

    public static long getTotalListenerTimeThreshold() {
        return totalListenerTimeThreshold;
    }

    public static void setTotalListenerTimeThreshold(long l) {
        totalListenerTimeThreshold = l;
    }

    static {
        keys.add(INDIVIDUAL_LISTENER_TIME_THRESHOLD_KEY);
        keys.add(TOTAL_LISTENER_TIME_THRESHOLD_KEY);
        INDIVIDUAL_LISTENER_TIME_THRESHOLD_DEFAULT = Long.MAX_VALUE;
        TOTAL_LISTENER_TIME_THRESHOLD_DEFAULT = Long.MAX_VALUE;
        individualListenerTimeThreshold = INDIVIDUAL_LISTENER_TIME_THRESHOLD_DEFAULT;
        totalListenerTimeThreshold = TOTAL_LISTENER_TIME_THRESHOLD_DEFAULT;
    }
}

