/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;

public class CfUtil {
    private static final TraceComponent tc = TrUtil.register(CfUtil.class);
    public static final String CHANNEL_SIP = "sip";
    public static final String CHANNEL_SSL = "ssl";
    public static final String CHANNEL_TCP = "tcp";
    public static final String CHANNEL_UDP = "udp";
    public static final String CHANNEL_HTTP = "http";
    public static final String CHANNEL_XMEM = "xmem";
    public static final String STACK_SIP = "sip/tcp";
    public static final String STACK_SIPS = "sip/ssl/tcp";
    public static final String STACK_SIPU = "sip/udp";
    public static final String STACK_SIPX = "sip/xmem";
    public static final String STACK_HTTP = "http/tcp";
    public static final String STACK_HTTPS = "http/ssl/tcp";
    public static final String STACK_HTTPX = "http/xmem";
    public static final String PROTO_SIP = "sip";
    public static final String PROTO_SIPS = "sips";
    public static final String PROTO_SIPU = "sipu";
    public static final String PROTO_SIPX = "sipx";
    public static final String PROTO_HTTP = "http";
    public static final String PROTO_HTTPS = "https";
    public static final String PROTO_HTTPX = "httpx";
    private static final String[] protocolNames = new String[]{"sipu", "sip", "sips", "sipx", "http", "https", "httpx"};
    private static final String[] stackNames = new String[]{"sip/udp", "sip/tcp", "sip/ssl/tcp", "sip/xmem", "http/tcp", "http/ssl/tcp", "http/xmem"};

    public static String getTransportName(CFEndPoint cFEndPoint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CfUtil.getProtocolName(cFEndPoint)).append(".");
        stringBuffer.append(cFEndPoint.getPort());
        if (cFEndPoint.isLocal()) {
            stringBuffer.append("#local");
        }
        String string = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTransportName = " + string);
        }
        return string;
    }

    public static String getProtocolName(CFEndPoint cFEndPoint) {
        String string = protocolNames[CfUtil.getProtocolIndex(cFEndPoint)];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "protocol name: " + string);
        }
        return string;
    }

    public static int getTransportType(CFEndPoint cFEndPoint) {
        return CfUtil.getProtocolIndex(cFEndPoint);
    }

    public static String getStackName(CFEndPoint cFEndPoint) {
        OutboundChannelDefinition[] outboundChannelDefinitionArray = cFEndPoint.getOutboundChannelDefs();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < outboundChannelDefinitionArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("/");
            }
            stringBuffer.append(CfUtil.classToProtocolName(outboundChannelDefinitionArray[i].getOutboundFactory().getName()));
        }
        String string = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stack name: " + string);
        }
        return string;
    }

    public static int getProtocolIndex(CFEndPoint cFEndPoint) {
        return CfUtil.getProtocolIndexForStackName(CfUtil.getStackName(cFEndPoint));
    }

    public static String getProtocolName(int n) {
        return protocolNames[n];
    }

    public static String getStackName(int n) {
        return stackNames[n];
    }

    public static int getNumProtocols() {
        return protocolNames.length;
    }

    public static int getProtocolIndexForProtocolName(String string) {
        for (int i = 0; i < protocolNames.length; ++i) {
            if (!string.equals(protocolNames[i])) continue;
            return i;
        }
        throw new RuntimeException("unknown protocol name: " + string);
    }

    public static int getProtocolIndexForStackName(String string) {
        for (int i = 0; i < stackNames.length; ++i) {
            if (!string.equals(stackNames[i])) continue;
            return i;
        }
        throw new RuntimeException("unknown protocol stack name: " + string);
    }

    private static String classToProtocolName(String string) {
        if (string.equals("com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory") || string.equals("com.ibm.ws.tcp.channel.impl.ZAioTCPChannelFactory")) {
            return CHANNEL_TCP;
        }
        if (string.equals("com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory")) {
            return CHANNEL_SSL;
        }
        if (string.equals("com.ibm.ws.http.channel.outbound.impl.WSHttpOutboundChannelFactory") || string.equals("com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext") || string.equals("com.ibm.ws.localhttp.channel.outbound.impl.LHttpOutboundChannelFactory") || string.equals("com.ibm.ws.localhttp.channel.outbound.impl.LHttpsOutboundChannelFactory")) {
            return "http";
        }
        if (string.equals("com.ibm.ws.sip.channel.outbound.impl.WSSipOutboundChannelFactory")) {
            return "sip";
        }
        if (string.equals("com.ibm.ws.udp.channel.outbound.impl.WSUdpOutboundChannelFactory")) {
            return CHANNEL_UDP;
        }
        throw new RuntimeException("unknown channel class: " + string);
    }
}

