/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.odc.util.TrUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class DMgrInfo {
    private static TraceComponent tc = TrUtil.register(DMgrInfo.class);
    private String hostName = null;

    public DMgrInfo(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
        try {
            this.hostName = DMgrInfo.getDMgrHost(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            Tr.error(tc, "Failed to get DeploymentManager hostname", throwable);
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public static String getDMgrHost(String string) throws Exception {
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        String[] stringArray = configRepository.listResourceNames("cells/" + string + "/nodes/", 1, Integer.MAX_VALUE);
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith("serverindex.xml")) continue;
            ServerIndex serverIndex = (ServerIndex)DMgrInfo.getTopLevelWCCMObject(stringArray[i]);
            Resource resource = serverIndex.eResource();
            EList eList = serverIndex.getServerEntries();
            if (eList == null || eList.size() <= 0) continue;
            ListIterator listIterator = eList.listIterator();
            int n = 0;
            while (listIterator.hasNext()) {
                Iterator iterator;
                EList eList2;
                Object e2 = listIterator.next();
                if (!(e2 instanceof ServerEntry)) continue;
                ServerEntry serverEntry = (ServerEntry)e2;
                if (serverEntry.getServerType().equals("DEPLOYMENT_MANAGER") && (eList2 = serverEntry.getSpecialEndpoints()) != null && eList2.size() > 0 && (iterator = eList2.iterator()).hasNext()) {
                    NamedEndPoint namedEndPoint = (NamedEndPoint)iterator.next();
                    string2 = namedEndPoint.getEndPoint().getHost();
                    return string2;
                }
                ++n;
            }
        }
        return null;
    }

    public static Object getTopLevelWCCMObject(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTopLevelWCCMObject", new Object[]{string});
        }
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        Object object = null;
        if (configRepository == null) {
            Tr.debug(tc, "Could not find repository");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTopLevelWCCMObject", object);
            }
            return object;
        }
        DocumentContentSource documentContentSource = configRepository.extract(string);
        if (documentContentSource == null) {
            return null;
        }
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URI uRI = URI.createFileURI((String)documentContentSource.getDocument().getURI());
        Resource resource = wASResourceSetImpl.createResource(uRI);
        resource.load(documentContentSource.getSource(), new HashMap());
        EList eList = resource.getContents();
        if (eList.size() < 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTopLevelWCCMObject - no objects found", object);
            }
            return object;
        }
        object = resource.getContents().get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTopLevelWCCMObject", object);
        }
        return object;
    }
}

