/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.zip.GZIPInputStream;

public class TargetXMLExtractor {
    private static final char[] TOKENS;
    private static final char PAD_TOKEN = '=';
    private static final int TOKEN_MIN = 0;
    private static final int TOKEN_MAX = 127;
    private static final byte INVALID_TOKEN_VALUE = -1;
    private static final byte[] TOKEN_VALUES;

    public static void main(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[i]));
                while ((string = bufferedReader.readLine()) != null) {
                    int n;
                    System.out.println(string);
                    if (string.indexOf("BEGIN_TARGET_XML_BASE64") == -1) continue;
                    String string2 = bufferedReader.readLine();
                    byte[] byArray = TargetXMLExtractor.decode(string2);
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
                    byte[] byArray2 = new byte[4096];
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while ((n = ((InputStream)gZIPInputStream).read(byArray2)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                    String string3 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
                    System.out.println(string3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static byte[] decode(String string) throws IllegalArgumentException {
        byte[] byArray = TargetXMLExtractor.decode(string, 0, string.length());
        return byArray;
    }

    public static byte[] decode(char[] cArray) {
        return TargetXMLExtractor.decode(cArray, 0, cArray.length);
    }

    public static byte[] decode(char[] cArray, int n, int n2) {
        byte[] byArray;
        byte[] byArray2 = new byte[n2 / 4 * 3];
        int n3 = 0;
        int n4 = 0;
        byte by = 0;
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            byte by2;
            char c = cArray[i];
            if (c == '=') {
                if (n4 < 2) {
                    throw new IllegalArgumentException();
                }
                bl = true;
                break;
            }
            if (c < '\u0000' || c > '\u007f' || (by2 = TOKEN_VALUES[c]) == -1) continue;
            switch (n4) {
                case 0: {
                    n4 = 1;
                    break;
                }
                case 1: {
                    byArray2[n3++] = (byte)(by << 2 | (by2 & 0x30) >> 4);
                    n4 = 2;
                    break;
                }
                case 2: {
                    byArray2[n3++] = (byte)((by & 0xF) << 4 | (by2 & 0x3C) >> 2);
                    n4 = 3;
                    break;
                }
                case 3: {
                    byArray2[n3++] = (byte)((by & 3) << 6 | by2);
                    n4 = 0;
                }
            }
            by = by2;
        }
        if (!bl && n4 != 0) {
            throw new IllegalArgumentException();
        }
        if (n3 < byArray2.length) {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        } else {
            byArray = byArray2;
        }
        return byArray;
    }

    public static byte[] decode(String string, int n, int n2) throws IllegalArgumentException {
        byte[] byArray = TargetXMLExtractor.decode(string.toCharArray(), n, n2);
        return byArray;
    }

    public static void decode(char[] cArray, OutputStream outputStream) throws IOException, IllegalArgumentException {
        TargetXMLExtractor.decode(cArray, 0, cArray.length, outputStream);
    }

    public static void decode(char[] cArray, int n, int n2, OutputStream outputStream) throws IOException, IllegalArgumentException {
        outputStream.write(TargetXMLExtractor.decode(cArray, n, n2));
    }

    public static void decode(String string, OutputStream outputStream) throws IOException, IllegalArgumentException {
        TargetXMLExtractor.decode(string.toCharArray(), outputStream);
    }

    public static void decode(Reader reader, OutputStream outputStream) throws IOException, IllegalArgumentException {
        int n;
        int n2 = 0;
        byte by = 0;
        boolean bl = false;
        while ((n = reader.read()) != -1) {
            byte by2;
            if (n == 61) {
                if (n2 < 2) {
                    throw new IllegalArgumentException();
                }
                bl = true;
                break;
            }
            if (n < 0 || n > 127 || (by2 = TOKEN_VALUES[n]) == -1) continue;
            switch (n2) {
                case 0: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    outputStream.write(by << 2 | (by2 & 0x30) >> 4);
                    n2 = 2;
                    break;
                }
                case 2: {
                    outputStream.write((by & 0xF) << 4 | (by2 & 0x3C) >> 2);
                    n2 = 3;
                    break;
                }
                case 3: {
                    outputStream.write((by & 3) << 6 | by2);
                    n2 = 0;
                }
            }
            by = by2;
        }
        if (!bl && n2 != 0) {
            throw new IllegalArgumentException();
        }
    }

    static {
        int n;
        TOKENS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        TOKEN_VALUES = new byte[128];
        for (n = 0; n < TOKEN_VALUES.length; ++n) {
            TargetXMLExtractor.TOKEN_VALUES[n] = -1;
        }
        for (n = 0; n < TOKENS.length; ++n) {
            TargetXMLExtractor.TOKEN_VALUES[TargetXMLExtractor.TOKENS[n]] = (byte)n;
        }
    }
}

