/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.odc.cell.TreeBuilderHelper;
import com.ibm.ws.odc.util.DoPrivUtil;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScopes;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class Util {
    private static final TraceComponent tc = TrUtil.register(Util.class);
    public static final String DEPLOYMENT_MANAGER_PROCESS = "DeploymentManager";
    public static final String NODE_AGENT_PROCESS = "NodeAgent";
    public static final String MANAGED_PROCESS = "ManagedProcess";
    public static final String STANDALONE_PROCESS = "UnManagedProcess";
    public static final String PROXY_SERVER_TYPE = "PROXY_SERVER";
    public static final String ODR_TYPE = "ONDEMAND_ROUTER";
    private static String myProcessType = null;
    private static String myServerType = null;
    private static final HashMap cellMap = new HashMap();
    private static final String myCellName = AdminServiceFactory.getAdminService().getCellName();

    public static boolean isDmgr() {
        return Util.isDmgr(Util.getMyProcessType());
    }

    public static boolean isNodeAgent() {
        return Util.isNodeAgent(Util.getMyProcessType());
    }

    public static boolean isManagedProcess() {
        return Util.isManagedProcess(Util.getMyProcessType());
    }

    public static boolean isStandAlone() {
        return Util.isStandAlone(Util.getMyProcessType());
    }

    public static boolean isProxy() {
        return Util.isProxy(Util.getMyServerType());
    }

    public static boolean isODR() {
        return Util.isODR(Util.getMyServerType());
    }

    public static boolean isDmgr(String string) {
        return string.equals(DEPLOYMENT_MANAGER_PROCESS);
    }

    public static boolean isNodeAgent(String string) {
        return string.equals(NODE_AGENT_PROCESS);
    }

    public static boolean isManagedProcess(String string) {
        return string.equals(MANAGED_PROCESS);
    }

    public static boolean isStandAlone(String string) {
        return string.equals(STANDALONE_PROCESS);
    }

    public static boolean isProxy(String string) {
        return string.equals(PROXY_SERVER_TYPE) || string.equals(ODR_TYPE);
    }

    public static boolean isODR(String string) {
        return string.equals(ODR_TYPE);
    }

    public static String getMyProcessType() {
        if (myProcessType == null && (myProcessType = AdminServiceFactory.getAdminService().getProcessType()) == null) {
            throw new RuntimeException("null process type");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "my process type is " + myProcessType);
        }
        return myProcessType;
    }

    public static String getMyServerType() {
        if (myServerType == null && (myServerType = AdminServiceFactory.getAdminService().getServerType()) == null) {
            throw new RuntimeException("null server type");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "my server type is " + myServerType);
        }
        return myServerType;
    }

    public static File getPerServerFile(String string) throws IOException {
        return Util.getPerServerFile("", string);
    }

    public static File getPerServerFile(String string, String string2) throws IOException {
        PlatformHelper platformHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPerServerFile", string2);
        }
        if ((platformHelper = PlatformHelperFactory.getPlatformHelper()) != null) {
            if (platformHelper.isBaseServantJvm() || platformHelper.isCRAJvm()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPerServerFile", "in Z CRA or Servant Regtion");
                }
                return null;
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPerServerFile", "could not reach Platform Helper");
            }
            return null;
        }
        String string3 = System.getProperty("server.root");
        if (string3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPerServerFile", "server.root not set");
            }
            return null;
        }
        String string4 = DoPrivUtil.getMyServerName();
        File file = new File(string3 + "/installedFilters/wlm/" + string4 + string);
        if (!DoPrivUtil.exists(file) && !DoPrivUtil.mkdirs(file)) {
            throw new IOException("unable to create directory: " + file.getAbsolutePath());
        }
        File file2 = new File(file, string2 + ".xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerServerFile", file2);
        }
        return file2;
    }

    public static String makeEdgeLongName(ODCNode oDCNode, ODCNode oDCNode2) {
        return Util.makeEdgeLongName(oDCNode.getPath(), oDCNode2.getPath());
    }

    public static String makeEdgeLongName(String string, String string2) {
        return string + "::" + string2;
    }

    public static boolean isRoutableServerType(String string) {
        if (string == null) {
            return false;
        }
        return !PROXY_SERVER_TYPE.equals(string) && !ODR_TYPE.equals(string) && !string.endsWith("AGENT");
    }

    public static synchronized boolean connectedToCell(String string) {
        boolean bl;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "connectedToCell - cell=" + string);
            }
            if (string.equals(myCellName)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "connectedToCell - true, mycell");
                }
                return true;
            }
            String string2 = System.getProperty("odc.foreign.cellName", "ForeignCell");
            if (string.equals(string2)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "connectedToCell - true, fake cell ForeignCell");
                }
                return true;
            }
            Boolean bl2 = (Boolean)cellMap.get(string);
            if (bl2 != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "connectedToCell - answer=" + bl2);
                }
                return bl2;
            }
            bl = false;
            try {
                BulletinBoardScopes bulletinBoardScopes = (BulletinBoardScopes)WsServiceRegistry.getService(Util.class, BulletinBoardScopes.class);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("cellName", string);
                if (bulletinBoardScopes.getRemoteScope(hashMap) != null) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block11;
                TrUtil.ffdc(exception, Util.class, "connectedToCell", tc);
            }
        }
        cellMap.put(string, new Boolean(bl));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectedToCell - found=" + bl);
        }
        return bl;
    }

    public static String getMyServerName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMyServerName");
        }
        String string = AdminServiceFactory.getAdminService().getProcessName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMyServerName - " + string);
        }
        return string;
    }

    public static String getMyNodeName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMyNodeName");
        }
        String string = AdminServiceFactory.getAdminService().getNodeName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMyNodeName - " + string);
        }
        return string;
    }

    public static String getMyCellName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMyCellName");
        }
        String string = AdminServiceFactory.getAdminService().getCellName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMyCellName - " + string);
        }
        return string;
    }

    public static String getClusterForServer(String string, String string2, String string3) throws Exception {
        String string4;
        TreeBuilderHelper treeBuilderHelper;
        String string5;
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterForServer", new String[]{string, string2, string3});
        }
        if ((file = new File(string5 = (treeBuilderHelper = TreeBuilderHelper.getInstance()).joinDir(string4 = treeBuilderHelper.getDir(string, null, null), "clusters"))).exists()) {
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            };
            File[] fileArray = file.listFiles(fileFilter);
            if (fileArray == null) {
                throw new IOException("unable to read clusters directory: " + string5);
            }
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    Repository repository2 = TreeBuilderHelper.getInstance().getRepository(string, null, null);
                    String string6 = "clusters" + File.separator + fileArray[i].getName() + File.separator + "cluster.xml";
                    for (ServerCluster serverCluster : repository2.getConfigRoot().getResource(0, string6).getContents()) {
                        Iterator iterator = serverCluster.getMembers().iterator();
                        boolean bl = false;
                        while (iterator.hasNext()) {
                            ClusterMember clusterMember = (ClusterMember)iterator.next();
                            String string7 = clusterMember.getNodeName();
                            String string8 = clusterMember.getMemberName();
                            if (!string8.equals(string3) || !string7.equals(string2)) continue;
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getClusterForServer - " + fileArray[i].getName());
                            }
                            return fileArray[i].getName();
                        }
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, null, "getClusterForServer", tc);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterForServer - null");
        }
        return null;
    }
}

