/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.ws390.proxy.controller;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.ws390.proxy.ODCProxyUtil;
import com.ibm.ws.odc.ws390.proxy.controller.ODCControllerEventListener;
import com.ibm.ws.odc.ws390.proxy.controller.ODCControllerProxy;
import com.ibm.ws.odc.ws390.proxy.controller.ODCControllerProxyImpl;
import com.ibm.ws.odc.ws390.proxy.servant.ODCServantProxyImpl;
import com.ibm.ws.odc.ws390.proxy.servant.ODCServantProxyOperations;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.JVMListenerInterface;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.SRAggregator;
import com.ibm.ws.util.SRObjectElement;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCTree;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class ODCControllerProxyHelper
implements JVMListenerInterface {
    private static PlatformHelper platformHelper = null;
    public static ODCControllerProxyHelper instance = null;
    private static final TraceComponent tc = TrUtil.register(ODCControllerProxyHelper.class);
    private ArrayList odcTreeList;
    private ArrayList broadcastItems;
    private Class sraClass;
    private String electedServant;
    private Object servantLock;
    private boolean helperStopped;
    private ODCControllerEventListener listener;
    private ODCControllerProxy proxy;

    public static synchronized ODCControllerProxyHelper getInstance() {
        if (instance == null) {
            instance = new ODCControllerProxyHelper();
            platformHelper.registerListener(instance);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ODC Controller Proxy Helper initialized.");
            }
        }
        return instance;
    }

    private ODCControllerProxyHelper() {
        String string;
        block9: {
            this.odcTreeList = new ArrayList();
            this.broadcastItems = new ArrayList();
            this.sraClass = null;
            this.electedServant = null;
            this.servantLock = new Object();
            this.helperStopped = false;
            this.listener = null;
            this.proxy = null;
            string = "Constructor";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string);
            }
            platformHelper = PlatformHelperFactory.getPlatformHelper();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading SRAggregator.");
                }
                this.sraClass = ImplFactory.loadClassFromKey(SRAggregator.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loaded SRAggregator.");
                }
                this.proxy = new ODCControllerProxyImpl();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Created new ODCControllerProxyImpl.");
                }
                platformHelper.register_initial_reference("ODCControllerProxy", this.proxy);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registered Control Region ODC Proxy Corba object");
                }
                BroadcastThread broadcastThread = new BroadcastThread();
                broadcastThread.setDaemon(true);
                broadcastThread.start();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ODCEvent broadcast thread started.");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block9;
                TrUtil.error(throwable, this, string, tc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void handleProxiedEvents(ODCTree oDCTree, ODCEvent[] oDCEventArray, String string) {
        String string2;
        block8: {
            string2 = "handleProxiedEvents() ";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string2);
            }
            if (oDCEventArray == null || oDCEventArray.length == 0) {
                Tr.debug(tc, "No events in the array. Tree: " + oDCTree.getName());
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting servantToken in the Event to: " + string);
            }
            for (int i = 0; i < oDCEventArray.length; ++i) {
                ODCEvent oDCEvent = oDCEventArray[i];
                oDCEvent.setAttachment(string);
            }
            try {
                oDCTree.performEvents(this.getClass().getName() + string, oDCEventArray, true, this.listener);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Applied Proxied Servant Events on Controller ODC Tree");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block8;
                TrUtil.error(throwable, this, string2, tc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2);
        }
    }

    public void manageTree(ODCTree oDCTree) {
        this.odcTreeList.add(oDCTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHelper() {
        this.helperStopped = true;
        ArrayList arrayList = this.broadcastItems;
        synchronized (arrayList) {
            this.broadcastItems.notify();
        }
    }

    public void handleLocalEvents(ODCTree oDCTree, ODCEvent[] oDCEventArray) {
        block8: {
            String string = "handleLocalEvents() ";
            if (oDCEventArray == null || oDCEventArray.length == 0) {
                Tr.debug(tc, "No events in the array. Tree: " + oDCTree.getName());
                return;
            }
            if (this.helperStopped) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Helper stop issued.");
                }
                return;
            }
            try {
                String string2 = (String)oDCEventArray[0].getAttachment();
                if (string2 == null) {
                    this.queueEventsForBroadcast(oDCTree, oDCEventArray, null);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignore ODCEvents proxied by Servant: " + string2);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block8;
                TrUtil.error(throwable, this, string, tc);
            }
        }
    }

    public void servantInitialized(String string) throws ODCException {
        this.electServantIfRequired();
        for (int i = 0; i < this.odcTreeList.size(); ++i) {
            ODCTree oDCTree = (ODCTree)this.odcTreeList.get(i);
            ODCEvent[] oDCEventArray = oDCTree.getEvents(false);
            this.queueEventsForBroadcast(oDCTree, oDCEventArray, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servantTerminated(String string) {
        String string2 = "servantTerminated() ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2, string);
        }
        Object object = this.servantLock;
        synchronized (object) {
            if (this.electedServant == null || this.electedServant.equals(string)) {
                this.electedServant = null;
                this.electNewServant();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void electServantIfRequired() {
        Object object = this.servantLock;
        synchronized (object) {
            if (this.electedServant == null) {
                this.electNewServant();
            }
        }
    }

    private void electNewServant() {
        String string;
        block10: {
            string = "electNewServant() ";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string);
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating SRAggregator");
                }
                this.electedServant = null;
                SRAggregator sRAggregator = (SRAggregator)this.sraClass.newInstance();
                sRAggregator.initialize(new ODCServantProxyImpl(), true, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Created SRAggregator");
                }
                while (sRAggregator.hasNext()) {
                    SRObjectElement sRObjectElement = sRAggregator.nextSRObjectElement();
                    if (sRObjectElement.isCra()) continue;
                    ODCServantProxyOperations oDCServantProxyOperations = (ODCServantProxyOperations)sRObjectElement.getSRObject();
                    try {
                        byte[] byArray = oDCServantProxyOperations.electThisServant();
                        this.electedServant = (String)ODCProxyUtil.getObject(byArray);
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "New Servant elected: " + this.electedServant);
                        break;
                    }
                    catch (RemoteException remoteException) {
                        if (!tc.isDebugEnabled()) continue;
                        TrUtil.ffdc(remoteException, this, string, tc);
                    }
                }
                if (this.electedServant == null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Servants are currently active.");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block10;
                TrUtil.error(throwable, this, string, tc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEventsForBroadcast(ODCTree oDCTree, ODCEvent[] oDCEventArray, String string) {
        BroadcastItem broadcastItem = new BroadcastItem();
        broadcastItem.treeName = oDCTree.getName();
        broadcastItem.events = oDCEventArray;
        broadcastItem.servantToken = string;
        ArrayList arrayList = this.broadcastItems;
        synchronized (arrayList) {
            this.broadcastItems.add(broadcastItem);
            this.broadcastItems.notify();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Events queued for broadcast.");
        }
    }

    private void broadcastItems(BroadcastItem[] broadcastItemArray) {
        String string = "broadcastItems() ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        block4: for (int i = 0; i < broadcastItemArray.length; ++i) {
            BroadcastItem broadcastItem = broadcastItemArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing item:" + broadcastItem.toString());
            }
            try {
                byte[] byArray = ODCProxyUtil.getByteArray(broadcastItem.treeName);
                byte[] byArray2 = ODCProxyUtil.getByteArray(broadcastItem.events);
                byte[] byArray3 = null;
                boolean bl = true;
                if (broadcastItem.servantToken != null) {
                    byArray3 = ODCProxyUtil.convertStokenToBinary(broadcastItem.servantToken);
                    bl = false;
                }
                SRAggregator sRAggregator = (SRAggregator)this.sraClass.newInstance();
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting ODC Proxies for all servants");
                    }
                    sRAggregator.initialize(new ODCServantProxyImpl(), true, null);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting ODC proxy for servant: " + broadcastItem.servantToken);
                    }
                    sRAggregator.initialize(new ODCServantProxyImpl(), false, byArray3);
                }
                ODCServantProxyOperations oDCServantProxyOperations = null;
                int n = 0;
                if (!sRAggregator.hasNext() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Servants are currently running");
                }
                while (sRAggregator.hasNext()) {
                    try {
                        SRObjectElement sRObjectElement = sRAggregator.nextSRObjectElement();
                        if (sRObjectElement.isCra()) continue;
                        oDCServantProxyOperations = (ODCServantProxyOperations)sRObjectElement.getSRObject();
                        oDCServantProxyOperations.handleProxiedEvents(byArray, byArray2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Sent to servant(number): " + n);
                        }
                        ++n;
                        if (bl) continue;
                    }
                    catch (Throwable throwable) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error sending to servant(number): " + n);
                            TrUtil.error(throwable, this, string, tc);
                        }
                        if (bl) continue;
                    }
                    continue block4;
                }
                continue;
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                TrUtil.error(throwable, this, string, tc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ControllerProxyHelper\n");
        stringBuffer.append("\telectedServant=" + this.electedServant.toString());
        int n2 = this.broadcastItems.size();
        stringBuffer.append("\tnumItemsInQueue=" + n2);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("\t\titem[" + n + "]=" + this.broadcastItems.get(n).toString());
        }
        n2 = this.odcTreeList.size();
        stringBuffer.append("\todcTreeListSize:" + n2);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("\t\todcTree:" + ((ODCTree)this.odcTreeList.get(n)).getName());
        }
        return stringBuffer.toString();
    }

    public void setListener(ODCControllerEventListener oDCControllerEventListener) {
        this.listener = oDCControllerEventListener;
    }

    class BroadcastThread
    extends Thread {
        BroadcastThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String string = "Broadcast";
            boolean bl = false;
            while (true) {
                if (ODCControllerProxyHelper.this.helperStopped || bl) {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Stopping broadcast thread.");
                    break;
                }
                try {
                    BroadcastItem[] broadcastItemArray = null;
                    ArrayList arrayList = ODCControllerProxyHelper.this.broadcastItems;
                    synchronized (arrayList) {
                        int n;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking for items in the queue.");
                        }
                        if ((n = ODCControllerProxyHelper.this.broadcastItems.size()) == 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Waiting for items to appear in queue");
                            }
                            ODCControllerProxyHelper.this.broadcastItems.wait();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "notified of items in queue");
                            }
                        }
                        if ((n = ODCControllerProxyHelper.this.broadcastItems.size()) > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Number of items in the queue: " + n);
                            }
                            broadcastItemArray = new BroadcastItem[n];
                            ODCControllerProxyHelper.this.broadcastItems.toArray(broadcastItemArray);
                            ODCControllerProxyHelper.this.broadcastItems.clear();
                        }
                    }
                    if (broadcastItemArray != null) {
                        ODCControllerProxyHelper.this.broadcastItems(broadcastItemArray);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No items to broadcast.");
                }
                catch (Throwable throwable) {
                    try {
                        BroadcastThread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Broadcast Thread Interrupted.");
                    TrUtil.error(throwable, this, string, tc);
                }
            }
        }
    }

    class BroadcastItem {
        String treeName = null;
        ODCEvent[] events = null;
        String servantToken = null;

        BroadcastItem() {
        }

        public String toString() {
            return "{tree=" + this.treeName + ",numEvents=" + this.events.length + ",servant=" + (this.servantToken == null ? "all" : this.servantToken) + "}";
        }
    }
}

