/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.ws390.proxy.servant;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.odc.ODCEventSetPropertyImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.ws390.proxy.controller.ODCControllerProxy;
import com.ibm.ws.odc.ws390.proxy.servant.ODCServantEventListener;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ServantInitializationListener;
import com.ibm.ws.util.ServantInitializedException;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventSetProperty;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;

public class ServantProxyHelper
implements ServantInitializationListener {
    private static PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
    public static ServantProxyHelper instance = null;
    private static final TraceComponent tc = TrUtil.register(ServantProxyHelper.class);
    private ArrayList odcTreeList = new ArrayList();
    private ODCControllerProxy proxy = null;
    private String servantToken = ServerName.getPrintableStoken();
    private byte[] stoken = ServerName.getStoken();
    private boolean thisServantElected = false;
    private boolean helperStopped = false;
    private ODCServantEventListener listener = null;

    public static synchronized ServantProxyHelper getInstance() {
        if (instance == null) {
            instance = new ServantProxyHelper();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ODC Servant Proxy Helper initialized.");
            }
        }
        return instance;
    }

    private void initODCControllerProxy() {
        block3: {
            try {
                ORB oRB = platformHelper.getGlobalORB();
                this.proxy = (ODCControllerProxy)oRB.resolve_initial_references("ODCControllerProxy");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Obtained ODCControllerProxy reference");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Could not initialize Controller ODC Proxy.");
                TrUtil.warning(throwable, this, "initODCControllerProxy", tc);
            }
        }
    }

    private void registerListener() {
        block3: {
            try {
                platformHelper.registerListener(this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registered as servant initialization listener.");
                }
            }
            catch (ServantInitializedException servantInitializedException) {
                if (!tc.isDebugEnabled()) break block3;
                TrUtil.warning(servantInitializedException, this, "registerListener", tc);
            }
        }
    }

    private ServantProxyHelper() {
        this.registerListener();
        this.initODCControllerProxy();
    }

    public void handleProxiedEvents(ODCTree oDCTree, ODCEvent[] oDCEventArray) {
        String string;
        block9: {
            string = "handleProxiedEvents() ";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string);
            }
            if (oDCEventArray == null || oDCEventArray.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No events in the array. Tree: " + oDCTree.getName());
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting servantToken in the Event to :" + this.servantToken);
            }
            for (int i = 0; i < oDCEventArray.length; ++i) {
                oDCEventArray[i].setAttachment(this.servantToken);
            }
            try {
                oDCTree.performEvents(this.getClass().getName(), oDCEventArray, true, this.listener);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Applied Proxied Controller Events on Servant ODC Tree");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block9;
                TrUtil.error(throwable, this, string, tc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void manageTree(ODCTree oDCTree) {
        this.odcTreeList.add(oDCTree);
    }

    public void stopHelper() {
        this.helperStopped = true;
    }

    public void handleLocalEvents(ODCTree oDCTree, ODCEvent[] oDCEventArray) {
        String string;
        block15: {
            string = "handleLocalEvents() ";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string);
            }
            try {
                if (oDCEventArray == null || oDCEventArray.length == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No events in the array. Tree: " + oDCTree.getName());
                    }
                    return;
                }
                if (this.helperStopped) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Helper Stop issued.");
                    }
                    return;
                }
                if (this.thisServantElected) {
                    if (oDCEventArray[0].getAttachment() == null) {
                        this.proxy.handleProxiedEvents(oDCTree.getName(), oDCEventArray, this.servantToken);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ODCEvents proxied to Controller");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ODCEvents proxied by Controller. Ignore.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "This is not the elected Servant, ignore events.");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block15;
                TrUtil.warning(exception, this, string, tc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void servantInitialized(String string) {
        String string2;
        block8: {
            string2 = "servantInitialized() ";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string2, string);
            }
            try {
                if (this.proxy != null) {
                    this.proxy.servantInitialized(string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Servant initialized: " + string);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Controller ODC Proxy could not be called.");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block8;
                TrUtil.warning(throwable, this, string2, tc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2);
        }
    }

    public String electThisServant() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "This Servant elected to proxy ODCEvents: " + this.servantToken);
        }
        this.thisServantElected = true;
        for (int i = 0; i < this.odcTreeList.size(); ++i) {
            ODCTree oDCTree = (ODCTree)this.odcTreeList.get(i);
            ODCEvent[] oDCEventArray = oDCTree.getEvents(false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "synching tree: " + oDCTree.getName());
            }
            ArrayList<ODCEvent> arrayList = new ArrayList<ODCEvent>();
            ODCHelper oDCHelper = null;
            try {
                oDCHelper = ODCHelper.getInstance();
            }
            catch (ODCException oDCException) {
                throw new RuntimeException(oDCException);
            }
            for (ODCEvent oDCEvent : oDCEventArray) {
                if (oDCEvent instanceof ODCEventSetProperty) {
                    ODCEventSetPropertyImpl oDCEventSetPropertyImpl = (ODCEventSetPropertyImpl)oDCEvent;
                    if (oDCEventSetPropertyImpl.getPropertyDescriptor() != oDCHelper.serverState && oDCEventSetPropertyImpl.getPropertyDescriptor() != oDCHelper.serverWeight && oDCEventSetPropertyImpl.getPropertyDescriptor() != oDCHelper.serverReachable) {
                        arrayList.add(oDCEvent);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "not proxying event: " + oDCEvent);
                    continue;
                }
                arrayList.add(oDCEvent);
            }
            ODCEvent[] oDCEventArray2 = new ODCEvent[]{};
            oDCEventArray = arrayList.toArray(oDCEventArray2);
            this.handleLocalEvents(oDCTree, oDCEventArray);
        }
        return this.servantToken;
    }

    public void setListener(ODCServantEventListener oDCServantEventListener) {
        this.listener = oDCServantEventListener;
    }
}

